/* main.c - initialize think & read commandline args
   Copyright (C) 1999 Peter Teichman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.  */

#include <config.h>
#include <gnome.h>
#include "think.h"

static void think_quit (GtkWidget *widget, gpointer data);

int 
main (int argc, char *argv[])
{
	GtkWidget *main_window;
	gchar *filename = NULL;
	char **args;
	poptContext ctx;

	gnome_init_with_popt_table ("think", VERSION, argc, argv, NULL, 0, &ctx);
	args = (char **)poptGetArgs(ctx);

	if (args) 
		filename = args[0];

	poptFreeContext (ctx);

	main_window = think_window_new (filename);
	gtk_widget_show (main_window);

	gtk_main();
  
	return 0;
}
