/* GnomerMind - A MasterMind(R)-based game for Gnome
 * (C) 2001 Germano Rizzo
 *
 * menu.c - menubar & statusbar implementation
 * Author: Germano Rizzo
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common.h"
#include <unistd.h>
#include <sys/stat.h>
#include "gnomermind.h"
#include "face.h"
#include "prefs.h"
#include "themes.h"
#include "save.h"

static void game_about ();
static void confirm_newall ();
static void confirm_rst ();
static void confirm_suicide ();

#ifndef PREFIX_EQUAL_TO_GNOME
static void help_manual ();
#endif

static GtkWidget *sb;

static const gchar *msg[] = {
  N_("You'll end the current game!"),
  N_("You'll lose all your tries!"),
  N_("Are you sure?"),
  N_("You can't!"),
  N_("You already know the solution!! ;)")
};

static GnomeUIInfo file_menu[] = {
  GNOMEUIINFO_MENU_NEW_GAME_ITEM (confirm_newall, NULL),
  GNOMEUIINFO_SEPARATOR,
  {
   GNOME_APP_UI_ITEM,
   N_("_Save and exit"),
   N_("Save the current game and quit"),
   save_and_exit,
   NULL,
   NULL,
   TRUE,
   GNOME_STOCK_PIXMAP_SAVE,
   '\0',
   GDK_CONTROL_MASK,
   NULL},
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (gtk_main_quit, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo game_menu[] = {
  GNOMEUIINFO_MENU_RESTART_GAME_ITEM (confirm_rst, NULL),
  GNOMEUIINFO_MENU_END_GAME_ITEM (confirm_suicide, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PREFERENCES_ITEM (prefs_show, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo help_menu[] = {
#ifdef PREFIX_EQUAL_TO_GNOME
  GNOMEUIINFO_HELP ("gnomermind"),
#else
  {
   GNOME_APP_UI_ITEM,
   "Gnomermind",
   N_("User's manual"),
   help_manual,
   NULL,
   NULL,
   GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_HELP,
   0,
   0,
   NULL},
#endif
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_ABOUT_ITEM (game_about, NULL),
  {
   GNOME_APP_UI_ITEM,
   N_("About _theme..."),
   N_("About the current theme"),
   theme_about,
   NULL,
   NULL,
   TRUE,
   GNOME_STOCK_PIXMAP_ABOUT,
   '\0',
   GDK_CONTROL_MASK,
   NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_game[] = {
  GNOMEUIINFO_MENU_FILE_TREE (file_menu),
  GNOMEUIINFO_MENU_GAME_TREE (game_menu),
  GNOMEUIINFO_MENU_HELP_TREE (help_menu),
  GNOMEUIINFO_END
};

/**
 * msgpush
 * @msg: the message to push
 *
 * Display a message in the statusbar
 **/
void
msgpush (gchar * msg)
{
  gnome_appbar_push (GNOME_APPBAR (sb), msg);
}

/**
 * msgpop
 *
 * Removes current message from the statusbar
 **/
void
msgpop ()
{
  gnome_appbar_pop (GNOME_APPBAR (sb));
}

/**
 * game_about
 * 
 * Displays the about window
 **/
static void
game_about ()
{
  GtkWidget *abo;
  const gchar *cop = _("(c) 2001, Germano Rizzo");
  const gchar *a[] = {
    "Germano Rizzo <mano78@users.sourceforge.net>",
    _("additional coding by"),
    "Marco Cova <mcova@users.sourceforge.net>",
    NULL
  };
  const gchar *des =
    _
    ("A simple but (I hope) intriguing game based (but not quite the same!) on the original MasterMind(R) game... with some spice added!\n              Have Fun!!! =:o)");
  const gchar *site = _("Web Site: http://gnomermind.sourceforge.net");
  const gchar *pix = "gnomermind.png";

  msgpush (_("*** To Paola ***"));

  abo =
    gnome_about_new (app, VERSION, cop, a,
		     g_strconcat (des, "\n \n", site, NULL), pix);

  gtk_signal_connect (GTK_OBJECT (abo), "clicked",
		      GTK_SIGNAL_FUNC (msgpop), NULL);
  gtk_signal_connect (GTK_OBJECT (abo), "close",
		      GTK_SIGNAL_FUNC (msgpop), NULL);
  gtk_window_set_modal (GTK_WINDOW (abo), TRUE);
  gtk_widget_show (abo);
}

#ifndef PREFIX_EQUAL_TO_GNOME
/**
 * help_manual
 *
 * Displays the user's manual
 **/
static void
help_manual ()
{
  gchar *doc_path;
/*
 * Uncomment if there's a translation other than `C'
 *
  gchar *lang;
  struct stat buf;

  lang = getenv ("LANG");

  g_assert (lang != NULL);

  doc_path =
    g_strconcat (GNOME_HELPDIR, lang, G_DIR_SEPARATOR_S, "index.html", NULL);

   *
   * if locale language help doesn't exist, falls back
   * on its base, and then on C
   *

  if (stat (doc_path, &buf) || !S_ISREG (buf.st_mode))
    {
      gchar *slang;

      slang = g_strndup (lang, 2);
      doc_path =
	g_strconcat (GNOME_HELPDIR, slang, G_DIR_SEPARATOR_S, "index.html",
		     NULL);
      g_free (slang);
    }

  if (stat (doc_path, &buf) || !S_ISREG (buf.st_mode))

  */

  doc_path =
    g_strconcat (GNOME_HELPDIR, "C", G_DIR_SEPARATOR_S, "index.html", NULL);

  gnome_help_goto (NULL, g_strconcat ("file:", doc_path, NULL));
}
#endif

/**
 * confirm_newall
 *
 * Asks for confirmation before starting a new game
 **/
static void
confirm_newall ()
{
  GtkWidget *dialog;

  if (ask)
    dialog =
      gnome_question_dialog_parented (g_strconcat
				      (_(msg[0]), "\n", _(msg[2]),
				       NULL), newall, NULL,
				      GTK_WINDOW (gwin));
  else
    newall (GNOME_YES, NULL);
}

/**
 * confirm_rst
 *
 * Asks for confirmation before restarting the current game
 **/
static void
confirm_rst ()
{
  GtkWidget *dialog;

  if (state > 1)
    dialog = gnome_warning_dialog_parented (g_strconcat
					    (_(msg[3]), "\n", _(msg[4]),
					     NULL), GTK_WINDOW (gwin));

  else if (ask)
    dialog =
      gnome_question_dialog_parented (g_strconcat
				      (_(msg[1]), "\n", _(msg[2]),
				       NULL), rst, NULL, GTK_WINDOW (gwin));
  else
    rst (GNOME_YES, NULL);
}

/**
 * confirm_suicide
 *
 * Asks for confirmation before showing the solution
 **/
static void
confirm_suicide ()
{
  GtkWidget *dialog;

  if (state > 1)
    return;

  if (ask)
    dialog =
      gnome_question_dialog_parented (g_strconcat
				      (_(msg[0]), "\n", _(msg[2]),
				       NULL), suicide, NULL,
				      GTK_WINDOW (gwin));
  else
    suicide (GNOME_YES, NULL);
}

/**
 * add_bars
 * @a: the window in which to place the bars
 * 
 * Adds the menu and status bars to the game window
 **/
void
add_bars (GtkWidget * a)
{
  gnome_app_create_menus (GNOME_APP (a), menu_game);
  sb = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_USER);
  gnome_appbar_set_default (GNOME_APPBAR (sb),
			    g_strconcat (app, " ", VERSION, NULL));
  gnome_app_set_statusbar (GNOME_APP (a), sb);
  gnome_app_install_menu_hints (GNOME_APP (a), menu_game);
};
