/**
 ** rule_dialog.c - gathering of user input related to playlist rules
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "mp3list.h"
#include "rule_list.h"

GtkWidget *hit_clist;

/* 
 * load and display the primary rule editing dialog. Rules are loaded from the
 * global rule list (gnomp3.rule_list) into the clist in the dialog. 
 */
void rule_dialog_load()
{
    GladeXML *xml;
    GList *ptr = gnomp3.rule_list;
    char *text[1];
    GtkWidget *pixmap;

    if( gnomp3.rule_clist )
	return; /* window already open */

    xml = glade_xml_new( gnomp3.glade_file, "rule_dialog");
    if(!xml) {
	g_warning("We could not load the main_window interface!");
	return;
    }
    
    gnomp3.rule_clist = glade_xml_get_widget(xml, "rule_clist");
    pixmap = glade_xml_get_widget(xml, "pixmap");

    gtk_pixmap_set( GTK_PIXMAP(pixmap), gnomp3.rule_big->pixmap, gnomp3.rule_big->mask );
    
    glade_xml_signal_autoconnect(xml);
    gtk_object_unref(GTK_OBJECT(xml));

    while(ptr){
	text[0] = ptr->data;
	gtk_clist_append( GTK_CLIST(gnomp3.rule_clist), text);
	ptr = ptr->next;
    }
}

/* 
 * callback executed when one of the buttons in the rule dialog is clicked.
 * Button is the number of the button clicked. 0 == OK, 1 == APPLY 2 == CLOSE 
 * If the rule set in the clist is to be applied then the global rule set is
 * destroyed and replaced 
 */
void rule_dialog_clicked(GnomeDialog *dlg, int button, gpointer data)
{
    char *text;
    int i;
    
    if( button == 0 || button == 1 ){ /* OK || APPLY */
	g_list_foreach( gnomp3.rule_list, (GFunc)g_free, NULL );
	g_list_free (gnomp3.rule_list);
	gnomp3.rule_list = NULL;
	
	for( i = 0; i < GTK_CLIST(gnomp3.rule_clist)->rows; i++){
	    gtk_clist_get_text( GTK_CLIST(gnomp3.rule_clist), i , 0, &text);
	    gnomp3.rule_list = g_list_append( gnomp3.rule_list, g_strdup(text));
	}
	
	rule_list_apply();
    }
    
    if( button == 0 || button == 2 ){ /* OK || CLOSE */
	gnomp3.rule_clist = NULL;
	gnome_dialog_close(dlg);
    }
}

/* 
 * this routine is called when rule is to be edited (i.e. when the edit button
 * is clicked. The new button callback also calls this routine after it has
 * created a empty rule. The UI is loaded tru libglade and is modal 
 */
void rule_dialog_edit_cb()
{
    GladeXML *xml;
    char *text;
    GtkWidget *dlg;
    GtkWidget *entry;
    int i;
    
    if( !GTK_CLIST(gnomp3.rule_clist)->selection )
	return;

    xml = glade_xml_new( gnomp3.glade_file, "rule_edit_dialog");
    if(!xml) {
	g_warning("We could not load the main_window interface!");
	return;
    }
    dlg = glade_xml_get_widget(xml, "rule_edit_dialog");
    entry = glade_xml_get_widget(xml, "rule_edit_entry");
    hit_clist = glade_xml_get_widget(xml, "hit_clist");

    gnome_dialog_editable_enters( GNOME_DIALOG(dlg), GTK_EDITABLE(entry));

    gtk_clist_get_text( GTK_CLIST(gnomp3.rule_clist), 
			(int)GTK_CLIST(gnomp3.rule_clist)->selection->data,
			0,
			&text);

    gtk_entry_set_text( GTK_ENTRY(glade_xml_get_widget(xml, "rule_edit_entry")), 
			text);
    glade_xml_signal_autoconnect(xml);
    gtk_object_unref(GTK_OBJECT(xml));

    i = gnome_dialog_run(GNOME_DIALOG(dlg));
    if( i == 0 ){
	gtk_clist_set_text (GTK_CLIST(gnomp3.rule_clist), 
			    (int)GTK_CLIST(gnomp3.rule_clist)->selection->data,
			    0, 
			    gtk_entry_get_text (GTK_ENTRY (entry)));
    }
    gnome_dialog_close(GNOME_DIALOG(dlg));
}

/* creates a new row and displayed the edit dialog for the new entry */
void rule_dialog_new_cb()
{
    char *text[1] = { "" };
    int n;

    n = gtk_clist_append( GTK_CLIST(gnomp3.rule_clist), text);
    gtk_clist_unselect_all (GTK_CLIST (gnomp3.rule_clist));
    gtk_clist_select_row (GTK_CLIST (gnomp3.rule_clist), n, 0);
    
    rule_dialog_edit_cb();
}

/* deletes the selected rule. Called from the 'delete' button */
void rule_dialog_delete_cb()
{
    if( !GTK_CLIST(gnomp3.rule_clist)->selection )
	return;

    gtk_clist_remove( GTK_CLIST (gnomp3.rule_clist), (int)GTK_CLIST(gnomp3.rule_clist)->selection->data );
}

/*
 * Callback to add songs to the clist in the rule_edit_dialog
 */
void hit_list_add(MP3 *mp3)
{
    char *col[2];
    int n;

    col[0] = mp3->display_name;
    col[1] = mp3list_build_time(mp3);
    n = gtk_clist_append( GTK_CLIST(hit_clist), col);
    gtk_clist_set_row_data( GTK_CLIST(hit_clist), n, mp3);
    if(mp3->row_playlist >= 0){
	gtk_clist_set_background( GTK_CLIST(hit_clist), n,
 				  &gnomp3.in_playlist_bg_color);
	gtk_clist_set_foreground( GTK_CLIST(hit_clist), n,
 				  &gnomp3.in_playlist_fg_color);
    }
}

/*
 * Callback for the rule edit dialogs entry field. Performas a search for the
 * given rule.
 */
void rule_edit_dialog_changed(GtkEditable *editable, gpointer user_data)
{
    char *string;

    string = gtk_entry_get_text(GTK_ENTRY(editable));
    
    gtk_clist_freeze( GTK_CLIST(hit_clist));
    gtk_clist_clear( GTK_CLIST(hit_clist));
    
    mp3list_search_by_name( string, hit_list_add );
    
    gtk_clist_thaw( GTK_CLIST(hit_clist));
}


