#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001 Free Software Foundation
#
# FILE:
# gnue.common.__init__
#
# DESCRIPTION:
#
# NOTES:
#
# HISTORY:
#
#

# CREATING A RELEASE:
#   1. Change _version to be the current version number
#   2. Set _release to 1
#
# AFTER THE RELEASE:
#   3. Increase the minor number
#   4. Set _release = 0
#   5. Commit to CVS

_version = (0,1,1)
_release = 1

# Version will be of the form "1.1.2" if a release or "1.1.2a" if in CVS
VERSION= ("%s.%s.%s" % _version) + (not _release and 'a' or '')

# Hex Version will be an integer in which version 1.2.15 is represented
# as 0x010215FF (for a release) or 0x01021500 (for a CVS snapshot)
# This allows numeric testing of version numbers
# (e.g., HEXVERSION >= 0x01020000)
HEXVERSION = eval('0x%s%s' % ('%02d%02d%02d' % _version,
                                                             _release and 'FF' or '00') )

# Sigh... For Python compatability
__version__ = VERSION
__hexversion__ = HEXVERSION

import os
import urllib
import string

#
# Open a file or URL resource, 
# properly handling drive letters.
#
def openResource(resource): 
  drive = os.path.splitdrive(resource) 
  if len(drive[0]):
    return open(resource,'r')
  else:
    return urllib.urlopen(resource)


#
# Dynamically import a python module
#
import string

def dyn_import(name):
  try:
    mod = __import__(name)
    components = string.split(name, '.')
    for comp in components[1:]:
        mod = getattr(mod, comp)
    return mod
  except AttributeError, mesg: 
    raise ImportError, mesg


