#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# geas/DBdriver.py
#
# DESCRIPTION:
# Implementation of dbdriver for use with GNUe Application Server.
#
# NOTES:
# This implementation currently requires the use of python-orbit 
# bindings.  You MUST use orbit-python 0.3.0 or newer 
#
# HISTORY:
#

from gnue.common import GDataObjects, GDebug, GConditions, GConfig
import string
import types
import md5
import sys

try:
    import CORBA
    idlFiles=GConfig.get('GEASDIR')+"/share/idl/geas.idl"
    GDebug.printMesg(1,"IDL being loaded from %s" % (idlFiles))
    CORBA._load_idl(idlFiles)
    import GEAS
    
except ImportError,ex:
    print "Failed to load CORBA module."
    print "Please see http://orbit-python.sault.org/ for the required python CORBA bindings"
    sys.exit(0)

class GEAS_RecordSet(GDataObjects.RecordSet): 
  def _postChanges(self): 
    values = []
    fields = []
    fieldString = ""
    for field in (self._modifiedFields.keys()): 
      fields.append(field + " = %s")
      values.append(self._fields[field])
    
    # statement = 'UPDATE %s SET %s WHERE %s = %s'

# GEAS_ResultSet
#
# Notes:
# In the GEAS driver a CURSOR is simply the ObjectList handle returned
# via the query interface
#
class GEAS_ResultSet(GDataObjects.ResultSet): 
  def __init__(self, dataObject, cursor=None, \
        defaultValues={}, masterRecordSet=None): 
    GDataObjects.ResultSet.__init__(
           self,dataObject,cursor,defaultValues,masterRecordSet)
    self._recordSetClass = GEAS_RecordSet
    self._fieldNames = None
    GDebug.printMesg(5, 'ResultSet created')

  
  def _loadNextRecord(self): 
    if self._cursor:
      #try:
      #   resultSet= self._dataObject._dataConnection.loadAll(self._dataObject.table)
      #except self._dataObject._DatabaseError, err:
      # raise GDataObjects.ConnectionError, err

      # Populate field names
      if not self._fieldNames:
          self._fieldNames = self._dataObject.getFields(self._dataObject.table)

      # Populate the result set
      #for recordSet in resultSet.objects:
      for recordSet in self._cursor.objects:
        dict = {}
        for fieldName in self._fieldNames:
            dict[fieldName] = recordSet.getField(fieldName)
        self._cachedRecords.append (self._recordSetClass(parent=self, \
                                                         initialData=dict))
      return 1
    return 0

class GEAS_DataObject(GDataObjects.DataObject):
  # ConditionalName (min args, max args, field creation, bypass function )
  #
  # Commented out conditionals are a bad thing
  conditionElements = {
       'add':             (2, 999, None,                   'None'      ),
       'sub':             (2, 999, None,                   'None'      ),
       'mul':             (2, 999, None,                   'None'      ),
       'div':             (2, 999, None,                   'None'      ),
       'and':             (1, 999, None,                   'None'      ),
       'or':              (2, 999, None,                   'None'      ),
       'not':             (1,   1, None,                   'None'      ),
       'negate':          (1,   1, None,                   'None'      ),
       'eq':              (2,   2, 'queryObject.addField(GEAS.Query.Field( field="%s", test=GEAS.Query.equals,' + \
                                   'invert=CORBA.FALSE,casesensitive=CORBA.FALSE,value=%s))',                None     ),
#       'ne':              (2,   2, '(%s != %s)',             None     ),
#       'gt':              (2,   2, '(%s > %s)',              None     ),
#       'ge':              (2,   2, '(%s >= %s)',                None     ),
#       'lt':              (2,   2, '(%s < %s)',                 None     ),
#       'le':              (2,   2, '(%s <= %s)',                None     ),
       'like':            (2,   2, 'queryObject.addField(GEAS.Query.Field( field="%s", test=GEAS.Query.equals,' + \
                                   'invert=CORBA.FALSE,casesensitive=CORBA.FALSE,value=%s))',                None     ),
#       'notlike':         (2,   2, '%s NOT LIKE %s',            None     ),
#       'between':         (3,   3, '%s BETWEEN %s AND %s',      None     )
       }

  def __init__(self):
    GDataObjects.DataObject.__init__(self)

    GDebug.printMesg (1,"GEAS database driver backend initializing")
    self._resultSetClass = GEAS_ResultSet
    self._DatabaseError = GEAS.ServerError

  def connect(self, connectData={}): 
    GDebug.printMesg(1,"GEAS database driver connecting...")
    # Extract the username and password...
    user = connectData['_username']
    passwd = connectData['_password']

    # find the object server base object
    self.orb = CORBA.ORB_init(() , CORBA.ORB_ID)
    try:
      print GConfig.get('GEASDIR')+"/var/run/geas-server.ior"
      self.ior = open(GConfig.get('GEASDIR')+"/var/run/geas-server.ior").readline()
    except (IOError), ex:
      GDebug.printMesg(1, "*** Error: ior file for geas was not found...  is geas running?")
      raise GDataObjects.LoginError, 'Unable to connect to GEAS. Is it running?'

    self._factory = self.orb.string_to_object(self.ior)
    try:
      GDebug.printMesg(1,"Logging into geas as %s" % (user))
      if (user == 'guest') or (user == ''):

        # TODO: (jcater) I'm not so sure about guest logins. This
        # TODO: (jcater) should be discussed. At a minimum, I think
        # TODO: (jcater) we need gnue.conf flags:
        # TODO: (jcater)     allowGuestLogin = [0|1]
        # TODO: (jcater)     guestLogin = guest
        # TODO: (jcater)     allowBlankLogin = [0|1]
        self._dataConnection = self._factory.guestLogin()
      else:

        # TODO: (jcater) The GEAS docs say this is not supported and
        # TODO: (jcater) CORBA-based security should instead be used.
        # TODO: (jcater) As I don't know jack about CORBA security,
        # TODO: (jcater) this will have to do for now (even though,
        # TODO: (jcater) IIRC, is does nothing to validate the user/pass
        # TODO: (jcater) supplied to it.)
        self._dataConnection = self._factory.unsecureLogin(user,passwd)

      self.triggerExtensions = TriggerExtensions(self._dataConnection)

    except (GEAS.ServerError, GEAS.AuthenticationError), ex:
      raise GDataObjects.ConnectionError, ex

    #
    # Enter transactional mode...
    #   TODO: (jcater) As transaction support does not yet exist in GEAS, 
    #   TODO: (jcater) I have no idea if this works, if it will change, 
    #   TODO: (jcater) or, well, anything for that matter. Think of it  
    #   TODO: (jcater) as a placeholder.
    self._transaction = self._dataConnection.new()


  # We only need the basics -- username and password -- to log in
  def getLoginFields(self): 
    return [['_username', 'User Name',0],['_password', 'Password',1]]

  def _buildQuery(self, conditions={}):
    # Standardize incomming conditions as a GConditions sturcutre
    if type(conditions) == types.DictType:
        cond = GConditions.buildConditionFromDict(conditions)
    else:
        cond = conditions

    # Construct query object
    GDebug.printMesg(7,'Implicit Fields: %s' % self._fieldReferences)
    query = self._dataConnection.newQuery()
    query.classname = "%s" % self.table
    query.orderby = "name"
    #query.reverse = CORBA.FALSE
    query.logic = GEAS.Query.AND
    
    # Add conditionals
    self.__conditionToGEASQuery(query, cond._children[0])
    
    return query

  def __conditionToGEASQuery(self, queryObject, conditionTree, count=1):
      if type(conditionTree) != types.InstanceType:
          return "%s" % conditionTree # This is usless in this driver as it won't be a string
      else:
          print ":"*count, conditionTree.getObjectType()
          otype = string.lower(conditionTree.getObjectType()[2:])
          if otype == 'cfield':
              return "%s" % conditionTree.name
          elif otype == 'cconst':
              if conditionTree.value == None:
                  return "NULL"
              elif conditionTree.type == 'number':
                  return "%s" % conditionTree.value
              else:
                  return "'%s'" % conditionTree.value
          elif otype == 'param':
              v = conditionTree.getValue()
              return (v == None and "NULL") or ("'%s'" % conditionTree.getValue())
          
          # If the object is a conditional object then process it's children to build query
          elif self.conditionElements.has_key(otype):
              for i in range(0, len(conditionTree._children)):
                  conditionTree._children[i] = self.__conditionToGEASQuery(queryObject,conditionTree._children[i])
              if len(conditionTree._children) < self.conditionElements[otype][0]:
                  raise GConditions.ConditionError, \
                        'Condition element "%s" expects at least %s arguments; found %s' % \
                        (otype, self.conditionElements[otype][0], len(conditionTree._children))
              if len(conditionTree._children) > self.conditionElements[otype][1]:
                  raise GConditions.ConditionError, \
                        'Condition element "%s" expects at most %s arguments; found %s' % \
                        (otype, self.conditionElements[otype][0], len(conditionTree._children))
              if self.conditionElements[otype][3] == None:
                  eval(self.conditionElements[otype][2] % tuple(conditionTree._children))
              else:
                  eval(self.conditionElements[otype][3])
                            # It's an unsupported condition so flag an error
          else:
              raise GConditions.ConditionNotSupported, \
                    'Condition clause "%s" is not supported by this db driver.' % otype
              
          #print " "*count, conditionTree.getObjectType()," : ", conditionTree.getValue()
          #for i in range(0, len(conditionTree._children)):
          #    self.__conditionToGEASQuery(queryObject, conditionTree._children[i],count+1)

        ##f = GEAS.Query.Field( field=fieldname, test=GEAS.Query.equals,invert=CORBA.FALSE,
        ##                      casesensitive=CORBA.FALSE,value=str(conditions[fieldname]))
        ##query.addField( f )
                      
  def _createEmptyResultSet(self, readOnly=0, masterRecordSet=None):
    return self.createResultSet(readOnly=readOnly, masterRecordSet=masterRecordSet)

  def _createResultSet(self, conditions={}, readOnly=0, masterRecordSet=None):
    print "Conditions", conditions # self._buildQuery(conditions)
    try:
      if conditions:
        obj_list = self._dataConnection.executeQuery(self._buildQuery(conditions))  
      else:
        obj_list = self._dataConnection.loadAll(self.table)
      
    except self._DatabaseError, err: 
      raise GDataObjects.ConnectionError, err
  
    rs = self._resultSetClass(self, cursor=obj_list, masterRecordSet=None)
    if readOnly: 
      rs._readonly = readOnly
    return rs

  def commit(self): 
    GDebug.printMesg (5,"GEAS database driver: commit()")
 
    try: 
      self._dataConnection.commit()
    except self._DatabaseError, value:
      raise GDataObjects.ConnectionError, value

  def rollback(self): 
    GDebug.printMesg (5,"GEAS database driver: rollback()")

    try: 
      self._dataConnection.abort()
    except: 
      pass	# I'm SURE this isn't right (jcater)
                # But not all db's support transactions
                # TODO : (jamest) This is cruft from _dbsig driver
                # TODO : not sure what to make of it yet for geas

  def getSchemaTypes(self):
      return [('object','Object',1)]

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
      includeObjects = (type in ('object','sources', None))
      
      list = []
      for classname in self._dataConnection.classes:
        list.append(self.getSchemaByName(classname))
      return list

  def getSchemaByName(self, name, type=None): 
      classdef = self._dataConnection.getFullClassDefinition(str(name))
      schema = GDataObjects.Schema(attrs={'id':string.lower(classdef.name),
                                          'name':classdef.name,
                                          'type':'object'},
                                   getChildSchema=self.__getFieldSchema)
      return schema
  
  # Get fields/methods of a GEAS object
  def __getChildSchema(self, parent):
      list = []
      c = con.getFullClassDefinition( classnames[idx-1] )
      
  def getFields(self, name):
      list = []
      classdef = self._dataConnection.getFullClassDefinition(str(name))
      for field in classdef.fields:
          list.append(field.name)

      return list

supportedDataObjects = { 
  'object': GEAS_DataObject
}


class TriggerExtensions:

    def __init__(self, connection):
        pass
