#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# sybase/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via Dave Cole's Sybase ASE/Python Driver
# Requires Sybase.py (http://www.object-craft.com.au/projects/sybase/)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     service=    This is the Sybase DSN for your connection  (required)
#     dbame=      This is the Sybase database to use (optional)
#

#### THIS IS AN UNTESTED DRIVER ####
####      Any volunteers?       ####


from string import lower
import sys
from gnue.common import GDebug, GDataObjects, GConnections
from gnue.common.dbdrivers._dbsig.DBdriver \
   import DBSIG_RecordSet, DBSIG_ResultSet, DBSIG_DataObject, \
          DBSIG_DataObject_SQL, DBSIG_DataObject_Object

try:
  import Sybase as SIG2api
except ImportError, message:
  raise GConnections.AdapterNotInstalled, \
         "Driver not installed: Sybase.py for Sybase ASE 11.0/11.9 [%s]" % message


class Sybase_RecordSet(DBSIG_RecordSet):
  pass


class Sybase_ResultSet(DBSIG_ResultSet):
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    DBSIG_ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = Sybase_RecordSet



class Sybase_DataObject(DBSIG_DataObject):
  def __init__(self):
    DBSIG_DataObject.__init__(self)
    self._DatabaseError = SIG2api.DatabaseError
    self._resultSetClass = Sybase_ResultSet


  def connect(self, connectData={}):
    GDebug.printMesg(1,"Sybase database driver initializing")
    try:
      if connectData.has_key('dbname'):
        self._dataConnection = SIG2api.connect( \
                  service=connectData['service'],  \
                  user=connectData['_username'], \
                  passwd=connectData['_password'], \
                  datbase=connectData['dbname'])
      else:
        self._dataConnection = SIG2api.connect( \
                  service=connectData['service'],  \
                  user=connectData['_username'], \
                  passwd=connectData['_password'])
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    self._postConnect()



  #
  # Schema (metadata) functions
  #

  # TODO: See postgresql for an example of what these functions do.

  # Return a list of the types of Schema objects this driver provides
  def getSchemaTypes(self):
    return [('view','View',1), ('table','Table',1)]

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    return []

  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    return None

  def _postConnect(self):
    self.triggerExtensions = TriggerExtensions(self._dataConnection)


class Sybase_DataObject_Object(Sybase_DataObject, \
      DBSIG_DataObject_Object):

  def __init__(self):
    Sybase_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG_DataObject_Object._buildQuery(self, conditions)


class Sybase_DataObject_SQL(Sybase_DataObject, \
      DBSIG_DataObject_SQL):
  def __init__(self):
    # Call DBSIG init first because Sybase_DataObject needs to overwrite
    # some of its values
    DBSIG_DataObject_SQL.__init__(self)
    Sybase_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG_DataObject_SQL._buildQuery(self, conditions)


#
#  Extensions to Trigger Namespaces
#
class TriggerExtensions:

  def __init__(self, connection):
    self.__connection = connection




######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': Sybase_DataObject_Object,
  'sql':    Sybase_DataObject_SQL
}

