#!/usr/bin/env python
#
# Copyright 2001 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#

import sys
import string
import os

from src import VERSION

# First of all, make sure this is a current enough Python release.
try:
  if sys.hexversion < 0x02000000:
    raise AttributeError
except AttributeError:
  print "-" * 70
  print """
  You are running Python %s.

  GNU Enterprise requires at least Python 2.0 (recommended: 2.1+).
  If you have a later version installed, you should run setup.py
  against that version. For example, if you have Python 2.1
  installed, you may need to run:

       python2.1 setup.py
""" % string.split(sys.version)[0]
  print "-" * 70
  sys.exit()

#
# hack to deal w/ fact distutils won't
# allow us to set absolute path prefix
# on windows
#

if not 'sdist' in sys.argv:
  if sys.platform != 'win32':
    os.system ("""cp setup.cfg.in setup.cfg""")
  else:
    try:
      os.remove('setup.cfg')
    except:
      pass

try:
  import distutils
  from distutils.command.build_scripts import build_scripts
  from distutils.command.build import build
  from setupext import Data_Files, install_Data_Files
except ImportError:
  print """
Setup requires that python's distutils be
installed.  You can get a copy of it from
http://www.python.org/sigs/distutils-sig/
    """
  sys.exit()


dfiles = [
  Data_Files(
             base_dir = 'install_data',
             copy_to = 'shared',
             template = ['recursive-include images *.png',
                         'recursive-include images *.xpm',
                         'recursive-include images *.ico',
                         'prune images/CVS'],
             preserve_path = 1),
  Data_Files(
             base_dir = 'install_data',
             copy_to = '',
             template = ['recursive-include etc *',
                         'prune etc/CVS'],
             preserve_path = 1),
  Data_Files(
             base_dir = 'install_data',
             copy_to = 'doc/common',
             template = ['recursive-include doc *',
                         'prune doc/CVS'],
             strip_dirs = 1, # This is a number, not true/false
             preserve_path = 1)
  ]

class my_build_scripts(build_scripts):
  def finalize_options(self):

    build_scripts.finalize_options(self)

    if self.finalized:
      return

    dict = self.distribution.get_option_dict("install")
    options = []

    # This statement stops the "search path" error messages
    try: 
      sys.path.append(dict['install_lib'][1])
    except KeyError: 
      if sys.platform == 'win32': 
        options.append('install_lib = r"%s"' % sys.prefix)

    for key in dict.keys():
      options.append('%s = "%s"' % (key, string.replace(dict[key][1],'"','\\"')))

    gnue_sys_py = """
#
# Copyright 2001 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#

import sys

# Settings used during installation
%s


# Add gnue base directory to the sys.path
if install_lib not in sys.path:
  sys.path.insert(0,install_lib)
""" % string.join(options,'\n')

    output = open("gnue_sys.py", "w")
    output.write(gnue_sys_py)
    output.close()


distutils.core.setup (name = "GNUe-Common",
       version = VERSION,
       description = "Base files of a GNU Enterprise Tools install",
       long_description = "",
       author = "GNUe Project",
       author_email = "info@gnue.org",
       url = "http://www.gnue.org",
       # Override certain command classes with our own ones
       cmdclass = {'install_data':install_Data_Files,
                   'build_scripts':my_build_scripts},
#       scripts = ["scripts/gnuedtd"],
       data_files = dfiles,
       packages = ["gnue",
                   "gnue.common",
                   "gnue.common.FormatMasks",
#                   "gnue.common.installer",
                   "gnue.common.dbdrivers",
                   "gnue.common.dbdrivers._dbsig",
                   "gnue.common.dbdrivers._empty",
                   "gnue.common.dbdrivers._oracle",
                   "gnue.common.dbdrivers._pgsql",
                   "gnue.common.dbdrivers._static",
                   "gnue.common.dbdrivers.geas",
                   "gnue.common.dbdrivers.mysql",
                   "gnue.common.dbdrivers.odbc",
                   "gnue.common.dbdrivers.mxodbc",
                   "gnue.common.dbdrivers.oracle",
                   "gnue.common.dbdrivers.postgresql",
                   "gnue.common.dbdrivers.psycopg",
                   "gnue.common.dbdrivers.popy",
                   "gnue.common.dbdrivers.pypgsql",
                   "gnue.common.dbdrivers.cxoracle",
                   "gnue.common.dbdrivers.informix",
                   "gnue.common.dbdrivers.ingres",
                   "gnue.common.dbdrivers.interbase",
                   "gnue.common.dbdrivers.sapdb",
                   "gnue.common.dbdrivers.sqlrelay", 
                   "gnue.common.dbdrivers.sybase"
                 ],

       package_dir = {"gnue": 'gnue',
                      "gnue.common" : "src",
                      "gnue.common.installer" : "installer"},
       )

distutils.core.setup (name = "GNUe-Common",
       version = VERSION,
       description = "Base files of a GNU Enterprise Tools install",
       long_description = "",
       author = "GNUe Project",
       author_email = "info@gnue.org",
       url = "http://www.gnue.org",
       # Override certain command classes with our own ones
       py_modules = ['gnue_sys'],
       scripts = [],
       data_files = None,
       packages = []
       )


if 'install' in sys.argv:
  print """
  Note:
  Warnings about the files not being installed in pythons search path can be
  ignored. You must now go to gnue install area (typically /usr/local/gnue )
  and create an etc/gnue.conf file if you do not already have one.  A sample
  is located in that directory that you can typically just rename.

  """


