#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# cxoracle/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via Computronix's Oracle/Python Driver
# Requires cx_Oracle 2.2+ (http://www.computronix.com/utilities/)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     service=    This is the Oracle TNS name for your connection  (required)
#

import sys, string
from gnue.common import GDebug, GDataObjects, GConnections
from gnue.common.dbdrivers._dbsig.DBdriver \
   import DBSIG_RecordSet, DBSIG_ResultSet, DBSIG_DataObject, \
          DBSIG_DataObject_SQL, DBSIG_DataObject_Object

from gnue.common.dbdrivers._oracle.DBdriver import Oracle_Schema

try:
  import cx_Oracle as SIG2api
except ImportError, message:
  raise GConnections.AdapterNotInstalled, \
         "Driver not installed: cx_Oracle for Oracle 8.x [%s]" % message


class Oracle_RecordSet(DBSIG_RecordSet):
  pass


class Oracle_ResultSet(DBSIG_ResultSet):
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    DBSIG_ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = Oracle_RecordSet


class Oracle_DataObject(Oracle_Schema, DBSIG_DataObject):
  def __init__(self):
    Oracle_Schema.__init__(self)
    DBSIG_DataObject.__init__(self)
    self._DatabaseError = SIG2api.DatabaseError
    self._resultSetClass = Oracle_ResultSet


  def connect(self, connectData={}):
    GDebug.printMesg(1,"Oracle database driver initializing")
    try:
      self._dataConnection = SIG2api.connect("%s/%s@%s" \
                % (connectData['_username'], \
                   connectData['_password'], \
                   connectData['service']))
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    self._postConnect()




class Oracle_DataObject_Object(Oracle_DataObject, \
      DBSIG_DataObject_Object):

  def __init__(self):
    Oracle_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG_DataObject_Object._buildQuery(self, conditions)


class Oracle_DataObject_SQL(Oracle_DataObject, \
      DBSIG_DataObject_SQL):
  def __init__(self):
    # Call DBSIG init first because Oracle_DataObject needs to overwrite
    # some of its values
    DBSIG_DataObject_SQL.__init__(self)
    Oracle_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG_DataObject_SQL._buildQuery(self, conditions)




######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': Oracle_DataObject_Object,
  'sql':    Oracle_DataObject_SQL
}

