#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# pypgsql/DBdriver.py
#
# DESCRIPTION:
# Postgresql implementation of dbdriver using Python DB-SIG v2
# specification.
#
# NOTES:
#

import sys
from gnue.common import GDebug, GDataObjects
from gnue.common.dbdrivers._pgsql.DBdriver \
   import PGSQL_RecordSet, PGSQL_ResultSet, PGSQL_DataObject, \
          PGSQL_DataObject_SQL, PGSQL_DataObject_Object, \
          PGSQL_TriggerExtensions

try:
  from pyPgSQL import PgSQL # pyPgSQL 2.0 support
except ImportError:
  import PgSQL              # pyPgSQL 1.6 support

  
class PG_RecordSet(PGSQL_RecordSet):
  pass

class PG_ResultSet(PGSQL_ResultSet):
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    PGSQL_ResultSet.__init__(self, dataObject, \
                             cursor, defaultValues, masterRecordSet)
    self._recordSetClass = PG_RecordSet
    
  # TODO: Override the base _loadNextRecord as the fetchmany() from the cursor
  # TODO: returns an exception instead of None.  Not sure wazzup with that.
  def _loadNextRecord(self):
    if self._cursor:
      rs = None

      try:
        rsets = self._cursor.fetchmany()
      except self._dataObject._DatabaseError, err:
        rsets = None
      except:
        rsets = None

      if rsets and len(rsets):
        for rs in(rsets):
          if rs:
            i = 0
            dict = {}
            for f in (rs):
              dict[self._fieldNames[i]] = f
              i += 1
            self._cachedRecords.append (self._recordSetClass(parent=self, \
                                                             initialData=dict))
          else:
            return 0
        return 1
      else:
        return 0
    else:
      return 0
    
class PG_DataObject(PGSQL_DataObject):
  def __init__(self):
    PGSQL_DataObject.__init__(self, PgSQL, PG_ResultSet)

class PG_DataObject_Object(PG_DataObject, \
      PGSQL_DataObject_Object):

  def __init__(self):
    # Call PGSQL init first because PG_DataObject needs to overwrite
    # some of its values
    PG_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return PGSQL_DataObject_Object._buildQuery(self, conditions)


class PG_DataObject_SQL(PG_DataObject, \
      PGSQL_DataObject_SQL):
  def __init__(self):
    # Call PGSQL init first because PG_DataObject needs to overwrite
    # some of its values
    PG_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return PGSQL_DataObject_SQL._buildQuery(self, conditions)


#
#  Extensions to Trigger Namespaces
#
class TriggerExtensions(PGSQL_TriggerExtensions):
  pass

######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': PG_DataObject_Object,
  'sql':    PG_DataObject_SQL
}
