# GNU Enterprise RPC interface - Pythonware-XMLRPC client adapter
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: ClientAdapter.py 7009 2005-02-11 17:04:16Z reinhard $

# NOTES:
# Requires Python 2.3
#
# Client Parameters:
#
#    url         The complete URI address of the XML-RPC service.
#                e.g, url="https://www.domain.com:9876/service.php"
#    ..or..
#    transport   The service transport (either "http" or "https")
#    host        The hostname or IP address of the service
#    port        The port that the service is located on
#

import string
import sys
import socket

from gnue.common.apps import errors, GDebug
from gnue.common.rpc import client
from gnue.common.rpc.drivers import Base

try:
  import xmlrpclib
except ImportError:
  tmsg = u_("\nUnable to load xmlrpclib.  To use the XML-RPC interface, \n"
            "please install xmlrpc from:\n"
            "    http://www.pythonware.com/products/xmlrpc/")
  raise client.AdapterInitializationError, tmsg

import typeconv

# =============================================================================
# Client driver
# =============================================================================

class ClientAdapter (Base.Client):

  _default_transport = 'http'
  _default_port      = 8765

  # ---------------------------------------------------------------------------
  # Initialize object
  # ---------------------------------------------------------------------------

  def __init__ (self, params):

    Base.Client.__init__ (self, params)

    # setLoglevel    
    if hasattr (params, 'loglevel'):
      verbose = params ['loglevel']
    else:
      verbose = 0

    # create the real xmlrpc server proxy (i.e. client)
    self.__proxy = xmlrpclib.Server (self._url, verbose=verbose)

  # ---------------------------------------------------------------------------
  # Run a procedure on the server
  # ---------------------------------------------------------------------------

  def _runMethod (self, method, *args, **params):
    
    __args = [typeconv.python_to_rpc (arg, client.InvalidParameter)
              for arg in args]

    # TODO: Add type conversion for **params 

    to_call = getattr (self.__proxy, method);
        
    try:
      result = to_call (*__args, **params)

    except xmlrpclib.Fault, e:
      (exType, exName, exMessage, exDetail) = string.split (e.faultString,
                                                            u'\x91')
      raise errors.RemoteError, (exType, exName, exMessage, exDetail)

    except socket.error:
      raise errors.AdminError, errors.getException () [2]

    # check, if an object handle is sent
    # TODO: make a better check
    if type(result)==type("String") and len(result)==40 :

      # create an proxy for this handle
      return self._createproxy ("[%s]" % result)

    else:
      return typeconv.rpc_to_python (result, client.InvalidParameter)
