#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# _dbsig/DBdriver.py
#
# DESCRIPTION:
# Generic implementation of dbdriver using Python DB-SIG v2
# specification.
#
# NOTES:
# The classes below are meant to be extended
#
# HISTORY:
#

__all__ = ['ResultSet']

from gnue.common.datasources import GConditions, Exceptions
from gnue.common.datasources.drivers.Base import ResultSet as BaseResultSet
from gnue.common.apps import errors
import string
import types

from RecordSet import RecordSet

class ResultSet(BaseResultSet):
  _recordSetClass = RecordSet
  def __init__(self, *args, **parms):
    try:
      self._fieldOrder = parms['fieldOrder']
      del parms['fieldOrder']
    except KeyError:
      self._fieldOrder = []
    BaseResultSet.__init__(self, *args, **parms)

    self._fieldNames = []

    if self._cursor:
      for t in self._cursor.description:
        name = t[0].lower ()

        if not isinstance (t[0], types.UnicodeType):
          name = unicode (name, self._dataObject._connection._encoding)

        gDebug (8, "Field from Cursordescription: %s new %s" % (t[0], name))

        self._fieldNames.append (name)
        self._dataObject._fieldReferences [name] = ""

      gDebug (8, "DBSIG2::Fields from cursor set to %s" % self._fieldNames)

    self._recordCount = self._cursor.rowcount or 0

    gDebug (8, 'ResultSet created')

  def _loadNextRecord(self):
    if self._cursor:
      rs = None

      if self._dataObject._connection._broken_fetchmany:
        try:
          rsets = self._cursor.fetchmany()
        except:
          rsets = None
      else:
        try:
          # Pass arraysize because of mysql fetchmany bug in MySQLdb < 0.9.2
          rsets = self._cursor.fetchmany (self._cursor.arraysize)
        except self._dataObject._connection._DatabaseError, err:
          raise Exceptions.ConnectionError, errors.getException()[2]

      if rsets and len(rsets):
        for rs in rsets:
          if rs:
            i = 0
            dict = {}
            for f in (rs):
              if self._dataObject._unicodeMode and type(f)==types.StringType:
                f = unicode(f,self._dataObject._connection._encoding)

              try:
                name = self._fieldOrder[i]
                if not name:
                  raise IndexError
              except IndexError:
                  name = string.lower(self._fieldNames[i])
              dict[name] = f
              i += 1
            self._cachedRecords.append (self._recordSetClass(parent=self,
                                                             initialData=dict))
          else:
            return False
        return True
      else:
        # We no longer need the cursor if we are read only
        if self._readonly:
          self._cursor.close()
        return False
    else:
      return False

