#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# csv/DataObject.py
#
# DESCRIPTION:
# Static database driver for loading data from a CSV file
#
# NOTES:
# Requires Python >= 2.3


__all__ = ['DataObject']

import string
import csv
from gnue.common.datasources.GDataObjects import *
from gnue.common.datasources.drivers.special.static.DataObject import STATIC_DataObject
from gnue.common.datasources.drivers.special.static.ResultSet import STATIC_ResultSet
from gnue.common.datasources.drivers.special.static.RecordSet import STATIC_RecordSet

###########################################################
#
# This is an static data driver for connectionless clients
#
###########################################################
class CSV_DataObject (STATIC_DataObject):

  def __init__(self, connection):
    DataObject.__init__(self, connection)

  def _createResultSet(self, conditions={}, readOnly=0, masterRecordSet=None, sql=""):
    return CSV_ResultSet(self, masterRecordSet=masterRecordSet)



class CSV_ResultSet(STATIC_ResultSet):

  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)

    self._recordSetClass = STATIC_RecordSet

  # Returns 1=DataObject has uncommitted changes
  def isPending(self):
    return 0    # Static DataObjects cannot have pending changes :)

  # Post changes to the database
  def post(self):
    # Leave this here in case (for some bizarro reason)
    # a bound dataobject uses us as a master
    for record in (self._cachedRecords):
      record.post()

  # Load cacheCount number of new records
  def _loadNextRecord(self):
    if hasattr(self,"_alldataloaded"):
      return 0

    # Load static data
    for row in self._dataObject._dataConnection:
      record=self._recordSetClass(parent=self,initialData=row)

      self._cachedRecords.append (record)

      self._recordCount=self._recordCount+1

    self._alldataloaded = 1

    return 1
