#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# SQLRelay/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via SQLRelay's Python Driver
# Requires SQLRelay + Python-DB Driver (http://www.firstworks.com/sqlrelay)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     host=      This is the SQLRelay host for your connection (required)
#                In the format hostname:port (or ipaddr:port)
#

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####


from string import lower
import sys
from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2

try:
  from SQLRelay import PySQLRDB as SIG2api
except ImportError:
  raise GConnections.DependencyError, ('SQLRelay', None)


from gnue.common.datasources.drivers.sqlrelay.Schema.Discovery.Introspection import Introspection


######################################################################
#
#  GConnection object for PostgreSQL-based drivers
#
class Connection(DBSIG2.Connection):

  _driver = SIG2api
  defaultBehavior = Introspection
  _DatabaseError = SIG2api.DatabaseError
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }


  def connect(self, connectData={}):
    GDebug.printMesg(9,"SQLRelay database driver initializing")

    host = connectData['host']
    try:
      port = int(connectData['port'])
    except ValueError:
      port = 9000

    try:
      self.native = SIG2api.connect( host, port, '', \
                   connectData['_username'], \
                   connectData['_password'], \
                   0,1)
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

