#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2004-2005 Free Software Foundation
#
# FILE:
# barcodes/codabar.py
#
# DESCRIPTION:
"""
Implements the Codabar barcode spec
"""
#
from Base import Barcode

class Codabar(Barcode):
  chars = '0123456789-$:/.+'
  mapping = {
    '0': 'NnNnNwWn',
    '1': 'NnNnWwNn',
    '2': 'NnNwNnWn',
    '3': 'WwNnNnNn',
    '4': 'NnWnNwNn',
    '5': 'WnNnNwNn',
    '6': 'NwNnNnWn',
    '7': 'NwNnWnNn',
    '8': 'NwWnNnNn',
    '9': 'WnNwNnNn',
    '-': 'NnNwWnNn',
    '$': 'NnWwNnNn',
    ':': 'WnNnWnWn',
    '/': 'WnWnNnWn',
    '.': 'WnWnWnNn',
    '+': 'NnWwWwWn'
  }

  start = 'NwNwNnWn'
  stop  = 'nnNwWwN'

  lineWidth = .72 # points (1.0mil)
  lineHeight = 18 # 1/4"

  encodingMap = {
         # Stroke?, X Multiplier, Y Multiplier
    'n': (False, 1, 1),   # Narrow Spaces
    'w': (False, 2.5, 1),   # Wide Spaces
    'N': (True, 1, 1),    # Narrow bars
    'W': (True, 2.5, 1)   # Wide bars
  }

if __name__ == '__main__':

  codabar = Codabar()

  def test(value, format, file):
    f = open(file,'wb')
    codabar.generate(value,f, format)
    f.close()

#   test('0123456789-$:/.+','png','test1.png')
#   test('+./:$-9876543210','tiff','test1.tif')
  test('0123456789-$:/.+','eps','codabar-1.eps')
