#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# proxy/CommDriver.py
#
# DESCRIPTION:
# Class that provides a "proxy" GComm driver (i.e, the client and server
# are actually run in the same program instance -- requests are "proxied"
# from the client to the server via this driver; no network activity occurs)
#
# NOTES:
#
# Client Parameters:
#
#   _proxy    The actual ServerAdapter instance. This has to be set by
#             the application, not by a config file.
#

#
# We provide both a client and a server driver...
#
CLIENT = 1      # ClientAdapter
SERVER = 1      # ServerAdapter


from gnue.common.rpc.drivers import GCommBase
from gnue.common.rpc import GComm

import string, sys

##############################################################################
#
# ClientAdapter
#
class ClientAdapter(GCommBase.Client):

  def __init__(self, params):
    #print "Proxy Client Adapter created"
    try:
      self._serverproxy = params['_proxy']
    except KeyError:
      tmsg = _('Proxy client adapter should be called with the server object')
      raise GComm.AdapterInitializationError, tmsg

  def request(self, service, params={}):
    proxy = _ProxyObject(self, service, \
        servicer=self._serverproxy._bindings[service],
        proxyinstance=self._serverproxy._bindings[service]())
    return proxy




##############################################################################
#
# ServerAdapter
#
class ServerAdapter(GCommBase.Server):

  def __init__(self, rpcdef, bindings, params):
    #print "Proxy Server Adapter created"
    GCommBase.Server.__init__(self, rpcdef, bindings, params)

  def raiseException(self, exception, message, event=None):
    raise exception, message




##############################################################################
#
# ProxyObject
#
class _ProxyObject(GCommBase.ProxyObject):
  def __init__(self, adapter, attr, parent=None, **params):
    GCommBase.ProxyObject.__init__(self, adapter, attr, parent=None, **params)


  # Server raised an exception...
  # Translate the exception into a local python
  # exception and raise it...
  def _exceptionRaised(self, data):
    if data.isGNUeGenerated():
      name, text = string.split(data.message,': ',1)
      # TODO: _lookup???
      exception = _lookup[name]
      raise exception, text
    else:
      # TODO:
      raise StandardError, data.message


  def __call__(self, *args, **params):
    #print "Calling %s" % self._adapter
    return self._adapter.runMethod(self, string.join(self._attrPath,'.'),
                                  *args, **params)


