#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# LayoutEditor.py
#
# DESCRIPTION:
#
# NOTES:

import os, string
from wxPython.wx import *
from gnue.common.apps import GDebug, GConfig

from gnue.common.events import Event, EventAware

iconlocation = os.path.join(GConfig.getInstalledBase('designer_images','common_images') ,'designer')

def getIcon(name, w, h):
  return wxImage(os.path.join(iconlocation,"%s-%sx%s.png" % (name,w, h)),
                  wxBITMAP_TYPE_PNG).ConvertToBitmap()

class BaseToolBar(wxToolBar, EventAware):

  ICON_SIZE = (24,24)

  def getToolbarMapping(self):
    return ''

  def init(self):
    pass

  def __init__(self, parent, instance):
    self.instance = instance
    wxToolBar.__init__(self, parent, -1)
    EventAware.__init__(self, instance)
    self.mapping = {}
    self.SetToolBitmapSize(wxSize(*self.ICON_SIZE))
    self.init()
    self.Realize()

  def addToolbarMapping(self, mapping):
    for type in string.split(mapping,';'):
      if not len(type):
        self.AddSeparator()
      else:
        try:
          handle, image, options  = string.split(type,',',2)
          options = options.lower().split()
        except:
          handle, image  = string.split(type,',',1)
          options = ()

        try:
          shortHelp, longHelp = self.instance.menubar.getEventHelp(handle)
          shortHelp = shortHelp.replace('&','') #Menu entries can contain shortcut keys
          longHelp = longHelp.replace('&','')
        except:
          print "Warning: No event tied to %s" % handle
          shortHelp = ""
          longHelp = ""

        id = wxNewId()
        self.mapping[id] = handle
        self.mapping[handle] = id


        if 'pulldown' in options:
          print "Erm, I don't yet support pulldown toolbar buttons (%s)" % handle

        self.AddTool(id,
          getIcon(image, *self.ICON_SIZE),
          isToggle=1,
          shortHelpString=shortHelp,
          longHelpString=longHelp)

        self.SetToolClientData(id, handle)

        EVT_TOOL(self, id, self.OnButtonSelected)


  def resetTool(self, mode):
    if self.mapping.has_key(mode):
      self.ToggleTool(self.mapping[mode],0)


  def OnButtonSelected(self, event):
    #
    # Cheer up any previously depressed toolbuttons
    #
#    for key in self.mapping.keys():
#      try:
#        self.ToggleTool(int(key),0)
#      except ValueError:
#        pass


    handle = self.mapping[event.GetId()]
    state = self.GetToolState(event.GetId())
    self.ToggleTool(event.GetId(),0)
    if not state:
      evt = 'Cancel:%s' % handle
    else:
      evt = handle

    self.instance.dispatchEvent(evt)
