#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: Debugger.py 7255 2005-03-25 10:32:29Z kilo $

"""
Support class to run/debug a form from within Designer.
"""

import sys, os
from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.common.apps.GClientApp import GClientApp
from gnue.forms import GFForm, GFInstance, GFParser
from StringIO import StringIO
from gnue.forms.uidrivers.wx import UIdriver as UIwxpython

#####################################################
## TODO
##
## Open little output window to print debug messages.
## Currently disable with comment marks #~
##
#####################################################

class DebugSession: 
  def __init__(self, caller): 
    self.caller = caller
    
    #~ #Open output window to show debug messages there
    #~ #instead of the console
    #~ outputWindow = wxFrame(caller, -1, _("Console Output"), 
         #~ size=wxSize(300,50))
    #~ outputWindow.text = wxTextCtrl(outputWindow, -1, style=wxTE_MULTILINE)
    #~ outputWindow.Show(true)
    #~ caller.outputWindow = outputWindow
    #~ self.outputWindow = outputWindow
    
    #~ #Redirect stdout and stderr to output window
    #~ self.stdoutcatcher = _stdoutcatcher(outputWindow.text)
    #~ self.stderrcatcher = _stderrcatcher(outputWindow.text)

    try: 
      self._saveexit = sys.exit
      sys.exit = self.debugClosing
      debugInstance = GFInstance.GFInstance(caller._app, \
                          connections=caller._app.connections, \
                          ui=DummyInterfaceModule, disableSplash=True, \
                          moduleName='gnue.forms.uidrivers.wx.UIdriver')
      debugInstance.addDialogs()
      debugInstance.addFormFromBuffer(caller.rootObject.dumpXML(treeDump=True))
          
      #debugInstance.setForm(GFParser.loadFile(StringIO(caller.rootObject.dumpXML(treeDump=1)), debugInstance))
      
      #strictly in this order,
      #or DebugUserInterfase.exitApplication won't be called
      debugInstance._uimodule._debuginstance = self
      debugInstance.activate()
    except: 
      self.sanityCheck()
      raise
      #~ self.outputWindow.text.AppendText(_('\n---- Form Closed Abruptly ----'))


  def debugClosing(self): 
    self.sanityCheck()
    #~ self.outputWindow.text.AppendText(_('\n---- Form Closed ----'))
    #self.outputWindow.Close()
    

  def sanityCheck(self): 
    #~ self.stdoutcatcher.restore()
    #~ self.stderrcatcher.restore()
    sys.exit = self._saveexit


class DebugUserInterface(UIwxpython.GFUserInterface): 
  def exitApplication(self, event):
    eo = event._form._instance
    eo._uimodule._debuginstance.debugClosing()
    UIwxpython.GFUserInterface.exitApplication(self, event)

# Ack!!! 
class DummyInterfaceModule:     
  GFUserInterface = DebugUserInterface


#class DebugInstance(GFInstance.GFInstance): 
#  def __init__(self, manager, connections=None, ui=DummyInterfaceModule, disableSplash=1,
#               parameters={}):
#    GFInstance.GFInstance.__init__(self,connections=manager.connections,
#                                   ui=ui, disableSplash=disableSplash)
#
#                                   app, -1, app.connections, 
#                          DummyInterfaceModule,1)
    
    

class _stdoutcatcher:
  def __init__(self, textctrl): 
    self.orig = sys.__stdout__
    self.textctl = textctrl
    sys.__stdout__ = self
        
  def write(self, str):
    self.orig.write(str)
    self.textctl.AppendText(str)

  def writelines(self, list):
    for line in list:
      self.write(str)

  def restore(self): 
    self.__stdout__ = self.orig
    
  def flush(self):
    self.orig.flush()


class _stderrcatcher:
  def __init__(self, textctrl): 
    self.orig = sys.__stderr__
    self.origfh = GDebug._fh
    self.textctl = textctrl
    #sys.__stderr__ = self
    #GDebug._fh = self
    GDebug.__catchStderr(self)
        
  def write(self, str):
    self.origfh.write(str)
    self.textctl.AppendText(str)

  def writelines(self, list):
    for line in list:
      self.write(str)

  def restore(self): 
    #self.__stderr__ = self.orig
    #GDebug._fh = self.origfh
    GDebug.__catchStderr(self.origfh)

  def flush(self):
    self.orig.flush()
