#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# uidrivers/html/widgets/entry.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.forms.uidrivers.html.widgets._base import UIHelper, HtmlWidget
from gnue.forms.uidrivers.html.common import *


class UIEntry(UIHelper):

  def _createWidget(self, event, spacer):
    object = event.object

    if object.style == 'dropdown':
      if event.initialize:
        choices = []
        for val in object._field.allowedValues()[1]:
          choices.append('<option value=%s>' % val)
      else:
        choices = [""]

      dhtml = '<select name="" id="" size="1"\
                style="position:absolute; top:%spx; left:%spx; width:%spx; height:%spx;>\
                %s</select>' % \
                (object.Char__y*event.widgetHeight + FIX,\
                 object.Char__x*event.widgetWidth,\
                 self.itemWidth,\
                 self.itemHeight,\
                 ''.join(choices))

    elif object.style == 'listbox':
      dhtml = '<select name="" id="" size="4"\
                style="position:absolute; top:%spx; left:%spx; width:%spx; height:%spx;>\
                %s</select>' % \
                (object.Char__y*event.widgetHeight + FIX,\
                 object.Char__x*event.widgetWidth,\
                 self.itemWidth,\
                 self.itemHeight,\
                 ''.join(choices))
                 
    elif object.style == 'label':
      dhtml = ''

    # multiline edit
    elif hasattr(object,'Char__height') and object.Char__height > 1:
      dhtml = '<textarea name="" id="" rows="%s"\
                style="position:absolute; top:%spx; left:%spx; width:%spx; height:%spx;\
                value="%%s"\
                ></textarea>' % \
                (object.Char__height,\
                 object.Char__y*event.widgetHeight + FIX,\
                 object.Char__x*event.widgetWidth,\
                 self.itemWidth,\
                 self.itemHeight)

    elif object.style == 'checkbox':
      dhtml = '<input type="checkbox" name="nameText" id="idText" \
              style="position:absolute; top:%spx; left:%spx"\
              "%%s" />' % \
              (object.Char__y*event.widgetHeight + FIX,\
               object.Char__x*event.widgetWidth)

    else: # normal text box

      dhtml = '<input type="text" name="nameText" id="idText" \
              style="position:absolute; top:%spx; left:%spx; width:%spx; height:%spx"\
              value="%%s" />' % \
              (object.Char__y*event.widgetHeight + FIX,\
               object.Char__x*event.widgetWidth,\
               self.itemWidth,\
               self.itemHeight-4)

    newWidget = HtmlWidget(event.container, self._uiDriver, 'ENTRY', dhtml, getNextId())
    
    return newWidget

configuration = {
    'baseClass'  : UIEntry,
    'provides'   : 'GFEntry',
    'container'  : 0,
  }
