/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef PREF_H
#define PREF_H

#define PREF_WRITEONCE  (1 << 0)
#define PREF_HASBEENSET (1 << 1)


#include <stdlib.h> // int16_t
#include <config.h>

enum pref_type {
    PREF_FLOAT,
    PREF_INT,
    PREF_STRING
};

union pref_value {
    char *s;
    float f;
    int i;
};

struct pref { 
    char *name;
    enum pref_type type;
    int flags;
    union pref_value value;
    union pref_value def;
    float min;
    float max;
    int (*callback)(struct pref *which, union pref_value *new_value);
};

int
pref_init();

void
pref_exit();

int
pref_get_as_int(const char *name);

float
pref_get_as_float(const char *name);

const char *
pref_get_as_string(const char *name);

int 
pref_set_int(const char *name,
             int i);

int 
pref_set_float(const char *name,
               float f);

int 
pref_set_string(const char *name,
                const char *s);

int
pref_set(const char *name, 
         union pref_value *value);

void 
pref_sync();

#endif /* ! PREF_H */

