#include <config.h>
#include "lib/cpudetect.h"
#include "lib/benchmark.h"
#include "pref.h"
#include "mixer.h"
#include "muxers.h"

extern struct mixer_muxer_table muxtable_16[NUM_MUXERS][NUM_MUXERS];

struct mixer_mux_data {
    mixer *mixer;
    frame_bits_t dst;
    frame_bits_t *src;
    int frame_count;
    int frame_width;
};

CpuCaps gCpuCaps;
int Emergency;

void 
muxer_generic(void *arg) {
    struct mixer_mux_data *md = arg;
    mixer_mux_generic(md->mixer, md->dst, md->src, md->frame_width, md->frame_count);
}

void 
muxer_specific(void *arg) {
    struct mixer_mux_data *md = arg;
    muxtable_16[md->mixer->source_channels-1][md->mixer->target_channels-1].muxer(md->mixer, md->dst, md->src, md->frame_width, md->frame_count);
}

void
time_muxing() {
    int i, max_tracks, num_targets = 1;
    int16_t *dst;
    int16_t *src[32];
    char buf[512];
    float diff[32];
    float gen, spec;
    struct mixer_mux_data md;
    
    for(i = 0; i < 32; i++)
        src[i] = malloc(8192 * sizeof(int16_t));

    dst = malloc(8192 * sizeof(int16_t) * num_targets);

    max_tracks = pref_get_as_int("invariant_max_tracks");
    md.mixer = mixer_new(max_tracks, max_tracks);
    md.src = (frame_bits_t *)src;
    md.dst = dst;
    md.frame_count = 8192;
    md.frame_width = 2;

    for(i = 1; i <= (NUM_MUXERS < max_tracks ? NUM_MUXERS : max_tracks); i++) {
        mixer_configure(md.mixer, num_targets, i);
        gen = benchmark_printf("generic_muxer", 100, muxer_generic, &md);
        snprintf(buf, 512, "muxer_%dto%d", i, num_targets);
        spec = benchmark_printf(buf, 100, muxer_specific, &md);
        diff[i] = (gen / spec) * 100;
    }
    for(i = 1; i <= (NUM_MUXERS < max_tracks ? NUM_MUXERS : max_tracks); i++) 
        printf("%d %f\n", i, diff[i]);
}

void
time_memcpy() {
    int i;
    void *p1, *p2, *p3;
    int sz, times = 1000;
    struct timeval tv_start, tv_stop;
    float seconds, bytes_sec;
    sz = 1024 * 1024 * 1; // 10MB
    p1 = malloc(sz);
    p2 = malloc(sz);

    gettimeofday(&tv_start, NULL);
    for(i = 0; i < times; i++) {
        memcpy(p1, p2, sz);
        p3 = p1;
        p1 = p2;
        p2 = p3;
    }
    gettimeofday(&tv_stop, NULL);

    DEBUG("stop.sec: %ld, start.sec: %ld, stop.usec: %ld, start.usec: %ld\n",
          tv_stop.tv_sec, tv_start.tv_sec, tv_stop.tv_usec, tv_start.tv_usec);
    seconds = TIMEVAL_DIFF(tv_start, tv_stop);
    bytes_sec = ((float)times * (float)sz) / seconds;
    INFO("%4d | %10d | % 3fs. | % 3.3f MB/s\n",
         times, sz, seconds, bytes_sec / (1024 * 1024));
    exit(0);
}

int
main(int argc, 
     char **argv) {
    time_muxing();
    return 0;
}
