/* Copyright (C) 2002,2003 Pascal Haakmat */

#ifndef GUI_H
#define GUI_H

#include <gnome.h>
#include <config.h>
#include "shell.h"

#define GUI_CANCEL -1
#define GUI_YES 0
#define GUI_NO 1

enum gui_colors {
    COLOR_BACKGROUND,
    COLOR_POINT_RECORD,
    COLOR_POINT_PLAY,
    COLOR_WAVE,
    COLOR_WAVE_LIGHTTONE,
    COLOR_WAVE_DARKTONE,
    COLOR_ZERO,
    COLOR_SELECTION_WAVE,
    COLOR_SELECTION,
    COLOR_SELECTION_BACKGROUND,
    COLOR_BLOCK,
    COLOR_MARK,
    COLOR_GRID,
    COLOR_GRID_FONT,
    COLOR_INFO_FONT,
    COLOR_INFO_FONT_RECORD,
    COLOR_INFO_FONT_PLAY,
    COLOR_MARKERS,
    COLOR_MARKER_SLOPE_MAIN,
    COLOR_MARKER_SLOPE_AUX,
    COLOR_MARKER_TEXT_BACKGROUND,
    COLOR_MARKER_TEXT,
    COLOR_TOGGLES_MUTE,
    COLOR_TOGGLES_SOLO,
    NUM_COLORS
};

struct gui_pref_controls {
    void *default_sample_rate;
    void *default_sample_width_8;
    void *default_sample_width_16;
    void *default_sample_width_32;
    void *playback_device;
    void *record_device;
    void *playback_channels;
    void *max_tracks;
    void *dialog;
};

int 
gui_run(int argc, 
        char *argv[]);

int 
gui_init(int argc, 
         char *argv[]);

void
gui_new_activate(GtkWidget *w,
                 gpointer user_data);

void 
gui_open_activate(GtkWidget *w,
                  gpointer user_data);

void
gui_exit_activate(GtkWidget *w,
                  shell *shl);

int
gui_yield();

void 
gui_alert(const gchar *format, 
          ...);

int 
gui_yes_no(const char *title, 
           const char *format,
           ...);

void 
gui_show_clipboard_activate(GtkMenuItem *menuitem,
                            gpointer user_data);

void
gui_preferences_activate(GtkMenuItem *menuitem,
                         gpointer user_data);

void 
gui_preferences_sample_width_8(GtkToggleButton *w,
                               gpointer user_data);

void 
gui_preferences_sample_width_16(GtkToggleButton *w,
                                gpointer user_data);

void 
gui_preferences_sample_width_32(GtkToggleButton *w,
                                gpointer user_data);

void
gui_preferences_ok_clicked(GtkButton *w,
                           gpointer user_data);

GdkWindow *
gui_get_window(GtkWidget *w);

void
gui_get_widget_position_absolute(GtkWidget *w,
                                 int *x,
                                 int *y);

int
gui_option_menu_get_active(GtkOptionMenu *optionmenu);

GtkWidget *
gui_file_selection_new(const char *title);

void
gui_window_set_cursor(GdkWindow *w,
                      GdkCursorType type);

#endif /* ! GUI_H */
