// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJob for more information on using the CancelJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelJobRequest method.
//    req, resp := client.CancelJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CancelJob
func (c *DataExchange) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/jobs/{JobId}",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	output = &CancelJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelJob API operation for AWS Data Exchange.
//
// This operation cancels a job. Jobs can be cancelled only when they are in
// the WAITING state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation CancelJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CancelJob
func (c *DataExchange) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	return out, req.Send()
}

// CancelJobWithContext is the same as CancelJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) CancelJobWithContext(ctx aws.Context, input *CancelJobInput, opts ...request.Option) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSet = "CreateDataSet"

// CreateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSet for more information on using the CreateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSetRequest method.
//    req, resp := client.CreateDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateDataSet
func (c *DataExchange) CreateDataSetRequest(input *CreateDataSetInput) (req *request.Request, output *CreateDataSetOutput) {
	op := &request.Operation{
		Name:       opCreateDataSet,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/data-sets",
	}

	if input == nil {
		input = &CreateDataSetInput{}
	}

	output = &CreateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSet API operation for AWS Data Exchange.
//
// This operation creates a data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation CreateDataSet for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * ServiceLimitExceededException
//   The request has exceeded the quotas imposed by the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateDataSet
func (c *DataExchange) CreateDataSet(input *CreateDataSetInput) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	return out, req.Send()
}

// CreateDataSetWithContext is the same as CreateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) CreateDataSetWithContext(ctx aws.Context, input *CreateDataSetInput, opts ...request.Option) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventAction = "CreateEventAction"

// CreateEventActionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventAction for more information on using the CreateEventAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventActionRequest method.
//    req, resp := client.CreateEventActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateEventAction
func (c *DataExchange) CreateEventActionRequest(input *CreateEventActionInput) (req *request.Request, output *CreateEventActionOutput) {
	op := &request.Operation{
		Name:       opCreateEventAction,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/event-actions",
	}

	if input == nil {
		input = &CreateEventActionInput{}
	}

	output = &CreateEventActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventAction API operation for AWS Data Exchange.
//
// This operation creates an event action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation CreateEventAction for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * ServiceLimitExceededException
//   The request has exceeded the quotas imposed by the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateEventAction
func (c *DataExchange) CreateEventAction(input *CreateEventActionInput) (*CreateEventActionOutput, error) {
	req, out := c.CreateEventActionRequest(input)
	return out, req.Send()
}

// CreateEventActionWithContext is the same as CreateEventAction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) CreateEventActionWithContext(ctx aws.Context, input *CreateEventActionInput, opts ...request.Option) (*CreateEventActionOutput, error) {
	req, out := c.CreateEventActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateJob
func (c *DataExchange) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/jobs",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJob API operation for AWS Data Exchange.
//
// This operation creates a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation CreateJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateJob
func (c *DataExchange) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRevision = "CreateRevision"

// CreateRevisionRequest generates a "aws/request.Request" representing the
// client's request for the CreateRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRevision for more information on using the CreateRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRevisionRequest method.
//    req, resp := client.CreateRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateRevision
func (c *DataExchange) CreateRevisionRequest(input *CreateRevisionInput) (req *request.Request, output *CreateRevisionOutput) {
	op := &request.Operation{
		Name:       opCreateRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions",
	}

	if input == nil {
		input = &CreateRevisionInput{}
	}

	output = &CreateRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRevision API operation for AWS Data Exchange.
//
// This operation creates a revision for a data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation CreateRevision for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateRevision
func (c *DataExchange) CreateRevision(input *CreateRevisionInput) (*CreateRevisionOutput, error) {
	req, out := c.CreateRevisionRequest(input)
	return out, req.Send()
}

// CreateRevisionWithContext is the same as CreateRevision with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) CreateRevisionWithContext(ctx aws.Context, input *CreateRevisionInput, opts ...request.Option) (*CreateRevisionOutput, error) {
	req, out := c.CreateRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAsset = "DeleteAsset"

// DeleteAssetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAsset for more information on using the DeleteAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssetRequest method.
//    req, resp := client.DeleteAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteAsset
func (c *DataExchange) DeleteAssetRequest(input *DeleteAssetInput) (req *request.Request, output *DeleteAssetOutput) {
	op := &request.Operation{
		Name:       opDeleteAsset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}",
	}

	if input == nil {
		input = &DeleteAssetInput{}
	}

	output = &DeleteAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAsset API operation for AWS Data Exchange.
//
// This operation deletes an asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation DeleteAsset for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteAsset
func (c *DataExchange) DeleteAsset(input *DeleteAssetInput) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	return out, req.Send()
}

// DeleteAssetWithContext is the same as DeleteAsset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) DeleteAssetWithContext(ctx aws.Context, input *DeleteAssetInput, opts ...request.Option) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSet = "DeleteDataSet"

// DeleteDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSet for more information on using the DeleteDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataSetRequest method.
//    req, resp := client.DeleteDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteDataSet
func (c *DataExchange) DeleteDataSetRequest(input *DeleteDataSetInput) (req *request.Request, output *DeleteDataSetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DeleteDataSetInput{}
	}

	output = &DeleteDataSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataSet API operation for AWS Data Exchange.
//
// This operation deletes a data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation DeleteDataSet for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteDataSet
func (c *DataExchange) DeleteDataSet(input *DeleteDataSetInput) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	return out, req.Send()
}

// DeleteDataSetWithContext is the same as DeleteDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) DeleteDataSetWithContext(ctx aws.Context, input *DeleteDataSetInput, opts ...request.Option) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventAction = "DeleteEventAction"

// DeleteEventActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventAction for more information on using the DeleteEventAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventActionRequest method.
//    req, resp := client.DeleteEventActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteEventAction
func (c *DataExchange) DeleteEventActionRequest(input *DeleteEventActionInput) (req *request.Request, output *DeleteEventActionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventAction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/event-actions/{EventActionId}",
	}

	if input == nil {
		input = &DeleteEventActionInput{}
	}

	output = &DeleteEventActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventAction API operation for AWS Data Exchange.
//
// This operation deletes the event action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation DeleteEventAction for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteEventAction
func (c *DataExchange) DeleteEventAction(input *DeleteEventActionInput) (*DeleteEventActionOutput, error) {
	req, out := c.DeleteEventActionRequest(input)
	return out, req.Send()
}

// DeleteEventActionWithContext is the same as DeleteEventAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) DeleteEventActionWithContext(ctx aws.Context, input *DeleteEventActionInput, opts ...request.Option) (*DeleteEventActionOutput, error) {
	req, out := c.DeleteEventActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRevision = "DeleteRevision"

// DeleteRevisionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRevision for more information on using the DeleteRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRevisionRequest method.
//    req, resp := client.DeleteRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteRevision
func (c *DataExchange) DeleteRevisionRequest(input *DeleteRevisionInput) (req *request.Request, output *DeleteRevisionOutput) {
	op := &request.Operation{
		Name:       opDeleteRevision,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}",
	}

	if input == nil {
		input = &DeleteRevisionInput{}
	}

	output = &DeleteRevisionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRevision API operation for AWS Data Exchange.
//
// This operation deletes a revision.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation DeleteRevision for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteRevision
func (c *DataExchange) DeleteRevision(input *DeleteRevisionInput) (*DeleteRevisionOutput, error) {
	req, out := c.DeleteRevisionRequest(input)
	return out, req.Send()
}

// DeleteRevisionWithContext is the same as DeleteRevision with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) DeleteRevisionWithContext(ctx aws.Context, input *DeleteRevisionInput, opts ...request.Option) (*DeleteRevisionOutput, error) {
	req, out := c.DeleteRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAsset = "GetAsset"

// GetAssetRequest generates a "aws/request.Request" representing the
// client's request for the GetAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAsset for more information on using the GetAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssetRequest method.
//    req, resp := client.GetAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetAsset
func (c *DataExchange) GetAssetRequest(input *GetAssetInput) (req *request.Request, output *GetAssetOutput) {
	op := &request.Operation{
		Name:       opGetAsset,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}",
	}

	if input == nil {
		input = &GetAssetInput{}
	}

	output = &GetAssetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAsset API operation for AWS Data Exchange.
//
// This operation returns information about an asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation GetAsset for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetAsset
func (c *DataExchange) GetAsset(input *GetAssetInput) (*GetAssetOutput, error) {
	req, out := c.GetAssetRequest(input)
	return out, req.Send()
}

// GetAssetWithContext is the same as GetAsset with the addition of
// the ability to pass a context and additional request options.
//
// See GetAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) GetAssetWithContext(ctx aws.Context, input *GetAssetInput, opts ...request.Option) (*GetAssetOutput, error) {
	req, out := c.GetAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSet = "GetDataSet"

// GetDataSetRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSet for more information on using the GetDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataSetRequest method.
//    req, resp := client.GetDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetDataSet
func (c *DataExchange) GetDataSetRequest(input *GetDataSetInput) (req *request.Request, output *GetDataSetOutput) {
	op := &request.Operation{
		Name:       opGetDataSet,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &GetDataSetInput{}
	}

	output = &GetDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSet API operation for AWS Data Exchange.
//
// This operation returns information about a data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation GetDataSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetDataSet
func (c *DataExchange) GetDataSet(input *GetDataSetInput) (*GetDataSetOutput, error) {
	req, out := c.GetDataSetRequest(input)
	return out, req.Send()
}

// GetDataSetWithContext is the same as GetDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) GetDataSetWithContext(ctx aws.Context, input *GetDataSetInput, opts ...request.Option) (*GetDataSetOutput, error) {
	req, out := c.GetDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventAction = "GetEventAction"

// GetEventActionRequest generates a "aws/request.Request" representing the
// client's request for the GetEventAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventAction for more information on using the GetEventAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventActionRequest method.
//    req, resp := client.GetEventActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetEventAction
func (c *DataExchange) GetEventActionRequest(input *GetEventActionInput) (req *request.Request, output *GetEventActionOutput) {
	op := &request.Operation{
		Name:       opGetEventAction,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/event-actions/{EventActionId}",
	}

	if input == nil {
		input = &GetEventActionInput{}
	}

	output = &GetEventActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventAction API operation for AWS Data Exchange.
//
// This operation retrieves information about an event action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation GetEventAction for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetEventAction
func (c *DataExchange) GetEventAction(input *GetEventActionInput) (*GetEventActionOutput, error) {
	req, out := c.GetEventActionRequest(input)
	return out, req.Send()
}

// GetEventActionWithContext is the same as GetEventAction with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) GetEventActionWithContext(ctx aws.Context, input *GetEventActionInput, opts ...request.Option) (*GetEventActionOutput, error) {
	req, out := c.GetEventActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJob = "GetJob"

// GetJobRequest generates a "aws/request.Request" representing the
// client's request for the GetJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJob for more information on using the GetJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobRequest method.
//    req, resp := client.GetJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetJob
func (c *DataExchange) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/jobs/{JobId}",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	output = &GetJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJob API operation for AWS Data Exchange.
//
// This operation returns information about a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation GetJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetJob
func (c *DataExchange) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	return out, req.Send()
}

// GetJobWithContext is the same as GetJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) GetJobWithContext(ctx aws.Context, input *GetJobInput, opts ...request.Option) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRevision = "GetRevision"

// GetRevisionRequest generates a "aws/request.Request" representing the
// client's request for the GetRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRevision for more information on using the GetRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRevisionRequest method.
//    req, resp := client.GetRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetRevision
func (c *DataExchange) GetRevisionRequest(input *GetRevisionInput) (req *request.Request, output *GetRevisionOutput) {
	op := &request.Operation{
		Name:       opGetRevision,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}",
	}

	if input == nil {
		input = &GetRevisionInput{}
	}

	output = &GetRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRevision API operation for AWS Data Exchange.
//
// This operation returns information about a revision.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation GetRevision for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetRevision
func (c *DataExchange) GetRevision(input *GetRevisionInput) (*GetRevisionOutput, error) {
	req, out := c.GetRevisionRequest(input)
	return out, req.Send()
}

// GetRevisionWithContext is the same as GetRevision with the addition of
// the ability to pass a context and additional request options.
//
// See GetRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) GetRevisionWithContext(ctx aws.Context, input *GetRevisionInput, opts ...request.Option) (*GetRevisionOutput, error) {
	req, out := c.GetRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataSetRevisions = "ListDataSetRevisions"

// ListDataSetRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSetRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSetRevisions for more information on using the ListDataSetRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSetRevisionsRequest method.
//    req, resp := client.ListDataSetRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSetRevisions
func (c *DataExchange) ListDataSetRevisionsRequest(input *ListDataSetRevisionsInput) (req *request.Request, output *ListDataSetRevisionsOutput) {
	op := &request.Operation{
		Name:       opListDataSetRevisions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetRevisionsInput{}
	}

	output = &ListDataSetRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSetRevisions API operation for AWS Data Exchange.
//
// This operation lists a data set's revisions sorted by CreatedAt in descending
// order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation ListDataSetRevisions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSetRevisions
func (c *DataExchange) ListDataSetRevisions(input *ListDataSetRevisionsInput) (*ListDataSetRevisionsOutput, error) {
	req, out := c.ListDataSetRevisionsRequest(input)
	return out, req.Send()
}

// ListDataSetRevisionsWithContext is the same as ListDataSetRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSetRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListDataSetRevisionsWithContext(ctx aws.Context, input *ListDataSetRevisionsInput, opts ...request.Option) (*ListDataSetRevisionsOutput, error) {
	req, out := c.ListDataSetRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSetRevisionsPages iterates over the pages of a ListDataSetRevisions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSetRevisions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSetRevisions operation.
//    pageNum := 0
//    err := client.ListDataSetRevisionsPages(params,
//        func(page *dataexchange.ListDataSetRevisionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataExchange) ListDataSetRevisionsPages(input *ListDataSetRevisionsInput, fn func(*ListDataSetRevisionsOutput, bool) bool) error {
	return c.ListDataSetRevisionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSetRevisionsPagesWithContext same as ListDataSetRevisionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListDataSetRevisionsPagesWithContext(ctx aws.Context, input *ListDataSetRevisionsInput, fn func(*ListDataSetRevisionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSetRevisionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSetRevisionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSetRevisionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSets = "ListDataSets"

// ListDataSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSets for more information on using the ListDataSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSetsRequest method.
//    req, resp := client.ListDataSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSets
func (c *DataExchange) ListDataSetsRequest(input *ListDataSetsInput) (req *request.Request, output *ListDataSetsOutput) {
	op := &request.Operation{
		Name:       opListDataSets,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetsInput{}
	}

	output = &ListDataSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSets API operation for AWS Data Exchange.
//
// This operation lists your data sets. When listing by origin OWNED, results
// are sorted by CreatedAt in descending order. When listing by origin ENTITLED,
// there is no order and the maxResults parameter is ignored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation ListDataSets for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSets
func (c *DataExchange) ListDataSets(input *ListDataSetsInput) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	return out, req.Send()
}

// ListDataSetsWithContext is the same as ListDataSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListDataSetsWithContext(ctx aws.Context, input *ListDataSetsInput, opts ...request.Option) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSetsPages iterates over the pages of a ListDataSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSets operation.
//    pageNum := 0
//    err := client.ListDataSetsPages(params,
//        func(page *dataexchange.ListDataSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataExchange) ListDataSetsPages(input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool) error {
	return c.ListDataSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSetsPagesWithContext same as ListDataSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListDataSetsPagesWithContext(ctx aws.Context, input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventActions = "ListEventActions"

// ListEventActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventActions for more information on using the ListEventActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventActionsRequest method.
//    req, resp := client.ListEventActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListEventActions
func (c *DataExchange) ListEventActionsRequest(input *ListEventActionsInput) (req *request.Request, output *ListEventActionsOutput) {
	op := &request.Operation{
		Name:       opListEventActions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/event-actions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventActionsInput{}
	}

	output = &ListEventActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventActions API operation for AWS Data Exchange.
//
// This operation lists your event actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation ListEventActions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListEventActions
func (c *DataExchange) ListEventActions(input *ListEventActionsInput) (*ListEventActionsOutput, error) {
	req, out := c.ListEventActionsRequest(input)
	return out, req.Send()
}

// ListEventActionsWithContext is the same as ListEventActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListEventActionsWithContext(ctx aws.Context, input *ListEventActionsInput, opts ...request.Option) (*ListEventActionsOutput, error) {
	req, out := c.ListEventActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventActionsPages iterates over the pages of a ListEventActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEventActions operation.
//    pageNum := 0
//    err := client.ListEventActionsPages(params,
//        func(page *dataexchange.ListEventActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataExchange) ListEventActionsPages(input *ListEventActionsInput, fn func(*ListEventActionsOutput, bool) bool) error {
	return c.ListEventActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventActionsPagesWithContext same as ListEventActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListEventActionsPagesWithContext(ctx aws.Context, input *ListEventActionsInput, fn func(*ListEventActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListJobs
func (c *DataExchange) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS Data Exchange.
//
// This operation lists your jobs sorted by CreatedAt in descending order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListJobs
func (c *DataExchange) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *dataexchange.ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataExchange) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRevisionAssets = "ListRevisionAssets"

// ListRevisionAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListRevisionAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRevisionAssets for more information on using the ListRevisionAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRevisionAssetsRequest method.
//    req, resp := client.ListRevisionAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListRevisionAssets
func (c *DataExchange) ListRevisionAssetsRequest(input *ListRevisionAssetsInput) (req *request.Request, output *ListRevisionAssetsOutput) {
	op := &request.Operation{
		Name:       opListRevisionAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRevisionAssetsInput{}
	}

	output = &ListRevisionAssetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRevisionAssets API operation for AWS Data Exchange.
//
// This operation lists a revision's assets sorted alphabetically in descending
// order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation ListRevisionAssets for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListRevisionAssets
func (c *DataExchange) ListRevisionAssets(input *ListRevisionAssetsInput) (*ListRevisionAssetsOutput, error) {
	req, out := c.ListRevisionAssetsRequest(input)
	return out, req.Send()
}

// ListRevisionAssetsWithContext is the same as ListRevisionAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRevisionAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListRevisionAssetsWithContext(ctx aws.Context, input *ListRevisionAssetsInput, opts ...request.Option) (*ListRevisionAssetsOutput, error) {
	req, out := c.ListRevisionAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRevisionAssetsPages iterates over the pages of a ListRevisionAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRevisionAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRevisionAssets operation.
//    pageNum := 0
//    err := client.ListRevisionAssetsPages(params,
//        func(page *dataexchange.ListRevisionAssetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataExchange) ListRevisionAssetsPages(input *ListRevisionAssetsInput, fn func(*ListRevisionAssetsOutput, bool) bool) error {
	return c.ListRevisionAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRevisionAssetsPagesWithContext same as ListRevisionAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListRevisionAssetsPagesWithContext(ctx aws.Context, input *ListRevisionAssetsInput, fn func(*ListRevisionAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRevisionAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRevisionAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRevisionAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListTagsForResource
func (c *DataExchange) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Data Exchange.
//
// This operation lists the tags on the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListTagsForResource
func (c *DataExchange) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeRevision = "RevokeRevision"

// RevokeRevisionRequest generates a "aws/request.Request" representing the
// client's request for the RevokeRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeRevision for more information on using the RevokeRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeRevisionRequest method.
//    req, resp := client.RevokeRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/RevokeRevision
func (c *DataExchange) RevokeRevisionRequest(input *RevokeRevisionInput) (req *request.Request, output *RevokeRevisionOutput) {
	op := &request.Operation{
		Name:       opRevokeRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/revoke",
	}

	if input == nil {
		input = &RevokeRevisionInput{}
	}

	output = &RevokeRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeRevision API operation for AWS Data Exchange.
//
// This operation revokes subscribers' access to a revision.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation RevokeRevision for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/RevokeRevision
func (c *DataExchange) RevokeRevision(input *RevokeRevisionInput) (*RevokeRevisionOutput, error) {
	req, out := c.RevokeRevisionRequest(input)
	return out, req.Send()
}

// RevokeRevisionWithContext is the same as RevokeRevision with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) RevokeRevisionWithContext(ctx aws.Context, input *RevokeRevisionInput, opts ...request.Option) (*RevokeRevisionOutput, error) {
	req, out := c.RevokeRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendApiAsset = "SendApiAsset"

// SendApiAssetRequest generates a "aws/request.Request" representing the
// client's request for the SendApiAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendApiAsset for more information on using the SendApiAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendApiAssetRequest method.
//    req, resp := client.SendApiAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/SendApiAsset
func (c *DataExchange) SendApiAssetRequest(input *SendApiAssetInput) (req *request.Request, output *SendApiAssetOutput) {
	op := &request.Operation{
		Name:       opSendApiAsset,
		HTTPMethod: "POST",
		HTTPPath:   "/v1",
	}

	if input == nil {
		input = &SendApiAssetInput{}
	}

	output = &SendApiAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api-fulfill.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SendApiAsset API operation for AWS Data Exchange.
//
// This operation invokes an API Gateway API asset. The request is proxied to
// the provider’s API Gateway API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation SendApiAsset for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/SendApiAsset
func (c *DataExchange) SendApiAsset(input *SendApiAssetInput) (*SendApiAssetOutput, error) {
	req, out := c.SendApiAssetRequest(input)
	return out, req.Send()
}

// SendApiAssetWithContext is the same as SendApiAsset with the addition of
// the ability to pass a context and additional request options.
//
// See SendApiAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) SendApiAssetWithContext(ctx aws.Context, input *SendApiAssetInput, opts ...request.Option) (*SendApiAssetOutput, error) {
	req, out := c.SendApiAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartJob = "StartJob"

// StartJobRequest generates a "aws/request.Request" representing the
// client's request for the StartJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartJob for more information on using the StartJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartJobRequest method.
//    req, resp := client.StartJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/StartJob
func (c *DataExchange) StartJobRequest(input *StartJobInput) (req *request.Request, output *StartJobOutput) {
	op := &request.Operation{
		Name:       opStartJob,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v1/jobs/{JobId}",
	}

	if input == nil {
		input = &StartJobInput{}
	}

	output = &StartJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartJob API operation for AWS Data Exchange.
//
// This operation starts a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation StartJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/StartJob
func (c *DataExchange) StartJob(input *StartJobInput) (*StartJobOutput, error) {
	req, out := c.StartJobRequest(input)
	return out, req.Send()
}

// StartJobWithContext is the same as StartJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) StartJobWithContext(ctx aws.Context, input *StartJobInput, opts ...request.Option) (*StartJobOutput, error) {
	req, out := c.StartJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/TagResource
func (c *DataExchange) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Data Exchange.
//
// This operation tags a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/TagResource
func (c *DataExchange) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UntagResource
func (c *DataExchange) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Data Exchange.
//
// This operation removes one or more tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UntagResource
func (c *DataExchange) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAsset = "UpdateAsset"

// UpdateAssetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAsset for more information on using the UpdateAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssetRequest method.
//    req, resp := client.UpdateAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateAsset
func (c *DataExchange) UpdateAssetRequest(input *UpdateAssetInput) (req *request.Request, output *UpdateAssetOutput) {
	op := &request.Operation{
		Name:       opUpdateAsset,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}",
	}

	if input == nil {
		input = &UpdateAssetInput{}
	}

	output = &UpdateAssetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAsset API operation for AWS Data Exchange.
//
// This operation updates an asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation UpdateAsset for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateAsset
func (c *DataExchange) UpdateAsset(input *UpdateAssetInput) (*UpdateAssetOutput, error) {
	req, out := c.UpdateAssetRequest(input)
	return out, req.Send()
}

// UpdateAssetWithContext is the same as UpdateAsset with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) UpdateAssetWithContext(ctx aws.Context, input *UpdateAssetInput, opts ...request.Option) (*UpdateAssetOutput, error) {
	req, out := c.UpdateAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSet = "UpdateDataSet"

// UpdateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSet for more information on using the UpdateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSetRequest method.
//    req, resp := client.UpdateDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateDataSet
func (c *DataExchange) UpdateDataSetRequest(input *UpdateDataSetInput) (req *request.Request, output *UpdateDataSetOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSet,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v1/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &UpdateDataSetInput{}
	}

	output = &UpdateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSet API operation for AWS Data Exchange.
//
// This operation updates a data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation UpdateDataSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateDataSet
func (c *DataExchange) UpdateDataSet(input *UpdateDataSetInput) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	return out, req.Send()
}

// UpdateDataSetWithContext is the same as UpdateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) UpdateDataSetWithContext(ctx aws.Context, input *UpdateDataSetInput, opts ...request.Option) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventAction = "UpdateEventAction"

// UpdateEventActionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventAction for more information on using the UpdateEventAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEventActionRequest method.
//    req, resp := client.UpdateEventActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateEventAction
func (c *DataExchange) UpdateEventActionRequest(input *UpdateEventActionInput) (req *request.Request, output *UpdateEventActionOutput) {
	op := &request.Operation{
		Name:       opUpdateEventAction,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v1/event-actions/{EventActionId}",
	}

	if input == nil {
		input = &UpdateEventActionInput{}
	}

	output = &UpdateEventActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEventAction API operation for AWS Data Exchange.
//
// This operation updates the event action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation UpdateEventAction for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateEventAction
func (c *DataExchange) UpdateEventAction(input *UpdateEventActionInput) (*UpdateEventActionOutput, error) {
	req, out := c.UpdateEventActionRequest(input)
	return out, req.Send()
}

// UpdateEventActionWithContext is the same as UpdateEventAction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) UpdateEventActionWithContext(ctx aws.Context, input *UpdateEventActionInput, opts ...request.Option) (*UpdateEventActionOutput, error) {
	req, out := c.UpdateEventActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRevision = "UpdateRevision"

// UpdateRevisionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRevision for more information on using the UpdateRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRevisionRequest method.
//    req, resp := client.UpdateRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateRevision
func (c *DataExchange) UpdateRevisionRequest(input *UpdateRevisionInput) (req *request.Request, output *UpdateRevisionOutput) {
	op := &request.Operation{
		Name:       opUpdateRevision,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}",
	}

	if input == nil {
		input = &UpdateRevisionInput{}
	}

	output = &UpdateRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRevision API operation for AWS Data Exchange.
//
// This operation updates a revision.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Exchange's
// API operation UpdateRevision for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request was invalid.
//
//   * InternalServerException
//   An exception occurred with the service.
//
//   * AccessDeniedException
//   Access to the resource is denied.
//
//   * ResourceNotFoundException
//   The resource couldn't be found.
//
//   * ThrottlingException
//   The limit on the number of requests per second was exceeded.
//
//   * ConflictException
//   The request couldn't be completed because it conflicted with the current
//   state of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateRevision
func (c *DataExchange) UpdateRevision(input *UpdateRevisionInput) (*UpdateRevisionOutput, error) {
	req, out := c.UpdateRevisionRequest(input)
	return out, req.Send()
}

// UpdateRevisionWithContext is the same as UpdateRevision with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataExchange) UpdateRevisionWithContext(ctx aws.Context, input *UpdateRevisionInput, opts ...request.Option) (*UpdateRevisionOutput, error) {
	req, out := c.UpdateRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access to the resource is denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Access to the resource is denied.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// What occurs after a certain event.
type Action struct {
	_ struct{} `type:"structure"`

	// Details for the export revision to Amazon S3 action.
	ExportRevisionToS3 *AutoExportRevisionToS3RequestDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.ExportRevisionToS3 != nil {
		if err := s.ExportRevisionToS3.Validate(); err != nil {
			invalidParams.AddNested("ExportRevisionToS3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportRevisionToS3 sets the ExportRevisionToS3 field's value.
func (s *Action) SetExportRevisionToS3(v *AutoExportRevisionToS3RequestDetails) *Action {
	s.ExportRevisionToS3 = v
	return s
}

// The API Gateway API that is the asset.
type ApiGatewayApiAsset struct {
	_ struct{} `type:"structure"`

	// The API description of the API asset.
	ApiDescription *string `type:"string"`

	// The API endpoint of the API asset.
	ApiEndpoint *string `type:"string"`

	// The unique identifier of the API asset.
	ApiId *string `type:"string"`

	// The API key of the API asset.
	ApiKey *string `type:"string"`

	// The API name of the API asset.
	ApiName *string `type:"string"`

	// The download URL of the API specification of the API asset.
	ApiSpecificationDownloadUrl *string `type:"string"`

	// The date and time that the upload URL expires, in ISO 8601 format.
	ApiSpecificationDownloadUrlExpiresAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The protocol type of the API asset.
	ProtocolType *string `type:"string" enum:"ProtocolType"`

	// The stage of the API asset.
	Stage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiGatewayApiAsset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiGatewayApiAsset) GoString() string {
	return s.String()
}

// SetApiDescription sets the ApiDescription field's value.
func (s *ApiGatewayApiAsset) SetApiDescription(v string) *ApiGatewayApiAsset {
	s.ApiDescription = &v
	return s
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *ApiGatewayApiAsset) SetApiEndpoint(v string) *ApiGatewayApiAsset {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *ApiGatewayApiAsset) SetApiId(v string) *ApiGatewayApiAsset {
	s.ApiId = &v
	return s
}

// SetApiKey sets the ApiKey field's value.
func (s *ApiGatewayApiAsset) SetApiKey(v string) *ApiGatewayApiAsset {
	s.ApiKey = &v
	return s
}

// SetApiName sets the ApiName field's value.
func (s *ApiGatewayApiAsset) SetApiName(v string) *ApiGatewayApiAsset {
	s.ApiName = &v
	return s
}

// SetApiSpecificationDownloadUrl sets the ApiSpecificationDownloadUrl field's value.
func (s *ApiGatewayApiAsset) SetApiSpecificationDownloadUrl(v string) *ApiGatewayApiAsset {
	s.ApiSpecificationDownloadUrl = &v
	return s
}

// SetApiSpecificationDownloadUrlExpiresAt sets the ApiSpecificationDownloadUrlExpiresAt field's value.
func (s *ApiGatewayApiAsset) SetApiSpecificationDownloadUrlExpiresAt(v time.Time) *ApiGatewayApiAsset {
	s.ApiSpecificationDownloadUrlExpiresAt = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *ApiGatewayApiAsset) SetProtocolType(v string) *ApiGatewayApiAsset {
	s.ProtocolType = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *ApiGatewayApiAsset) SetStage(v string) *ApiGatewayApiAsset {
	s.Stage = &v
	return s
}

// The destination for the asset.
type AssetDestinationEntry struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the asset.
	//
	// AssetId is a required field
	AssetId *string `type:"string" required:"true"`

	// The S3 bucket that is the destination for the asset.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The name of the object in Amazon S3 for the asset.
	Key *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetDestinationEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetDestinationEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetDestinationEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetDestinationEntry"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *AssetDestinationEntry) SetAssetId(v string) *AssetDestinationEntry {
	s.AssetId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *AssetDestinationEntry) SetBucket(v string) *AssetDestinationEntry {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *AssetDestinationEntry) SetKey(v string) *AssetDestinationEntry {
	s.Key = &v
	return s
}

// Information about the asset.
type AssetDetails struct {
	_ struct{} `type:"structure"`

	// Information about the API Gateway API asset.
	ApiGatewayApiAsset *ApiGatewayApiAsset `type:"structure"`

	// The Amazon Redshift datashare that is the asset.
	RedshiftDataShareAsset *RedshiftDataShareAsset `type:"structure"`

	// The S3 object that is the asset.
	S3SnapshotAsset *S3SnapshotAsset `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetDetails) GoString() string {
	return s.String()
}

// SetApiGatewayApiAsset sets the ApiGatewayApiAsset field's value.
func (s *AssetDetails) SetApiGatewayApiAsset(v *ApiGatewayApiAsset) *AssetDetails {
	s.ApiGatewayApiAsset = v
	return s
}

// SetRedshiftDataShareAsset sets the RedshiftDataShareAsset field's value.
func (s *AssetDetails) SetRedshiftDataShareAsset(v *RedshiftDataShareAsset) *AssetDetails {
	s.RedshiftDataShareAsset = v
	return s
}

// SetS3SnapshotAsset sets the S3SnapshotAsset field's value.
func (s *AssetDetails) SetS3SnapshotAsset(v *S3SnapshotAsset) *AssetDetails {
	s.S3SnapshotAsset = v
	return s
}

// An asset in AWS Data Exchange is a piece of data (S3 object) or a means of
// fulfilling data (Amazon Redshift datashare or Amazon API Gateway API). The
// asset can be a structured data file, an image file, or some other data file
// that can be stored as an S3 object, an Amazon API Gateway API, or an Amazon
// Redshift datashare. When you create an import job for your files, API Gateway
// APIs, or Amazon Redshift datashares, you create an asset in AWS Data Exchange.
type AssetEntry struct {
	_ struct{} `type:"structure"`

	// The ARN for the asset.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// Information about the asset.
	//
	// AssetDetails is a required field
	AssetDetails *AssetDetails `type:"structure" required:"true"`

	// The type of asset that is added to a data set.
	//
	// AssetType is a required field
	AssetType *string `type:"string" required:"true" enum:"AssetType"`

	// The date and time that the asset was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique identifier for the data set associated with this asset.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the asset.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The name of the asset. When importing from Amazon S3, the S3 object key is
	// used as the asset name. When exporting to Amazon S3, the asset name is used
	// as default target S3 object key. When importing from Amazon API Gateway API,
	// the API name is used as the asset name. When importing from Amazon Redshift,
	// the datashare name is used as the asset name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this asset.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`

	// The asset ID of the owned asset corresponding to the entitled asset being
	// viewed. This parameter is returned when an asset owner is viewing the entitled
	// copy of its owned asset.
	SourceId *string `type:"string"`

	// The date and time that the asset was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetEntry) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetEntry) SetArn(v string) *AssetEntry {
	s.Arn = &v
	return s
}

// SetAssetDetails sets the AssetDetails field's value.
func (s *AssetEntry) SetAssetDetails(v *AssetDetails) *AssetEntry {
	s.AssetDetails = v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *AssetEntry) SetAssetType(v string) *AssetEntry {
	s.AssetType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssetEntry) SetCreatedAt(v time.Time) *AssetEntry {
	s.CreatedAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *AssetEntry) SetDataSetId(v string) *AssetEntry {
	s.DataSetId = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetEntry) SetId(v string) *AssetEntry {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetEntry) SetName(v string) *AssetEntry {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AssetEntry) SetRevisionId(v string) *AssetEntry {
	s.RevisionId = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *AssetEntry) SetSourceId(v string) *AssetEntry {
	s.SourceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AssetEntry) SetUpdatedAt(v time.Time) *AssetEntry {
	s.UpdatedAt = &v
	return s
}

// The source of the assets.
type AssetSourceEntry struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that's part of the source of the asset.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The name of the object in Amazon S3 for the asset.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetSourceEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetSourceEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetSourceEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetSourceEntry"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AssetSourceEntry) SetBucket(v string) *AssetSourceEntry {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *AssetSourceEntry) SetKey(v string) *AssetSourceEntry {
	s.Key = &v
	return s
}

// A revision destination is the Amazon S3 bucket folder destination to where
// the export will be sent.
type AutoExportRevisionDestinationEntry struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that is the destination for the event action.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// A string representing the pattern for generated names of the individual assets
	// in the revision. For more information about key patterns, see Key patterns
	// when exporting revisions (https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns).
	KeyPattern *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoExportRevisionDestinationEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoExportRevisionDestinationEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoExportRevisionDestinationEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoExportRevisionDestinationEntry"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AutoExportRevisionDestinationEntry) SetBucket(v string) *AutoExportRevisionDestinationEntry {
	s.Bucket = &v
	return s
}

// SetKeyPattern sets the KeyPattern field's value.
func (s *AutoExportRevisionDestinationEntry) SetKeyPattern(v string) *AutoExportRevisionDestinationEntry {
	s.KeyPattern = &v
	return s
}

// Details of the operation to be performed by the job.
type AutoExportRevisionToS3RequestDetails struct {
	_ struct{} `type:"structure"`

	// Encryption configuration for the auto export job.
	Encryption *ExportServerSideEncryption `type:"structure"`

	// A revision destination is the Amazon S3 bucket folder destination to where
	// the export will be sent.
	//
	// RevisionDestination is a required field
	RevisionDestination *AutoExportRevisionDestinationEntry `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoExportRevisionToS3RequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoExportRevisionToS3RequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoExportRevisionToS3RequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoExportRevisionToS3RequestDetails"}
	if s.RevisionDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionDestination"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}
	if s.RevisionDestination != nil {
		if err := s.RevisionDestination.Validate(); err != nil {
			invalidParams.AddNested("RevisionDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *AutoExportRevisionToS3RequestDetails) SetEncryption(v *ExportServerSideEncryption) *AutoExportRevisionToS3RequestDetails {
	s.Encryption = v
	return s
}

// SetRevisionDestination sets the RevisionDestination field's value.
func (s *AutoExportRevisionToS3RequestDetails) SetRevisionDestination(v *AutoExportRevisionDestinationEntry) *AutoExportRevisionToS3RequestDetails {
	s.RevisionDestination = v
	return s
}

type CancelJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelJobInput) SetJobId(v string) *CancelJobInput {
	s.JobId = &v
	return s
}

type CancelJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobOutput) GoString() string {
	return s.String()
}

// The request couldn't be completed because it conflicted with the current
// state of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The request couldn't be completed because it conflicted with the current
	// state of the resource.
	Message_ *string `locationName:"Message" type:"string"`

	// The unique identifier for the resource with the conflict.
	ResourceId *string `type:"string"`

	// The type of the resource with the conflict.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A request to create a data set that contains one or more revisions.
type CreateDataSetInput struct {
	_ struct{} `type:"structure"`

	// The type of asset that is added to a data set.
	//
	// AssetType is a required field
	AssetType *string `type:"string" required:"true" enum:"AssetType"`

	// A description for the data set. This value can be up to 16,348 characters
	// long.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the data set.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A data set tag is an optional label that you can assign to a data set when
	// you create it. Each tag consists of a key and an optional value, both of
	// which you define. When you use tagging, you can also use tag-based access
	// control in IAM policies to control access to these data sets and revisions.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSetInput"}
	if s.AssetType == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetType"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetType sets the AssetType field's value.
func (s *CreateDataSetInput) SetAssetType(v string) *CreateDataSetInput {
	s.AssetType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSetInput) SetDescription(v string) *CreateDataSetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSetInput) SetName(v string) *CreateDataSetInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSetInput) SetTags(v map[string]*string) *CreateDataSetInput {
	s.Tags = v
	return s
}

type CreateDataSetOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// The type of asset that is added to a data set.
	AssetType *string `type:"string" enum:"AssetType"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A description of a resource.
	Description *string `type:"string"`

	// A unique identifier.
	Id *string `type:"string"`

	// The name of the model.
	Name *string `type:"string"`

	// A property that defines the data set as OWNED by the account (for providers)
	// or ENTITLED to the account (for subscribers). When an owned data set is published
	// in a product, AWS Data Exchange creates a copy of the data set. Subscribers
	// can access that copy of the data set as an entitled data set.
	Origin *string `type:"string" enum:"Origin"`

	// Information about the origin of the data set.
	OriginDetails *OriginDetails `type:"structure"`

	// A unique identifier.
	SourceId *string `type:"string"`

	Tags map[string]*string `type:"map"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataSetOutput) SetArn(v string) *CreateDataSetOutput {
	s.Arn = &v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *CreateDataSetOutput) SetAssetType(v string) *CreateDataSetOutput {
	s.AssetType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateDataSetOutput) SetCreatedAt(v time.Time) *CreateDataSetOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSetOutput) SetDescription(v string) *CreateDataSetOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDataSetOutput) SetId(v string) *CreateDataSetOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSetOutput) SetName(v string) *CreateDataSetOutput {
	s.Name = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *CreateDataSetOutput) SetOrigin(v string) *CreateDataSetOutput {
	s.Origin = &v
	return s
}

// SetOriginDetails sets the OriginDetails field's value.
func (s *CreateDataSetOutput) SetOriginDetails(v *OriginDetails) *CreateDataSetOutput {
	s.OriginDetails = v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *CreateDataSetOutput) SetSourceId(v string) *CreateDataSetOutput {
	s.SourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSetOutput) SetTags(v map[string]*string) *CreateDataSetOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateDataSetOutput) SetUpdatedAt(v time.Time) *CreateDataSetOutput {
	s.UpdatedAt = &v
	return s
}

// A request to create an event action.
type CreateEventActionInput struct {
	_ struct{} `type:"structure"`

	// What occurs after a certain event.
	//
	// Action is a required field
	Action *Action `type:"structure" required:"true"`

	// What occurs to start an action.
	//
	// Event is a required field
	Event *Event `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventActionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Event != nil {
		if err := s.Event.Validate(); err != nil {
			invalidParams.AddNested("Event", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateEventActionInput) SetAction(v *Action) *CreateEventActionInput {
	s.Action = v
	return s
}

// SetEvent sets the Event field's value.
func (s *CreateEventActionInput) SetEvent(v *Event) *CreateEventActionInput {
	s.Event = v
	return s
}

type CreateEventActionOutput struct {
	_ struct{} `type:"structure"`

	// What occurs after a certain event.
	Action *Action `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// What occurs to start an action.
	Event *Event `type:"structure"`

	// A unique identifier.
	Id *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventActionOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CreateEventActionOutput) SetAction(v *Action) *CreateEventActionOutput {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateEventActionOutput) SetArn(v string) *CreateEventActionOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateEventActionOutput) SetCreatedAt(v time.Time) *CreateEventActionOutput {
	s.CreatedAt = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *CreateEventActionOutput) SetEvent(v *Event) *CreateEventActionOutput {
	s.Event = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateEventActionOutput) SetId(v string) *CreateEventActionOutput {
	s.Id = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateEventActionOutput) SetUpdatedAt(v time.Time) *CreateEventActionOutput {
	s.UpdatedAt = &v
	return s
}

// The CreateJob request. AWS Data Exchange Jobs are asynchronous import or
// export operations used to create or copy assets. A data set owner can both
// import and export assets. A subscriber with an entitlement to a data set
// can only export. Jobs are deleted 90 days after they are created. Created
// jobs must be started with the StartJob operation.
type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// The details for the CreateJob request.
	//
	// Details is a required field
	Details *RequestDetails `type:"structure" required:"true"`

	// The type of job to be created.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.Details == nil {
		invalidParams.Add(request.NewErrParamRequired("Details"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Details != nil {
		if err := s.Details.Validate(); err != nil {
			invalidParams.AddNested("Details", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *CreateJobInput) SetDetails(v *RequestDetails) *CreateJobInput {
	s.Details = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateJobInput) SetType(v string) *CreateJobInput {
	s.Type = &v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Details for the response.
	Details *ResponseDetails `type:"structure"`

	Errors []*JobError `type:"list"`

	// A unique identifier.
	Id *string `type:"string"`

	State *string `type:"string" enum:"State"`

	Type *string `type:"string" enum:"Type"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateJobOutput) SetArn(v string) *CreateJobOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateJobOutput) SetCreatedAt(v time.Time) *CreateJobOutput {
	s.CreatedAt = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *CreateJobOutput) SetDetails(v *ResponseDetails) *CreateJobOutput {
	s.Details = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *CreateJobOutput) SetErrors(v []*JobError) *CreateJobOutput {
	s.Errors = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateJobOutput) SetId(v string) *CreateJobOutput {
	s.Id = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateJobOutput) SetState(v string) *CreateJobOutput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateJobOutput) SetType(v string) *CreateJobOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateJobOutput) SetUpdatedAt(v time.Time) *CreateJobOutput {
	s.UpdatedAt = &v
	return s
}

// Creates a revision for a data set. When they're created, revisions are not
// published to products, and therefore are not available to subscribers. To
// publish a revision to a data set in a product, the revision must first be
// finalized.
type CreateRevisionInput struct {
	_ struct{} `type:"structure"`

	// An optional comment about the revision.
	Comment *string `type:"string"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// A revision tag is an optional label that you can assign to a revision when
	// you create it. Each tag consists of a key and an optional value, both of
	// which you define. When you use tagging, you can also use tag-based access
	// control in IAM policies to control access to these data sets and revisions.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRevisionInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CreateRevisionInput) SetComment(v string) *CreateRevisionInput {
	s.Comment = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateRevisionInput) SetDataSetId(v string) *CreateRevisionInput {
	s.DataSetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRevisionInput) SetTags(v map[string]*string) *CreateRevisionInput {
	s.Tags = v
	return s
}

type CreateRevisionOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	Comment *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	DataSetId *string `type:"string"`

	Finalized *bool `type:"boolean"`

	// A unique identifier.
	Id *string `type:"string"`

	RevocationComment *string `min:"10" type:"string"`

	Revoked *bool `type:"boolean"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	RevokedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	SourceId *string `type:"string"`

	Tags map[string]*string `type:"map"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRevisionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateRevisionOutput) SetArn(v string) *CreateRevisionOutput {
	s.Arn = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *CreateRevisionOutput) SetComment(v string) *CreateRevisionOutput {
	s.Comment = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateRevisionOutput) SetCreatedAt(v time.Time) *CreateRevisionOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateRevisionOutput) SetDataSetId(v string) *CreateRevisionOutput {
	s.DataSetId = &v
	return s
}

// SetFinalized sets the Finalized field's value.
func (s *CreateRevisionOutput) SetFinalized(v bool) *CreateRevisionOutput {
	s.Finalized = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateRevisionOutput) SetId(v string) *CreateRevisionOutput {
	s.Id = &v
	return s
}

// SetRevocationComment sets the RevocationComment field's value.
func (s *CreateRevisionOutput) SetRevocationComment(v string) *CreateRevisionOutput {
	s.RevocationComment = &v
	return s
}

// SetRevoked sets the Revoked field's value.
func (s *CreateRevisionOutput) SetRevoked(v bool) *CreateRevisionOutput {
	s.Revoked = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *CreateRevisionOutput) SetRevokedAt(v time.Time) *CreateRevisionOutput {
	s.RevokedAt = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *CreateRevisionOutput) SetSourceId(v string) *CreateRevisionOutput {
	s.SourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRevisionOutput) SetTags(v map[string]*string) *CreateRevisionOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateRevisionOutput) SetUpdatedAt(v time.Time) *CreateRevisionOutput {
	s.UpdatedAt = &v
	return s
}

// A data set is an AWS resource with one or more revisions.
type DataSetEntry struct {
	_ struct{} `type:"structure"`

	// The ARN for the data set.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The type of asset that is added to a data set.
	//
	// AssetType is a required field
	AssetType *string `type:"string" required:"true" enum:"AssetType"`

	// The date and time that the data set was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description for the data set.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The unique identifier for the data set.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The name of the data set.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A property that defines the data set as OWNED by the account (for providers)
	// or ENTITLED to the account (for subscribers).
	//
	// Origin is a required field
	Origin *string `type:"string" required:"true" enum:"Origin"`

	// If the origin of this data set is ENTITLED, includes the details for the
	// product on AWS Marketplace.
	OriginDetails *OriginDetails `type:"structure"`

	// The data set ID of the owned data set corresponding to the entitled data
	// set being viewed. This parameter is returned when a data set owner is viewing
	// the entitled copy of its owned data set.
	SourceId *string `type:"string"`

	// The date and time that the data set was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetEntry) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataSetEntry) SetArn(v string) *DataSetEntry {
	s.Arn = &v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *DataSetEntry) SetAssetType(v string) *DataSetEntry {
	s.AssetType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSetEntry) SetCreatedAt(v time.Time) *DataSetEntry {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataSetEntry) SetDescription(v string) *DataSetEntry {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DataSetEntry) SetId(v string) *DataSetEntry {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSetEntry) SetName(v string) *DataSetEntry {
	s.Name = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *DataSetEntry) SetOrigin(v string) *DataSetEntry {
	s.Origin = &v
	return s
}

// SetOriginDetails sets the OriginDetails field's value.
func (s *DataSetEntry) SetOriginDetails(v *OriginDetails) *DataSetEntry {
	s.OriginDetails = v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *DataSetEntry) SetSourceId(v string) *DataSetEntry {
	s.SourceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSetEntry) SetUpdatedAt(v time.Time) *DataSetEntry {
	s.UpdatedAt = &v
	return s
}

type DeleteAssetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"AssetId" type:"string" required:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 1))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DeleteAssetInput) SetAssetId(v string) *DeleteAssetInput {
	s.AssetId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DeleteAssetInput) SetDataSetId(v string) *DeleteAssetInput {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DeleteAssetInput) SetRevisionId(v string) *DeleteAssetInput {
	s.RevisionId = &v
	return s
}

type DeleteAssetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetOutput) GoString() string {
	return s.String()
}

type DeleteDataSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSetInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *DeleteDataSetInput) SetDataSetId(v string) *DeleteDataSetInput {
	s.DataSetId = &v
	return s
}

type DeleteDataSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSetOutput) GoString() string {
	return s.String()
}

type DeleteEventActionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// EventActionId is a required field
	EventActionId *string `location:"uri" locationName:"EventActionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventActionInput"}
	if s.EventActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventActionId"))
	}
	if s.EventActionId != nil && len(*s.EventActionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventActionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventActionId sets the EventActionId field's value.
func (s *DeleteEventActionInput) SetEventActionId(v string) *DeleteEventActionInput {
	s.EventActionId = &v
	return s
}

type DeleteEventActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventActionOutput) GoString() string {
	return s.String()
}

type DeleteRevisionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRevisionInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *DeleteRevisionInput) SetDataSetId(v string) *DeleteRevisionInput {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DeleteRevisionInput) SetRevisionId(v string) *DeleteRevisionInput {
	s.RevisionId = &v
	return s
}

type DeleteRevisionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRevisionOutput) GoString() string {
	return s.String()
}

// Information about the job error.
type Details struct {
	_ struct{} `type:"structure"`

	// Information about the job error.
	ImportAssetFromSignedUrlJobErrorDetails *ImportAssetFromSignedUrlJobErrorDetails `type:"structure"`

	// Information about the job error.
	ImportAssetsFromS3JobErrorDetails []*AssetSourceEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Details) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Details) GoString() string {
	return s.String()
}

// SetImportAssetFromSignedUrlJobErrorDetails sets the ImportAssetFromSignedUrlJobErrorDetails field's value.
func (s *Details) SetImportAssetFromSignedUrlJobErrorDetails(v *ImportAssetFromSignedUrlJobErrorDetails) *Details {
	s.ImportAssetFromSignedUrlJobErrorDetails = v
	return s
}

// SetImportAssetsFromS3JobErrorDetails sets the ImportAssetsFromS3JobErrorDetails field's value.
func (s *Details) SetImportAssetsFromS3JobErrorDetails(v []*AssetSourceEntry) *Details {
	s.ImportAssetsFromS3JobErrorDetails = v
	return s
}

// What occurs to start an action.
type Event struct {
	_ struct{} `type:"structure"`

	// What occurs to start the revision publish action.
	RevisionPublished *RevisionPublished `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Event) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Event"}
	if s.RevisionPublished != nil {
		if err := s.RevisionPublished.Validate(); err != nil {
			invalidParams.AddNested("RevisionPublished", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRevisionPublished sets the RevisionPublished field's value.
func (s *Event) SetRevisionPublished(v *RevisionPublished) *Event {
	s.RevisionPublished = v
	return s
}

// An event action is an object that defines the relationship between a specific
// event and an automated action that will be taken on behalf of the customer.
type EventActionEntry struct {
	_ struct{} `type:"structure"`

	// What occurs after a certain event.
	//
	// Action is a required field
	Action *Action `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for the event action.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The date and time that the event action was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// What occurs to start an action.
	//
	// Event is a required field
	Event *Event `type:"structure" required:"true"`

	// The unique identifier for the event action.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time that the event action was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventActionEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventActionEntry) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *EventActionEntry) SetAction(v *Action) *EventActionEntry {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *EventActionEntry) SetArn(v string) *EventActionEntry {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EventActionEntry) SetCreatedAt(v time.Time) *EventActionEntry {
	s.CreatedAt = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *EventActionEntry) SetEvent(v *Event) *EventActionEntry {
	s.Event = v
	return s
}

// SetId sets the Id field's value.
func (s *EventActionEntry) SetId(v string) *EventActionEntry {
	s.Id = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *EventActionEntry) SetUpdatedAt(v time.Time) *EventActionEntry {
	s.UpdatedAt = &v
	return s
}

// Details of the operation to be performed by the job.
type ExportAssetToSignedUrlRequestDetails struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the asset that is exported to a signed URL.
	//
	// AssetId is a required field
	AssetId *string `type:"string" required:"true"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this export request.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAssetToSignedUrlRequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAssetToSignedUrlRequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportAssetToSignedUrlRequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportAssetToSignedUrlRequestDetails"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *ExportAssetToSignedUrlRequestDetails) SetAssetId(v string) *ExportAssetToSignedUrlRequestDetails {
	s.AssetId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ExportAssetToSignedUrlRequestDetails) SetDataSetId(v string) *ExportAssetToSignedUrlRequestDetails {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ExportAssetToSignedUrlRequestDetails) SetRevisionId(v string) *ExportAssetToSignedUrlRequestDetails {
	s.RevisionId = &v
	return s
}

// The details of the export to signed URL response.
type ExportAssetToSignedUrlResponseDetails struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the asset associated with this export job.
	//
	// AssetId is a required field
	AssetId *string `type:"string" required:"true"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this export response.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`

	// The signed URL for the export request.
	SignedUrl *string `type:"string"`

	// The date and time that the signed URL expires, in ISO 8601 format.
	SignedUrlExpiresAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAssetToSignedUrlResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAssetToSignedUrlResponseDetails) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *ExportAssetToSignedUrlResponseDetails) SetAssetId(v string) *ExportAssetToSignedUrlResponseDetails {
	s.AssetId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ExportAssetToSignedUrlResponseDetails) SetDataSetId(v string) *ExportAssetToSignedUrlResponseDetails {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ExportAssetToSignedUrlResponseDetails) SetRevisionId(v string) *ExportAssetToSignedUrlResponseDetails {
	s.RevisionId = &v
	return s
}

// SetSignedUrl sets the SignedUrl field's value.
func (s *ExportAssetToSignedUrlResponseDetails) SetSignedUrl(v string) *ExportAssetToSignedUrlResponseDetails {
	s.SignedUrl = &v
	return s
}

// SetSignedUrlExpiresAt sets the SignedUrlExpiresAt field's value.
func (s *ExportAssetToSignedUrlResponseDetails) SetSignedUrlExpiresAt(v time.Time) *ExportAssetToSignedUrlResponseDetails {
	s.SignedUrlExpiresAt = &v
	return s
}

// Details of the operation to be performed by the job.
type ExportAssetsToS3RequestDetails struct {
	_ struct{} `type:"structure"`

	// The destination for the asset.
	//
	// AssetDestinations is a required field
	AssetDestinations []*AssetDestinationEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// Encryption configuration for the export job.
	Encryption *ExportServerSideEncryption `type:"structure"`

	// The unique identifier for the revision associated with this export request.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAssetsToS3RequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAssetsToS3RequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportAssetsToS3RequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportAssetsToS3RequestDetails"}
	if s.AssetDestinations == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetDestinations"))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.AssetDestinations != nil {
		for i, v := range s.AssetDestinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetDestinations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetDestinations sets the AssetDestinations field's value.
func (s *ExportAssetsToS3RequestDetails) SetAssetDestinations(v []*AssetDestinationEntry) *ExportAssetsToS3RequestDetails {
	s.AssetDestinations = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ExportAssetsToS3RequestDetails) SetDataSetId(v string) *ExportAssetsToS3RequestDetails {
	s.DataSetId = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *ExportAssetsToS3RequestDetails) SetEncryption(v *ExportServerSideEncryption) *ExportAssetsToS3RequestDetails {
	s.Encryption = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ExportAssetsToS3RequestDetails) SetRevisionId(v string) *ExportAssetsToS3RequestDetails {
	s.RevisionId = &v
	return s
}

// Details about the export to Amazon S3 response.
type ExportAssetsToS3ResponseDetails struct {
	_ struct{} `type:"structure"`

	// The destination in Amazon S3 where the asset is exported.
	//
	// AssetDestinations is a required field
	AssetDestinations []*AssetDestinationEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// Encryption configuration of the export job.
	Encryption *ExportServerSideEncryption `type:"structure"`

	// The unique identifier for the revision associated with this export response.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAssetsToS3ResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAssetsToS3ResponseDetails) GoString() string {
	return s.String()
}

// SetAssetDestinations sets the AssetDestinations field's value.
func (s *ExportAssetsToS3ResponseDetails) SetAssetDestinations(v []*AssetDestinationEntry) *ExportAssetsToS3ResponseDetails {
	s.AssetDestinations = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ExportAssetsToS3ResponseDetails) SetDataSetId(v string) *ExportAssetsToS3ResponseDetails {
	s.DataSetId = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *ExportAssetsToS3ResponseDetails) SetEncryption(v *ExportServerSideEncryption) *ExportAssetsToS3ResponseDetails {
	s.Encryption = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ExportAssetsToS3ResponseDetails) SetRevisionId(v string) *ExportAssetsToS3ResponseDetails {
	s.RevisionId = &v
	return s
}

// Details of the operation to be performed by the job.
type ExportRevisionsToS3RequestDetails struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// Encryption configuration for the export job.
	Encryption *ExportServerSideEncryption `type:"structure"`

	// The destination for the revision.
	//
	// RevisionDestinations is a required field
	RevisionDestinations []*RevisionDestinationEntry `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportRevisionsToS3RequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportRevisionsToS3RequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportRevisionsToS3RequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportRevisionsToS3RequestDetails"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.RevisionDestinations == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionDestinations"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}
	if s.RevisionDestinations != nil {
		for i, v := range s.RevisionDestinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RevisionDestinations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *ExportRevisionsToS3RequestDetails) SetDataSetId(v string) *ExportRevisionsToS3RequestDetails {
	s.DataSetId = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *ExportRevisionsToS3RequestDetails) SetEncryption(v *ExportServerSideEncryption) *ExportRevisionsToS3RequestDetails {
	s.Encryption = v
	return s
}

// SetRevisionDestinations sets the RevisionDestinations field's value.
func (s *ExportRevisionsToS3RequestDetails) SetRevisionDestinations(v []*RevisionDestinationEntry) *ExportRevisionsToS3RequestDetails {
	s.RevisionDestinations = v
	return s
}

// Details about the export revisions to Amazon S3 response.
type ExportRevisionsToS3ResponseDetails struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the data set associated with this export job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// Encryption configuration of the export job.
	Encryption *ExportServerSideEncryption `type:"structure"`

	// The Amazon Resource Name (ARN) of the event action.
	EventActionArn *string `type:"string"`

	// The destination in Amazon S3 where the revision is exported.
	//
	// RevisionDestinations is a required field
	RevisionDestinations []*RevisionDestinationEntry `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportRevisionsToS3ResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportRevisionsToS3ResponseDetails) GoString() string {
	return s.String()
}

// SetDataSetId sets the DataSetId field's value.
func (s *ExportRevisionsToS3ResponseDetails) SetDataSetId(v string) *ExportRevisionsToS3ResponseDetails {
	s.DataSetId = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *ExportRevisionsToS3ResponseDetails) SetEncryption(v *ExportServerSideEncryption) *ExportRevisionsToS3ResponseDetails {
	s.Encryption = v
	return s
}

// SetEventActionArn sets the EventActionArn field's value.
func (s *ExportRevisionsToS3ResponseDetails) SetEventActionArn(v string) *ExportRevisionsToS3ResponseDetails {
	s.EventActionArn = &v
	return s
}

// SetRevisionDestinations sets the RevisionDestinations field's value.
func (s *ExportRevisionsToS3ResponseDetails) SetRevisionDestinations(v []*RevisionDestinationEntry) *ExportRevisionsToS3ResponseDetails {
	s.RevisionDestinations = v
	return s
}

// Encryption configuration of the export job. Includes the encryption type
// in addition to the AWS KMS key. The KMS key is only necessary if you chose
// the KMS encryption. type.
type ExportServerSideEncryption struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt
	// the Amazon S3 objects. This parameter is required if you choose aws:kms as
	// an encryption type.
	KmsKeyArn *string `type:"string"`

	// The type of server side encryption used for encrypting the objects in Amazon
	// S3.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ServerSideEncryptionTypes"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportServerSideEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportServerSideEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportServerSideEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportServerSideEncryption"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *ExportServerSideEncryption) SetKmsKeyArn(v string) *ExportServerSideEncryption {
	s.KmsKeyArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExportServerSideEncryption) SetType(v string) *ExportServerSideEncryption {
	s.Type = &v
	return s
}

type GetAssetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"AssetId" type:"string" required:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 1))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *GetAssetInput) SetAssetId(v string) *GetAssetInput {
	s.AssetId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *GetAssetInput) SetDataSetId(v string) *GetAssetInput {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetAssetInput) SetRevisionId(v string) *GetAssetInput {
	s.RevisionId = &v
	return s
}

type GetAssetOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// Information about the asset.
	AssetDetails *AssetDetails `type:"structure"`

	// The type of asset that is added to a data set.
	AssetType *string `type:"string" enum:"AssetType"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	DataSetId *string `type:"string"`

	// A unique identifier.
	Id *string `type:"string"`

	// The name of the asset. When importing from Amazon S3, the S3 object key is
	// used as the asset name. When exporting to Amazon S3, the asset name is used
	// as default target S3 object key. When importing from Amazon API Gateway API,
	// the API name is used as the asset name. When importing from Amazon Redshift,
	// the datashare name is used as the asset name.
	Name *string `type:"string"`

	// A unique identifier.
	RevisionId *string `type:"string"`

	// A unique identifier.
	SourceId *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetAssetOutput) SetArn(v string) *GetAssetOutput {
	s.Arn = &v
	return s
}

// SetAssetDetails sets the AssetDetails field's value.
func (s *GetAssetOutput) SetAssetDetails(v *AssetDetails) *GetAssetOutput {
	s.AssetDetails = v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *GetAssetOutput) SetAssetType(v string) *GetAssetOutput {
	s.AssetType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAssetOutput) SetCreatedAt(v time.Time) *GetAssetOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *GetAssetOutput) SetDataSetId(v string) *GetAssetOutput {
	s.DataSetId = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetAssetOutput) SetId(v string) *GetAssetOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAssetOutput) SetName(v string) *GetAssetOutput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetAssetOutput) SetRevisionId(v string) *GetAssetOutput {
	s.RevisionId = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *GetAssetOutput) SetSourceId(v string) *GetAssetOutput {
	s.SourceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetAssetOutput) SetUpdatedAt(v time.Time) *GetAssetOutput {
	s.UpdatedAt = &v
	return s
}

type GetDataSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSetInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *GetDataSetInput) SetDataSetId(v string) *GetDataSetInput {
	s.DataSetId = &v
	return s
}

type GetDataSetOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// The type of asset that is added to a data set.
	AssetType *string `type:"string" enum:"AssetType"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A description of a resource.
	Description *string `type:"string"`

	// A unique identifier.
	Id *string `type:"string"`

	// The name of the model.
	Name *string `type:"string"`

	// A property that defines the data set as OWNED by the account (for providers)
	// or ENTITLED to the account (for subscribers). When an owned data set is published
	// in a product, AWS Data Exchange creates a copy of the data set. Subscribers
	// can access that copy of the data set as an entitled data set.
	Origin *string `type:"string" enum:"Origin"`

	// Information about the origin of the data set.
	OriginDetails *OriginDetails `type:"structure"`

	// A unique identifier.
	SourceId *string `type:"string"`

	Tags map[string]*string `type:"map"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDataSetOutput) SetArn(v string) *GetDataSetOutput {
	s.Arn = &v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *GetDataSetOutput) SetAssetType(v string) *GetDataSetOutput {
	s.AssetType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDataSetOutput) SetCreatedAt(v time.Time) *GetDataSetOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDataSetOutput) SetDescription(v string) *GetDataSetOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDataSetOutput) SetId(v string) *GetDataSetOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataSetOutput) SetName(v string) *GetDataSetOutput {
	s.Name = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *GetDataSetOutput) SetOrigin(v string) *GetDataSetOutput {
	s.Origin = &v
	return s
}

// SetOriginDetails sets the OriginDetails field's value.
func (s *GetDataSetOutput) SetOriginDetails(v *OriginDetails) *GetDataSetOutput {
	s.OriginDetails = v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *GetDataSetOutput) SetSourceId(v string) *GetDataSetOutput {
	s.SourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDataSetOutput) SetTags(v map[string]*string) *GetDataSetOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDataSetOutput) SetUpdatedAt(v time.Time) *GetDataSetOutput {
	s.UpdatedAt = &v
	return s
}

type GetEventActionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// EventActionId is a required field
	EventActionId *string `location:"uri" locationName:"EventActionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventActionInput"}
	if s.EventActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventActionId"))
	}
	if s.EventActionId != nil && len(*s.EventActionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventActionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventActionId sets the EventActionId field's value.
func (s *GetEventActionInput) SetEventActionId(v string) *GetEventActionInput {
	s.EventActionId = &v
	return s
}

type GetEventActionOutput struct {
	_ struct{} `type:"structure"`

	// What occurs after a certain event.
	Action *Action `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// What occurs to start an action.
	Event *Event `type:"structure"`

	// A unique identifier.
	Id *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventActionOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GetEventActionOutput) SetAction(v *Action) *GetEventActionOutput {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetEventActionOutput) SetArn(v string) *GetEventActionOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetEventActionOutput) SetCreatedAt(v time.Time) *GetEventActionOutput {
	s.CreatedAt = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *GetEventActionOutput) SetEvent(v *Event) *GetEventActionOutput {
	s.Event = v
	return s
}

// SetId sets the Id field's value.
func (s *GetEventActionOutput) SetId(v string) *GetEventActionOutput {
	s.Id = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetEventActionOutput) SetUpdatedAt(v time.Time) *GetEventActionOutput {
	s.UpdatedAt = &v
	return s
}

type GetJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetJobInput) SetJobId(v string) *GetJobInput {
	s.JobId = &v
	return s
}

type GetJobOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Details for the response.
	Details *ResponseDetails `type:"structure"`

	Errors []*JobError `type:"list"`

	// A unique identifier.
	Id *string `type:"string"`

	State *string `type:"string" enum:"State"`

	Type *string `type:"string" enum:"Type"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetJobOutput) SetArn(v string) *GetJobOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetJobOutput) SetCreatedAt(v time.Time) *GetJobOutput {
	s.CreatedAt = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *GetJobOutput) SetDetails(v *ResponseDetails) *GetJobOutput {
	s.Details = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *GetJobOutput) SetErrors(v []*JobError) *GetJobOutput {
	s.Errors = v
	return s
}

// SetId sets the Id field's value.
func (s *GetJobOutput) SetId(v string) *GetJobOutput {
	s.Id = &v
	return s
}

// SetState sets the State field's value.
func (s *GetJobOutput) SetState(v string) *GetJobOutput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetJobOutput) SetType(v string) *GetJobOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetJobOutput) SetUpdatedAt(v time.Time) *GetJobOutput {
	s.UpdatedAt = &v
	return s
}

type GetRevisionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRevisionInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *GetRevisionInput) SetDataSetId(v string) *GetRevisionInput {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetRevisionInput) SetRevisionId(v string) *GetRevisionInput {
	s.RevisionId = &v
	return s
}

type GetRevisionOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	Comment *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	DataSetId *string `type:"string"`

	Finalized *bool `type:"boolean"`

	// A unique identifier.
	Id *string `type:"string"`

	RevocationComment *string `min:"10" type:"string"`

	Revoked *bool `type:"boolean"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	RevokedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	SourceId *string `type:"string"`

	Tags map[string]*string `type:"map"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRevisionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetRevisionOutput) SetArn(v string) *GetRevisionOutput {
	s.Arn = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *GetRevisionOutput) SetComment(v string) *GetRevisionOutput {
	s.Comment = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetRevisionOutput) SetCreatedAt(v time.Time) *GetRevisionOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *GetRevisionOutput) SetDataSetId(v string) *GetRevisionOutput {
	s.DataSetId = &v
	return s
}

// SetFinalized sets the Finalized field's value.
func (s *GetRevisionOutput) SetFinalized(v bool) *GetRevisionOutput {
	s.Finalized = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetRevisionOutput) SetId(v string) *GetRevisionOutput {
	s.Id = &v
	return s
}

// SetRevocationComment sets the RevocationComment field's value.
func (s *GetRevisionOutput) SetRevocationComment(v string) *GetRevisionOutput {
	s.RevocationComment = &v
	return s
}

// SetRevoked sets the Revoked field's value.
func (s *GetRevisionOutput) SetRevoked(v bool) *GetRevisionOutput {
	s.Revoked = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *GetRevisionOutput) SetRevokedAt(v time.Time) *GetRevisionOutput {
	s.RevokedAt = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *GetRevisionOutput) SetSourceId(v string) *GetRevisionOutput {
	s.SourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetRevisionOutput) SetTags(v map[string]*string) *GetRevisionOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetRevisionOutput) SetUpdatedAt(v time.Time) *GetRevisionOutput {
	s.UpdatedAt = &v
	return s
}

// The request details.
type ImportAssetFromApiGatewayApiRequestDetails struct {
	_ struct{} `type:"structure"`

	// The API description. Markdown supported.
	ApiDescription *string `type:"string"`

	// The API Gateway API ID.
	//
	// ApiId is a required field
	ApiId *string `type:"string" required:"true"`

	// The API Gateway API key.
	ApiKey *string `type:"string"`

	// The API name.
	//
	// ApiName is a required field
	ApiName *string `type:"string" required:"true"`

	// The Base64-encoded MD5 hash of the OpenAPI 3.0 JSON API specification file.
	// It is used to ensure the integrity of the file.
	//
	// ApiSpecificationMd5Hash is a required field
	ApiSpecificationMd5Hash *string `min:"24" type:"string" required:"true"`

	// The data set ID.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The protocol type.
	//
	// ProtocolType is a required field
	ProtocolType *string `type:"string" required:"true" enum:"ProtocolType"`

	// The revision ID.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`

	// The API stage.
	//
	// Stage is a required field
	Stage *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromApiGatewayApiRequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromApiGatewayApiRequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportAssetFromApiGatewayApiRequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportAssetFromApiGatewayApiRequestDetails"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiName"))
	}
	if s.ApiSpecificationMd5Hash == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiSpecificationMd5Hash"))
	}
	if s.ApiSpecificationMd5Hash != nil && len(*s.ApiSpecificationMd5Hash) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("ApiSpecificationMd5Hash", 24))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.ProtocolType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtocolType"))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.Stage == nil {
		invalidParams.Add(request.NewErrParamRequired("Stage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiDescription sets the ApiDescription field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetApiDescription(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.ApiDescription = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetApiId(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.ApiId = &v
	return s
}

// SetApiKey sets the ApiKey field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetApiKey(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.ApiKey = &v
	return s
}

// SetApiName sets the ApiName field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetApiName(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.ApiName = &v
	return s
}

// SetApiSpecificationMd5Hash sets the ApiSpecificationMd5Hash field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetApiSpecificationMd5Hash(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.ApiSpecificationMd5Hash = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetDataSetId(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.DataSetId = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetProtocolType(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.ProtocolType = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetRevisionId(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.RevisionId = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *ImportAssetFromApiGatewayApiRequestDetails) SetStage(v string) *ImportAssetFromApiGatewayApiRequestDetails {
	s.Stage = &v
	return s
}

// The response details.
type ImportAssetFromApiGatewayApiResponseDetails struct {
	_ struct{} `type:"structure"`

	// The API description.
	ApiDescription *string `type:"string"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `type:"string" required:"true"`

	// The API key.
	ApiKey *string `type:"string"`

	// The API name.
	//
	// ApiName is a required field
	ApiName *string `type:"string" required:"true"`

	// The Base64-encoded Md5 hash for the API asset, used to ensure the integrity
	// of the API at that location.
	//
	// ApiSpecificationMd5Hash is a required field
	ApiSpecificationMd5Hash *string `min:"24" type:"string" required:"true"`

	// The upload URL of the API specification.
	//
	// ApiSpecificationUploadUrl is a required field
	ApiSpecificationUploadUrl *string `type:"string" required:"true"`

	// The date and time that the upload URL expires, in ISO 8601 format.
	//
	// ApiSpecificationUploadUrlExpiresAt is a required field
	ApiSpecificationUploadUrlExpiresAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data set ID.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The protocol type.
	//
	// ProtocolType is a required field
	ProtocolType *string `type:"string" required:"true" enum:"ProtocolType"`

	// The revision ID.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`

	// The API stage.
	//
	// Stage is a required field
	Stage *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromApiGatewayApiResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromApiGatewayApiResponseDetails) GoString() string {
	return s.String()
}

// SetApiDescription sets the ApiDescription field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetApiDescription(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.ApiDescription = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetApiId(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.ApiId = &v
	return s
}

// SetApiKey sets the ApiKey field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetApiKey(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.ApiKey = &v
	return s
}

// SetApiName sets the ApiName field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetApiName(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.ApiName = &v
	return s
}

// SetApiSpecificationMd5Hash sets the ApiSpecificationMd5Hash field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetApiSpecificationMd5Hash(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.ApiSpecificationMd5Hash = &v
	return s
}

// SetApiSpecificationUploadUrl sets the ApiSpecificationUploadUrl field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetApiSpecificationUploadUrl(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.ApiSpecificationUploadUrl = &v
	return s
}

// SetApiSpecificationUploadUrlExpiresAt sets the ApiSpecificationUploadUrlExpiresAt field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetApiSpecificationUploadUrlExpiresAt(v time.Time) *ImportAssetFromApiGatewayApiResponseDetails {
	s.ApiSpecificationUploadUrlExpiresAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetDataSetId(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.DataSetId = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetProtocolType(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.ProtocolType = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetRevisionId(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.RevisionId = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *ImportAssetFromApiGatewayApiResponseDetails) SetStage(v string) *ImportAssetFromApiGatewayApiResponseDetails {
	s.Stage = &v
	return s
}

// Information about the job error.
type ImportAssetFromSignedUrlJobErrorDetails struct {
	_ struct{} `type:"structure"`

	// Information about the job error.
	//
	// AssetName is a required field
	AssetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromSignedUrlJobErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromSignedUrlJobErrorDetails) GoString() string {
	return s.String()
}

// SetAssetName sets the AssetName field's value.
func (s *ImportAssetFromSignedUrlJobErrorDetails) SetAssetName(v string) *ImportAssetFromSignedUrlJobErrorDetails {
	s.AssetName = &v
	return s
}

// Details of the operation to be performed by the job.
type ImportAssetFromSignedUrlRequestDetails struct {
	_ struct{} `type:"structure"`

	// The name of the asset. When importing from Amazon S3, the S3 object key is
	// used as the asset name.
	//
	// AssetName is a required field
	AssetName *string `type:"string" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The Base64-encoded Md5 hash for the asset, used to ensure the integrity of
	// the file at that location.
	//
	// Md5Hash is a required field
	Md5Hash *string `min:"24" type:"string" required:"true"`

	// The unique identifier for the revision associated with this import request.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromSignedUrlRequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromSignedUrlRequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportAssetFromSignedUrlRequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportAssetFromSignedUrlRequestDetails"}
	if s.AssetName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetName"))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.Md5Hash == nil {
		invalidParams.Add(request.NewErrParamRequired("Md5Hash"))
	}
	if s.Md5Hash != nil && len(*s.Md5Hash) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("Md5Hash", 24))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetName sets the AssetName field's value.
func (s *ImportAssetFromSignedUrlRequestDetails) SetAssetName(v string) *ImportAssetFromSignedUrlRequestDetails {
	s.AssetName = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ImportAssetFromSignedUrlRequestDetails) SetDataSetId(v string) *ImportAssetFromSignedUrlRequestDetails {
	s.DataSetId = &v
	return s
}

// SetMd5Hash sets the Md5Hash field's value.
func (s *ImportAssetFromSignedUrlRequestDetails) SetMd5Hash(v string) *ImportAssetFromSignedUrlRequestDetails {
	s.Md5Hash = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ImportAssetFromSignedUrlRequestDetails) SetRevisionId(v string) *ImportAssetFromSignedUrlRequestDetails {
	s.RevisionId = &v
	return s
}

// The details in the response for an import request, including the signed URL
// and other information.
type ImportAssetFromSignedUrlResponseDetails struct {
	_ struct{} `type:"structure"`

	// The name for the asset associated with this import job.
	//
	// AssetName is a required field
	AssetName *string `type:"string" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The Base64-encoded Md5 hash for the asset, used to ensure the integrity of
	// the file at that location.
	Md5Hash *string `min:"24" type:"string"`

	// The unique identifier for the revision associated with this import response.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`

	// The signed URL.
	SignedUrl *string `type:"string"`

	// The time and date at which the signed URL expires, in ISO 8601 format.
	SignedUrlExpiresAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromSignedUrlResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetFromSignedUrlResponseDetails) GoString() string {
	return s.String()
}

// SetAssetName sets the AssetName field's value.
func (s *ImportAssetFromSignedUrlResponseDetails) SetAssetName(v string) *ImportAssetFromSignedUrlResponseDetails {
	s.AssetName = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ImportAssetFromSignedUrlResponseDetails) SetDataSetId(v string) *ImportAssetFromSignedUrlResponseDetails {
	s.DataSetId = &v
	return s
}

// SetMd5Hash sets the Md5Hash field's value.
func (s *ImportAssetFromSignedUrlResponseDetails) SetMd5Hash(v string) *ImportAssetFromSignedUrlResponseDetails {
	s.Md5Hash = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ImportAssetFromSignedUrlResponseDetails) SetRevisionId(v string) *ImportAssetFromSignedUrlResponseDetails {
	s.RevisionId = &v
	return s
}

// SetSignedUrl sets the SignedUrl field's value.
func (s *ImportAssetFromSignedUrlResponseDetails) SetSignedUrl(v string) *ImportAssetFromSignedUrlResponseDetails {
	s.SignedUrl = &v
	return s
}

// SetSignedUrlExpiresAt sets the SignedUrlExpiresAt field's value.
func (s *ImportAssetFromSignedUrlResponseDetails) SetSignedUrlExpiresAt(v time.Time) *ImportAssetFromSignedUrlResponseDetails {
	s.SignedUrlExpiresAt = &v
	return s
}

// Details from an import from Amazon Redshift datashare request.
type ImportAssetsFromRedshiftDataSharesRequestDetails struct {
	_ struct{} `type:"structure"`

	// A list of Amazon Redshift datashare assets.
	//
	// AssetSources is a required field
	AssetSources []*RedshiftDataShareAssetSourceEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this import job.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetsFromRedshiftDataSharesRequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetsFromRedshiftDataSharesRequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportAssetsFromRedshiftDataSharesRequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportAssetsFromRedshiftDataSharesRequestDetails"}
	if s.AssetSources == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetSources"))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.AssetSources != nil {
		for i, v := range s.AssetSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetSources sets the AssetSources field's value.
func (s *ImportAssetsFromRedshiftDataSharesRequestDetails) SetAssetSources(v []*RedshiftDataShareAssetSourceEntry) *ImportAssetsFromRedshiftDataSharesRequestDetails {
	s.AssetSources = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ImportAssetsFromRedshiftDataSharesRequestDetails) SetDataSetId(v string) *ImportAssetsFromRedshiftDataSharesRequestDetails {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ImportAssetsFromRedshiftDataSharesRequestDetails) SetRevisionId(v string) *ImportAssetsFromRedshiftDataSharesRequestDetails {
	s.RevisionId = &v
	return s
}

// Details from an import from Amazon Redshift datashare response.
type ImportAssetsFromRedshiftDataSharesResponseDetails struct {
	_ struct{} `type:"structure"`

	// A list of Amazon Redshift datashare asset sources.
	//
	// AssetSources is a required field
	AssetSources []*RedshiftDataShareAssetSourceEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this import job.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetsFromRedshiftDataSharesResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetsFromRedshiftDataSharesResponseDetails) GoString() string {
	return s.String()
}

// SetAssetSources sets the AssetSources field's value.
func (s *ImportAssetsFromRedshiftDataSharesResponseDetails) SetAssetSources(v []*RedshiftDataShareAssetSourceEntry) *ImportAssetsFromRedshiftDataSharesResponseDetails {
	s.AssetSources = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ImportAssetsFromRedshiftDataSharesResponseDetails) SetDataSetId(v string) *ImportAssetsFromRedshiftDataSharesResponseDetails {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ImportAssetsFromRedshiftDataSharesResponseDetails) SetRevisionId(v string) *ImportAssetsFromRedshiftDataSharesResponseDetails {
	s.RevisionId = &v
	return s
}

// Details of the operation to be performed by the job.
type ImportAssetsFromS3RequestDetails struct {
	_ struct{} `type:"structure"`

	// Is a list of S3 bucket and object key pairs.
	//
	// AssetSources is a required field
	AssetSources []*AssetSourceEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this import request.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetsFromS3RequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetsFromS3RequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportAssetsFromS3RequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportAssetsFromS3RequestDetails"}
	if s.AssetSources == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetSources"))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.AssetSources != nil {
		for i, v := range s.AssetSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetSources sets the AssetSources field's value.
func (s *ImportAssetsFromS3RequestDetails) SetAssetSources(v []*AssetSourceEntry) *ImportAssetsFromS3RequestDetails {
	s.AssetSources = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ImportAssetsFromS3RequestDetails) SetDataSetId(v string) *ImportAssetsFromS3RequestDetails {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ImportAssetsFromS3RequestDetails) SetRevisionId(v string) *ImportAssetsFromS3RequestDetails {
	s.RevisionId = &v
	return s
}

// Details from an import from Amazon S3 response.
type ImportAssetsFromS3ResponseDetails struct {
	_ struct{} `type:"structure"`

	// Is a list of Amazon S3 bucket and object key pairs.
	//
	// AssetSources is a required field
	AssetSources []*AssetSourceEntry `type:"list" required:"true"`

	// The unique identifier for the data set associated with this import job.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The unique identifier for the revision associated with this import response.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetsFromS3ResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportAssetsFromS3ResponseDetails) GoString() string {
	return s.String()
}

// SetAssetSources sets the AssetSources field's value.
func (s *ImportAssetsFromS3ResponseDetails) SetAssetSources(v []*AssetSourceEntry) *ImportAssetsFromS3ResponseDetails {
	s.AssetSources = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ImportAssetsFromS3ResponseDetails) SetDataSetId(v string) *ImportAssetsFromS3ResponseDetails {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ImportAssetsFromS3ResponseDetails) SetRevisionId(v string) *ImportAssetsFromS3ResponseDetails {
	s.RevisionId = &v
	return s
}

// An exception occurred with the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message identifying the service exception that occurred.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Data Exchange Jobs are asynchronous import or export operations used
// to create or copy assets. A data set owner can both import and export as
// they see fit. Someone with an entitlement to a data set can only export.
// Jobs are deleted 90 days after they are created.
type JobEntry struct {
	_ struct{} `type:"structure"`

	// The ARN for the job.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The date and time that the job was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Details of the operation to be performed by the job, such as export destination
	// details or import source details.
	//
	// Details is a required field
	Details *ResponseDetails `type:"structure" required:"true"`

	// Errors for jobs.
	Errors []*JobError `type:"list"`

	// The unique identifier for the job.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The state of the job.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"State"`

	// The job type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`

	// The date and time that the job was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobEntry) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *JobEntry) SetArn(v string) *JobEntry {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobEntry) SetCreatedAt(v time.Time) *JobEntry {
	s.CreatedAt = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *JobEntry) SetDetails(v *ResponseDetails) *JobEntry {
	s.Details = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *JobEntry) SetErrors(v []*JobError) *JobEntry {
	s.Errors = v
	return s
}

// SetId sets the Id field's value.
func (s *JobEntry) SetId(v string) *JobEntry {
	s.Id = &v
	return s
}

// SetState sets the State field's value.
func (s *JobEntry) SetState(v string) *JobEntry {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *JobEntry) SetType(v string) *JobEntry {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *JobEntry) SetUpdatedAt(v time.Time) *JobEntry {
	s.UpdatedAt = &v
	return s
}

// An error that occurred with the job request.
type JobError struct {
	_ struct{} `type:"structure"`

	// The code for the job error.
	//
	// Code is a required field
	Code *string `type:"string" required:"true" enum:"Code"`

	// The details about the job error.
	Details *Details `type:"structure"`

	// The name of the limit that was reached.
	LimitName *string `type:"string" enum:"JobErrorLimitName"`

	// The value of the exceeded limit.
	LimitValue *float64 `type:"double"`

	// The message related to the job error.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The unique identifier for the resource related to the error.
	ResourceId *string `type:"string"`

	// The type of resource related to the error.
	ResourceType *string `type:"string" enum:"JobErrorResourceTypes"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *JobError) SetCode(v string) *JobError {
	s.Code = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *JobError) SetDetails(v *Details) *JobError {
	s.Details = v
	return s
}

// SetLimitName sets the LimitName field's value.
func (s *JobError) SetLimitName(v string) *JobError {
	s.LimitName = &v
	return s
}

// SetLimitValue sets the LimitValue field's value.
func (s *JobError) SetLimitValue(v float64) *JobError {
	s.LimitValue = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *JobError) SetMessage(v string) *JobError {
	s.Message = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *JobError) SetResourceId(v string) *JobError {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *JobError) SetResourceType(v string) *JobError {
	s.ResourceType = &v
	return s
}

type ListDataSetRevisionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSetRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSetRevisionsInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *ListDataSetRevisionsInput) SetDataSetId(v string) *ListDataSetRevisionsInput {
	s.DataSetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSetRevisionsInput) SetMaxResults(v int64) *ListDataSetRevisionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetRevisionsInput) SetNextToken(v string) *ListDataSetRevisionsInput {
	s.NextToken = &v
	return s
}

type ListDataSetRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `type:"string"`

	Revisions []*RevisionEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetRevisionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetRevisionsOutput) SetNextToken(v string) *ListDataSetRevisionsOutput {
	s.NextToken = &v
	return s
}

// SetRevisions sets the Revisions field's value.
func (s *ListDataSetRevisionsOutput) SetRevisions(v []*RevisionEntry) *ListDataSetRevisionsOutput {
	s.Revisions = v
	return s
}

type ListDataSetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	Origin *string `location:"querystring" locationName:"origin" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSetsInput) SetMaxResults(v int64) *ListDataSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetsInput) SetNextToken(v string) *ListDataSetsInput {
	s.NextToken = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *ListDataSetsInput) SetOrigin(v string) *ListDataSetsInput {
	s.Origin = &v
	return s
}

type ListDataSetsOutput struct {
	_ struct{} `type:"structure"`

	DataSets []*DataSetEntry `type:"list"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetsOutput) GoString() string {
	return s.String()
}

// SetDataSets sets the DataSets field's value.
func (s *ListDataSetsOutput) SetDataSets(v []*DataSetEntry) *ListDataSetsOutput {
	s.DataSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetsOutput) SetNextToken(v string) *ListDataSetsOutput {
	s.NextToken = &v
	return s
}

type ListEventActionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	EventSourceId *string `location:"querystring" locationName:"eventSourceId" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventActionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSourceId sets the EventSourceId field's value.
func (s *ListEventActionsInput) SetEventSourceId(v string) *ListEventActionsInput {
	s.EventSourceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventActionsInput) SetMaxResults(v int64) *ListEventActionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventActionsInput) SetNextToken(v string) *ListEventActionsInput {
	s.NextToken = &v
	return s
}

type ListEventActionsOutput struct {
	_ struct{} `type:"structure"`

	EventActions []*EventActionEntry `type:"list"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventActionsOutput) GoString() string {
	return s.String()
}

// SetEventActions sets the EventActions field's value.
func (s *ListEventActionsOutput) SetEventActions(v []*EventActionEntry) *ListEventActionsOutput {
	s.EventActions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventActionsOutput) SetNextToken(v string) *ListEventActionsOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	DataSetId *string `location:"querystring" locationName:"dataSetId" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	RevisionId *string `location:"querystring" locationName:"revisionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *ListJobsInput) SetDataSetId(v string) *ListJobsInput {
	s.DataSetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ListJobsInput) SetRevisionId(v string) *ListJobsInput {
	s.RevisionId = &v
	return s
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	Jobs []*JobEntry `type:"list"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*JobEntry) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

type ListRevisionAssetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRevisionAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRevisionAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRevisionAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRevisionAssetsInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *ListRevisionAssetsInput) SetDataSetId(v string) *ListRevisionAssetsInput {
	s.DataSetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRevisionAssetsInput) SetMaxResults(v int64) *ListRevisionAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRevisionAssetsInput) SetNextToken(v string) *ListRevisionAssetsInput {
	s.NextToken = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ListRevisionAssetsInput) SetRevisionId(v string) *ListRevisionAssetsInput {
	s.RevisionId = &v
	return s
}

type ListRevisionAssetsOutput struct {
	_ struct{} `type:"structure"`

	Assets []*AssetEntry `type:"list"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRevisionAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRevisionAssetsOutput) GoString() string {
	return s.String()
}

// SetAssets sets the Assets field's value.
func (s *ListRevisionAssetsOutput) SetAssets(v []*AssetEntry) *ListRevisionAssetsOutput {
	s.Assets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRevisionAssetsOutput) SetNextToken(v string) *ListRevisionAssetsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about the origin of the data set.
type OriginDetails struct {
	_ struct{} `type:"structure"`

	// The product ID of the origin of the data set.
	//
	// ProductId is a required field
	ProductId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OriginDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OriginDetails) GoString() string {
	return s.String()
}

// SetProductId sets the ProductId field's value.
func (s *OriginDetails) SetProductId(v string) *OriginDetails {
	s.ProductId = &v
	return s
}

// The Amazon Redshift datashare asset.
type RedshiftDataShareAsset struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the datashare asset.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDataShareAsset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDataShareAsset) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RedshiftDataShareAsset) SetArn(v string) *RedshiftDataShareAsset {
	s.Arn = &v
	return s
}

// The source of the Amazon Redshift datashare asset.
type RedshiftDataShareAssetSourceEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the datashare asset.
	//
	// DataShareArn is a required field
	DataShareArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDataShareAssetSourceEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDataShareAssetSourceEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDataShareAssetSourceEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDataShareAssetSourceEntry"}
	if s.DataShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataShareArn sets the DataShareArn field's value.
func (s *RedshiftDataShareAssetSourceEntry) SetDataShareArn(v string) *RedshiftDataShareAssetSourceEntry {
	s.DataShareArn = &v
	return s
}

// The details for the request.
type RequestDetails struct {
	_ struct{} `type:"structure"`

	// Details about the export to signed URL request.
	ExportAssetToSignedUrl *ExportAssetToSignedUrlRequestDetails `type:"structure"`

	// Details about the export to Amazon S3 request.
	ExportAssetsToS3 *ExportAssetsToS3RequestDetails `type:"structure"`

	// Details about the export to Amazon S3 request.
	ExportRevisionsToS3 *ExportRevisionsToS3RequestDetails `type:"structure"`

	// Information about the import asset from API Gateway API request.
	ImportAssetFromApiGatewayApi *ImportAssetFromApiGatewayApiRequestDetails `type:"structure"`

	// Details about the import from signed URL request.
	ImportAssetFromSignedUrl *ImportAssetFromSignedUrlRequestDetails `type:"structure"`

	// Details from an import from Amazon Redshift datashare request.
	ImportAssetsFromRedshiftDataShares *ImportAssetsFromRedshiftDataSharesRequestDetails `type:"structure"`

	// Details about the import from Amazon S3 request.
	ImportAssetsFromS3 *ImportAssetsFromS3RequestDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestDetails"}
	if s.ExportAssetToSignedUrl != nil {
		if err := s.ExportAssetToSignedUrl.Validate(); err != nil {
			invalidParams.AddNested("ExportAssetToSignedUrl", err.(request.ErrInvalidParams))
		}
	}
	if s.ExportAssetsToS3 != nil {
		if err := s.ExportAssetsToS3.Validate(); err != nil {
			invalidParams.AddNested("ExportAssetsToS3", err.(request.ErrInvalidParams))
		}
	}
	if s.ExportRevisionsToS3 != nil {
		if err := s.ExportRevisionsToS3.Validate(); err != nil {
			invalidParams.AddNested("ExportRevisionsToS3", err.(request.ErrInvalidParams))
		}
	}
	if s.ImportAssetFromApiGatewayApi != nil {
		if err := s.ImportAssetFromApiGatewayApi.Validate(); err != nil {
			invalidParams.AddNested("ImportAssetFromApiGatewayApi", err.(request.ErrInvalidParams))
		}
	}
	if s.ImportAssetFromSignedUrl != nil {
		if err := s.ImportAssetFromSignedUrl.Validate(); err != nil {
			invalidParams.AddNested("ImportAssetFromSignedUrl", err.(request.ErrInvalidParams))
		}
	}
	if s.ImportAssetsFromRedshiftDataShares != nil {
		if err := s.ImportAssetsFromRedshiftDataShares.Validate(); err != nil {
			invalidParams.AddNested("ImportAssetsFromRedshiftDataShares", err.(request.ErrInvalidParams))
		}
	}
	if s.ImportAssetsFromS3 != nil {
		if err := s.ImportAssetsFromS3.Validate(); err != nil {
			invalidParams.AddNested("ImportAssetsFromS3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportAssetToSignedUrl sets the ExportAssetToSignedUrl field's value.
func (s *RequestDetails) SetExportAssetToSignedUrl(v *ExportAssetToSignedUrlRequestDetails) *RequestDetails {
	s.ExportAssetToSignedUrl = v
	return s
}

// SetExportAssetsToS3 sets the ExportAssetsToS3 field's value.
func (s *RequestDetails) SetExportAssetsToS3(v *ExportAssetsToS3RequestDetails) *RequestDetails {
	s.ExportAssetsToS3 = v
	return s
}

// SetExportRevisionsToS3 sets the ExportRevisionsToS3 field's value.
func (s *RequestDetails) SetExportRevisionsToS3(v *ExportRevisionsToS3RequestDetails) *RequestDetails {
	s.ExportRevisionsToS3 = v
	return s
}

// SetImportAssetFromApiGatewayApi sets the ImportAssetFromApiGatewayApi field's value.
func (s *RequestDetails) SetImportAssetFromApiGatewayApi(v *ImportAssetFromApiGatewayApiRequestDetails) *RequestDetails {
	s.ImportAssetFromApiGatewayApi = v
	return s
}

// SetImportAssetFromSignedUrl sets the ImportAssetFromSignedUrl field's value.
func (s *RequestDetails) SetImportAssetFromSignedUrl(v *ImportAssetFromSignedUrlRequestDetails) *RequestDetails {
	s.ImportAssetFromSignedUrl = v
	return s
}

// SetImportAssetsFromRedshiftDataShares sets the ImportAssetsFromRedshiftDataShares field's value.
func (s *RequestDetails) SetImportAssetsFromRedshiftDataShares(v *ImportAssetsFromRedshiftDataSharesRequestDetails) *RequestDetails {
	s.ImportAssetsFromRedshiftDataShares = v
	return s
}

// SetImportAssetsFromS3 sets the ImportAssetsFromS3 field's value.
func (s *RequestDetails) SetImportAssetsFromS3(v *ImportAssetsFromS3RequestDetails) *RequestDetails {
	s.ImportAssetsFromS3 = v
	return s
}

// The resource couldn't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The resource couldn't be found.
	Message_ *string `locationName:"Message" type:"string"`

	// The unique identifier for the resource that couldn't be found.
	ResourceId *string `type:"string"`

	// The type of resource that couldn't be found.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details for the response.
type ResponseDetails struct {
	_ struct{} `type:"structure"`

	// Details for the export to signed URL response.
	ExportAssetToSignedUrl *ExportAssetToSignedUrlResponseDetails `type:"structure"`

	// Details for the export to Amazon S3 response.
	ExportAssetsToS3 *ExportAssetsToS3ResponseDetails `type:"structure"`

	// Details for the export revisions to Amazon S3 response.
	ExportRevisionsToS3 *ExportRevisionsToS3ResponseDetails `type:"structure"`

	// The response details.
	ImportAssetFromApiGatewayApi *ImportAssetFromApiGatewayApiResponseDetails `type:"structure"`

	// Details for the import from signed URL response.
	ImportAssetFromSignedUrl *ImportAssetFromSignedUrlResponseDetails `type:"structure"`

	// Details from an import from Amazon Redshift datashare response.
	ImportAssetsFromRedshiftDataShares *ImportAssetsFromRedshiftDataSharesResponseDetails `type:"structure"`

	// Details for the import from Amazon S3 response.
	ImportAssetsFromS3 *ImportAssetsFromS3ResponseDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseDetails) GoString() string {
	return s.String()
}

// SetExportAssetToSignedUrl sets the ExportAssetToSignedUrl field's value.
func (s *ResponseDetails) SetExportAssetToSignedUrl(v *ExportAssetToSignedUrlResponseDetails) *ResponseDetails {
	s.ExportAssetToSignedUrl = v
	return s
}

// SetExportAssetsToS3 sets the ExportAssetsToS3 field's value.
func (s *ResponseDetails) SetExportAssetsToS3(v *ExportAssetsToS3ResponseDetails) *ResponseDetails {
	s.ExportAssetsToS3 = v
	return s
}

// SetExportRevisionsToS3 sets the ExportRevisionsToS3 field's value.
func (s *ResponseDetails) SetExportRevisionsToS3(v *ExportRevisionsToS3ResponseDetails) *ResponseDetails {
	s.ExportRevisionsToS3 = v
	return s
}

// SetImportAssetFromApiGatewayApi sets the ImportAssetFromApiGatewayApi field's value.
func (s *ResponseDetails) SetImportAssetFromApiGatewayApi(v *ImportAssetFromApiGatewayApiResponseDetails) *ResponseDetails {
	s.ImportAssetFromApiGatewayApi = v
	return s
}

// SetImportAssetFromSignedUrl sets the ImportAssetFromSignedUrl field's value.
func (s *ResponseDetails) SetImportAssetFromSignedUrl(v *ImportAssetFromSignedUrlResponseDetails) *ResponseDetails {
	s.ImportAssetFromSignedUrl = v
	return s
}

// SetImportAssetsFromRedshiftDataShares sets the ImportAssetsFromRedshiftDataShares field's value.
func (s *ResponseDetails) SetImportAssetsFromRedshiftDataShares(v *ImportAssetsFromRedshiftDataSharesResponseDetails) *ResponseDetails {
	s.ImportAssetsFromRedshiftDataShares = v
	return s
}

// SetImportAssetsFromS3 sets the ImportAssetsFromS3 field's value.
func (s *ResponseDetails) SetImportAssetsFromS3(v *ImportAssetsFromS3ResponseDetails) *ResponseDetails {
	s.ImportAssetsFromS3 = v
	return s
}

// The destination where the assets in the revision will be exported.
type RevisionDestinationEntry struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that is the destination for the assets in the revision.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// A string representing the pattern for generated names of the individual assets
	// in the revision. For more information about key patterns, see Key patterns
	// when exporting revisions (https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns).
	KeyPattern *string `type:"string"`

	// The unique identifier for the revision.
	//
	// RevisionId is a required field
	RevisionId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevisionDestinationEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevisionDestinationEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevisionDestinationEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevisionDestinationEntry"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *RevisionDestinationEntry) SetBucket(v string) *RevisionDestinationEntry {
	s.Bucket = &v
	return s
}

// SetKeyPattern sets the KeyPattern field's value.
func (s *RevisionDestinationEntry) SetKeyPattern(v string) *RevisionDestinationEntry {
	s.KeyPattern = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *RevisionDestinationEntry) SetRevisionId(v string) *RevisionDestinationEntry {
	s.RevisionId = &v
	return s
}

// A revision is a container for one or more assets.
type RevisionEntry struct {
	_ struct{} `type:"structure"`

	// The ARN for the revision.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// An optional comment about the revision.
	Comment *string `type:"string"`

	// The date and time that the revision was created, in ISO 8601 format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique identifier for the data set associated with this revision.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// To publish a revision to a data set in a product, the revision must first
	// be finalized. Finalizing a revision tells AWS Data Exchange that your changes
	// to the assets in the revision are complete. After it's in this read-only
	// state, you can publish the revision to your products.
	//
	// Finalized revisions can be published through the AWS Data Exchange console
	// or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace
	// Catalog API action. When using the API, revisions are uniquely identified
	// by their ARN.
	Finalized *bool `type:"boolean"`

	// The unique identifier for the revision.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A required comment to inform subscribers of the reason their access to the
	// revision was revoked.
	RevocationComment *string `min:"10" type:"string"`

	// A status indicating that subscribers' access to the revision was revoked.
	Revoked *bool `type:"boolean"`

	// The date and time that the revision was revoked, in ISO 8601 format.
	RevokedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The revision ID of the owned revision corresponding to the entitled revision
	// being viewed. This parameter is returned when a revision owner is viewing
	// the entitled copy of its owned revision.
	SourceId *string `type:"string"`

	// The date and time that the revision was last updated, in ISO 8601 format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevisionEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevisionEntry) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RevisionEntry) SetArn(v string) *RevisionEntry {
	s.Arn = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *RevisionEntry) SetComment(v string) *RevisionEntry {
	s.Comment = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RevisionEntry) SetCreatedAt(v time.Time) *RevisionEntry {
	s.CreatedAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *RevisionEntry) SetDataSetId(v string) *RevisionEntry {
	s.DataSetId = &v
	return s
}

// SetFinalized sets the Finalized field's value.
func (s *RevisionEntry) SetFinalized(v bool) *RevisionEntry {
	s.Finalized = &v
	return s
}

// SetId sets the Id field's value.
func (s *RevisionEntry) SetId(v string) *RevisionEntry {
	s.Id = &v
	return s
}

// SetRevocationComment sets the RevocationComment field's value.
func (s *RevisionEntry) SetRevocationComment(v string) *RevisionEntry {
	s.RevocationComment = &v
	return s
}

// SetRevoked sets the Revoked field's value.
func (s *RevisionEntry) SetRevoked(v bool) *RevisionEntry {
	s.Revoked = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *RevisionEntry) SetRevokedAt(v time.Time) *RevisionEntry {
	s.RevokedAt = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *RevisionEntry) SetSourceId(v string) *RevisionEntry {
	s.SourceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *RevisionEntry) SetUpdatedAt(v time.Time) *RevisionEntry {
	s.UpdatedAt = &v
	return s
}

// Information about the published revision.
type RevisionPublished struct {
	_ struct{} `type:"structure"`

	// The data set ID of the published revision.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevisionPublished) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevisionPublished) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevisionPublished) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevisionPublished"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *RevisionPublished) SetDataSetId(v string) *RevisionPublished {
	s.DataSetId = &v
	return s
}

// The request sent to revoke the revision.
type RevokeRevisionInput struct {
	_ struct{} `type:"structure"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`

	// A required comment to inform subscribers of the reason their access to the
	// revision was revoked.
	//
	// RevocationComment is a required field
	RevocationComment *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeRevisionInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}
	if s.RevocationComment == nil {
		invalidParams.Add(request.NewErrParamRequired("RevocationComment"))
	}
	if s.RevocationComment != nil && len(*s.RevocationComment) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("RevocationComment", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *RevokeRevisionInput) SetDataSetId(v string) *RevokeRevisionInput {
	s.DataSetId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *RevokeRevisionInput) SetRevisionId(v string) *RevokeRevisionInput {
	s.RevisionId = &v
	return s
}

// SetRevocationComment sets the RevocationComment field's value.
func (s *RevokeRevisionInput) SetRevocationComment(v string) *RevokeRevisionInput {
	s.RevocationComment = &v
	return s
}

type RevokeRevisionOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	Comment *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	DataSetId *string `type:"string"`

	Finalized *bool `type:"boolean"`

	// A unique identifier.
	Id *string `type:"string"`

	RevocationComment *string `min:"10" type:"string"`

	Revoked *bool `type:"boolean"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	RevokedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	SourceId *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeRevisionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RevokeRevisionOutput) SetArn(v string) *RevokeRevisionOutput {
	s.Arn = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *RevokeRevisionOutput) SetComment(v string) *RevokeRevisionOutput {
	s.Comment = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RevokeRevisionOutput) SetCreatedAt(v time.Time) *RevokeRevisionOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *RevokeRevisionOutput) SetDataSetId(v string) *RevokeRevisionOutput {
	s.DataSetId = &v
	return s
}

// SetFinalized sets the Finalized field's value.
func (s *RevokeRevisionOutput) SetFinalized(v bool) *RevokeRevisionOutput {
	s.Finalized = &v
	return s
}

// SetId sets the Id field's value.
func (s *RevokeRevisionOutput) SetId(v string) *RevokeRevisionOutput {
	s.Id = &v
	return s
}

// SetRevocationComment sets the RevocationComment field's value.
func (s *RevokeRevisionOutput) SetRevocationComment(v string) *RevokeRevisionOutput {
	s.RevocationComment = &v
	return s
}

// SetRevoked sets the Revoked field's value.
func (s *RevokeRevisionOutput) SetRevoked(v bool) *RevokeRevisionOutput {
	s.Revoked = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *RevokeRevisionOutput) SetRevokedAt(v time.Time) *RevokeRevisionOutput {
	s.RevokedAt = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *RevokeRevisionOutput) SetSourceId(v string) *RevokeRevisionOutput {
	s.SourceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *RevokeRevisionOutput) SetUpdatedAt(v time.Time) *RevokeRevisionOutput {
	s.UpdatedAt = &v
	return s
}

// The S3 object that is the asset.
type S3SnapshotAsset struct {
	_ struct{} `type:"structure"`

	// The size of the S3 object that is the object.
	//
	// Size is a required field
	Size *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3SnapshotAsset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3SnapshotAsset) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *S3SnapshotAsset) SetSize(v float64) *S3SnapshotAsset {
	s.Size = &v
	return s
}

type SendApiAssetInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// AssetId is a required field
	AssetId *string `location:"header" locationName:"x-amzn-dataexchange-asset-id" type:"string" required:"true"`

	Body *string `type:"string"`

	// DataSetId is a required field
	DataSetId *string `location:"header" locationName:"x-amzn-dataexchange-data-set-id" type:"string" required:"true"`

	Method *string `location:"header" locationName:"x-amzn-dataexchange-http-method" type:"string"`

	Path *string `location:"header" locationName:"x-amzn-dataexchange-path" type:"string"`

	QueryStringParameters map[string]*string `location:"querystring" type:"map"`

	RequestHeaders map[string]*string `location:"headers" locationName:"x-amzn-dataexchange-header-" type:"map"`

	// RevisionId is a required field
	RevisionId *string `location:"header" locationName:"x-amzn-dataexchange-revision-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendApiAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendApiAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendApiAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendApiAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *SendApiAssetInput) SetAssetId(v string) *SendApiAssetInput {
	s.AssetId = &v
	return s
}

// SetBody sets the Body field's value.
func (s *SendApiAssetInput) SetBody(v string) *SendApiAssetInput {
	s.Body = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *SendApiAssetInput) SetDataSetId(v string) *SendApiAssetInput {
	s.DataSetId = &v
	return s
}

// SetMethod sets the Method field's value.
func (s *SendApiAssetInput) SetMethod(v string) *SendApiAssetInput {
	s.Method = &v
	return s
}

// SetPath sets the Path field's value.
func (s *SendApiAssetInput) SetPath(v string) *SendApiAssetInput {
	s.Path = &v
	return s
}

// SetQueryStringParameters sets the QueryStringParameters field's value.
func (s *SendApiAssetInput) SetQueryStringParameters(v map[string]*string) *SendApiAssetInput {
	s.QueryStringParameters = v
	return s
}

// SetRequestHeaders sets the RequestHeaders field's value.
func (s *SendApiAssetInput) SetRequestHeaders(v map[string]*string) *SendApiAssetInput {
	s.RequestHeaders = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *SendApiAssetInput) SetRevisionId(v string) *SendApiAssetInput {
	s.RevisionId = &v
	return s
}

// The details of the send API asset response.
type SendApiAssetOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The response body from the underlying API tracked by the API asset.
	Body *string `type:"string"`

	// The response headers from the underlying API tracked by the API asset.
	//
	// By default unmarshaled keys are written as a map keys in following canonicalized format:
	// the first letter and any letter following a hyphen will be capitalized, and the rest as lowercase.
	// Set `aws.Config.LowerCaseHeaderMaps` to `true` to write unmarshaled keys to the map as lowercase.
	ResponseHeaders map[string]*string `location:"headers" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendApiAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendApiAssetOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *SendApiAssetOutput) SetBody(v string) *SendApiAssetOutput {
	s.Body = &v
	return s
}

// SetResponseHeaders sets the ResponseHeaders field's value.
func (s *SendApiAssetOutput) SetResponseHeaders(v map[string]*string) *SendApiAssetOutput {
	s.ResponseHeaders = v
	return s
}

// The request has exceeded the quotas imposed by the service.
type ServiceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	LimitName *string `type:"string" enum:"LimitName"`

	LimitValue *float64 `type:"double"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorServiceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ServiceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceLimitExceededException) Code() string {
	return "ServiceLimitExceededException"
}

// Message returns the exception's message.
func (s *ServiceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ServiceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StartJobInput) SetJobId(v string) *StartJobInput {
	s.JobId = &v
	return s
}

type StartJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The limit on the number of requests per second was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The limit on the number of requests per second was exceeded.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The request to update an asset.
type UpdateAssetInput struct {
	_ struct{} `type:"structure"`

	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"AssetId" type:"string" required:"true"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// The name of the asset. When importing from Amazon S3, the S3 object key is
	// used as the asset name. When exporting to Amazon S3, the asset name is used
	// as default target S3 object key. When importing from Amazon API Gateway API,
	// the API name is used as the asset name. When importing from Amazon Redshift,
	// the datashare name is used as the asset name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 1))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *UpdateAssetInput) SetAssetId(v string) *UpdateAssetInput {
	s.AssetId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateAssetInput) SetDataSetId(v string) *UpdateAssetInput {
	s.DataSetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAssetInput) SetName(v string) *UpdateAssetInput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateAssetInput) SetRevisionId(v string) *UpdateAssetInput {
	s.RevisionId = &v
	return s
}

type UpdateAssetOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// Information about the asset.
	AssetDetails *AssetDetails `type:"structure"`

	// The type of asset that is added to a data set.
	AssetType *string `type:"string" enum:"AssetType"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	DataSetId *string `type:"string"`

	// A unique identifier.
	Id *string `type:"string"`

	// The name of the asset. When importing from Amazon S3, the S3 object key is
	// used as the asset name. When exporting to Amazon S3, the asset name is used
	// as default target S3 object key. When importing from Amazon API Gateway API,
	// the API name is used as the asset name. When importing from Amazon Redshift,
	// the datashare name is used as the asset name.
	Name *string `type:"string"`

	// A unique identifier.
	RevisionId *string `type:"string"`

	// A unique identifier.
	SourceId *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAssetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateAssetOutput) SetArn(v string) *UpdateAssetOutput {
	s.Arn = &v
	return s
}

// SetAssetDetails sets the AssetDetails field's value.
func (s *UpdateAssetOutput) SetAssetDetails(v *AssetDetails) *UpdateAssetOutput {
	s.AssetDetails = v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *UpdateAssetOutput) SetAssetType(v string) *UpdateAssetOutput {
	s.AssetType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateAssetOutput) SetCreatedAt(v time.Time) *UpdateAssetOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateAssetOutput) SetDataSetId(v string) *UpdateAssetOutput {
	s.DataSetId = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateAssetOutput) SetId(v string) *UpdateAssetOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAssetOutput) SetName(v string) *UpdateAssetOutput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateAssetOutput) SetRevisionId(v string) *UpdateAssetOutput {
	s.RevisionId = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *UpdateAssetOutput) SetSourceId(v string) *UpdateAssetOutput {
	s.SourceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateAssetOutput) SetUpdatedAt(v time.Time) *UpdateAssetOutput {
	s.UpdatedAt = &v
	return s
}

// The request to update a data set.
type UpdateDataSetInput struct {
	_ struct{} `type:"structure"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// The description for the data set.
	Description *string `type:"string"`

	// The name of the data set.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSetInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateDataSetInput) SetDataSetId(v string) *UpdateDataSetInput {
	s.DataSetId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSetInput) SetDescription(v string) *UpdateDataSetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSetInput) SetName(v string) *UpdateDataSetInput {
	s.Name = &v
	return s
}

type UpdateDataSetOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// The type of asset that is added to a data set.
	AssetType *string `type:"string" enum:"AssetType"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A description of a resource.
	Description *string `type:"string"`

	// A unique identifier.
	Id *string `type:"string"`

	// The name of the model.
	Name *string `type:"string"`

	// A property that defines the data set as OWNED by the account (for providers)
	// or ENTITLED to the account (for subscribers). When an owned data set is published
	// in a product, AWS Data Exchange creates a copy of the data set. Subscribers
	// can access that copy of the data set as an entitled data set.
	Origin *string `type:"string" enum:"Origin"`

	// Information about the origin of the data set.
	OriginDetails *OriginDetails `type:"structure"`

	// A unique identifier.
	SourceId *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateDataSetOutput) SetArn(v string) *UpdateDataSetOutput {
	s.Arn = &v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *UpdateDataSetOutput) SetAssetType(v string) *UpdateDataSetOutput {
	s.AssetType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateDataSetOutput) SetCreatedAt(v time.Time) *UpdateDataSetOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSetOutput) SetDescription(v string) *UpdateDataSetOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDataSetOutput) SetId(v string) *UpdateDataSetOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSetOutput) SetName(v string) *UpdateDataSetOutput {
	s.Name = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *UpdateDataSetOutput) SetOrigin(v string) *UpdateDataSetOutput {
	s.Origin = &v
	return s
}

// SetOriginDetails sets the OriginDetails field's value.
func (s *UpdateDataSetOutput) SetOriginDetails(v *OriginDetails) *UpdateDataSetOutput {
	s.OriginDetails = v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *UpdateDataSetOutput) SetSourceId(v string) *UpdateDataSetOutput {
	s.SourceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateDataSetOutput) SetUpdatedAt(v time.Time) *UpdateDataSetOutput {
	s.UpdatedAt = &v
	return s
}

// The request to update an event action.
type UpdateEventActionInput struct {
	_ struct{} `type:"structure"`

	// What occurs after a certain event.
	Action *Action `type:"structure"`

	// EventActionId is a required field
	EventActionId *string `location:"uri" locationName:"EventActionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEventActionInput"}
	if s.EventActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventActionId"))
	}
	if s.EventActionId != nil && len(*s.EventActionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventActionId", 1))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateEventActionInput) SetAction(v *Action) *UpdateEventActionInput {
	s.Action = v
	return s
}

// SetEventActionId sets the EventActionId field's value.
func (s *UpdateEventActionInput) SetEventActionId(v string) *UpdateEventActionInput {
	s.EventActionId = &v
	return s
}

type UpdateEventActionOutput struct {
	_ struct{} `type:"structure"`

	// What occurs after a certain event.
	Action *Action `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// What occurs to start an action.
	Event *Event `type:"structure"`

	// A unique identifier.
	Id *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventActionOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *UpdateEventActionOutput) SetAction(v *Action) *UpdateEventActionOutput {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateEventActionOutput) SetArn(v string) *UpdateEventActionOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateEventActionOutput) SetCreatedAt(v time.Time) *UpdateEventActionOutput {
	s.CreatedAt = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *UpdateEventActionOutput) SetEvent(v *Event) *UpdateEventActionOutput {
	s.Event = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateEventActionOutput) SetId(v string) *UpdateEventActionOutput {
	s.Id = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateEventActionOutput) SetUpdatedAt(v time.Time) *UpdateEventActionOutput {
	s.UpdatedAt = &v
	return s
}

// The request to update a revision.
type UpdateRevisionInput struct {
	_ struct{} `type:"structure"`

	// An optional comment about the revision.
	Comment *string `type:"string"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// Finalizing a revision tells AWS Data Exchange that your changes to the assets
	// in the revision are complete. After it's in this read-only state, you can
	// publish the revision to your products.
	Finalized *bool `type:"boolean"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRevisionInput"}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *UpdateRevisionInput) SetComment(v string) *UpdateRevisionInput {
	s.Comment = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateRevisionInput) SetDataSetId(v string) *UpdateRevisionInput {
	s.DataSetId = &v
	return s
}

// SetFinalized sets the Finalized field's value.
func (s *UpdateRevisionInput) SetFinalized(v bool) *UpdateRevisionInput {
	s.Finalized = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateRevisionInput) SetRevisionId(v string) *UpdateRevisionInput {
	s.RevisionId = &v
	return s
}

type UpdateRevisionOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	Comment *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	DataSetId *string `type:"string"`

	Finalized *bool `type:"boolean"`

	// A unique identifier.
	Id *string `type:"string"`

	RevocationComment *string `min:"10" type:"string"`

	Revoked *bool `type:"boolean"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	RevokedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	SourceId *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRevisionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateRevisionOutput) SetArn(v string) *UpdateRevisionOutput {
	s.Arn = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *UpdateRevisionOutput) SetComment(v string) *UpdateRevisionOutput {
	s.Comment = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateRevisionOutput) SetCreatedAt(v time.Time) *UpdateRevisionOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateRevisionOutput) SetDataSetId(v string) *UpdateRevisionOutput {
	s.DataSetId = &v
	return s
}

// SetFinalized sets the Finalized field's value.
func (s *UpdateRevisionOutput) SetFinalized(v bool) *UpdateRevisionOutput {
	s.Finalized = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateRevisionOutput) SetId(v string) *UpdateRevisionOutput {
	s.Id = &v
	return s
}

// SetRevocationComment sets the RevocationComment field's value.
func (s *UpdateRevisionOutput) SetRevocationComment(v string) *UpdateRevisionOutput {
	s.RevocationComment = &v
	return s
}

// SetRevoked sets the Revoked field's value.
func (s *UpdateRevisionOutput) SetRevoked(v bool) *UpdateRevisionOutput {
	s.Revoked = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *UpdateRevisionOutput) SetRevokedAt(v time.Time) *UpdateRevisionOutput {
	s.RevokedAt = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *UpdateRevisionOutput) SetSourceId(v string) *UpdateRevisionOutput {
	s.SourceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateRevisionOutput) SetUpdatedAt(v time.Time) *UpdateRevisionOutput {
	s.UpdatedAt = &v
	return s
}

// The request was invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message that informs you about what the exception was.
	ExceptionCause *string `type:"string" enum:"ExceptionCause"`

	// The message that informs you about what was invalid about the request.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The type of asset that is added to a data set.
const (
	// AssetTypeS3Snapshot is a AssetType enum value
	AssetTypeS3Snapshot = "S3_SNAPSHOT"

	// AssetTypeRedshiftDataShare is a AssetType enum value
	AssetTypeRedshiftDataShare = "REDSHIFT_DATA_SHARE"

	// AssetTypeApiGatewayApi is a AssetType enum value
	AssetTypeApiGatewayApi = "API_GATEWAY_API"
)

// AssetType_Values returns all elements of the AssetType enum
func AssetType_Values() []string {
	return []string{
		AssetTypeS3Snapshot,
		AssetTypeRedshiftDataShare,
		AssetTypeApiGatewayApi,
	}
}

const (
	// CodeAccessDeniedException is a Code enum value
	CodeAccessDeniedException = "ACCESS_DENIED_EXCEPTION"

	// CodeInternalServerException is a Code enum value
	CodeInternalServerException = "INTERNAL_SERVER_EXCEPTION"

	// CodeMalwareDetected is a Code enum value
	CodeMalwareDetected = "MALWARE_DETECTED"

	// CodeResourceNotFoundException is a Code enum value
	CodeResourceNotFoundException = "RESOURCE_NOT_FOUND_EXCEPTION"

	// CodeServiceQuotaExceededException is a Code enum value
	CodeServiceQuotaExceededException = "SERVICE_QUOTA_EXCEEDED_EXCEPTION"

	// CodeValidationException is a Code enum value
	CodeValidationException = "VALIDATION_EXCEPTION"

	// CodeMalwareScanEncryptedFile is a Code enum value
	CodeMalwareScanEncryptedFile = "MALWARE_SCAN_ENCRYPTED_FILE"
)

// Code_Values returns all elements of the Code enum
func Code_Values() []string {
	return []string{
		CodeAccessDeniedException,
		CodeInternalServerException,
		CodeMalwareDetected,
		CodeResourceNotFoundException,
		CodeServiceQuotaExceededException,
		CodeValidationException,
		CodeMalwareScanEncryptedFile,
	}
}

const (
	// ExceptionCauseInsufficientS3bucketPolicy is a ExceptionCause enum value
	ExceptionCauseInsufficientS3bucketPolicy = "InsufficientS3BucketPolicy"

	// ExceptionCauseS3accessDenied is a ExceptionCause enum value
	ExceptionCauseS3accessDenied = "S3AccessDenied"
)

// ExceptionCause_Values returns all elements of the ExceptionCause enum
func ExceptionCause_Values() []string {
	return []string{
		ExceptionCauseInsufficientS3bucketPolicy,
		ExceptionCauseS3accessDenied,
	}
}

// The name of the limit that was reached.
const (
	// JobErrorLimitNameAssetsperrevision is a JobErrorLimitName enum value
	JobErrorLimitNameAssetsperrevision = "Assets per revision"

	// JobErrorLimitNameAssetsizeinGb is a JobErrorLimitName enum value
	JobErrorLimitNameAssetsizeinGb = "Asset size in GB"

	// JobErrorLimitNameAmazonRedshiftdatashareassetsperrevision is a JobErrorLimitName enum value
	JobErrorLimitNameAmazonRedshiftdatashareassetsperrevision = "Amazon Redshift datashare assets per revision"
)

// JobErrorLimitName_Values returns all elements of the JobErrorLimitName enum
func JobErrorLimitName_Values() []string {
	return []string{
		JobErrorLimitNameAssetsperrevision,
		JobErrorLimitNameAssetsizeinGb,
		JobErrorLimitNameAmazonRedshiftdatashareassetsperrevision,
	}
}

// The types of resource which the job error can apply to.
const (
	// JobErrorResourceTypesRevision is a JobErrorResourceTypes enum value
	JobErrorResourceTypesRevision = "REVISION"

	// JobErrorResourceTypesAsset is a JobErrorResourceTypes enum value
	JobErrorResourceTypesAsset = "ASSET"

	// JobErrorResourceTypesDataSet is a JobErrorResourceTypes enum value
	JobErrorResourceTypesDataSet = "DATA_SET"
)

// JobErrorResourceTypes_Values returns all elements of the JobErrorResourceTypes enum
func JobErrorResourceTypes_Values() []string {
	return []string{
		JobErrorResourceTypesRevision,
		JobErrorResourceTypesAsset,
		JobErrorResourceTypesDataSet,
	}
}

const (
	// LimitNameProductsperaccount is a LimitName enum value
	LimitNameProductsperaccount = "Products per account"

	// LimitNameDatasetsperaccount is a LimitName enum value
	LimitNameDatasetsperaccount = "Data sets per account"

	// LimitNameDatasetsperproduct is a LimitName enum value
	LimitNameDatasetsperproduct = "Data sets per product"

	// LimitNameRevisionsperdataset is a LimitName enum value
	LimitNameRevisionsperdataset = "Revisions per data set"

	// LimitNameAssetsperrevision is a LimitName enum value
	LimitNameAssetsperrevision = "Assets per revision"

	// LimitNameAssetsperimportjobfromAmazonS3 is a LimitName enum value
	LimitNameAssetsperimportjobfromAmazonS3 = "Assets per import job from Amazon S3"

	// LimitNameAssetperexportjobfromAmazonS3 is a LimitName enum value
	LimitNameAssetperexportjobfromAmazonS3 = "Asset per export job from Amazon S3"

	// LimitNameAssetsizeinGb is a LimitName enum value
	LimitNameAssetsizeinGb = "Asset size in GB"

	// LimitNameConcurrentinprogressjobstoexportassetstoAmazonS3 is a LimitName enum value
	LimitNameConcurrentinprogressjobstoexportassetstoAmazonS3 = "Concurrent in progress jobs to export assets to Amazon S3"

	// LimitNameConcurrentinprogressjobstoexportassetstoasignedUrl is a LimitName enum value
	LimitNameConcurrentinprogressjobstoexportassetstoasignedUrl = "Concurrent in progress jobs to export assets to a signed URL"

	// LimitNameConcurrentinprogressjobstoimportassetsfromAmazonS3 is a LimitName enum value
	LimitNameConcurrentinprogressjobstoimportassetsfromAmazonS3 = "Concurrent in progress jobs to import assets from Amazon S3"

	// LimitNameConcurrentinprogressjobstoimportassetsfromasignedUrl is a LimitName enum value
	LimitNameConcurrentinprogressjobstoimportassetsfromasignedUrl = "Concurrent in progress jobs to import assets from a signed URL"

	// LimitNameConcurrentinprogressjobstoexportrevisionstoAmazonS3 is a LimitName enum value
	LimitNameConcurrentinprogressjobstoexportrevisionstoAmazonS3 = "Concurrent in progress jobs to export revisions to Amazon S3"

	// LimitNameEventactionsperaccount is a LimitName enum value
	LimitNameEventactionsperaccount = "Event actions per account"

	// LimitNameAutoexporteventactionsperdataset is a LimitName enum value
	LimitNameAutoexporteventactionsperdataset = "Auto export event actions per data set"

	// LimitNameAmazonRedshiftdatashareassetsperimportjobfromRedshift is a LimitName enum value
	LimitNameAmazonRedshiftdatashareassetsperimportjobfromRedshift = "Amazon Redshift datashare assets per import job from Redshift"

	// LimitNameConcurrentinprogressjobstoimportassetsfromAmazonRedshiftdatashares is a LimitName enum value
	LimitNameConcurrentinprogressjobstoimportassetsfromAmazonRedshiftdatashares = "Concurrent in progress jobs to import assets from Amazon Redshift datashares"

	// LimitNameRevisionsperAmazonRedshiftdatasharedataset is a LimitName enum value
	LimitNameRevisionsperAmazonRedshiftdatasharedataset = "Revisions per Amazon Redshift datashare data set"

	// LimitNameAmazonRedshiftdatashareassetsperrevision is a LimitName enum value
	LimitNameAmazonRedshiftdatashareassetsperrevision = "Amazon Redshift datashare assets per revision"

	// LimitNameConcurrentinprogressjobstoimportassetsfromanApigatewayApi is a LimitName enum value
	LimitNameConcurrentinprogressjobstoimportassetsfromanApigatewayApi = "Concurrent in progress jobs to import assets from an API Gateway API"

	// LimitNameAmazonApigatewayApiassetsperrevision is a LimitName enum value
	LimitNameAmazonApigatewayApiassetsperrevision = "Amazon API Gateway API assets per revision"

	// LimitNameRevisionsperAmazonApigatewayApidataset is a LimitName enum value
	LimitNameRevisionsperAmazonApigatewayApidataset = "Revisions per Amazon API Gateway API data set"
)

// LimitName_Values returns all elements of the LimitName enum
func LimitName_Values() []string {
	return []string{
		LimitNameProductsperaccount,
		LimitNameDatasetsperaccount,
		LimitNameDatasetsperproduct,
		LimitNameRevisionsperdataset,
		LimitNameAssetsperrevision,
		LimitNameAssetsperimportjobfromAmazonS3,
		LimitNameAssetperexportjobfromAmazonS3,
		LimitNameAssetsizeinGb,
		LimitNameConcurrentinprogressjobstoexportassetstoAmazonS3,
		LimitNameConcurrentinprogressjobstoexportassetstoasignedUrl,
		LimitNameConcurrentinprogressjobstoimportassetsfromAmazonS3,
		LimitNameConcurrentinprogressjobstoimportassetsfromasignedUrl,
		LimitNameConcurrentinprogressjobstoexportrevisionstoAmazonS3,
		LimitNameEventactionsperaccount,
		LimitNameAutoexporteventactionsperdataset,
		LimitNameAmazonRedshiftdatashareassetsperimportjobfromRedshift,
		LimitNameConcurrentinprogressjobstoimportassetsfromAmazonRedshiftdatashares,
		LimitNameRevisionsperAmazonRedshiftdatasharedataset,
		LimitNameAmazonRedshiftdatashareassetsperrevision,
		LimitNameConcurrentinprogressjobstoimportassetsfromanApigatewayApi,
		LimitNameAmazonApigatewayApiassetsperrevision,
		LimitNameRevisionsperAmazonApigatewayApidataset,
	}
}

// A property that defines the data set as OWNED by the account (for providers)
// or ENTITLED to the account (for subscribers). When an owned data set is published
// in a product, AWS Data Exchange creates a copy of the data set. Subscribers
// can access that copy of the data set as an entitled data set.
const (
	// OriginOwned is a Origin enum value
	OriginOwned = "OWNED"

	// OriginEntitled is a Origin enum value
	OriginEntitled = "ENTITLED"
)

// Origin_Values returns all elements of the Origin enum
func Origin_Values() []string {
	return []string{
		OriginOwned,
		OriginEntitled,
	}
}

const (
	// ProtocolTypeRest is a ProtocolType enum value
	ProtocolTypeRest = "REST"
)

// ProtocolType_Values returns all elements of the ProtocolType enum
func ProtocolType_Values() []string {
	return []string{
		ProtocolTypeRest,
	}
}

const (
	// ResourceTypeDataSet is a ResourceType enum value
	ResourceTypeDataSet = "DATA_SET"

	// ResourceTypeRevision is a ResourceType enum value
	ResourceTypeRevision = "REVISION"

	// ResourceTypeAsset is a ResourceType enum value
	ResourceTypeAsset = "ASSET"

	// ResourceTypeJob is a ResourceType enum value
	ResourceTypeJob = "JOB"

	// ResourceTypeEventAction is a ResourceType enum value
	ResourceTypeEventAction = "EVENT_ACTION"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeDataSet,
		ResourceTypeRevision,
		ResourceTypeAsset,
		ResourceTypeJob,
		ResourceTypeEventAction,
	}
}

// The types of encryption supported in export jobs to Amazon S3.
const (
	// ServerSideEncryptionTypesAwsKms is a ServerSideEncryptionTypes enum value
	ServerSideEncryptionTypesAwsKms = "aws:kms"

	// ServerSideEncryptionTypesAes256 is a ServerSideEncryptionTypes enum value
	ServerSideEncryptionTypesAes256 = "AES256"
)

// ServerSideEncryptionTypes_Values returns all elements of the ServerSideEncryptionTypes enum
func ServerSideEncryptionTypes_Values() []string {
	return []string{
		ServerSideEncryptionTypesAwsKms,
		ServerSideEncryptionTypesAes256,
	}
}

const (
	// StateWaiting is a State enum value
	StateWaiting = "WAITING"

	// StateInProgress is a State enum value
	StateInProgress = "IN_PROGRESS"

	// StateError is a State enum value
	StateError = "ERROR"

	// StateCompleted is a State enum value
	StateCompleted = "COMPLETED"

	// StateCancelled is a State enum value
	StateCancelled = "CANCELLED"

	// StateTimedOut is a State enum value
	StateTimedOut = "TIMED_OUT"
)

// State_Values returns all elements of the State enum
func State_Values() []string {
	return []string{
		StateWaiting,
		StateInProgress,
		StateError,
		StateCompleted,
		StateCancelled,
		StateTimedOut,
	}
}

const (
	// TypeImportAssetsFromS3 is a Type enum value
	TypeImportAssetsFromS3 = "IMPORT_ASSETS_FROM_S3"

	// TypeImportAssetFromSignedUrl is a Type enum value
	TypeImportAssetFromSignedUrl = "IMPORT_ASSET_FROM_SIGNED_URL"

	// TypeExportAssetsToS3 is a Type enum value
	TypeExportAssetsToS3 = "EXPORT_ASSETS_TO_S3"

	// TypeExportAssetToSignedUrl is a Type enum value
	TypeExportAssetToSignedUrl = "EXPORT_ASSET_TO_SIGNED_URL"

	// TypeExportRevisionsToS3 is a Type enum value
	TypeExportRevisionsToS3 = "EXPORT_REVISIONS_TO_S3"

	// TypeImportAssetsFromRedshiftDataShares is a Type enum value
	TypeImportAssetsFromRedshiftDataShares = "IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES"

	// TypeImportAssetFromApiGatewayApi is a Type enum value
	TypeImportAssetFromApiGatewayApi = "IMPORT_ASSET_FROM_API_GATEWAY_API"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeImportAssetsFromS3,
		TypeImportAssetFromSignedUrl,
		TypeExportAssetsToS3,
		TypeExportAssetToSignedUrl,
		TypeExportRevisionsToS3,
		TypeImportAssetsFromRedshiftDataShares,
		TypeImportAssetFromApiGatewayApi,
	}
}
