\raffect
addhelp(randomprime,"randomprime(N): generate a random prime number < 2^N")
powmod(a,b,c)=lift(Mod(a,c)^b)
buildkey(N)=
{
  local(A,P,x);
  A=gp2crand(2^N);
  P=randomprime(N+1);
  x=gp2crand(P);
  Ax=powmod(A,x,P);
  [[Ax,A,P],[x,P]]
}
addhelp(buildkey,"buildkey(N): compute a random El Gamal key of N bits");
crypt(data,key)=
{
  local(y,Ax=key[1],A=key[2],P=key[3]);
  y=gp2crand(P);
  Ay=powmod(A,y,P);
  Axy=powmod(Ax,y,P);
  [data*Axy%P,Ay]
}
decrypt(data,key)=
{
  local(Axy,Ay=data[2],x=key[1],P=key[2]);
  Axy=powmod(Ay,-x,P);
  data[1]*Axy%P
}
