/*
  Gnome-o-Phone - A program for internet telephony
  Copyright (C) 1999  Roland Dreier
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  $Id: connection.h 1.4 Fri, 10 Dec 1999 17:29:43 -0600 dreier $
*/

#ifndef _CONNECTION_H
#define _CONNECTION_H 1

#include <glib.h>

#include "rtp.h"
#include "rtp-audio.h"

void connection_init(int port);
void connection_call(gchar *hostname);
void send_switch_packet(void);
void maybe_send_rtcp(void);
gboolean connection_connected(void);
gchar *connection_hostname(void);
int connection_listen(float timeout);
void rtp_send(gchar *buf, int nbytes, rtp_payload_t pt, guint32 nsamp);
rtp_source *find_member(guint32 src);
void member_sdes(rtp_source *s, guint8 type, char *data, guint8 length);

#endif /* connection.h */
