/* Pmud Monitor as Gnome Applet
 *
 * By Uwe Steinmann <Uwe.Steinmann@fernuni-hagen.de>
 *
 * Enjoy.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License  
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>
#include "gpmudmon.h"

#define BIG_ICON_SIZE   48

extern int open_pmudinfo();
extern int count_timer(gpointer data);
extern void save_config(PmudData *pd);

static void apply_cb(GtkObject *pb, gint page, gpointer data)
{
	PmudData *pd = (PmudData *) data;
	const gchar *buf;
	GtkWidget *widget_s;

//	GtkWidget *width_s = gtk_object_get_data(GTK_OBJECT(pb),"width");
//	GtkWidget *height_s = gtk_object_get_data(GTK_OBJECT(pb),"height");
	GtkWidget *update_s = gtk_object_get_data(GTK_OBJECT(pb), "update");

	/* Do not make the changes on page basis, but for all pages */
	if(page != -1)
		return;

//	buf = gtk_entry_get_text(GTK_ENTRY(height_s));
//	sscanf(buf, "%d", &(pd->height));
//	buf = gtk_entry_get_text(GTK_ENTRY(width_s));
//	sscanf(buf, "%d", &(pd->width));
	buf = gtk_entry_get_text(GTK_ENTRY(update_s));
	sscanf(buf, "%d", &(pd->updatetime));
	gtk_timeout_remove(pd->timeout);
	pd->timeout = gtk_timeout_add(pd->updatetime, (GtkFunction)count_timer, pd);

#ifdef PMUD
	/*** servername ***/
	widget_s = gtk_object_get_data(GTK_OBJECT(pb), "servername");
	buf = gtk_entry_get_text(GTK_ENTRY(widget_s));
	if(pd->servername)
		free(pd->servername);
	pd->servername = strdup(buf);

	/*** serverport ***/
	widget_s = gtk_object_get_data(GTK_OBJECT(pb), "serverport");
	buf = gtk_entry_get_text(GTK_ENTRY(widget_s));
	sscanf(buf, "%d", &(pd->port));
#endif

	/**** Show current ****/
	widget_s = gtk_object_get_data(GTK_OBJECT(pb), "current");
	pd->show_current = GTK_TOGGLE_BUTTON(widget_s)->active ? 1 : 0;
	if(pd->show_current) {
		gtk_widget_show(pd->gaugeframe1);
		gtk_widget_show(pd->gaugeframe2);
	} else {
		gtk_widget_hide(pd->gaugeframe1);
		gtk_widget_hide(pd->gaugeframe2);
	}

	save_config(pd);
#ifdef PMUD
	pd->pmudinfo = open_pmudinfo(pd);
#endif
	count_timer(pd);
}

static void
toggled_cb(GtkWidget *widget, void *data)
{	
	PmudData *pd = data;
	gnome_property_box_changed(GNOME_PROPERTY_BOX(pd->pb));
}

static void
changed_cb(gpointer d)
{	
	PmudData *pd = d;
	gnome_property_box_changed(GNOME_PROPERTY_BOX(pd->pb));
}

void
prefs_cb(BonoboUIComponent *uic, gpointer p, const gchar *verbname)
{
	GtkWidget *frame, *hbox, *tbox, *label, *spin_label, *cadre, *entry, *checkbox;
	GtkAdjustment *adj;
	PmudData *pd = (PmudData *) p;

	pd->pb = gnome_property_box_new();
	gtk_window_set_title(GTK_WINDOW(pd->pb), _("gpmudmon Preferences"));
	
	frame=gtk_vbox_new(FALSE,0);

	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pd->pb), frame,
                       gtk_label_new(_("General")));
	
	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(frame),hbox,FALSE,FALSE,5);
	gtk_widget_show(hbox);
	label=gtk_label_new(_("Refresh rate (in milli seconds)"));
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	gtk_widget_show(label);
	adj=(GtkAdjustment *)gtk_adjustment_new(pd->updatetime,100,200000,1000,100,10);
	spin_label=gtk_spin_button_new(adj,1,0);
	gtk_widget_set_usize(spin_label, 70,-1);
	gtk_object_set_data(GTK_OBJECT(pd->pb), "update", spin_label);
	gtk_box_pack_start(GTK_BOX(hbox),spin_label,FALSE,FALSE,5);
	gtk_widget_show(spin_label);
	gtk_signal_connect_object(GTK_OBJECT(adj),"value_changed",GTK_SIGNAL_FUNC(changed_cb),(gpointer)pd);
	gtk_signal_connect_object(GTK_OBJECT(spin_label),"changed",GTK_SIGNAL_FUNC(changed_cb),(gpointer)pd);

	cadre=gtk_frame_new(_("Current"));
	gtk_widget_show(cadre);
	tbox=gtk_vbox_new(FALSE,5);
	gtk_widget_show(tbox);

	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE, 2);
	gtk_widget_show(hbox);
	label=gtk_label_new(_("Current gauge"));
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	gtk_widget_show(label);
	checkbox = gtk_check_button_new_with_label (_("On/Off"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), pd->show_current);
	gtk_object_set_data(GTK_OBJECT(pd->pb), "current", checkbox);
	gtk_box_pack_start(GTK_BOX(hbox),checkbox,FALSE,FALSE,5);
	gtk_widget_show(checkbox);
	gtk_signal_connect(GTK_OBJECT(checkbox), "toggled",
                   	GTK_SIGNAL_FUNC(toggled_cb), (gpointer) pd);

	gtk_container_add(GTK_CONTAINER(cadre),tbox);
	gtk_box_pack_start(GTK_BOX(frame),cadre,FALSE,FALSE,15);

#ifdef PMUD
	cadre=gtk_frame_new(_("Server"));
	gtk_object_set_data(GTK_OBJECT(pd->pb), "server", cadre);
	gtk_widget_show(cadre);
	tbox=gtk_vbox_new(FALSE,5);
	gtk_widget_show(tbox);
	
	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE, 2);
	gtk_widget_show(hbox);
	label=gtk_label_new(_("Server port"));
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	gtk_widget_show(label);
	adj=(GtkAdjustment *)gtk_adjustment_new(pd->port,1,65535,1,1,1);
	spin_label=gtk_spin_button_new(adj,1,0);
	gtk_object_set_data(GTK_OBJECT(pd->pb), "serverport", spin_label);
	gtk_widget_set_usize(spin_label, 60,-1);
	gtk_box_pack_start(GTK_BOX(hbox),spin_label,FALSE,FALSE,5);
	gtk_widget_show(spin_label);
	gtk_signal_connect_object(GTK_OBJECT(spin_label),"changed",GTK_SIGNAL_FUNC(changed_cb),(gpointer)pd);

	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE, 2);
	gtk_widget_show(hbox);
	label=gtk_label_new(_("Server name"));
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	gtk_widget_show(label);
	entry = gtk_entry_new();
	if(pd->servername)
		gtk_entry_set_text(GTK_ENTRY(entry), (gchar *) pd->servername);
	gtk_object_set_data(GTK_OBJECT(pd->pb), "servername", entry);
	gtk_box_pack_start(GTK_BOX(hbox),entry,FALSE,FALSE,5);
	gtk_widget_show(entry);
	gtk_signal_connect_object(GTK_OBJECT(entry),"changed",GTK_SIGNAL_FUNC(changed_cb),(gpointer)pd);

	gtk_container_add(GTK_CONTAINER(cadre),tbox);
	gtk_box_pack_start(GTK_BOX(frame),cadre,FALSE,FALSE,15);
#endif

	gtk_widget_show(frame);

	gtk_signal_connect(GTK_OBJECT(pd->pb), "apply",
                           GTK_SIGNAL_FUNC(apply_cb), pd);
	gtk_signal_connect(GTK_OBJECT(pd->pb), "destroy",
                           GTK_SIGNAL_FUNC(gtk_widget_destroyed), &(pd->pb));

	gtk_widget_show_all(pd->pb);
}
