package CsaFileSession;
use strict;
use IO::Handle;
use Time::HiRes;

BEGIN {
  $| = 1;
}

sub new ($$$) {
  my ($pkg, $directory, $initial) = @_;
  my $this = { directory => $directory, cur => $initial, };

  bless $this;
  return $this;
}

sub write ($$) {
  my ($this, $message) = @_;
  my ($directory, $id) = ($this->{directory}, sprintf("%03d", $this->{cur}));
  chomp $message;
  open (OUT, "> $directory/$id.part") || die "open $directory/$id $!";
  print OUT $message."\n";
  close OUT;
  print STDERR "write $directory/$id\n";
  system("mv", "$directory/$id.part", "$directory/$id.txt") == 0 || die "mv $id $!";
  print STDERR "finish $directory/$id\n";
  $this->{cur} += 1;
}

sub try_read ($) {
  my ($this) = @_;
  my ($directory, $id) = ($this->{directory}, sprintf("%03d", $this->{cur}));
  if (open (IN, "$directory/$id.txt")) {
    my $message = <IN>;
    chomp $message;
    close IN;
    print STDERR "read $id $message.\n";
    $this->{cur} += 1;
    return $message;
  }
  return undef;
}

sub read ($) {
  my ($this) = @_;
  while (1) {
    if (my $message = $this->try_read()) {
      return $message;
    } else {
      Time::HiRes::usleep(20);
    }
  }
}

sub id ($) {
  my ($this) = @_;
  return $this->{cur};
}

# END
return 1;
