#!/usr/bin/perl -w
use Getopt::Std;
use strict;

my %options;
getopts('est', \%options);
my $mode = "escape";
if ($options{e}) {
    $mode = "escape";
} elsif ($options{s}) {
    $mode = "sokudumi";
} elsif ($options{t}) {
    $mode = "tsumero";
}

sub parse ($) {
    my ($line) = @_;
    my $result = {};

    my ($id, $moves, $e_p, $e_d, $s_p, $s_d, $t_p, $t_d) 
	= split(/\s+/,$line);
    $result->{id} = $id;
    $result->{moves} = $moves;
    $result->{escape} = { proof  => $e_p, disproof => $e_d };
    $result->{sokudumi} = { proof  => $s_p, disproof => $s_d };
    $result->{tsumero} = { proof  => $t_p, disproof => $t_d };
    return $result;
}

sub show_property ($@) {
    my ($property,$id,$moves) = @_;
    print "$id $moves $property->{proof} $property->{disproof}\n";
}

sub position ($$) {
    my ($line,$negative) = @_;
    return ($line->{id}, -$line->{moves})
	if ($negative);
    return ($line->{id}, $line->{moves});
}

my $instances = {};

sub output() {
    my $negative = ($mode eq "tsumero");
    foreach my $tsumero (keys %{$instances->{$mode}}) {
	my $line = $instances->{$mode}->{$tsumero};
	show_property($line->{$mode}, &position($line, $negative));
    }
    $instances->{$mode} = {};
}

sub good_property ($) {
    my ($property) = @_;
    return ($property->{proof} > 0);
}

sub property_key ($$) {
    my ($moves,$property) = @_;
    return "" . $moves % 2 . "-"
	. $property->{proof} . "-" . $property->{disproof};
}

my $last_move = undef;
while (<>) {
    my $line = &parse($_);
    if (defined($last_move) && ($line->{moves} < $last_move)) {
	output();
    }
    $last_move = $line->{moves};

    if (&good_property($line->{$mode})) {
	my $key = &property_key($line->{moves}, $line->{$mode});
	$instances->{$mode}->{$key} = $line; # overwrite
    }
}
output();
