/* piecePairKing.cc
 */
#include "eval/piecePairKing.h"

void gpsshogi::PiecePairKing::
featuresOneNonUniq(const NumEffectState &state,
		   index_list_t &feature_count) const
{
  FixedCapacityVector<Piece,38> pieces;
  if (state.getKingPosition(BLACK).y() >= 7)
  {
    PieceMask black = state.getOnBoardMask(BLACK) & ~state.promotedPieces();
    black.clearBit<KING>();
    while (! black.none()) 
    {
      const Piece p = state.getPieceOf(black.takeOneBit());
      if (p.position().y() >= 5)
	pieces.push_back(p);
    }
    bool flipx;
    const int index_king = indexKing(BLACK, state.getKingPosition(BLACK), flipx);
    for (size_t i=0; i<pieces.size(); ++i)
    {
      const unsigned int i0 = indexPiece(BLACK, pieces[i].position(), pieces[i].ptype(), flipx);
      for (size_t j=i+1; j<pieces.size(); ++j)
      {
	const unsigned int i1 = indexPiece(BLACK, pieces[j].position(), pieces[j].ptype(), flipx);
	const unsigned int index = composeIndex(index_king, i0, i1);
	assert(index == indexBlack(state.getKingPosition(BLACK), pieces[i], pieces[j]));
	assert(index < dimension());
	feature_count.add(index, 1);
      }
    }
  }
  if (state.getKingPosition(WHITE).y() <= 3)
  {  
    PieceMask white = state.getOnBoardMask(WHITE) & ~state.promotedPieces();
    white.clearBit<KING>();
    pieces.clear();
    while (! white.none()) 
    {
      const Piece p = state.getPieceOf(white.takeOneBit());
      if (p.position().y() <= 5)
	pieces.push_back(p);
    }
    bool flipx;
    const int index_king = indexKing(WHITE, state.getKingPosition(WHITE), flipx);
    for (size_t i=0; i<pieces.size(); ++i)
    {
      const unsigned int i0 = indexPiece(WHITE, pieces[i].position(), pieces[i].ptype(), flipx);
      for (size_t j=i+1; j<pieces.size(); ++j)
      {
	const unsigned int i1 = indexPiece(WHITE, pieces[j].position(), pieces[j].ptype(), flipx);
	const unsigned int index = composeIndex(index_king, i0, i1);
	assert(index == indexWhite(state.getKingPosition(WHITE), pieces[i], pieces[j]));
	assert(index < dimension());
	feature_count.add(index, -1);
      }
    }
  }
}

gpsshogi::PiecePairKingFlat::~PiecePairKingFlat()
{
}

int gpsshogi::PiecePairKingFlat::
eval(const NumEffectState& state) const
{
  index_list_t features;
  feature.featuresOneNonUniq(state, features);
  int ret=0;
  for (size_t i=0; i<features.size(); ++i)
    ret += value(features[i].first) * features[i].second;
  return ret;
}

int gpsshogi::PiecePairKingFlat::
add(const NumEffectState& state, Player player, Position to, Ptype ptype) const
{
  const Position king = state.getKingPosition(player);
  bool flipx;
  const int index_king = feature.indexKing(player, king, flipx);
  const unsigned int i0 = feature.indexPiece(player, to, ptype, flipx);
  int sum = 0;
  PieceMask bitset = state.getOnBoardMask(player) & ~state.promotedPieces();
  bitset.clearBit<KING>();
  while (! bitset.none()) 
  {
    const Piece p = state.getPieceOf(bitset.takeOneBit());
    if (p.position().positionForBlack(player).y() < 5)
      continue;
    const unsigned int i1 = feature.indexPiece(player, p.position(), p.ptype(), flipx);
    const unsigned int index = feature.composeIndex(index_king, i0, i1);
    sum += value(index);
  }
  sum -= value(feature.composeIndex(index_king, i0, i0));
  return (player == BLACK) ? sum : -sum;
}

int gpsshogi::PiecePairKingFlat::
sub(const NumEffectState& state, Player player, Position from, Ptype ptype) const
{
  const Position king = state.getKingPosition(player);
  bool flipx;
  const int index_king = feature.indexKing(player, king, flipx);
  const unsigned int i0 = feature.indexPiece(player, from, ptype, flipx);
  int sum = 0;
  PieceMask bitset = state.getOnBoardMask(player) & ~state.promotedPieces();
  bitset.clearBit<KING>();
  while (! bitset.none()) 
  {
    const Piece p = state.getPieceOf(bitset.takeOneBit());
    if (p.position().positionForBlack(player).y() < 5)
      continue;
    const unsigned int i1 = feature.indexPiece(player, p.position(), p.ptype(), flipx);
    const unsigned int index = feature.composeIndex(index_king, i0, i1);
    sum -= value(index);
  }
  return (player == BLACK) ? sum : -sum;
}

int gpsshogi::PiecePairKingFlat::
addSub(const NumEffectState& state, Player player, Position to, Ptype ptype, Position from) const
{
  const Position king = state.getKingPosition(player);
  bool flipx;
  const int index_king = feature.indexKing(player, king, flipx);
  const unsigned int i0 = feature.indexPiece(player, to, ptype, flipx);
  const unsigned int s0 = feature.indexPiece(player, from, ptype, flipx);
  int sum = 0;
  PieceMask bitset = state.getOnBoardMask(player) & ~state.promotedPieces();
  bitset.clearBit<KING>();
  FixedCapacityVector<Piece,38> pieces;
  while (! bitset.none()) 
  {
    const Piece p = state.getPieceOf(bitset.takeOneBit());
    if (p.position().positionForBlack(player).y() < 5)
      continue;
    const unsigned int i1 = feature.indexPiece(player, p.position(), p.ptype(), flipx);
    const unsigned int index = feature.composeIndex(index_king, i0, i1);
    sum += value(index);
    const unsigned int sub_index = feature.composeIndex(index_king, s0, i1);
    sum -= value(sub_index);
  }
  sum -= value(feature.composeIndex(index_king, i0, i0));
  sum += value(feature.composeIndex(index_king, s0, i0));
  return (player == BLACK) ? sum : -sum;
}

int gpsshogi::PiecePairKingFlat::
evalWithUpdate(const NumEffectState& state, Move moved, int last_value) const
{
  if (moved.isPass())
    return last_value;
  const Player player = moved.player();
  if (moved.ptype() == KING)	// osl ではking別に分けると手間が半分に
    return PiecePairKingFlat::eval(state);
  const Position rking = state.getKingPosition(player).positionForBlack(player);
  if (rking.y() < 7) 
  {
    if (moved.capturePtype() != PTYPE_EMPTY && ! isPromoted(moved.capturePtype()))
    {
      const Position roking = state.getKingPosition(alt(player)).positionForBlack(alt(player));
      if (roking.y() >= 7 && moved.to().positionForBlack(alt(player)).y() >= 5)
	return last_value + sub(state, alt(player), moved.to(), moved.capturePtype());
    }
    return last_value;
  }
  const Position rto = moved.to().positionForBlack(player);
  if (moved.isDrop())
  {
    if (rto.y() < 5)
      return last_value;
    return last_value + add(state, player, moved.to(), moved.ptype());
  }
  const Position rfrom = moved.from().positionForBlack(player);
  const Ptype captured = moved.capturePtype();
  if (captured != PTYPE_EMPTY && ! isPromoted(captured))
  {
    const Player opponent = alt(player);
    const Position roking = state.getKingPosition(opponent).positionForBlack(opponent);
    if (roking.y() >= 7 && moved.to().positionForBlack(opponent).y() >= 5)
      last_value += sub(state, opponent, moved.to(), moved.capturePtype());
  }

  if (isPromoted(moved.oldPtype()))
    return last_value;
  if (rfrom.y() < 5)
  {
    if (rto.y() < 5 || isPromoted(moved.ptype()))
      return last_value;
    return last_value + add(state, player, moved.to(), moved.ptype());
  }
  if (rto.y() < 5 || isPromoted(moved.ptype()))
    return last_value + sub(state, player, moved.from(), moved.oldPtype());
  assert(! moved.isPromote());
  return last_value + addSub(state, player, moved.to(), moved.ptype(), moved.from());
}

void gpsshogi::PiecePairKingFlat::
featuresNonUniq(const NumEffectState& state, index_list_t& out, int offset) const
{
  index_list_t tmp;
  feature.featuresOneNonUniq(state, tmp);
  for (size_t i=0; i<tmp.size(); ++i)
    out.add(tmp[i].first+offset, tmp[i].second);
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
