/* quiesce.t.cc
 */
#include "quiesce.h"
#include "eval/eval.h"
#include "osl/record/csaString.h"
#include "osl/eval/pieceEval.h"
#include "osl/record/csaString.h"

#include "gtest/gtest.h"
#include <iostream>

using namespace osl;
using namespace osl::eval;
extern bool isShortTest;

const int Gold = gpsshogi::PieceEval().value(GOLD);
const int Bishop = gpsshogi::PieceEval().value(BISHOP);
const int Rook = gpsshogi::PieceEval().value(ROOK);

TEST(QuiesceTest, testPv)
{
  NumEffectState state((CsaString(
			  "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			  "P2 * -HI *  *  *  *  * -KA *	\n"
			  "P3-FU-FU-FU-FU-FU * -FU-FU-FU\n"
			  "P4 *  *  *  *  * -FU *  *  *	\n"
			  "P5 *  *  *  *  *  *  *  *  *	\n"
			  "P6 *  * +FU *  *  *  *  *  *	\n"
			  "P7+FU+FU * +FU+FU+FU+FU+FU+FU\n"
			  "P8 * +KA *  *  *  *  * +HI *	\n"
			  "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			  "+\n").getInitialState()));
  
  gpsshogi::PVVector pv;
  int value;
  gpsshogi::PieceEval eval;
  gpsshogi::Quiesce quiesce(&eval, 1, 4);
  quiesce.quiesce(state, value, pv, -300, +300);
  EXPECT_GT(pv.size(), 0);
}

TEST(QuiesceTest, testConstruct)
{
  gpsshogi::PieceEval eval;
  {
    NumEffectState state((SimpleState(HIRATE)));
    gpsshogi::Quiesce quiesce(&eval);
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_EQ(0, value);
    EXPECT_TRUE(pv.empty());
  }
}

TEST(QuiesceTest, testCapture)
{
  gpsshogi::PieceEval eval;
  gpsshogi::Quiesce quiesce(&eval);
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI * -OU-KI-GI-KE-KY\n"
			   "P2 * -HI *  *  *  *  * -KA * \n"
			   "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  * -KI * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7+FU+FU+FU+FU+FU+FU+FU * +FU\n"
			   "P8 * +KA *  *  *  *  * +HI * \n"
			   "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			   "P+00FU\n"
			   "+\n").getInitialState());
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_EQ(Gold*2, value);
    const Move m25hi(Position(2,8),Position(2,5),ROOK,GOLD,false,BLACK);
    EXPECT_EQ((size_t)1, pv.size());
    EXPECT_EQ(m25hi, pv[0]);
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI * -OU-KI-GI-KE-KY\n"
			   "P2 * -HI *  *  *  *  * -KA * \n"
			   "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
			   "P4 *  *  *  *  *  *  * -KI * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7+FU+FU+FU+FU+FU+FU+FU * +FU\n"
			   "P8 * +KA *  *  *  *  * +HI * \n"
			   "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			   "P+00FU\n"
			   "+\n").getInitialState());
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_EQ(0, value);
    EXPECT_EQ((size_t)0, pv.size());
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI * -OU-KI-GI-KE-KY\n"
			   "P2 *  *  *  *  *  *  * -KA * \n"
			   "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  * -HI *  *  *  *  * -KI\n"
			   "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
			   "P8 * +KA *  *  *  *  * +HI * \n"
			   "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			   "+\n").getInitialState());
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_EQ(Rook*2, value);
    EXPECT_EQ((size_t)1, pv.size());
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI * -OU-KI-GI-KE-KY\n"
			   "P2 * -HI *  *  *  *  * -KA * \n"
			   "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
			   "P4+HI *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  * -KI\n"
			   "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
			   "P8 * +KA *  *  *  *  *  *  * \n"
			   "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			   "+\n").getInitialState());
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_EQ(0, value);
    EXPECT_EQ((size_t)0, pv.size());
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			   "P2 *  *  *  *  *  *  * -KA * \n"
			   "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
			   "P4+KI *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  * -HI\n"
			   "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
			   "P8 * +KA *  *  *  *  * +HI * \n"
			   "P9+KY+KE+GI+KI+OU * +GI+KE+KY\n"
			   "+\n").getInitialState());
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_EQ(Rook*2 - Gold*2, value);
    EXPECT_EQ((size_t)2, pv.size());
  }
}

TEST(QuiesceTest, testCheckmate)
{
  gpsshogi::PieceEval eval;
  gpsshogi::Quiesce quiesce(&eval);
  EXPECT_GT(quiesce.infty(BLACK), quiesce.infty(WHITE));
  EXPECT_GT(quiesce.infty(BLACK), Rook*4);
  {
    NumEffectState state(CsaString(
			   "P1 *  *  * -OU *  *  *  *  * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  * +FU *  *  *  *  * \n"
			   "P4 *  *  * +KY *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  * +OU *  *  *  *  * \n"
			   "P-00AL\n"
			   "+\n").getInitialState());
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_EQ(quiesce.infty(BLACK), value);
    const Move m62to(Position(6,3),Position(6,2),PPAWN,PTYPE_EMPTY,true,BLACK);
    EXPECT_EQ((size_t)1, pv.size());
    EXPECT_EQ(m62to, pv[0]);
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  * -OU *  *  *  *  * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  * -KY *  *  *  *  * \n"
			   "P7 *  *  * -FU *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  * +OU *  *  *  *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_EQ(quiesce.infty(WHITE), value);
    const Move m68to(Position(6,7),Position(6,8),PPAWN,PTYPE_EMPTY,true,WHITE);
    EXPECT_EQ((size_t)1, pv.size());
    EXPECT_EQ(m68to, pv[0]);
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			   "P2 * -HI *  *  *  *  * -KA * \n"
			   "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
			   "P4 *  *  *  *  *  * -FU *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  * +FU *  *  *  *  *  * \n"
			   "P7+FU+FU * +FU+FU+FU+FU+FU+FU\n"
			   "P8 * +KA * +GI *  *  * +HI * \n"
			   "P9+KY+KE * +KI+OU+KI+GI+KE+KY\n"
			   "-\n").getInitialState());
    gpsshogi::PVVector pv;
    int value;
    quiesce.quiesce(state, value, pv);
    EXPECT_LT(value, -Bishop*2);
    const Move m88um(Position(2,2),Position(8,8),PBISHOP,BISHOP,true,WHITE);
    EXPECT_EQ((size_t)1, pv.size());
    EXPECT_EQ(m88um, pv[0]);

    quiesce.clear();
    pv.clear();

    quiesce.quiesce(state, value, pv, -300, 300);
    EXPECT_LT(value, -Bishop*2);
    EXPECT_EQ((size_t)1, pv.size());
    EXPECT_EQ(m88um, pv[0]);
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
