#ifndef _BOARD_TABCHILD_H
#define _BOARD_TABCHILD_H
#include "tabchild.h"

namespace gpsshogi
{
  namespace gui
  {
    class Board;
  }
}

class BoardTabChild : public TabChild
{
  Q_OBJECT
public:
  BoardTabChild(QWidget *parent = 0, const char *name = 0);
  void toInitialState();
  osl::Player turn() const;
  const osl::state::SimpleState& getState();
  void toggleOrientation();
  void setOrientation(bool sente);
  bool isSenteView() const;
  void copy();
  void copyBoardAndMoves();
  void copyUsi();
  void copyBoardAndMovesUsi();
  void enableEffect(bool on);
  bool effectEnabled();
  void highlightLastMove(bool on);
  virtual osl::state::SimpleState getStateAndMovesToCurrent(osl::stl::vector<osl::Move> &moves) = 0;
  virtual int getLimit() { return 1000; };
public slots:
  QWidget *moveGenerateDialog();
signals:
  void statusChanged();
  void statusChanged(const osl::state::SimpleState &state,
		     const osl::stl::vector<osl::Move> &moves,
		     int limit, osl::Move next);
protected:
  virtual osl::Move getNextMove() { return osl::Move::INVALID(); }
  gpsshogi::gui::Board *board;
  osl::state::SimpleState initialState;
protected slots:
  void notifyState();
};

#endif // _BOARD_TABCHILD_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
