#include "database-metadata.h"
#include "result-set.h"

#include "gql++/mod-result-set.h"

namespace GQL
{

namespace MySQL
{

using namespace std;

ResultSet *MyDatabaseMetaData::get_tables(
        const string& catalog,
        const string& schema_pattern,
        const string& table_name_pattern,
        const vector<string>& types)
{
  MYSQL_RES *r;
  ModResultSet *result;

  r = mysql_list_tables(conn_->mysql_connection(), "%");
  
  result = manage(new ModResultSet(conn_, 5));

  for (int i = 0; i < (int)mysql_num_rows(r); i++)
  {
    string s;
    string name;
    MYSQL_ROW row;
    const char *tuple[5];

    row = mysql_fetch_row(r);

    if (!row)
      continue;
    
    // Table name
    tuple[0] = 0;
    tuple[1] = 0;
    tuple[2] = row[0];
    tuple[3] = 0;
    tuple[4] = 0;
    
    result->append(tuple);
  }

  mysql_free_result(r);

  return result;
}

ResultSet *MyDatabaseMetaData::get_columns(
        const string& catalog,
        const string& schema_pattern,
        const string& table_name_pattern,
        const string& column_name_pattern)
{
  ModResultSet *result = manage(new ModResultSet(conn_, 8));

  // FIXME: Implement
  
  return result;
}

ResultSet *MyDatabaseMetaData::get_cross_reference(
        const string& primary_catalog,
        const string& primary_schema,
        const string& primary_table,
        const string& foreign_catalog,
        const string& foreign_schema,
        const string& foreign_table)
{
  ResultSet *result = manage(new ModResultSet(conn_, 0));

  // FIXME: Implement

  return result;
}

}

}
