/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_DRIVER_H)
#define __INC_DRIVER_H

#include <vector>
#include <map>
#include <string>

#include <sigc++/sigc++.h>

#include <yehia/plugin.h>

#include "gql++/connection.h"

namespace GQL
{

class DriverPropertyInfo
{
  public:
    DriverPropertyInfo(const std::string& nam,
                       const std::string& descr = std::string(),
                       const std::string& val = std::string(),
                       bool req = false,
                       const std::vector<std::string>& cs = std::vector<std::string>())
        : choices_(cs), description_(descr), name_(nam),
          required_(req), value_(val) { }
      
    const std::vector<std::string>& choices() const { return(choices_); }
    const std::string& description() const { return(description_); }
    const std::string& name() const { return(description_); }
    bool required() const { return(required_); }
    const std::string& value() const { return(value_); }
  private:
    std::vector<std::string> choices_;
    std::string description_;
    std::string name_;
    bool required_;
    std::string value_;
};

class Driver : public Yehia::Plugin
{
  public:
    Driver(Yehia::PluginManager& mgr,const std::string& id, 
           const std::string& name)
        : Yehia::Plugin(mgr), id_(id), name_(name) {
    }
    virtual ~Driver();
    
    const std::string& get_id() const { return id_; }
    const std::string& get_name() const { return name_; }
    int get_major_version() const { return major_; }
    int get_minor_version() const { return minor_; }
    virtual std::vector<DriverPropertyInfo> get_property_info(
            const std::string& url,
            const std::map<std::string, std::string>& props) const = 0;
    
    virtual bool accept_url(const std::string& str) const = 0;
    virtual Connection *connect(
            const std::string& url, 
            const std::map<std::string, std::string>& prop) = 0;
    
    // From Yehia::Plugin
    virtual std::string name() const { return id_; }
    virtual std::string description() const { return name_; }
  protected:
    void set_version(int maj, int min) {
      minor_ = min;
      major_ = maj;
    }
  private:
    int minor_, major_;
    std::string id_, name_;
};


}

#endif
