/* $Id: ConstraintGraph.cpp,v 1.6 2005/04/05 11:32:55 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "dynadag/DynaDAG.h"

namespace DynaDAG {

ConstraintGraph::ConstraintGraph() : anchor(create_node()) {
	gd<ConstraintType>(anchor).why = ConstraintType::anchor;
}
DDCGraph::Node *ConstraintGraph::GetVar(NodeConstraints &nc) {
	if(!nc.n) 
		gd<ConstraintType>(nc.n = create_node()).why = ConstraintType::node;
	return nc.n;
}

void ConstraintGraph::Stabilize(NodeConstraints &nc, int newrank, int weight) {
	if(!nc.stab) 
		gd<ConstraintType>(nc.stab = create_node()).why = ConstraintType::stab;
//	assert(newrank>-1000000 && newrank<1000000);
	DDCGraph::Node *var = GetVar(nc);
	int len0,len1;
	if (newrank >= 0) {
		len0 = 0; 
		len1 = newrank;
	}
	else {
		len0 = -newrank; 
		len1 = 0;
	}
	NSEdgePair ep(nc.stab,anchor,var);
	DDNS::NSd(ep.e[0]).minlen = len0;
	DDNS::NSd(ep.e[1]).minlen = len1;
	DDNS::NSd(ep.e[0]).weight = weight;
	DDNS::NSd(ep.e[1]).weight = weight;
}
void ConstraintGraph::Unstabilize(NodeConstraints &nc) {
	if(nc.stab) { 
		erase_node(nc.stab);
		nc.stab = 0;
	}
	/*if (nd->con[csys].n)
		agdelete(cg,nd->con[csys].n); */ 	/* incorrect? */
}
void ConstraintGraph::RemoveNodeConstraints(NodeConstraints &nc) {
	if(nc.n) {
		erase_node(nc.n);
		nc.n = 0;
	}
	if(nc.stab) {
		erase_node(nc.stab);
		nc.stab = 0;
	}
}

} // namespace DynaDAG
