Components.utils.import('resource://greasemonkey/prefmanager.js');
Components.utils.import('resource://greasemonkey/util.js');

const EXPORTED_SYMBOLS = ['checkCoralCache'];

const XMLHttpRequest = Components.Constructor(
    '@mozilla.org/xmlextras/xmlhttprequest;1');

var gCheckIsRunning = false;

function checkCoralCache() {
  if (GM_prefRoot.getValue('coralCacheWorks')) return true;

  if (gCheckIsRunning) return false;

  gCheckIsRunning = true;
  var req = new XMLHttpRequest();
  req.onerror = GM_util.hitch(null, onError, req);
  req.onload = GM_util.hitch(null, onLoad, req);
  req.open('get', 'http://www.greasespot.net.nyud.net/');
  req.send();

  return false;
}

function onError(aReq, aEvent) {
  GM_prefRoot.setValue('coralCacheWorks', false);
  gCheckIsRunning = false;
}

function onLoad(aReq, aEvent) {
  if (200 !== aReq.status) return onError();
  if (-1 == aReq.responseText.indexOf('Greasemonkey')) return onError();

  GM_prefRoot.setValue('coralCacheWorks', true);
  gCheckIsRunning = false;
}
