//*****************************************************************************
//                               PrcSimrBase.cpp                              *
//                              -----------------                             *
//  Started     : 25/04/2004                                                  *
//  Last Update : 20/09/2007                                                  *
//  Copyright   : (C) 2004 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "base/PrcSimrBase.hpp"

//*****************************************************************************
// Constructor.

PrcSimrBase::PrcSimrBase( void ) : PrcBase( wxPROCESS_REDIRECT )
{
  m_eSimrType = eSIMR_NONE;
}

//*****************************************************************************
// Destructor.

PrcSimrBase::~PrcSimrBase( )
{
}

//*****************************************************************************
// Set the simulation results file name.
//
// Argument List:
//   rosFName - A string containing the full path and file name
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PrcSimrBase::bSetResultsFile( const wxString & rosFName )
{
  wxFileName  ofn1;

  ofn1 = rosFName;
  if( ofn1.GetPath( ).IsEmpty( ) ) ofn1.SetPath( wxT(".") );

  if( ! ofn1.IsOk( ) ) return( FALSE );

  m_oFnResults = ofn1;

  return( TRUE );
}

//*****************************************************************************
// Save the console output to file.
//
// Arguments:
//   rosFName - The save file name
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PrcSimrBase::bSaveOutput( const wxString & rosFName )
{
  wxFileName  ofn1;
  wxString    os1, os2;
  wxChar      oc1;

  // Check the validity of the save file name
  if( rosFName.IsEmpty( ) )         return( FALSE );
  ofn1 = rosFName;
  if( ! ofn1.IsOk( ) )              return( FALSE );

  // Open the save file and delete any lines it may contain
  wxTextFile  oFileCct( ofn1.GetFullPath( ) );
  if( oFileCct.Exists( ) )
       { if( ! oFileCct.Open( ) )   return( FALSE ); }
  else { if( ! oFileCct.Create( ) ) return( FALSE ); }
  oFileCct.Clear( );

  wxMicroSleep( 100 );

  // Save the simulator output to file
  while( bIsExec( ) || IsInputAvailable( ) || IsErrorAvailable( ) )
  {
    while( IsInputAvailable( ) )
    { // Input characters from stdout
      oc1 = GetInputStream( )->GetC( );
      if( oc1 == wxT('\n') )
      {
        oFileCct.AddLine( os1 );
        os1 = wxT("");
        continue;
      }
      if( oc1==wxT('\t') || (oc1>31 && oc1!=127) ) os1 << oc1;
    }

    while( IsErrorAvailable( ) )
    { // Input characters from stderr
      oc1 = GetErrorStream( )->GetC( );
      if( oc1 == wxT('\n') )
      {
        oFileCct.AddLine( os2 );
        os2 = wxT("");
        continue;
      }
      if( oc1==wxT('\t') || (oc1>31 && oc1!=127) ) os2 << oc1;
    }

    if( !IsInputAvailable( ) && !IsErrorAvailable( ) )
      wxTheApp->Yield( );  // Release the processor for other tasks
  }

  if( os1.Length( ) > 0 ) oFileCct.AddLine( os1 );
  if( os2.Length( ) > 0 ) oFileCct.AddLine( os2 );
  oFileCct.AddLine( wxT("") );

  oFileCct.Write( ); // Save the changes to disk
  oFileCct.Close( ); // Close the results file

  return( TRUE );
}

//*****************************************************************************
// Execute a simulation.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PrcSimrBase::bExec( void )
{
  wxString  os1, os2;

  // Execute the simulation
  if( ! PrcBase::bExec( ) )      return( FALSE );

  // Save the simulation results to the log file
  os1 = rofnGetLogFile( ).GetFullPath( );
  if( ! bSaveOutput( os1 ) )     return( FALSE );

  // Copy the log file to the results file
  os2 = roGetResultsFile( ).GetFullPath( );
  if( ! wxCopyFile( os1, os2 ) ) return( FALSE );

  return( TRUE );
}

//*****************************************************************************
