//*****************************************************************************
//                               CmdGnuCapAC.hpp                              *
//                              -----------------                             *
//  Description : This class contains values associated with the GNU-Cap      *
//                AC command. It inherits from the class CmdBase.             *
//  Started     : 21/02/2008                                                  *
//  Last Update : 22/02/2008                                                  *
//  Copyright   : (C) 2008 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDGNUCAPAC_HPP
#define CMDGNUCAPAC_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "TypeDefs.hpp"
#include "base/CmdBase.hpp"
#include "utility/ConvertType.hpp"

// Local Macro and Constant Declarations


//*****************************************************************************

struct CmdGnuCapAC : public CmdBase
{
  public :

    float       m_fStart;  // The sweep start value
    float       m_fStop;   // The sweep stop  value
    float       m_fStep;   // The sweep step  value
    eScaleType  m_eScale;  // The sweep scale type
    float       m_fTempC;  // The analysis temperature

              CmdGnuCapAC( void );
    virtual  ~CmdGnuCapAC( );

    bool  bClear( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    wxString & operator = ( const wxString & ros )
                { *((wxString *) this) = ros; return( *((wxString *) this) ); }

    void  Print( const char * psPrefix="" );
};

//*****************************************************************************

#endif // CMDGNUCAPAC_HPP
