//*****************************************************************************
//                                NbkTxtCtls.cpp                              *
//                               ----------------                             *
//  Started     : 14/06/2005                                                  *
//  Last Update : 15/11/2005                                                  *
//  Copyright   : (C) 2005 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "main/NbkTxtCtls.hpp"

//*****************************************************************************
// Constructor.

NbkTxtCtls::NbkTxtCtls( void ) : wxNotebook( )
{
}

//*****************************************************************************
// Destructor.

NbkTxtCtls::~NbkTxtCtls( )
{
}

//*****************************************************************************
// Create an instantance of this object.
//
// Argument List:
//   poWin  - The parent window
//   oWinID - The window identifier
//   roPosn - The position
//   roSize - The size
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  NbkTxtCtls::bCreate( wxWindow * poWin, wxWindowID oWinID )
{
  bool  bRtn=TRUE;
  wxString  os1;

  // Check if the object has already been created
  if( bIsCreated( ) )             return( TRUE );

  // Create the notebook object to hold the text controls
  if( ! Create( poWin, oWinID ) ) return( FALSE );

  // Allocate memory for the text controls
  TextCtrl * poTxcConsole = new TextCtrl;
  TextCtrl * poTxcNetList = new TextCtrl;
  TextCtrl * poTxcSimultn = new TextCtrl;
  TextCtrl * poTxcGnuCap  = new TextCtrl;
  TextCtrl * poTxcNgSpice = new TextCtrl;

  // Create the text controls
  if( ! poTxcConsole->bCreate( this ) ) bRtn = FALSE;
  if( ! poTxcNetList->bCreate( this ) ) bRtn = FALSE;
  if( ! poTxcSimultn->bCreate( this ) ) bRtn = FALSE;
  if( ! poTxcGnuCap ->bCreate( this ) ) bRtn = FALSE;
  if( ! poTxcNgSpice->bCreate( this ) ) bRtn = FALSE;

  // Initialize the text controls
  os1 = wxT("No console input/output to display");
  if( ! poTxcConsole->bSetInitMsg( os1 ) ) bRtn = FALSE;
  os1 = wxT("No net list currently loaded");
  if( ! poTxcNetList->bSetInitMsg( os1 ) ) bRtn = FALSE;
  os1 = wxT("No circuit simulation currently defined");
  if( ! poTxcSimultn->bSetInitMsg( os1 ) ) bRtn = FALSE;
  os1 = wxT("No GNU-Cap simulation results to display");
  if( ! poTxcGnuCap ->bSetInitMsg( os1 ) ) bRtn = FALSE;
  os1 = wxT("No NG-Spice simulation results to display");
  if( ! poTxcNgSpice->bSetInitMsg( os1 ) ) bRtn = FALSE;

  // Define tool tips for the note book and each page
  SetToolTip( wxT("Text Based Input / Output Consoles") ); // ??? 18/04/2004 Doesn't work
  poTxcConsole->SetToolTip( wxT("Console Input/Output (non-editable)") );
  poTxcNetList->SetToolTip( wxT("Net List File (non-editable)") );
  poTxcSimultn->SetToolTip( wxT("Simulation File (editable)") );
  poTxcGnuCap ->SetToolTip( wxT("GNU-Cap Simulation Results (non-editable)") );
  poTxcNgSpice->SetToolTip( wxT("NG-Spice Simulation Results (non-editable)") );

  // Add the display objects to the note book
  AddPage( poTxcConsole, wxT("   Console   ") );
  AddPage( poTxcNetList, wxT("    Circuit    ") );
  AddPage( poTxcSimultn, wxT(" Simulation ") );
  AddPage( poTxcGnuCap,  wxT("  GNU-Cap  ") );
  AddPage( poTxcNgSpice, wxT("  NG-Spice  ") );

  Initialize( );

  return( bRtn );
}

//*****************************************************************************
// Clear one or all text controls associated with the notebook.
//
// Argument List:
//   ePage - The enumerated page identifier
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  NbkTxtCtls::bClear( ePageType ePage )
{
  size_t  szt1;

  // Check if the object has already been created
  if( ! bIsCreated( ) )                                return( FALSE );

  // Attempt to perform the clear operation
  if( ePage>=ePAGE_FST && ePage<=ePAGE_LST )
  { // Clear a particular page
    if( ! poGetPage( ePage )->bClear( ) )              return( FALSE );
  }
  else if( ePage>=ePAGE_ALL )
  { // Clear all pages
    for( szt1=0; szt1<GetPageCount( ); szt1++ )
    {
      if( ! poGetPage( (ePageType) szt1 )->bClear( ) ) return( FALSE );
    }
    if( bSetPage( ePAGE_FST ) )                        return( FALSE );
  } // Invalid page identifier
  else                                                 return( FALSE );

  return( TRUE );
}

//*****************************************************************************
// Initialize one or all text controls associated with the notebook.
//
// Argument List:
//   ePage - The enumerated page identifier
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

void  NbkTxtCtls::Initialize( ePageType ePage )
{
  size_t  szt1;

  // Check if the object has already been created
  if( ! bIsCreated( ) ) return;

  // Attempt to perform the clear operation
  if( ePage>=ePAGE_FST && ePage<=ePAGE_LST )
  { // Clear a particular page
    poGetPage( ePage )->Initialize( );
  }
  else if( ePage>=ePAGE_ALL )
  { // Clear all pages
    for( szt1=0; szt1<GetPageCount( ); szt1++ )
      poGetPage( (ePageType) szt1 )->Initialize( );
  }

  bSetPage( ePAGE_FST );
}

//*****************************************************************************
// Set the page to be displayed.
//
// Argument List:
//   ePage - The enumerated page identifier
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  NbkTxtCtls::bSetPage( NbkTxtCtls::ePageType ePage )
{
  // Check if the object has already been created
  if( ! bIsCreated( ) )                        return( FALSE );

  // Check that the page identifier is valid
  if( GetPageCount( ) < ((size_t) ePage + 1) ) return( FALSE );

  SetSelection( (size_t) ePage );

  return( TRUE );
}

//*****************************************************************************
// Set the insert and show positions in the currently displayed page.
//
// Argument List:
//   liPosn - The position
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  NbkTxtCtls::bSetPosn( long liPosn )
{
  TextCtrl * poTxtCtl;

  // Check if the object has already been created
  if( ! bIsCreated( ) )  return( FALSE );

  // Get a pointer to the currently displayed page
  poTxtCtl = (TextCtrl *) GetCurrentPage( );

  if( poTxtCtl == NULL ) return( FALSE );

  // Set the position
  poTxtCtl->SetInsertionPoint( liPosn );
//  poTxtCtl->ShowPosition( liPosn ); ??? 18/06/2005

  return( TRUE );
}

//*****************************************************************************
// Get the enumerated identifier for the currently displayed notebook page.
//
// Return Values:
//   Success - The enumerated page identifier 
//   Failure - ePAGE_NONE

NbkTxtCtls::ePageType  NbkTxtCtls::eGetPage( void )
{
  ePageType  ePage;

  // Check if the object has already been created
  if( ! bIsCreated( ) ) return( ePAGE_NONE );

  switch( GetSelection( ) )
  {
    case 0:  ePage = ePAGE_CONSOLE; break;
    case 1:  ePage = ePAGE_NETLIST; break;
    case 2:  ePage = ePAGE_SIMULTN; break;
    case 3:  ePage = ePAGE_GNUCAP;  break;
    case 4:  ePage = ePAGE_NGSPICE; break;
    default: ePage = ePAGE_NONE;
  }

  return( ePage );
}

//*****************************************************************************
// Get a pointer to the text control currently being displayed.
//
// Argument List:
//   ePage - The enumerated page identifier
//
// Return Values:
//   Success - A pointer to the TextCtrl object
//   Failure - NULL

TextCtrl * NbkTxtCtls::poGetPage( NbkTxtCtls::ePageType ePage )
{
  // Check if the object has already been created
  if( ! bIsCreated( ) )                        return( NULL );

  // Check that the page identifier is valid
  if( ePage == ePAGE_CURRENT ) ePage = eGetPage( );
  if( GetPageCount( ) < ((size_t) ePage + 1) ) return( NULL );

  return( (TextCtrl *) GetPage( (size_t) ePage ) );
}

//*****************************************************************************
