//*****************************************************************************
//                               PrcSimrBase.hpp                              *
//                              -----------------                             *
//  Description : This is the base class for classes which provide the        *
//                interface to the SPICE circuit simulator.                   *
//  Started     : 25/04/2004                                                  *
//  Last Update : 19/08/2009                                                  *
//  Copyright   : (C) 2004 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCSIMRBASE_HPP
#define PRCSIMRBASE_HPP

// System Includes


// wxWindows Includes

#include <wx/wx.h>

// Application Includes

#include "TypeDefs.hpp"
#include "base/PrcBase.hpp"
#include "base/SimnBase.hpp"
#include "netlist/NetList.hpp"

// Local Constant Declarations


//*****************************************************************************

class PrcSimrBase : public PrcBase
{
  protected :

    eSimrType   m_eSimEng;       // Simulation engine specifier

    wxFileName  m_oFnResults;    // The file name of the process output
    wxTextFile  m_oFileResults;  // A text file object for the above

    // Save the console output to file
    bool  bSaveOutput( const wxString & rosFName );
    bool  bErrorCheck( const wxString & rosFName );

  public :

    PrcSimrBase( void );
   ~PrcSimrBase( );

    bool  bSetResultsFile( const wxString & rosFName );

          eSimrType     eGetSimEng     ( void ) { return( m_eSimEng    ); }
    const wxFileName & roGetResultsFile( void ) { return( m_oFnResults ); }

    // Create the process argument list
    virtual  bool  bMakeArgLst( SimnBase & roSimn );

    // Execute the simulation
    virtual  bool  bExec( void );

    // Format the results file
    virtual  bool  bFmtResults( void ) = 0;
};

//*****************************************************************************

#endif // PRCSIMRBASE_HPP
