//*****************************************************************************
//                                HelpTasks.hpp                               *
//                               ---------------                              *
//  Description : This is a helper class for FrmMain, it handles most of the  *
//                required help operations.                                   *
//  Started     : 03/06/2005                                                  *
//  Last Update : 19/08/2009                                                  *
//  Copyright   : (C) 2005 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef HELPTASKS_HPP
#define HELPTASKS_HPP

// System includes

#include <iostream>

// wxWindows includes

#include <wx/wx.h>
#include <wx/config.h>
#include <wx/filefn.h>
#include <wx/html/htmlwin.h>
#ifdef __WXMAC__
  #include <wx/image.h>
#endif

// Application includes

#include "CmdLinePcr.hpp"

class FrmMain;

//*****************************************************************************

class HelpTasks : public wxFrame
{
  private :

    FrmMain     * m_poFrmMain;  // Pointer to application main frame
    wxConfig    * m_poCfg;      // Pointer to the configuration object
    wxHtmlWindow  m_oHtmlWin;   // The HTML viewer window

    // Object initialization functions
    void  Initialize  ( void ); // This function calls the following init. fns
    void  InitToolBar ( void );
    void  InitStatBar ( void );
    void  InitHtmlWin ( void );
    void  InitPosnSize( void );

    wxString & rosGetInstallPath( void );

  public :

    HelpTasks( FrmMain * poFrmMain );
   ~HelpTasks( );

    void  SetAppFrm( FrmMain * poFrmMain ) { m_poFrmMain = poFrmMain; }
    void  SetTitle( void );

    void  Manual( void );
    void  About ( void );

    // Event handlers
    void  OnBack ( wxCommandEvent & roEvtCmd );
    void  OnClose( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eFrmItemID
    {
      ID_TOOLBAR = 1,
      ID_TBR_BACK,
      ID_TBR_CLOSE,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_TOOLBAR,
      ID_LST = ID_TBR_CLOSE
    };

    // Leave this as the last line as private access is envoked by this macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // HELPTASKS_HPP
