//*****************************************************************************
//                              CmdNgSpiceDC.hpp                              *
//                             ------------------                             *
// Description : This class contains values associated with the NG-Spice      *
//               DC command. It inherits from the class CmdBase.              *
// Started     : 23/08/2006                                                   *
// Last Update : 13/05/2009                                                   *
// Copyright   : (C) 2006 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPICEDC_HPP
#define CMDNGSPICEDC_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "gnucap/commands/CmdGnuCapOP.hpp"
#include "gnucap/commands/CmdGnuCapDC.hpp"
#include "utility/ConvertType.hpp"

struct CmdGnuCapOP;
struct CmdGnuCapDC;

// Local Macro and Constant Declarations

//*****************************************************************************

struct CmdNgSpiceDC : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString  m_osStart;   // Sweep start value
    wxString  m_osStop;    // Sweep stop  value
    wxString  m_osStep;    // Sweep step  value
    wxString  m_osSource;  // Sweep source

              CmdNgSpiceDC( void );
    virtual  ~CmdNgSpiceDC( );

    virtual  bool  bClear   ( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdNgSpiceDC & operator = ( const CmdGnuCapOP & roCmdOP );
    CmdNgSpiceDC & operator = ( const CmdGnuCapDC & roCmdDC );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDNGSPICEDC_HPP
