//*****************************************************************************
//                                GNetList.hpp                                *
//                               --------------                               *
// Description : Provides a programatic interface to the utility gnetlist     *
//               which is used to generate netlist file from various          *
//               schematic editor formats.                                    *
// Started     : 29/01/2004                                                   *
// Last Update : 12/10/2009                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCGNETLIST_HPP
#define PRCGNETLIST_HPP

// System Includes

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/regex.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/PrcBase.hpp"

// Local Constant Declarations

#define GNETLST_BIN_NAME    wxT("gnetlist")       // The binary file name
#define GNETLST_LOG_FILE    wxT("gspiceui.log")   // Default log file name
#define GNETLST_GUILE_PROC  wxT("spice-sdb")      // Default Guile procedure
#define GNETLST_USE_SCHEM   wxT("use-schem-name") // Use schem. name for netlist
#define GNETLST_CUR_PROC    100  // A value greater than the no. of Guile proc's

//*****************************************************************************

class PrcGNetList : public PrcBase
{
  private :

    ArrayFileName  m_ofnaSchemFiles;  // The full names of the schematic file/s
    wxFileName     m_ofnNetLstFile;   // The full name  of the list file
    size_t         m_szGuileProc;     // The Guile procedure specifier
    wxArrayString  m_osaGuileProcs;   // Array of all possible Guile procedures

    void  InitGuileProcs( void );

  public :

    PrcGNetList( void );
   ~PrcGNetList( );

    bool  bClear( void );

    bool  bSetGNetList  ( const wxString      &  rosFName  );
    bool  bSetSchemFiles( const wxString      &  rosFNames );
    bool  bSetSchemFiles( const wxArrayString & rosaFNames );
    bool  bSetNetLstFile( const wxString      &  rosFName=GNETLST_USE_SCHEM );
    bool  bSetGuileProc ( const wxString      &  rosGProc=GNETLST_GUILE_PROC );

    const wxFileName    &  rofnGetGNetList  ( void ) { return( rofnGetBinary( ) ); }
    const ArrayFileName & rofnaGetSchemFiles( void ) { return( m_ofnaSchemFiles ); }
    const wxFileName    &  rofnGetSchemFile ( size_t szIndex=0 );
    const wxFileName    &  rofnGetNetLstFile( void ) { return( m_ofnNetLstFile ); }
    const wxArrayString &  rosaGetGuileProcs( void ) { return( m_osaGuileProcs ); }
    const wxString      &   rosGetGuileProc ( size_t szIndex=GNETLST_CUR_PROC );
    size_t  szGetGuileProcCnt( void ) { return( m_osaGuileProcs .GetCount( ) ); }
    size_t  szGetSchemFileCnt( void ) { return( m_ofnaSchemFiles.GetCount( ) ); }

    virtual  bool  bExec( void );
};

//*****************************************************************************

#endif // PRCGNETLIST_HPP
