//*****************************************************************************
//                                ConvertType.hpp                             *
//                               -----------------                            *
//                                                                            *
//  Description : This class is intended to provide useful functionality for  *
//                converting basic types one to another eg. wxString to long. *
//                The strings may contain alpha scale factors eg. K for Kilo. *
//  Started     : 21/09/2004                                                  *
//  Last Update : 17/09/2009                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CONVERTTYPE_HPP
#define CONVERTTYPE_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <cmath>
#include <cfloat>

// wxWindows Includes

#include <wx/wx.h>

// Application Includes


// Local Constant Declarations

#define  CNVTYPE_DFLT_FLTRES  3
#define  CNVTYPE_MIN_FLTRES   1
#define  CNVTYPE_MAX_FLTRES  10

//*****************************************************************************

class ConvertType
{
  private :

    static  int  m_iFltRes;

  public :

    ConvertType( void );
   ~ConvertType( );

    static  int   iGetFltRes( void ) { return( m_iFltRes ); }
    static  bool  bSetFltRes( int iRes );

    static  wxString & rosGetNum( const wxString & rosNum );

    static  bool  bStrToLong   ( const wxString & rosNum, long   * pliNum );
    static  bool  bStrToDFlt   ( const wxString & rosNum, double * pdfNum );
    static  bool  bDFltToStr   ( double dfNum, wxString & rosNum );
    static  bool  bDFltToStrEng( double dfNum, wxString & rosNum );
    static  bool  bParseDFlt   ( double dfNum, float * pfMan, int * piExp );

    static  bool  bStrToInt    ( const wxString & rosNum, int   * piNum );
    static  bool  bStrToFlt    ( const wxString & rosNum, float * pfNum );
    static  bool  bFltToStr    ( float fNum, wxString & rosNum );
    static  bool  bFltToStrEng ( float fNum, wxString & rosNum );
    static  bool  bParseFlt    ( float fNum, float * pfMan, int * piExp );
};

//*****************************************************************************

#endif // CONVERTTYPE_HPP
