/*
 * Copyright (C) 2005 Ronald S. Bultje <rbultje@ronald.bitfreak.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GST_IMAGE_MIXER_H__
#define __GST_IMAGE_MIXER_H__

#include <gst/gst.h>
#include "mixerpad.h"

G_BEGIN_DECLS

#define GST_TYPE_IMAGE_MIXER \
  (gst_image_mixer_get_type ())
#define GST_IMAGE_MIXER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST (obj, GST_TYPE_IMAGE_MIXER, GstImageMixer))
#define GST_IS_IMAGE_MIXER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE (obj, GST_TYPE_IMAGE_MIXER))

typedef struct _GstImageMixer {
  GstElement element;

  /* input, output, subpicture pads */
  GstPad *sink, *src;
  GstData *next_data;
  GstBuffer *last_buf; /* set when next_data is an event */
  GList *subpads;
  guint npad;

  /* main video stream properties */
  GstImageMixerFormat fmt;
} GstImageMixer;

typedef struct _GstImageMixerClass {
  GstElementClass element_class;
} GstImageMixerClass;

GType	gst_image_mixer_get_type	(void);

G_END_DECLS

#endif /* __GST_IMAGE_MIXER_H__ */
