/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2012 Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <config.h>
#include <gthumb.h>
#include "gth-selections-manager.h"


void
gth_browser_activate_action_show_selection (GthBrowser *browser,
					    int         n_selection)
{
	char  *uri;
	GFile *location;

	uri = g_strdup_printf ("selection:///%d", n_selection);
	location = g_file_new_for_uri (uri);
	gth_browser_load_location (browser, location);

	g_free (uri);
	g_object_unref (location);
}


void
gth_browser_activate_action_go_selection_1 (GtkAction  *action,
					    GthBrowser *browser)
{
	gth_browser_activate_action_show_selection (browser, 1);
}


void
gth_browser_activate_action_go_selection_2 (GtkAction  *action,
					    GthBrowser *browser)
{
	gth_browser_activate_action_show_selection (browser, 2);
}


void
gth_browser_activate_action_go_selection_3 (GtkAction  *action,
					    GthBrowser *browser)
{
	gth_browser_activate_action_show_selection (browser, 3);
}


void
gth_browser_activate_action_add_to_selection (GthBrowser *browser,
					      int         n_selection)
{
	char  *uri;
	GFile *folder;
	GList *items;
	GList *file_list = NULL;
	GList *files;

	uri = g_strdup_printf ("selection:///%d", n_selection);
	folder = g_file_new_for_uri (uri);
	items = gth_file_selection_get_selected (GTH_FILE_SELECTION (gth_browser_get_file_list_view (browser)));
	file_list = gth_file_list_get_files (GTH_FILE_LIST (gth_browser_get_file_list (browser)), items);
	files = gth_file_data_list_to_file_list (file_list);
	gth_selections_manager_add_files (folder, files, -1);

	_g_object_list_unref (files);
	_g_object_list_unref (file_list);
	_gtk_tree_path_list_free (items);
	g_object_unref (folder);
	g_free (uri);
}


void
gth_browser_activate_action_add_to_selection_1 (GtkAction  *action,
						GthBrowser *browser)
{
	gth_browser_activate_action_add_to_selection (browser, 1);
}

void
gth_browser_activate_action_add_to_selection_2 (GtkAction  *action,
						GthBrowser *browser)
{
	gth_browser_activate_action_add_to_selection (browser, 2);
}


void
gth_browser_activate_action_add_to_selection_3 (GtkAction  *action,
						GthBrowser *browser)
{
	gth_browser_activate_action_add_to_selection (browser, 3);
}


void
gth_browser_activate_action_remove_from_selection (GthBrowser *browser,
						   int         n_selection)
{
	char  *uri;
	GFile *folder;
	GList *items;
	GList *file_list = NULL;
	GList *files;

	uri = g_strdup_printf ("selection:///%d", n_selection);
	folder = g_file_new_for_uri (uri);
	items = gth_file_selection_get_selected (GTH_FILE_SELECTION (gth_browser_get_file_list_view (browser)));
	file_list = gth_file_list_get_files (GTH_FILE_LIST (gth_browser_get_file_list (browser)), items);
	files = gth_file_data_list_to_file_list (file_list);
	gth_selections_manager_remove_files (folder, files);

	_g_object_list_unref (files);
	_g_object_list_unref (file_list);
	_gtk_tree_path_list_free (items);
	g_object_unref (folder);
	g_free (uri);
}


void
gth_browser_activate_action_selection_go_to_container (GthBrowser *browser,
						       int         n_selection)
{
	GList *items;
	GList *file_list = NULL;

	items = gth_file_selection_get_selected (GTH_FILE_SELECTION (gth_browser_get_file_list_view (browser)));
	file_list = gth_file_list_get_files (GTH_FILE_LIST (gth_browser_get_file_list (browser)), items);

	if (file_list != NULL) {
		GthFileData *first_file = file_list->data;
		GFile       *parent;

		parent = g_file_get_parent (first_file->file);
		gth_browser_go_to (browser, parent, first_file->file);

		g_object_unref (parent);
	}

	_g_object_list_unref (file_list);
	_gtk_tree_path_list_free (items);
}
