/*
 * $Id: whitelist.h 9450 2005-09-10 08:17:29Z daichik $
 *
 * Copyright (c) 2002, Vidar Madsen
 *
 *----------------------------------------------------------------------
 * This file is part of gtk-gnutella.
 *
 *  gtk-gnutella is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  gtk-gnutella is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gtk-gnutella; if not, write to the Free Software
 *  Foundation, Inc.:
 *      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *----------------------------------------------------------------------
 */

/**
 * @ingroup core
 * @file
 *
 * Needs brief description here.
 *
 * Functions for keeping a whitelist of nodes we always allow in,
 * and whom we try to keep a connection to.
 *
 * @author Vidar Madsen
 * @date 2002
 */

#ifndef _core_whitelist_h_
#define _core_whitelist_h_

#include "common.h"
#include "lib/host_addr.h"

/**
 * Number of seconds between each connection attempt to a whitelisted node.
 */
#define WHITELIST_RETRY_DELAY 30

/**
 * Number of seconds between checking the whitelist file for updates.
 */
#define WHITELIST_CHECK_INTERVAL 60

struct whitelist {
    time_t last_try;
    host_addr_t addr;
    guint16 port;
    guint8 bits;
};

gboolean whitelist_check(const host_addr_t addr);
void whitelist_init(void);
void whitelist_close(void);
guint whitelist_connect(void);
void whitelist_reload(void);

#endif /* _core_whitelist_h_ */
/* vi: set ts=4 sw=4 cindent: */
