/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright © 2002-2014 Sylvain Rochet
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <png.h>

typedef struct {
	gint32 width;
	gint32 height;
	guint8 *rgba;
	gboolean rgba_needed;
} _png_imagedata;


gint8 readpng_read(gchar *path, _png_imagedata *png_imagedata);
gint32 readpng_get_width(_png_imagedata *png_imagedata);
gint32 readpng_get_height(_png_imagedata *png_imagedata);
guint8 *readpng_get_rgba(_png_imagedata *png_imagedata);
guint8 *readpng_get_rgba_crop(_png_imagedata *png_imagedata, gint32 x, gint32 y, gint32 width, gint32 height);
void readpng_cleanup(_png_imagedata *png_imagedata);
