/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright © 2002-2014 Sylvain Rochet
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <cairo.h>

#include "config.h"

#include "global.h"
#include "interface.h"
#include "callback.h"
#include "game.h"
#include "client.h"
#include "display.h"

#include "engine.h"

#include "icon.xpm"

#ifdef WIN32
#undef PACKAGE_DATA_DIR
#define PACKAGE_DATA_DIR "./data"
#endif

void interface_create_mainwindow()  {

	global->MainWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(global->MainWin), "GtkAtlantic");
	gtk_widget_set_size_request(global->MainWin, 700, 500);

	g_signal_connect(G_OBJECT(global->MainWin), "delete-event", G_CALLBACK(gtk_main_quit), NULL);

	global->MainBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_add(GTK_CONTAINER(global->MainWin), global->MainBox);

	/* icon */
	global->icon_pixbuf = gdk_pixbuf_new_from_xpm_data((const char **)icon_xpm);
	gtk_window_set_icon(GTK_WINDOW(global->MainWin), global->icon_pixbuf);

	/* used for reparent some widgets shouldn't be displayed */
	global->Trick = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);

	gtk_widget_show_all(global->MainWin);
}


void interface_create_menubar()  {

//	GtkWidget *HandleBar;
		GtkWidget *MenuBar;
			GtkWidget *Button;
				GtkWidget *Menu;
					GtkWidget *MenuItem;

	MenuBar = gtk_menu_bar_new();
	gtk_box_pack_start(GTK_BOX(global->MainBox), MenuBar, FALSE, FALSE, 0);

	/* GAME MENU */
	Button = gtk_menu_item_new_with_label("Game");
	gtk_menu_shell_append(GTK_MENU_SHELL(MenuBar), Button);

	Menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(Button), Menu);

	MenuItem = gtk_menu_item_new_with_label("Change nickname");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_menu_change_nickname), NULL);

	MenuItem = gtk_menu_item_new_with_label("Show estates tree");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_estates_tree), NULL);

	MenuItem = gtk_menu_item_new();
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("(Un)dock Server messages");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_toggle_float_message), NULL);

	MenuItem = gtk_menu_item_new_with_label("(Un)dock Chat");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_toggle_float_chat), NULL);

	MenuItem = gtk_menu_item_new();
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Declare bankrupcy");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_menu_DeclareBankrupcy), NULL);

	MenuItem = gtk_menu_item_new();
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Reconnect (after client crash)");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_menu_reconnect), NULL);

	MenuItem = gtk_menu_item_new_with_label("Leave game (disconnect)");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_menu_LeaveGame), NULL);

	MenuItem = gtk_menu_item_new();
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Exit");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(gtk_main_quit), NULL);

	/* CONFIG MENU */
	Button = gtk_menu_item_new_with_label("Settings");
	gtk_menu_shell_append(GTK_MENU_SHELL(MenuBar), Button);

	Menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(Button), Menu);

	MenuItem = gtk_menu_item_new_with_label("Preferences");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(Callback_ShowConfiguration), NULL);

//	MenuItem = gtk_menu_item_new_with_label("Themes (unavailable yet)");
//	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
//	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(Callback_menu_Themes), NULL);

	/* HELP MENU */
	Button = gtk_menu_item_new_with_label("Help");
	gtk_menu_shell_append(GTK_MENU_SHELL(MenuBar), Button);

	Menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(Button), Menu);

	MenuItem = gtk_menu_item_new_with_label("Index");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(interface_create_helpwin), NULL);

	MenuItem = gtk_menu_item_new_with_label("About");
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), MenuItem);
	g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(interface_create_aboutwin), NULL);

	gtk_widget_show_all(MenuBar);
}


void interface_create_logo()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *FrameLogo;
			GtkWidget *AlignementLogo;
				//global->gdkrgb_logo
				//global->pixmap_logo
				//global->mask_logo
		GtkWidget *AlignementEnterButton;
			GtkWidget *EnterButton;

	eng_frame *frame;
	eng_obj *pic;

	interface_unparent_message();
	interface_unparent_chat();

	global->phase = PHASE_LOGO;

	global->MainVerticalBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);
	g_signal_connect(G_OBJECT(global->MainVerticalBox), "destroy", G_CALLBACK(CallBack_logo_page_destroyed), NULL);

	/* logo */
	AlignementLogo = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), AlignementLogo, TRUE, TRUE, 0);

	FrameLogo = gtk_frame_new(NULL);
	gtk_container_add(GTK_CONTAINER(AlignementLogo), FrameLogo);

	global->gdkrgb_logo = gtk_drawing_area_new();
	gtk_widget_set_size_request( GTK_WIDGET(global->gdkrgb_logo), data->logo_width +20, data->logo_height +20);
	gtk_container_add(GTK_CONTAINER(FrameLogo), global->gdkrgb_logo);
	g_signal_connect(G_OBJECT( global->gdkrgb_logo), "draw", G_CALLBACK(on_logo_draw), NULL);

	/* enter button */
	AlignementEnterButton = gtk_alignment_new(0.9, 0.5, 0.0, 0.0);
	gtk_widget_set_size_request(AlignementEnterButton, -1, 100);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), AlignementEnterButton, FALSE, FALSE, 0);

	EnterButton = gtk_button_new_with_label("Enter");
	gtk_widget_set_size_request(EnterButton, 150, 30);
	gtk_container_add(GTK_CONTAINER(AlignementEnterButton), EnterButton);
	g_signal_connect(G_OBJECT(EnterButton), "clicked", G_CALLBACK(Callback_EnterButton), NULL);

	/* frame */
	frame = global->logo_frame = eng_frame_create();
	eng_frame_set_width(frame, data->logo_width + 20);
	eng_frame_set_height(frame, data->logo_height + 20);

	/* logo */
	pic = global->logo_pic = eng_pic_create(frame);
	eng_pic_set_x(pic, 10);
	eng_pic_set_y(pic, 10);
	eng_pic_set_z(pic, 0);
	eng_pic_set_width(pic, data->logo_width);
	eng_pic_set_height(pic, data->logo_height);
	eng_pic_set_buf(pic, data->pngfile_logo_buf);

	/* draw logo frame */
	eng_create_frame(frame);

	gtk_widget_show_all(global->MainVerticalBox);
}


void interface_create_getgamespage()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *GameFrame;
			GtkWidget *GameScrollwin;
				GtkWidget *GameVbox;
					//GameList
		GtkWidget *ButtonAndEntryHorizontalBox;
			GtkWidget *MetaServerFrame;
				GtkWidget *MetaServerHorizontalBox;
					GtkWidget *RefreshGameButton;
					GtkWidget *ShowServerButton;
			GtkWidget *CustomServerFrame;
				GtkWidget *CustomServerHorizontalBox;
					GtkWidget *HostLabel;
					GtkWidget *HostEntry;
					GtkWidget *PortEntry;
					GtkWidget *GetgameButton;
			GtkWidget *ConnectButton;
		GtkWidget *MessageFrame;

	gchar *text;
	GtkTreeSelection *select;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkListStore *store;

	global->phase = PHASE_GETGAMES;

	interface_unparent_message();
	interface_unparent_chat();

	gtk_widget_destroy(global->MainVerticalBox);
	global->MainVerticalBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);

	/* list of open game & gametype */
	GameFrame = gtk_frame_new("Start or Select a monopd game");
	gtk_container_set_border_width(GTK_CONTAINER(GameFrame), 15);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), GameFrame, TRUE, TRUE, 0);

	/* Game and server list container */
	GameScrollwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(GameScrollwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width(GTK_CONTAINER(GameScrollwin), 10);
	gtk_container_add(GTK_CONTAINER(GameFrame), GameScrollwin);

	GameVbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_add(GTK_CONTAINER(GameScrollwin), GameVbox);

	/* Game list */
	global->GameList = gtk_tree_view_new();
	gtk_box_pack_start(GTK_BOX(GameVbox), global->GameList, TRUE, TRUE, 0);
	select = gtk_tree_view_get_selection(GTK_TREE_VIEW(global->GameList));
	gtk_tree_selection_set_mode(select, GTK_SELECTION_SINGLE);
	g_signal_connect(G_OBJECT(select), "changed", G_CALLBACK(Callback_GetGame_Select), NULL);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Host", renderer, "text", GAMELIST_COLUMN_HOST, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->GameList), column);
	column = gtk_tree_view_column_new_with_attributes("Version", renderer, "text", GAMELIST_COLUMN_VERSION, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->GameList), column);
	column = gtk_tree_view_column_new_with_attributes("Game", renderer, "text", GAMELIST_COLUMN_GAME, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->GameList), column);
	column = gtk_tree_view_column_new_with_attributes("Description", renderer, "text", GAMELIST_COLUMN_DESCRIPTION, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->GameList), column);
	column = gtk_tree_view_column_new_with_attributes("Players", renderer, "text", GAMELIST_COLUMN_PLAYERS, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->GameList), column);

	store = gtk_list_store_new(GAMELIST_COLUMN_NUM, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING, G_TYPE_INT, G_TYPE_INT);
	gtk_tree_view_set_model(GTK_TREE_VIEW(global->GameList), GTK_TREE_MODEL(store));
	g_object_unref(store);

	/* Server list */
	global->ServerList = gtk_tree_view_new();
	gtk_box_pack_start(GTK_BOX(GameVbox), global->ServerList, TRUE, TRUE, 0);
	select = gtk_tree_view_get_selection(GTK_TREE_VIEW(global->ServerList));
	gtk_tree_selection_set_mode(select, GTK_SELECTION_NONE);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Host", renderer, "text", SERVERLIST_COLUMN_HOST, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->ServerList), column);
	column = gtk_tree_view_column_new_with_attributes("Port", renderer, "text", SERVERLIST_COLUMN_PORT, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->ServerList), column);
	column = gtk_tree_view_column_new_with_attributes("Version", renderer, "text", SERVERLIST_COLUMN_VERSION, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->ServerList), column);
	column = gtk_tree_view_column_new_with_attributes("Users", renderer, "text", SERVERLIST_COLUMN_USERS, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(global->ServerList), column);

	store = gtk_list_store_new(SERVERLIST_COLUMN_NUM, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING, G_TYPE_INT);
	gtk_tree_view_set_model(GTK_TREE_VIEW(global->ServerList), GTK_TREE_MODEL(store));
	g_object_unref(store);

	/* horizontal box for button / entry */
	ButtonAndEntryHorizontalBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), ButtonAndEntryHorizontalBox, FALSE, FALSE, 0);

	/* meta server frame */
	MetaServerFrame = gtk_frame_new("Meta server");
	gtk_box_pack_start(GTK_BOX(ButtonAndEntryHorizontalBox), MetaServerFrame, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(MetaServerFrame), BORDER);

	/* meta server horizontal box */
	MetaServerHorizontalBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, BORDER);
	gtk_container_set_border_width(GTK_CONTAINER(MetaServerHorizontalBox), BORDER);
	gtk_container_add(GTK_CONTAINER(MetaServerFrame), MetaServerHorizontalBox);

	/* refresh button */
	ShowServerButton = gtk_button_new_with_label("Servers list");
//	gtk_widget_set_size_request(ShowServerButton, 120, -1);
	gtk_box_pack_start(GTK_BOX(MetaServerHorizontalBox), ShowServerButton, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(ShowServerButton), "clicked", G_CALLBACK(Callback_ShowMetaServer), NULL);

	/* refresh button */
	RefreshGameButton = gtk_button_new_with_label("Refresh games");
//	gtk_widget_set_size_request(RefreshGameButton, 120, -1);
	gtk_box_pack_start(GTK_BOX(MetaServerHorizontalBox), RefreshGameButton, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(RefreshGameButton), "clicked", G_CALLBACK(Callback_RefreshGameMetaServer), NULL);

	/* custom server frame */
	CustomServerFrame = gtk_frame_new("Custom server");
	gtk_box_pack_start(GTK_BOX(ButtonAndEntryHorizontalBox), CustomServerFrame, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(CustomServerFrame), BORDER);

	/* Custom server horizontal box */
	CustomServerHorizontalBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, BORDER);
	gtk_container_set_border_width(GTK_CONTAINER(CustomServerHorizontalBox), BORDER);
	gtk_container_add(GTK_CONTAINER(CustomServerFrame), CustomServerHorizontalBox);

	/* label/entry host, label/entry port, get games button */
	HostLabel = gtk_label_new("host/port");
	gtk_box_pack_start(GTK_BOX(CustomServerHorizontalBox), HostLabel, FALSE, FALSE, 0);

	HostEntry = gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(HostEntry), 10);
	gtk_box_pack_start(GTK_BOX(CustomServerHorizontalBox), HostEntry, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(HostEntry), config->getgames_host);

	PortEntry = gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(PortEntry), 4);
	gtk_box_pack_start(GTK_BOX(CustomServerHorizontalBox), PortEntry, FALSE, FALSE, 0);
	text = g_strdup_printf("%d", config->getgames_port);
	gtk_entry_set_text(GTK_ENTRY(PortEntry), text);
	g_free(text);

	GetgameButton = gtk_button_new_with_label("Get games");
	gtk_box_pack_start(GTK_BOX(CustomServerHorizontalBox), GetgameButton, FALSE, FALSE, 0);
	g_object_set_data(G_OBJECT(GetgameButton), "host", HostEntry);
	g_object_set_data(G_OBJECT(GetgameButton), "port", PortEntry);
	g_signal_connect(G_OBJECT(GetgameButton), "clicked", G_CALLBACK(Callback_GetgamesButton), NULL);

	/* big connect button */
	ConnectButton = gtk_button_new_with_label("CREATE/JOIN GAME");
	gtk_widget_set_size_request(ConnectButton, 150, -1);
	gtk_container_set_border_width(GTK_CONTAINER(ConnectButton), BORDER);
	gtk_box_pack_start(GTK_BOX(ButtonAndEntryHorizontalBox), ConnectButton, FALSE, TRUE, 0);
	g_signal_connect(G_OBJECT(ConnectButton), "clicked", G_CALLBACK(Callback_ConnectButton), NULL);

	/* message text */
	MessageFrame = gtk_frame_new("Messages");
	gtk_container_set_border_width(GTK_CONTAINER(MessageFrame), BORDER);
	gtk_widget_set_size_request(MessageFrame, -1, 125);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), MessageFrame, FALSE, FALSE, 0);

	interface_create_message(MessageFrame);

	gtk_widget_show_all(global->MainVerticalBox);
	gtk_widget_hide(global->ServerList);

	/* autoconnect to server (getgamelist / getserverlist) */
	if(config->metaserver_autogetlist)  {

		create_connection_metaserver(CONNECT_TYPE_META_GETLIST);
		return;
	}

	if(config->metaserver_autogetgames)
		create_connection_metaserver(CONNECT_TYPE_META_GETGAME);

	if(config->getgames_autogetgames)
		create_connection_get_games(config->getgames_host, config->getgames_port);
}


void interface_create_gameconfigpage()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *HorizontalBox;
			GtkWidget *VerticalBoxLeft;
				GtkWidget *MessageFrame;
					//global->MessageBox;
				GtkWidget *ChatFrame;
					//currentgame->ChatBox
			GtkWidget *VerticalBoxRight;
				GtkWidget *AlignementListFrame;
					GtkWidget *PlayerScrollwin;
						GtkWidget *PlayerListFrame;
				GtkWidget *ConfigurationFrame;
					GtkWidget *ConfigurationScrolledWin;
						//currentgame->GameConfigBox
				GtkWidget *HorizontalBoxButton;
					GtkWidget *StartButton;
					GtkWidget *LeaveButton;


	GtkTreeSelection *select;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkListStore *store;

	global->phase = PHASE_GAMECREATE;

	interface_unparent_message();
	interface_unparent_chat();

	gtk_widget_destroy(global->MainVerticalBox);
	global->MainVerticalBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);

	/* main horizontal box */
	HorizontalBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), HorizontalBox, TRUE, TRUE, 0);

	/* vertical box for messages */
	VerticalBoxLeft = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(HorizontalBox), VerticalBoxLeft, TRUE, TRUE, 0);

	/* message frame */
	MessageFrame = gtk_frame_new("Server Messages");
	gtk_container_set_border_width(GTK_CONTAINER(MessageFrame), 10);
	gtk_widget_set_size_request(MessageFrame , -1, 130);
	gtk_box_pack_start(GTK_BOX(VerticalBoxLeft), MessageFrame, FALSE, TRUE, 0);

//	gtk_text_set_point(GTK_TEXT(global->Message), 0);
//	gtk_text_forward_delete(GTK_TEXT(global->Message), gtk_text_get_length(GTK_TEXT(global->Message)) );
	global->message_nb_lines = 0;
	interface_create_message(MessageFrame);

	/* chat frame */
	ChatFrame = gtk_frame_new("Chat");
	gtk_container_set_border_width(GTK_CONTAINER(ChatFrame), 10);
	gtk_box_pack_start(GTK_BOX(VerticalBoxLeft), ChatFrame, TRUE, TRUE, 0);
	interface_create_chat(ChatFrame);


	/* vertical box right */
	VerticalBoxRight = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(HorizontalBox), VerticalBoxRight, FALSE, TRUE, 0);

	/* player list frame */
	PlayerListFrame = gtk_frame_new("Players");
	gtk_container_set_border_width(GTK_CONTAINER(PlayerListFrame), 10);
	gtk_widget_set_size_request(PlayerListFrame, 380, 240);
	gtk_box_pack_start(GTK_BOX(VerticalBoxRight), PlayerListFrame, FALSE, TRUE, 0);

	AlignementListFrame = gtk_alignment_new(0.0, 0.0, 1.0, 1.0);
	gtk_container_set_border_width(GTK_CONTAINER(AlignementListFrame), 10);
	gtk_container_add(GTK_CONTAINER(PlayerListFrame), AlignementListFrame);

	PlayerScrollwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(PlayerScrollwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(AlignementListFrame), PlayerScrollwin);

	/* player list */
	currentgame->PlayerList = gtk_tree_view_new();
	gtk_container_add(GTK_CONTAINER(PlayerScrollwin), currentgame->PlayerList);
	select = gtk_tree_view_get_selection(GTK_TREE_VIEW(currentgame->PlayerList));
	gtk_tree_selection_set_mode(select, GTK_SELECTION_NONE);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Name", renderer, "text", PLAYERLIST_COLUMN_NAME, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(currentgame->PlayerList), column);
	column = gtk_tree_view_column_new_with_attributes("Host", renderer, "text", PLAYERLIST_COLUMN_HOST, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(currentgame->PlayerList), column);

	store = gtk_list_store_new(PLAYERLIST_COLUMN_NUM, G_TYPE_STRING, G_TYPE_STRING);
	gtk_tree_view_set_model(GTK_TREE_VIEW(currentgame->PlayerList), GTK_TREE_MODEL(store));
	g_object_unref(store);

	/* game configuration frame */
	ConfigurationFrame = gtk_frame_new("Game Configuration");
	gtk_container_set_border_width(GTK_CONTAINER(ConfigurationFrame), 10);
	gtk_box_pack_start(GTK_BOX(VerticalBoxRight), ConfigurationFrame, TRUE, TRUE, 0);

	ConfigurationScrolledWin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ConfigurationScrolledWin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(ConfigurationFrame), ConfigurationScrolledWin);

	/* config box might already been created by <configupdate/> early events */
	if (!currentgame->GameConfigBox) {
		currentgame->GameConfigBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	}
	gtk_container_set_border_width(GTK_CONTAINER(currentgame->GameConfigBox), 10);
	gtk_container_add(GTK_CONTAINER(ConfigurationScrolledWin), currentgame->GameConfigBox);

	/* horizontal box button */
	HorizontalBoxButton = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(HorizontalBoxButton), 30);
	gtk_box_set_spacing(GTK_BOX(HorizontalBoxButton), 30);
	gtk_box_pack_start(GTK_BOX(VerticalBoxRight), HorizontalBoxButton, FALSE, TRUE, 0);

	/* leave button */
	LeaveButton = gtk_button_new_with_label("LEAVE GAME");
	gtk_widget_set_size_request(LeaveButton, -1, 30);
	gtk_box_pack_start(GTK_BOX(HorizontalBoxButton), LeaveButton, TRUE, TRUE, 0);
	g_signal_connect(G_OBJECT(LeaveButton), "clicked", G_CALLBACK(CallBack_menu_LeaveGame), NULL);

	/* start button */
	StartButton = gtk_button_new_with_label("START GAME");
	gtk_widget_set_size_request(StartButton, -1, 30);
	gtk_widget_set_sensitive(StartButton, (global->my_playerid == currentgame->master));
	gtk_box_pack_start(GTK_BOX(HorizontalBoxButton), StartButton, TRUE, TRUE, 0);
	g_signal_connect(G_OBJECT(StartButton), "clicked", G_CALLBACK(Callback_StartButton), NULL);
	g_object_set_data(G_OBJECT(global->MainVerticalBox), "start_button", StartButton);

	gtk_widget_show_all(global->MainVerticalBox);
}


void interface_create_gameinitpage()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *Alignment;
			GtkWidget *Label;

	global->phase = PHASE_GAMEINIT;

	interface_unparent_message();
	interface_unparent_chat();

	gtk_widget_destroy(global->MainVerticalBox);
	global->MainVerticalBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);

	/* text */
	Alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), Alignment, TRUE, TRUE, 0);

	Label = gtk_label_new("Please wait while loading...");
	gtk_container_add(GTK_CONTAINER(Alignment), Label);

	gtk_widget_show_all(global->MainVerticalBox);

	/* We are going to receive <display/> events before game is in running state */	
	currentgame->BoardCenter = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	display_init();

	while(gtk_events_pending()) gtk_main_iteration();
}


void interface_create_gameboardpage()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *MainHorizontalBox;
			GtkWidget *VerticalBoxPlayerlistMessageChat;
				GtkWidget *PlayerVerticalBox;
					GtkWidget *PlayerHorizontalBox;
						GtkWidget *AlignementTokenPlayer;
							//global->player[].playerlist_token_gdkrgb
						GtkWidget *PlayerGrid;
							//global->player[i].playerlist_AlignementNamePlayer;
								//global->player[].playerlist_LabelNamePlayer
							//global->player[i].playerlist_AlignementMoneyPlayer;
								//global->player[].playerlist_LabelMoneyPlayer
							//global->player[].playerlist_cards_gdkrgb
						GtkWidget *PlayerPopupMenu;
					GtkWidget *PlayerSeparator;
				//currentgame->BoxMessageAndChat
					//call interface_message_and_chat_float_unfloat
			GtkWidget *VerticalBoxBoard;
				GtkWidget *FixedBoard;
					GtkWidget *EventBox;
						//currentgame->BoardCenter;
						//currentgame->estate[].gdkrgb
							GtkWidget *EstatePopupMenu;
				GtkWidget *CmdButton;

	GtkWidget *Alignment;

	eng_frame *frame;
	eng_obj *pic;
	gint32 i, j, t, token, star, houses;
	gchar *text, *tmp1, *tmp2;

	GtkWidget *MenuItem;
	gint32 nb_players;

	global->phase = PHASE_GAMEPLAY;
	game_sort_playerlist_by_playerid();

	interface_unparent_message();
	interface_unparent_chat();

	gtk_widget_destroy(global->MainVerticalBox);
	global->MainVerticalBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);

	/* horizontal box for board / player status */
	MainHorizontalBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), MainHorizontalBox, TRUE, TRUE, 0);

	/* vertical box for player / messages / chat */
	VerticalBoxPlayerlistMessageChat = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	if(config->game_playerlist_position == GAME_PLAYERLIST_POS_RIGHT)
		gtk_box_pack_end(GTK_BOX(MainHorizontalBox), VerticalBoxPlayerlistMessageChat, TRUE, TRUE, 0);
	else /* left (default) */
		gtk_box_pack_start(GTK_BOX(MainHorizontalBox), VerticalBoxPlayerlistMessageChat, TRUE, TRUE, 0);
	gtk_widget_set_hexpand(VerticalBoxPlayerlistMessageChat, TRUE);
	gtk_widget_set_vexpand(VerticalBoxPlayerlistMessageChat, TRUE);

	/* player status */
	PlayerVerticalBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(PlayerVerticalBox), BORDER);
	gtk_box_pack_start(GTK_BOX(VerticalBoxPlayerlistMessageChat), PlayerVerticalBox, FALSE, FALSE, 0);

	/* player list game */
	for(i = 0, token = 0; i < MAX_PLAYERS ; i++)  {

		if(! global->player[i].playerid) continue;
		if (global->player[i].spectator) continue;
		if(global->player[i].game != currentgame->gameid) continue;

		global->player[i].buffer_token = token;
		global->player[i].buffer_star = token;

		/* separator */
		PlayerSeparator = gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
		gtk_box_pack_start(GTK_BOX(PlayerVerticalBox), PlayerSeparator, FALSE, FALSE, 0);

		/* alignment */
		Alignment = gtk_alignment_new(0.0, 0.5, 0.0, 1.0);
		gtk_box_pack_start(GTK_BOX(PlayerVerticalBox), Alignment, FALSE, TRUE, 0);

		/* event box */
		EventBox = gtk_event_box_new();
		g_signal_connect(G_OBJECT(EventBox), "button_press_event", G_CALLBACK(Callback_ClicOnPlayer), NULL);
		gtk_container_add(GTK_CONTAINER(Alignment), EventBox);

		/* box which contain all widgets for a player */
		PlayerHorizontalBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
		gtk_container_add(GTK_CONTAINER(EventBox), PlayerHorizontalBox);

		/* building popup player menu */
		PlayerPopupMenu = gtk_menu_new();
		g_object_set_data(G_OBJECT(PlayerPopupMenu), "playerid", GINT_TO_POINTER(global->player[i].playerid));
		g_object_set_data(G_OBJECT(EventBox), "menu", PlayerPopupMenu);

		MenuItem = gtk_menu_item_new_with_label("Initiate a trade");
		gtk_menu_shell_append(GTK_MENU_SHELL(PlayerPopupMenu), MenuItem);
		g_object_set_data(G_OBJECT(MenuItem), "action", GINT_TO_POINTER(PLAYER_ACTION_TRADE));
		g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_PopupMenuPlayer), NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(PlayerPopupMenu), MenuItem);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("Request version");
		gtk_menu_shell_append(GTK_MENU_SHELL(PlayerPopupMenu), MenuItem);
		g_object_set_data(G_OBJECT(MenuItem), "action", GINT_TO_POINTER(PLAYER_ACTION_VERSION));
		g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_PopupMenuPlayer), NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("Request date");
		gtk_menu_shell_append(GTK_MENU_SHELL(PlayerPopupMenu), MenuItem);
		g_object_set_data(G_OBJECT(MenuItem), "action", GINT_TO_POINTER(PLAYER_ACTION_DATE));
		g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_PopupMenuPlayer), NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("Request ping");
		gtk_menu_shell_append(GTK_MENU_SHELL(PlayerPopupMenu), MenuItem);
		g_object_set_data(G_OBJECT(MenuItem), "action", GINT_TO_POINTER(PLAYER_ACTION_PING));
		g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_PopupMenuPlayer), NULL);
		gtk_widget_show(MenuItem);

		/* token player in playerlist */
		AlignementTokenPlayer = gtk_alignment_new(1.0, 1.0, 0.0, 0.0);
		gtk_box_pack_start(GTK_BOX(PlayerHorizontalBox), AlignementTokenPlayer, TRUE, TRUE, 0);
		global->player[i].playerlist_token_gdkrgb = gtk_drawing_area_new();
		gtk_widget_set_size_request( GTK_WIDGET(global->player[i].playerlist_token_gdkrgb), data->playerlist_token_width,  data->playerlist_token_height );
		gtk_container_add(GTK_CONTAINER(AlignementTokenPlayer), global->player[i].playerlist_token_gdkrgb);
		g_signal_connect(G_OBJECT(global->player[i].playerlist_token_gdkrgb), "draw", G_CALLBACK(on_playertoken_draw), NULL);
		g_object_set_data(G_OBJECT(global->player[i].playerlist_token_gdkrgb), "playerid", GINT_TO_POINTER(i));

		/* name, money, cards owned by player */
		PlayerGrid = gtk_grid_new();
		gtk_grid_set_row_spacing(GTK_GRID(PlayerGrid), 0);
		gtk_grid_set_column_spacing(GTK_GRID(PlayerGrid), 0);
		gtk_box_pack_start(GTK_BOX(PlayerHorizontalBox), PlayerGrid, FALSE, FALSE, 0);

		/* cards */
		global->player[i].playerlist_cards_gdkrgb = gtk_drawing_area_new();
		gtk_widget_set_size_request( GTK_WIDGET(global->player[i].playerlist_cards_gdkrgb), data->playerlist_cards_width,  data->playerlist_cards_height );
		gtk_grid_attach(GTK_GRID(PlayerGrid),  global->player[i].playerlist_cards_gdkrgb,  0,  1,  2,  1);
		g_signal_connect(G_OBJECT(global->player[i].playerlist_cards_gdkrgb), "draw", G_CALLBACK(on_playercards_draw), NULL);
		g_object_set_data(G_OBJECT(global->player[i].playerlist_cards_gdkrgb), "playerid", GINT_TO_POINTER(i));

		/* name */
		global->player[i].playerlist_AlignementNamePlayer = gtk_alignment_new(0.0, 0.0, 0.0, 0.0);
		gtk_grid_attach(GTK_GRID(PlayerGrid),  global->player[i].playerlist_AlignementNamePlayer,  0,  0,  1,  1);
		global->player[i].playerlist_LabelNamePlayer = gtk_label_new(NULL);
		g_object_set_data(G_OBJECT(global->player[i].playerlist_AlignementNamePlayer), "namelabel", global->player[i].playerlist_LabelNamePlayer);
		gtk_container_add(GTK_CONTAINER(global->player[i].playerlist_AlignementNamePlayer), global->player[i].playerlist_LabelNamePlayer);

		if(global->player[i].hasturn) {
			gchar *tmp = g_markup_printf_escaped("<span foreground=\"#ff0000\">%s</span>", global->player[i].name);
			gtk_label_set_markup(GTK_LABEL(global->player[i].playerlist_LabelNamePlayer), tmp);
			g_free(tmp);
		} else {
			gchar *tmp = g_markup_printf_escaped("<span foreground=\"#000000\">%s</span>", global->player[i].name);
			gtk_label_set_markup(GTK_LABEL(global->player[i].playerlist_LabelNamePlayer), tmp);
			g_free(tmp);
		}

		/* money */
		global->player[i].playerlist_AlignementMoneyPlayer = gtk_alignment_new(1.0, 0.0, 0.0, 0.0);
		gtk_grid_attach(GTK_GRID(PlayerGrid),  global->player[i].playerlist_AlignementMoneyPlayer,  1,  0,  1,  1);
		global->player[i].playerlist_LabelMoneyPlayer = gtk_label_new(NULL);
		g_object_set_data(G_OBJECT(global->player[i].playerlist_AlignementMoneyPlayer), "moneylabel", global->player[i].playerlist_LabelMoneyPlayer);
		gtk_container_add(GTK_CONTAINER(global->player[i].playerlist_AlignementMoneyPlayer), global->player[i].playerlist_LabelMoneyPlayer);

		if(global->player[i].hasturn) {
			gchar *tmp = g_markup_printf_escaped("<span foreground=\"#ff0000\">%d</span>", global->player[i].money);
			gtk_label_set_markup(GTK_LABEL(global->player[i].playerlist_LabelMoneyPlayer), tmp);
			g_free(tmp);
		} else {
			gchar *tmp = g_markup_printf_escaped("<span foreground=\"#000000\">%d</span>", global->player[i].money);
			gtk_label_set_markup(GTK_LABEL(global->player[i].playerlist_LabelMoneyPlayer), tmp);
			g_free(tmp);
		}

		/* playerlist token frame */
		frame = global->player[i].playerlist_token_frame = eng_frame_create();
		eng_frame_set_width(frame, data->playerlist_token_width);
		eng_frame_set_height(frame, data->playerlist_token_height);

		/* playerlist token pic */
		pic = global->player[i].playerlist_token_pic = eng_pic_create(frame);
		eng_pic_set_x(pic, (data->playerlist_token_width - data->pngfile_token_width[token]) / 2);
		eng_pic_set_y(pic, (data->playerlist_token_height - data->pngfile_token_height[token]) / 2);
		eng_pic_set_z(pic, 0);
		eng_pic_set_width(pic, data->pngfile_token_width[token]);
		eng_pic_set_height(pic, data->pngfile_token_height[token]);
		eng_pic_set_buf(pic, data->pngfile_token_buf[token]);

		/* playerlist first draw */
		eng_create_frame(frame);

		/* engine frame cards */
		frame = global->player[i].playerlist_cards_frame = eng_frame_create();
		eng_frame_set_width(frame, data->playerlist_cards_width);
		eng_frame_set_height(frame, data->playerlist_cards_height);

		/* cards */
		for(j = 0 ; j < data->number_playerlist_card ; j++)  {

			pic = global->player[i].playerlist_cards_pic[j] = eng_pic_create(frame);
			eng_pic_set_x(pic, data->playerlist_card[j].x);
			eng_pic_set_y(pic, data->playerlist_card[j].y);
			eng_pic_set_z(pic, data->playerlist_card[j].z);
			t = data->playerlist_card[j].buffer_card;
			eng_pic_set_width(pic, data->pngfile_card_width[t]);
			eng_pic_set_height(pic, data->pngfile_card_height[t]);

			if(currentgame->estate[ data->playerlist_card[j].estateid ].owner  ==  (gint32)global->player[i].playerid)  {

				if(currentgame->estate[ data->playerlist_card[j].estateid ].mortgaged)  {

					eng_pic_set_alpha(pic, data->playerlist_cards_alphamortgage);
					eng_pic_set_bgcolor(pic, data->playerlist_cards_cardbgcolormortgage);
				}
				else  {

					eng_pic_set_alpha(pic, data->playerlist_cards_alphaowned);
					eng_pic_set_bgcolor(pic, data->playerlist_cards_cardbgcolor);
				}
			}
			else  {

				eng_pic_set_alpha(pic, data->playerlist_cards_alphaunowned);
				eng_pic_set_bgcolor(pic, data->playerlist_cards_cardbgcolor);
			}

			eng_pic_set_buf(pic, data->pngfile_card_buf[t]);
		}

		/* Next token */
		token++;

		/* cards first draw */
		eng_create_frame(frame);
	}

	/* last separator */
	PlayerSeparator = gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
	gtk_box_pack_start(GTK_BOX(PlayerVerticalBox), PlayerSeparator, FALSE, FALSE, 0);

	/* message and chat box */
	currentgame->BoxMessageAndChat = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(VerticalBoxPlayerlistMessageChat), currentgame->BoxMessageAndChat, TRUE, TRUE, 0);

	nb_players = game_nb_players();
	if(nb_players <= 5)  {

		currentgame->message_float = 0;
		currentgame->chat_float = 0;
	}
	else if(nb_players <= 7)  {

		currentgame->message_float = 0;
		currentgame->chat_float = 1;
	}
	else  {

		currentgame->message_float = 1;
		currentgame->chat_float = 1;
	}
	interface_message_and_chat_float_unfloat();


	/* vertical box for board / left space */
	VerticalBoxBoard = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_pack_start(GTK_BOX(MainHorizontalBox), VerticalBoxBoard, FALSE, FALSE, 0);

	Alignment = gtk_alignment_new(0.0, 0.0, 1.0, 1.0);
	gtk_box_pack_start(GTK_BOX(VerticalBoxBoard), Alignment, TRUE, TRUE, 0);

	FixedBoard = gtk_fixed_new();
	gtk_container_add(GTK_CONTAINER(Alignment), FixedBoard);
	gtk_container_set_border_width(GTK_CONTAINER(FixedBoard), BORDER);

	/* board estates - drawing area */
	for(i = 0 ; i < data->number_estates ; i++)  {

		j = data->estate[i].buffer_board;

		EventBox = gtk_event_box_new();
		gtk_fixed_put(GTK_FIXED(FixedBoard), EventBox, data->estate[i].x, data->estate[i].y);

		currentgame->estate[i].gdkrgb = gtk_drawing_area_new();
		gtk_widget_set_size_request( GTK_WIDGET(currentgame->estate[i].gdkrgb), data->pngfile_board_width[j],  data->pngfile_board_height[j] );

		gtk_widget_set_events(GTK_WIDGET(currentgame->estate[i].gdkrgb), GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK);

		g_object_set_data(G_OBJECT(EventBox), "estateid", GINT_TO_POINTER(i));
		g_object_set_data(G_OBJECT(currentgame->estate[i].gdkrgb), "estateid", GINT_TO_POINTER(i));

		g_signal_connect_after(G_OBJECT(EventBox), "enter_notify_event", G_CALLBACK(Callback_EnterAnEstate), NULL);
		g_signal_connect(G_OBJECT(EventBox), "leave_notify_event", G_CALLBACK(Callback_LeaveAnEstate), NULL);
		g_signal_connect(G_OBJECT(EventBox), "button_press_event", G_CALLBACK(Callback_ClicOnEstate), NULL);
		g_signal_connect(G_OBJECT(currentgame->estate[i].gdkrgb), "draw", G_CALLBACK(on_board_draw), NULL);

		gtk_container_add(GTK_CONTAINER(EventBox),  currentgame->estate[i].gdkrgb);

		/* building estate popup menu */
		EstatePopupMenu = gtk_menu_new();
		g_object_set_data(G_OBJECT(EstatePopupMenu), "estateid", GINT_TO_POINTER(i));
		g_object_set_data(G_OBJECT(EventBox), "menu", EstatePopupMenu);

		MenuItem = gtk_menu_item_new_with_label("Build house");
		gtk_menu_shell_append(GTK_MENU_SHELL(EstatePopupMenu), MenuItem);
		g_object_set_data(G_OBJECT(MenuItem), "action", GINT_TO_POINTER(ESTATE_ACTION_BUILDHOUSE));
		g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_PopupMenuEstate), NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("Sell house");
		gtk_menu_shell_append(GTK_MENU_SHELL(EstatePopupMenu), MenuItem);
		g_object_set_data(G_OBJECT(MenuItem), "action", GINT_TO_POINTER(ESTATE_ACTION_SELLHOUSE));
		g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_PopupMenuEstate), NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("(Un)mortage");
		gtk_menu_shell_append(GTK_MENU_SHELL(EstatePopupMenu), MenuItem);
		g_object_set_data(G_OBJECT(MenuItem), "action", GINT_TO_POINTER(ESTATE_ACTION_MORTGAGE));
		g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_PopupMenuEstate), NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("Sell property");
		gtk_menu_shell_append(GTK_MENU_SHELL(EstatePopupMenu), MenuItem);
		g_object_set_data(G_OBJECT(MenuItem), "action", GINT_TO_POINTER(ESTATE_ACTION_SELL));
		g_signal_connect(G_OBJECT(MenuItem), "activate", G_CALLBACK(CallBack_PopupMenuEstate), NULL);
		gtk_widget_show(MenuItem);

		/* set ToolTips */
		text = g_strdup_printf("%s", currentgame->estate[i].name);

		if(currentgame->estate[i].group >= 0)  {
			tmp1 = text;
			tmp2 = g_strdup_printf(" (%s)", currentgame->group[ currentgame->estate[i].group ].name);
			text = g_strconcat(tmp1, tmp2, NULL);
			g_free(tmp1);
			g_free(tmp2);
		}

		if(currentgame->estate[i].price > 0)  {
			tmp1 = text;
			tmp2 = g_strdup_printf("\nPrice: %d", currentgame->estate[i].price);
			text = g_strconcat(tmp1, tmp2, NULL);
			g_free(tmp1);
			g_free(tmp2);
		}

		if(currentgame->estate[i].rent[5] > 0)  {
			tmp1 = text;
			tmp2 = g_strdup_printf(
				"\nNo house: %d, One: %d, Two: %d, Three: %d, Four: %d, Hotel: %d"
				"\nHouse price: %d",
				currentgame->estate[i].rent[0], currentgame->estate[i].rent[1], currentgame->estate[i].rent[2], currentgame->estate[i].rent[3], currentgame->estate[i].rent[4], currentgame->estate[i].rent[5],
				currentgame->estate[i].houseprice   );
			text = g_strconcat(tmp1, tmp2, NULL);
			g_free(tmp1);
			g_free(tmp2);
		}

		if(currentgame->estate[i].mortgageprice > 0)  {
			tmp1 = text;
			tmp2 = g_strdup_printf("\nMortgage value: %d", currentgame->estate[i].mortgageprice);
			text = g_strconcat(tmp1, tmp2, NULL);
			g_free(tmp1);
			g_free(tmp2);
		}

		gtk_widget_set_tooltip_text(EventBox, text);
		g_free(text);
	}

	gtk_container_set_border_width(GTK_CONTAINER(currentgame->BoardCenter), 0);
	gtk_widget_set_size_request( GTK_WIDGET(currentgame->BoardCenter), data->board_center_width, data->board_center_height);
	gtk_fixed_put(GTK_FIXED(FixedBoard), currentgame->BoardCenter, data->board_center_x, data->board_center_y);


	/* command box */
	currentgame->CommandsBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 10);
	gtk_container_set_border_width(GTK_CONTAINER(currentgame->CommandsBox), BORDER);
	gtk_box_pack_start(GTK_BOX(VerticalBoxBoard), currentgame->CommandsBox, FALSE, TRUE, 0);

	/* roll button */
	CmdButton = gtk_button_new_with_label("Roll");
	g_object_set_data(G_OBJECT(currentgame->CommandsBox), "roll_button", CmdButton);
	gtk_widget_set_size_request(CmdButton, 60, -1);
	g_object_set_data(G_OBJECT(CmdButton), "command", ".r\n");
	gtk_box_pack_start(GTK_BOX(currentgame->CommandsBox), CmdButton, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(CmdButton), "clicked", G_CALLBACK(CallBack_button_command_pressed), NULL);

	/* how to play in center */
	if (!global->reconnected) {
		display_title("How to Play");
		display_text("Estate houses or mortgage: Press left or right button on estate\n\n"
		  "Trade: press left or right button on the player you want to trade with, then select \"Initiate a trade\"\n\n"
		  "Please read help for more informations");
	}


	/* ==== GRAPHIC ENGINE IMAGES ==== */

	/* board frame */
	frame = currentgame->board_frame = eng_frame_create();
	eng_frame_set_width(frame, data->board_width);
	eng_frame_set_height(frame, data->board_height);

	/* pic for estates / stars / houses */
	for(i = 0 ; i < data->number_estates ; i++)  {

		j = data->estate[i].buffer_board;


		/* estate */
		pic = currentgame->estate[i].pic = eng_pic_create(frame);
		eng_pic_set_x(pic, data->estate[i].x);
		eng_pic_set_y(pic, data->estate[i].y);
		eng_pic_set_z(pic, 0);
		eng_pic_set_width(pic, data->pngfile_board_width[j]);
		eng_pic_set_height(pic, data->pngfile_board_height[j]);
		eng_pic_set_buf(pic, data->pngfile_board_buf[j]);

		/* star */
		pic = currentgame->estate[i].star_pic = eng_pic_create(frame);
		eng_pic_set_x(pic, data->estate[i].xstar);
		eng_pic_set_y(pic, data->estate[i].ystar);
		eng_pic_set_z(pic, 1);

		/* if estate owned  &&  not mortgaged */
		if(currentgame->estate[i].owner > 0  &&  !currentgame->estate[i].mortgaged)  {

			star = global->player[ get_player_slot_with_playerid( currentgame->estate[i].owner ) ].buffer_star;

			pic = currentgame->estate[i].star_pic;
			eng_pic_set_width(pic, data->pngfile_star_width[star]);
			eng_pic_set_height(pic, data->pngfile_star_height[star]);
			eng_pic_set_buf(pic, data->pngfile_star_buf[star]);		
			eng_pic_show(pic);
		}

		/* if estate owned  &&  mortgaged */
		else  if(currentgame->estate[i].owner > 0  &&  currentgame->estate[i].mortgaged)  {

			star = global->player[ get_player_slot_with_playerid( currentgame->estate[i].owner ) ].buffer_star;

			pic = currentgame->estate[i].star_pic;
			eng_pic_set_width(pic, data->pngfile_star_m_width[star]);
			eng_pic_set_height(pic, data->pngfile_star_m_height[star]);
			eng_pic_set_buf(pic, data->pngfile_star_m_buf[star]);
			eng_pic_show(pic);
		}

		/* if estate unowned */
		else  /* if( currentgame->estate[i].owner <= 0 ) */ {

			pic = currentgame->estate[i].star_pic;
			eng_pic_unshow(pic);
		}

		/* house image */
		pic = currentgame->estate[i].house_pic = eng_pic_create(frame);
		eng_pic_set_x(pic, data->estate[i].xhouse);
		eng_pic_set_y(pic, data->estate[i].yhouse);
		eng_pic_set_z(pic, 1);

		houses = currentgame->estate[i].houses;

		if(houses <= 0)   {

			pic = currentgame->estate[i].house_pic;
			eng_pic_unshow(pic);
		}
		else  if(houses > 0  &&  data->estate[i].type_house == TYPE_HOUSE_HORIZONTAL)  {

			pic = currentgame->estate[i].house_pic;
			eng_pic_set_width(pic, data->pngfile_horiz_house_width[ houses ]);
			eng_pic_set_height(pic, data->pngfile_horiz_house_height[ houses ]);
			eng_pic_set_buf(pic, data->pngfile_horiz_house_buf[ houses ]);
			eng_pic_show(pic);
		}
		else  if(houses > 0  &&  data->estate[i].type_house == TYPE_HOUSE_VERTICAL)  {

			pic = currentgame->estate[i].house_pic;
			eng_pic_set_width(pic, data->pngfile_vert_house_width[ houses ]);
			eng_pic_set_height(pic, data->pngfile_vert_house_height[ houses ]);
			eng_pic_set_buf(pic, data->pngfile_vert_house_buf[ houses ]);
			eng_pic_show(pic);
		}
	}


	/* pic for tokens */
	for(i = 0 ; i < MAX_PLAYERS ; i++)  {

		if(! global->player[i].playerid) continue;
		if (global->player[i].spectator) continue;
		if(global->player[i].game != currentgame->gameid)  continue;

		token = global->player[i].buffer_token;

		/* token */
		pic = global->player[i].token_pic = eng_pic_create(frame);
		eng_pic_set_z(pic, 1);
		eng_pic_set_width(pic, data->pngfile_token_width[token]);
		eng_pic_set_height(pic, data->pngfile_token_height[token]);
		eng_pic_set_buf(pic, data->pngfile_token_buf[token]);
		if(global->player[i].bankrupt)
			eng_pic_unshow(pic);

		/* set token location to target location */
		global->player[i].location = global->player[i].location_to;
	}
	game_update_tokens();

	/* board first draw */
	eng_create_frame(frame);

	gtk_widget_show_all(global->MainVerticalBox);

	if(global->player[ get_player_slot_with_playerid(global->my_playerid) ].can_roll)
		gtk_widget_show(CmdButton);
	else
		gtk_widget_hide(CmdButton);
}


/* create message box, chat box fixed or floating */
void interface_message_and_chat_float_unfloat()  {

	//currentgame->BoxMessageAndChat
		//global->MessageFrame
		//global->MessageWindow
			//global->MessageBox
		//global->ChatFrame
		//global->ChatWindow
			//currentgame->ChatBox

	/* message is fixed and not created */
	if(!currentgame->message_float  &&  !global->MessageFrame) {

		/* if message window is created */
		if(global->MessageWindow)  {

			interface_unparent_message();
			gtk_widget_destroy(global->MessageWindow);
			global->MessageWindow = 0;
		}
		global->MessageFrame = gtk_frame_new("Server Messages");
		gtk_container_set_border_width(GTK_CONTAINER(global->MessageFrame), BORDER);
		gtk_widget_set_size_request(global->MessageFrame, -1, 100);
		gtk_box_pack_start(GTK_BOX(currentgame->BoxMessageAndChat), global->MessageFrame, FALSE, FALSE, 0);

		interface_create_message(global->MessageFrame);
		gtk_widget_show_all(global->MessageFrame);
	}

	/* message is float and not created */
	if(currentgame->message_float  &&  !global->MessageWindow)  {

		/* if message fixed is created */
		if(global->MessageFrame)  {

			interface_unparent_message();
			gtk_widget_destroy(global->MessageFrame);
			global->MessageFrame = 0;
			while(gtk_events_pending()) gtk_main_iteration();
		}
		global->MessageWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(global->MessageWindow), "GtkAtlantic: Server Messages");
		gtk_widget_set_size_request(global->MessageWindow, 300, 230);
		gtk_window_set_icon(GTK_WINDOW(global->MainWin), global->icon_pixbuf);
		g_signal_connect(G_OBJECT(global->MessageWindow), "delete_event", G_CALLBACK(CallBack_delete_window_message), NULL);
		g_signal_connect(G_OBJECT(global->MessageWindow), "destroy", G_CALLBACK(CallBack_destroy_window_message), NULL);

		interface_create_message(global->MessageWindow);
		gtk_widget_show_all(global->MessageWindow);
	}


	/* chat is fixed and not created */
	if(!currentgame->chat_float  &&  !currentgame->ChatFrame) {

		/* if chat window is created */
		if(currentgame->ChatWindow)  {

			interface_unparent_chat();
			gtk_widget_destroy(currentgame->ChatWindow);
			currentgame->ChatWindow = 0;
		}
		currentgame->ChatFrame = gtk_frame_new("Chat");
		gtk_container_set_border_width(GTK_CONTAINER(currentgame->ChatFrame), BORDER);
		gtk_box_pack_end(GTK_BOX(currentgame->BoxMessageAndChat), currentgame->ChatFrame, TRUE, TRUE, 0);

		interface_create_chat(currentgame->ChatFrame);
		gtk_widget_show_all(currentgame->ChatFrame);
	}

	/* chat is float and not created */
	if(currentgame->chat_float  &&  !currentgame->ChatWindow)  {

		/* if chat fixed is created */
		if(currentgame->ChatFrame)  {

			interface_unparent_chat();
			gtk_widget_destroy(currentgame->ChatFrame);
			currentgame->ChatFrame = 0;
			while(gtk_events_pending()) gtk_main_iteration();
		}
		currentgame->ChatWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(currentgame->ChatWindow), "GtkAtlantic: Chat");
		gtk_widget_set_size_request(currentgame->ChatWindow, 300, 230);
		gtk_window_set_icon(GTK_WINDOW(global->MainWin), global->icon_pixbuf);
		g_signal_connect(G_OBJECT(currentgame->ChatWindow), "delete_event", G_CALLBACK(CallBack_delete_window_chat), NULL);
		g_signal_connect(G_OBJECT(currentgame->ChatWindow), "destroy", G_CALLBACK(CallBack_destroy_window_chat), NULL);

		interface_create_chat(currentgame->ChatWindow);
		gtk_widget_show_all(currentgame->ChatWindow);
	}
}


void interface_create_message(GtkWidget *container)  {

	//global->MessageBox;
		//global->Message
		//GtkWidget* MessageVerticalScrollbar;

	GtkTextBuffer *textbuff;
	GtkTextIter textiter;

	/* already created, just reparent */
	if(global->MessageBox)  {
		gtk_widget_reparent(GTK_WIDGET(global->MessageBox), container);
		/* This is a bit ugly but I could not find a better way */
		g_timeout_add(100, interface_message_and_chat_scroll_to_the_end, global->Message);
		return;
	}

	global->MessageBox = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(global->MessageBox),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(container), global->MessageBox);

	/* Create the text view */
	global->Message = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(global->Message), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(global->Message), GTK_WRAP_CHAR);
	textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(global->Message));
	gtk_text_buffer_get_end_iter(textbuff, &textiter);
	gtk_text_buffer_create_mark(textbuff, "endmark", &textiter, FALSE);
	gtk_container_add(GTK_CONTAINER(global->MessageBox), global->Message);

	global->message_nb_lines = 0;
}


gboolean interface_message_and_chat_scroll_to_the_end(gpointer data) {
	GtkWidget *widget = GTK_WIDGET(data);
	GtkTextBuffer *textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
	GtkTextMark *textmark = gtk_text_buffer_get_mark(textbuff, "endmark");
	gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(widget), textmark, 0.0, FALSE, 0.0, 0.0);
	return FALSE;
}


void interface_unparent_message()  {

	if(!global->MessageBox) return;

	gtk_widget_hide( GTK_WIDGET(global->MessageBox) );
	gtk_widget_reparent(GTK_WIDGET(global->MessageBox), global->Trick);
}


void interface_destroy_message()  {

	if(!global->MessageBox) return;

	if(global->MessageFrame)
		gtk_widget_destroy( GTK_WIDGET(global->MessageFrame) );

	if(global->MessageWindow)
		gtk_widget_destroy( GTK_WIDGET(global->MessageWindow) );

	global->MessageWindow = 0;
	global->MessageFrame = 0;
	global->MessageBox = 0;
	global->Message = 0;
}


void interface_create_chat(GtkWidget *container)  {

	//currentgame->ChatBox
		GtkWidget *ChatScrolledWindow;
			//currentgame->Chat
		GtkWidget *SendEntry;

	GtkTextBuffer *textbuff;
	GtkTextIter textiter;

	if(! currentgame) return;

	/* already created, just reparent */
	if(currentgame->ChatBox)  {
		gtk_widget_reparent(GTK_WIDGET(currentgame->ChatBox), container);
		/* This is a bit ugly but I could not find a better way */
		g_timeout_add(100, interface_message_and_chat_scroll_to_the_end, currentgame->Chat);
		return;
	}

	currentgame->ChatBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_add(GTK_CONTAINER(container), currentgame->ChatBox);

	/* Create a scrolled window and put the textview in it */
	ChatScrolledWindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ChatScrolledWindow),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(currentgame->ChatBox), ChatScrolledWindow, TRUE, TRUE, 0);

	currentgame->Chat = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(currentgame->Chat), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(currentgame->Chat), GTK_WRAP_CHAR);
	textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(currentgame->Chat));
	gtk_text_buffer_get_end_iter(textbuff, &textiter);
	gtk_text_buffer_create_mark(textbuff, "endmark", &textiter, FALSE);
	currentgame->chat_nb_lines = 0;
	gtk_container_add(GTK_CONTAINER(ChatScrolledWindow), currentgame->Chat);

	/* send entry */
	SendEntry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(currentgame->ChatBox), SendEntry, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(SendEntry), "activate", G_CALLBACK(Callback_SendButton), (gpointer)SendEntry);
}


void interface_unparent_chat()  {

	if(! currentgame) return;
	if(! currentgame->ChatBox) return;

	gtk_widget_hide( GTK_WIDGET(currentgame->ChatBox) );
	gtk_widget_reparent(GTK_WIDGET(currentgame->ChatBox), global->Trick);
}


void interface_destroy_chat()  {

	if(! currentgame) return;
	if(! currentgame->ChatBox) return;

	if(currentgame->ChatFrame)
		gtk_widget_destroy( GTK_WIDGET(currentgame->ChatFrame) );

	if(currentgame->ChatWindow)
		gtk_widget_destroy( GTK_WIDGET(currentgame->ChatWindow) );

	currentgame->ChatWindow = 0;
	currentgame->ChatFrame = 0;
	currentgame->ChatBox = 0;
	currentgame->Chat = 0;
}


void interface_create_auctionbox()  {

	GtkWidget *vbox;
		GtkWidget *scrolledwindow;
			GtkWidget *text;
				GtkTextBuffer *textbuff;
				GtkTextIter textiter;
		GtkWidget *hbox_entry;
			GtkWidget *entry;
			GtkWidget *Alignment;
				GtkWidget *hbox_buttons;
					GtkWidget *button;

	vbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_hexpand(vbox, TRUE);
	gtk_widget_set_vexpand(vbox, TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 15);
	g_object_set_data(G_OBJECT(currentgame->BoardCenter), "auctionbox", vbox);
	gtk_box_pack_start(GTK_BOX(currentgame->BoardCenter), vbox, TRUE, TRUE, 0);

//	hbox_text = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
//	gtk_box_pack_start(GTK_BOX(vbox), hbox_text, TRUE, TRUE, 0);

	/* text box */
	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	text = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text), GTK_WRAP_WORD);

        textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
        gtk_text_buffer_get_end_iter(textbuff, &textiter);
        gtk_text_buffer_create_mark(textbuff, "endmark", &textiter, FALSE);

	g_object_set_data(G_OBJECT(currentgame->BoardCenter), "auction_text", text);
	gtk_container_add(GTK_CONTAINER(scrolledwindow), text);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);

	/* commands */
	hbox_entry = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox_entry, FALSE, TRUE, 0);

	/* send entry */
	entry = gtk_entry_new();
	g_object_set_data(G_OBJECT(currentgame->BoardCenter), "auction_entry", entry);
	gtk_box_pack_start(GTK_BOX(hbox_entry), entry,  FALSE, FALSE, 0);
	gtk_entry_set_width_chars(GTK_ENTRY(entry), 4);
	g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(Callback_AuctionButton_Absolute), (gpointer)entry);

	button = gtk_button_new_with_label("Bid");
	gtk_widget_set_size_request(button, 40, -1);
	gtk_box_pack_start(GTK_BOX(hbox_entry), button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(Callback_AuctionButton_Absolute), (gpointer)entry);

	/* buttons entry */
	Alignment = gtk_alignment_new(1.0, 0.5, 0.0, 1.0);
	gtk_box_pack_start(GTK_BOX(hbox_entry), Alignment, TRUE, TRUE, 0);
	hbox_buttons = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_container_add(GTK_CONTAINER(Alignment), hbox_buttons);

	button = gtk_button_new_with_label("+1");
	g_object_set_data(G_OBJECT(button), "auction_entry", entry);
	g_object_set_data(G_OBJECT(button), "value_add", GINT_TO_POINTER(1));
	gtk_box_pack_start(GTK_BOX(hbox_buttons), button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(Callback_AuctionButton_Relative), NULL);

	button = gtk_button_new_with_label("+10");
	g_object_set_data(G_OBJECT(button), "auction_entry", entry);
	g_object_set_data(G_OBJECT(button), "value_add", GINT_TO_POINTER(10));
	gtk_box_pack_start(GTK_BOX(hbox_buttons), button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(Callback_AuctionButton_Relative), NULL);

	button = gtk_button_new_with_label("+50");
	g_object_set_data(G_OBJECT(button), "auction_entry", entry);
	g_object_set_data(G_OBJECT(button), "value_add", GINT_TO_POINTER(50));
	gtk_box_pack_start(GTK_BOX(hbox_buttons), button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(Callback_AuctionButton_Relative), NULL);

	button = gtk_button_new_with_label("+100");
	g_object_set_data(G_OBJECT(button), "auction_entry", entry);
	g_object_set_data(G_OBJECT(button), "value_add", GINT_TO_POINTER(100));
	gtk_box_pack_start(GTK_BOX(hbox_buttons), button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(Callback_AuctionButton_Relative), NULL);

	gtk_widget_show_all(vbox);
}


/* create about window */
void interface_create_aboutwin()
{
	GtkWidget *AboutDlg;
	GtkWidget *Label;
	GtkWidget *VBox;

	gchar *text;

	AboutDlg = gtk_dialog_new_with_buttons("About gtkAtlantic", NULL,
			GTK_DIALOG_MODAL, "_OK", GTK_RESPONSE_ACCEPT,
			NULL);
	gtk_window_set_default_size(GTK_WINDOW(AboutDlg), 200, 0);
//	gtk_window_set_icon(GTK_WINDOW(global->MainWin), global->icon_pixbuf);
	g_signal_connect_swapped(G_OBJECT(AboutDlg), "response",
			G_CALLBACK(gtk_widget_destroy), G_OBJECT(AboutDlg));

	/* Create a VBox with a border */
	VBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(VBox), 10);
	gtk_container_add(GTK_CONTAINER(gtk_dialog_get_content_area(GTK_DIALOG(AboutDlg))), VBox);

	/* name */
	text = g_strdup_printf("<span size=\"xx-large\"><b>GtkAtlantic %s</b></span>", VERSION);

	Label = gtk_label_new(text);
	gtk_label_set_use_markup(GTK_LABEL(Label), TRUE);
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE,
			FALSE, 5);

	g_free(text);

	/* web site */
	Label = gtk_label_new("http://gtkatlantic.gradator.net");
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE,	FALSE, 5);

	/* license */
	Label = gtk_label_new("This software is distributed under the GPL Version 2 or any later version");
	gtk_label_set_line_wrap(GTK_LABEL(Label), TRUE);
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE,	FALSE, 10);

	/* author */
	Label = gtk_label_new("<b>Authors:</b>");
	gtk_label_set_use_markup(GTK_LABEL(Label), TRUE);
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE, FALSE, 0);

	Label = gtk_label_new("Sylvain Rochet (gradator@gradator.net)");
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE, FALSE, 0);
	Label = gtk_label_new("Xavier Amado (xavier@blackbloodstudios.com)");
        gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE, FALSE, 0);

	/* IRC */
	Label = gtk_label_new("irc.freenode.net #gtkatlantic");
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE, FALSE, 10);

	gtk_widget_show_all(AboutDlg);
}


/* create config panel */
void interface_create_config_panel()  {

	//global->ConfigWin;
		GtkWidget *vbox;
			GtkWidget *hbox;
				GtkWidget *Frame;
					GtkWidget *hboxFrame;
						GtkWidget *vboxFrame;
							GtkWidget *Label;
							GtkWidget *CButton;
							GtkWidget *Entry;
							GtkWidget *Combo;
							GtkAdjustment *Adjust;
								GtkWidget *Scale;
		GtkWidget *Button;

	gchar *text;

	if(global->ConfigWin)  return;

	global->ConfigWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(global->ConfigWin), "GtkAtlantic: Configuration");
	gtk_window_set_icon(GTK_WINDOW(global->MainWin), global->icon_pixbuf);
	g_signal_connect(G_OBJECT(global->ConfigWin), "delete_event", G_CALLBACK(gtk_widget_destroy), NULL);
	g_signal_connect(G_OBJECT(global->ConfigWin), "destroy", G_CALLBACK(CallBack_configwindow_destroyed), NULL);

	vbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), BORDER);
	gtk_container_add(GTK_CONTAINER(global->ConfigWin), vbox);


	/* PLAYER CONFIG (such has nickname) */
	Frame = gtk_frame_new("Player");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(vbox), Frame, FALSE, FALSE, 0);

	vboxFrame = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Nickname");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_player_nickname", Entry);
	gtk_entry_set_text(GTK_ENTRY(Entry), config->nickname);

	/* horizontal box for metaserver & custom server */
	hbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);


	/* METASERVER */
	Frame = gtk_frame_new("Meta server");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(hbox), Frame, TRUE, TRUE, 0);

	vboxFrame = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	CButton = gtk_check_button_new_with_label("Check new releases of GtkAtlantic");
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_metaserver_sendclientversion", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->metaserver_sendclientversion);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Get servers list automatically");
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_metaserver_autogetlist", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->metaserver_autogetlist);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Get games list automatically");
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_metaserver_autogetgames", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->metaserver_autogetgames);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);


	/* DEFAULT CUSTOM SERVER */
	Frame = gtk_frame_new("Default custom server");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(hbox), Frame, TRUE, TRUE, 0);

	vboxFrame = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, TRUE, 0);

	Label = gtk_label_new("host/port");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_customserver_host", Entry);
	gtk_entry_set_text(GTK_ENTRY(Entry), config->getgames_host);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, TRUE, TRUE, 0);

	Entry = gtk_entry_new();
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_customserver_port", Entry);
	text = g_strdup_printf("%d", config->getgames_port);
	gtk_entry_set_text(GTK_ENTRY(Entry), text);
	g_free(text);
	gtk_widget_set_size_request(Entry, 45, -1);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Get games list automatically");
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_customserver_autogetgames", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->getgames_autogetgames);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);


	/* SERVER MESSAGE BUFFER SIZE */
	Frame = gtk_frame_new("Buffer sizes");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(vbox), Frame, FALSE, TRUE, 0);

	vboxFrame = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Server messages : ");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_buffersize_servermessages", Entry);
	text = g_strdup_printf("%d", config->message_max_lines);
	gtk_entry_set_text(GTK_ENTRY(Entry), text);
	g_free(text);
	gtk_widget_set_size_request(Entry, 45, -1);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);

	Label = gtk_label_new("lines (0=Unlimited)");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	hboxFrame = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Chat : ");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_buffersize_chat", Entry);
	text = g_strdup_printf("%d", config->chat_max_lines);
	gtk_entry_set_text(GTK_ENTRY(Entry), text);
	g_free(text);
	gtk_widget_set_size_request(Entry, 45, -1);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);

	Label = gtk_label_new("lines (0=Unlimited)");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);


	/* INTERFACE GAME CONFIG */
	Frame = gtk_frame_new("Game interface");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(vbox), Frame, FALSE, FALSE, 0);

	vboxFrame = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Display player list at ");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Combo = gtk_combo_box_text_new();
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_gameinterface_playerlistposition", Combo);
	gtk_widget_set_size_request(Combo, 60, -1);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Combo, FALSE, FALSE, 0);

	gtk_combo_box_text_append_text(GTK_COMBO_BOX_TEXT(Combo), "left");
	gtk_combo_box_text_append_text(GTK_COMBO_BOX_TEXT(Combo), "right");

	if(config->game_playerlist_position == GAME_PLAYERLIST_POS_LEFT)
		gtk_combo_box_set_active(GTK_COMBO_BOX(Combo), 0);
	else
		gtk_combo_box_set_active(GTK_COMBO_BOX(Combo), 1);


	hboxFrame = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Token speed (in ms per estate) : ");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Adjust = gtk_adjustment_new (config->game_token_animation_speed, 25, 500, 25, 25, 0);
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_gameinterface_tokenanimatespeed", Adjust);
	Scale = gtk_scale_new(GTK_ORIENTATION_HORIZONTAL, GTK_ADJUSTMENT(Adjust));
	gtk_widget_set_size_request(Scale, 200, -1);
	gtk_scale_set_value_pos (GTK_SCALE (Scale), GTK_POS_TOP);
	gtk_scale_set_digits (GTK_SCALE (Scale), 0);
	gtk_box_pack_start (GTK_BOX (hboxFrame), Scale, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Show in transparency the tokens of players who are not moving now");
	g_object_set_data(G_OBJECT(global->ConfigWin), "config_gameinterface_tokentransparency", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->game_token_transparency);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);

	/* CANCEL/OK BUTTON */
	/* horizontal box buttons */
	hbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);

	Button = gtk_button_new_with_label("CANCEL");
	gtk_widget_set_size_request(Button, 130, 45);
	gtk_container_set_border_width(GTK_CONTAINER(Button), 10);
	gtk_box_pack_start(GTK_BOX(hbox), Button, TRUE, FALSE, 0);
	g_signal_connect_object(G_OBJECT(Button), "clicked", G_CALLBACK(gtk_widget_destroy), global->ConfigWin, G_CONNECT_SWAPPED);

	Button = gtk_button_new_with_label("OK");
	gtk_widget_set_size_request(Button, 130, 45);
	gtk_container_set_border_width(GTK_CONTAINER(Button), 10);
	gtk_box_pack_start(GTK_BOX(hbox), Button, TRUE, FALSE, 0);
	g_signal_connect(G_OBJECT(Button), "clicked", G_CALLBACK(CallBack_ok_button_configwindow), NULL);

	gtk_widget_show_all(global->ConfigWin);
}


/* create the little window change nickname */
void interface_create_nicknamewin()  {

	GtkWidget *NicknameWin;
		GtkWidget *HBox;
			GtkWidget *Entry;
			GtkWidget *Label;

	NicknameWin = gtk_dialog_new_with_buttons("GtkAtlantic: Nickname",
			GTK_WINDOW(global->MainWin), GTK_DIALOG_MODAL,
			"_OK", GTK_RESPONSE_OK, NULL);

//	gtk_window_set_icon(GTK_WINDOW(global->MainWin), global->icon_pixbuf);
//	g_signal_connect(G_OBJECT(NicknameWin), "delete_event", G_CALLBACK(gtk_widget_destroy, NULL);

	HBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(HBox), 10);
	gtk_container_add(GTK_CONTAINER(gtk_dialog_get_content_area(GTK_DIALOG(NicknameWin))), HBox);

	Label = gtk_label_new("Nickname:");
	gtk_box_pack_start(GTK_BOX(HBox), Label, FALSE, FALSE, 5);

	Entry = gtk_entry_new();
	gtk_widget_set_size_request(Entry, 150, -1);
	g_object_set_data(G_OBJECT(NicknameWin), "nickname", Entry);
	gtk_entry_set_text(GTK_ENTRY(Entry), global->player[ get_player_slot_with_playerid(global->my_playerid) ].name);
	gtk_box_pack_start(GTK_BOX(HBox), Entry, TRUE, TRUE, 0);

	g_signal_connect(G_OBJECT(NicknameWin), "response", G_CALLBACK(CallBack_response_changenick_window), NicknameWin);

	gtk_widget_show_all(NicknameWin);
}


/* create estates tree */
void interface_create_estates_tree()  {

	GtkWidget *EstateWin;
		GtkWidget *HBox;
			GtkWidget *ScrollWin;
				GtkWidget *EstateTree;
			GtkWidget *VBox;
				GtkWidget *Alignment;
					GtkWidget *Label;

	GtkTreeViewColumn *estateTreeCol;
	GtkCellRenderer *estateTreeRenderer;
	GtkTreeStore *stateTreestore;
	GtkTreeIter stateTreeIterGroup[MAX_GROUPS], stateTreeIterOther, stateTreeIterChild;
	GtkTreeSelection *select;
	guint32 i;

	if(currentgame->WinEstateTree)  return;

	currentgame->WinEstateTree = EstateWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_size_request(EstateWin, 450, 400);
	gtk_window_set_title(GTK_WINDOW(EstateWin), "GtkAtlantic: Estates Tree");
	gtk_window_set_icon(GTK_WINDOW(global->MainWin), global->icon_pixbuf);
	g_signal_connect(G_OBJECT(EstateWin), "delete_event", G_CALLBACK(gtk_widget_destroy), NULL);
	g_signal_connect(G_OBJECT(EstateWin), "destroy", G_CALLBACK(CallBack_EstateTree_Destroyed), NULL);

	HBox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_set_data(G_OBJECT(currentgame->WinEstateTree), "parent_box", HBox);
//	gtk_container_set_border_width(GTK_CONTAINER(HBox), 10);
	gtk_container_add(GTK_CONTAINER(EstateWin), HBox);

	/* ScrollWin win */
	ScrollWin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollWin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_size_request(ScrollWin, 250, -1);
	gtk_box_pack_start(GTK_BOX(HBox), ScrollWin, FALSE, TRUE, 0);

	/* estate tree */
	EstateTree = gtk_tree_view_new();
	select = gtk_tree_view_get_selection(GTK_TREE_VIEW(EstateTree));
	gtk_tree_selection_set_mode(select, GTK_SELECTION_SINGLE);
	g_signal_connect(G_OBJECT(select), "changed", G_CALLBACK(CallBack_EstateTree_SelectRow), NULL);

	gtk_container_add(GTK_CONTAINER(ScrollWin), EstateTree);
	
	estateTreeCol = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(estateTreeCol, "Estates");
	gtk_tree_view_append_column(GTK_TREE_VIEW(EstateTree), estateTreeCol);
	
	estateTreeRenderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(estateTreeCol, estateTreeRenderer, TRUE);
	gtk_tree_view_column_add_attribute(estateTreeCol, estateTreeRenderer, "text", 0);


	stateTreestore = gtk_tree_store_new(2, G_TYPE_STRING, G_TYPE_INT);

	/* create groups node */
	for(i = 0 ; i < MAX_GROUPS ; i++)  {
		if(! currentgame->group[i].name)  continue;

		gtk_tree_store_append(stateTreestore, &stateTreeIterGroup[i], NULL);
		gtk_tree_store_set(stateTreestore, &stateTreeIterGroup[i], 0, currentgame->group[i].name, 1, -1, -1);
	}
	gtk_tree_store_append(stateTreestore, &stateTreeIterOther, NULL);
	gtk_tree_store_set(stateTreestore, &stateTreeIterOther, 0, "Other", 1, -1, -1);

	/* create estates node */
	for(i = 0 ; i < data->number_estates ; i++)  {
		if(currentgame->estate[i].group >= 0) {
			gtk_tree_store_append(stateTreestore, &stateTreeIterChild, &stateTreeIterGroup[currentgame->estate[i].group]);
		} else {
			gtk_tree_store_append(stateTreestore, &stateTreeIterChild, &stateTreeIterOther);
		}
		gtk_tree_store_set(stateTreestore, &stateTreeIterChild, 0, currentgame->estate[i].name, 1, i, -1);
	}

	gtk_tree_view_set_model(GTK_TREE_VIEW(EstateTree), GTK_TREE_MODEL(stateTreestore));
	g_object_unref(stateTreestore); /* the TreeView creates its own reference */

	/* Expand groups */
	for(i = 0 ; i < MAX_GROUPS ; i++)  {
		GtkTreePath *path;

		if(! currentgame->group[i].name)  continue;

		path = gtk_tree_model_get_path(GTK_TREE_MODEL(stateTreestore), &stateTreeIterGroup[i]);
		if(path) {
			gtk_tree_view_expand_row(GTK_TREE_VIEW(EstateTree), path, FALSE);
			gtk_tree_path_free(path);
		}
	}

	/* info box */
	VBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	g_object_set_data(G_OBJECT(currentgame->WinEstateTree), "info_box", VBox);
	gtk_container_set_border_width(GTK_CONTAINER(VBox), 10);
	gtk_box_pack_start(GTK_BOX(HBox), VBox, TRUE, TRUE, 0);

	/* default text */
	Alignment = gtk_alignment_new(0.0, 0.0, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(VBox), Alignment, FALSE, TRUE, 0);
	Label = gtk_label_new("Select an estate...");
	gtk_container_add(GTK_CONTAINER(Alignment), Label);


	gtk_widget_show_all(EstateWin);
}


/* create help window */
void interface_create_helpwin()  {

	GtkWidget *HelpWin;
		GtkWidget *Scrolled;
			GtkWidget *label;

	if(global->HelpWin)  return;

	global->HelpWin = HelpWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_size_request(HelpWin, 700, 500);
	gtk_window_set_title(GTK_WINDOW(HelpWin), "GtkAtlantic: Help");
	gtk_window_set_icon(GTK_WINDOW(global->MainWin), global->icon_pixbuf);
	g_signal_connect(G_OBJECT(HelpWin), "delete_event", G_CALLBACK(gtk_widget_destroy), NULL);
	g_signal_connect(G_OBJECT(HelpWin), "destroy", G_CALLBACK(CallBack_HelpWin_Destroyed), NULL);

	Scrolled = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Scrolled), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(global->HelpWin), Scrolled);

	label = gtk_label_new(NULL);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_container_add(GTK_CONTAINER(Scrolled), label);

	gchar *tmp = g_markup_printf_escaped(
	  "<span size=\"xx-large\"><b>GtkAtlantic Help</b></span>\n"
	  "\n"
	  "<span size=\"x-large\"><b>Contents</b></span>\n"
	  "\n"
	  "1) About Atlantic\n"
	  "    i. What is the Atlantic game?\n"
	  "    ii. What is GtkAtlantic?\n"
	  "2) How to play\n"
	  "3) Fun chat macros\n"
	  "    i. Remote Macros\n"
	  "    ii. Local Macros\n"
	  "\n"
	  "\n"
	  "<span size=\"x-large\"><b>1) About Atlantic</b></span>\n"
	  "\n"
	  "<span size=\"large\"><b>i. What is the Atlantic game?</b></span>\n"
	  "\n"
	  "The goal in playing Atlantic is to <i>Get rich quick and win!</i> The richest player is the winner :)\n"
	  "\n"
	  "In order to win, you need to buy properties quickly and profitably. To succeed, you need at least one set of the same group of "
	  "properties, so that you can build Houses and ultimately Hotels upon them.\n"
	  "\n"
	  "Play begins from <i>Start</i> square. Players move their tokens around the board by clicking the <i>Roll Dice</i> button. When a player lands "
	  "on an unowned estate, he may <i>Buy</i> it from the bank or put it up for <i>Auction</i>. When a player lands on a estate owned by custom "
	  "player, he must pay rent to the owner.\n"
	  "\n"
	  "Building houses or hotels dramatically increase payable rents - so much so that it may force other players to declare 'Bankruptcy'. "
	  "To raise money, you can mortgage any owned estate to the bank.\n"
	  "\n"
	  "The <i>Chance</i> and <i>Community</i> squares give you a card whose instructions must be followed. Sometimes you are sent to Jail! :(\n"
	  "\n"
	  "Atlantic is a game that combines subtlety and a sense of business - a good mood helps if you are losing! :)\n"
	  "\n"
	  "<span size=\"large\"><b>ii. What is GtkAtlantic?</b></span>\n"
	  "\n"
	  "GtkAtlantic is a network client to play the Atlantic game on monopd servers. The Atlantic game looks like a Monopoly® game.\n"
	  "\n"
	  "\n"
	  "<span size=\"x-large\"><b>2) How to Play</b></span>\n"
	  "\n"
	  "Well, it is quite easy to play with GtkAtlantic. If you know how to play Monopoly® you can probably play without problem.\n"
	  "\n"
	  "<b>Roll dice:</b> Clic the <i>Roll</i> button.\n"
	  "\n"
	  "<b>Buy a house:</b> Clic on the estate on which you want to build a house then choose <i>Build house</i>.\n"
	  "<b>Sell a house:</b> Clic on the estate on which you want to sell a house then choose <i>Sell house</i>.\n"
	  "<b>Mortgage an estate:</b> Clic on the estate you want to mortgage then choose <i>(Un)mortgage</i>.\n"
	  "\n"
	  "<b>Start a trade with a player:</b> Clic on the player you want to trade with, then select <i>Initiate a trade</i>.\n"
	  "\n"
	  "\n"
	  "<span size=\"x-large\"><b>3) Fun chat commands</b></span>\n"
	  "\n"
	  "<span size=\"large\"><b>i. Remote commands</b></span>\n"
	  "\n"
	  "Note that all players will know what you are doing, and all players will receive what you have requested. "
	  "Please do not flood chat - use with care because some players don't like receiving this information. "
	  "Only a GtkAtlantic client will answer these requests.\n"
	  "\n"
	  "<b>!version [player]</b>\n"
	  "Returns player client version. If no player is specified, returns client version of all players.\n"
	  "\n"
	  "<b>!date [player]</b>\n"
	  "Returns player local time. If no player is specified, returns date of all players.\n"
	  "\n"
	  "<b>!ping [player]</b>\n"
	  "Returns pong if player is still connected. If no player is specified, returns pong of all players\n"
	  "\n"
	  "<span size=\"large\"><b>ii. Local commands</b></span>\n"
	  "\n"
	  "Local commands to use whenever you want and as often as you need.\n"
	  "\n"
	  "<b>/me msg</b>\n"
	  "Sends an action message\n"
	  "\n"
	  "<b>/date</b>\n"
	  "Returns local time\n"
	  "\n"
	  "<b>/nick [new nick]</b>\n"
	  "Changes nick\n"
	  "\n"
	  "<b>/assets [player]</b>\n"
	  "Returns player assets. If no player is specified, returns assets of all players.\n"
	  "\n"
	  "<b>/elapsed</b>\n"
	  "Returns elapsed time since game start.\n"
	  "\n"
	  );
	gtk_label_set_markup(GTK_LABEL(label), tmp);
	g_free(tmp);

	gtk_widget_show_all(HelpWin);
}


/* generic window with a label into */
void interface_create_messagewin(gchar *msg)  {
	(void)msg;

/*	GtkWidget *MessageWin;
		GtkWidget *VBox;
			GtkWidget *Alignment;
				GtkWidget *Label;
				GtkWidget *Button;


	MessageWin = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(MessageWin), "GtkAtlantic: Message");
	gtk_window_set_position(GTK_WINDOW(MessageWin), GTK_WIN_POS_CENTER);
	gtk_window_set_transient_for(GTK_WINDOW(MessageWin), GTK_WINDOW(global->MainWin));
	gtk_window_set_modal(GTK_WINDOW(MessageWin), TRUE);
	gtk_widget_set_size_request(MessageWin, -1, -1);
	g_signal_connect(G_OBJECT(MessageWin), "delete_event", G_CALLBACK(gtk_widget_destroy), NULL);

	VBox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
	gtk_container_set_border_width(GTK_CONTAINER(VBox), 10);
	gtk_container_add(GTK_CONTAINER(MessageWin), VBox);
*/
	/* text  */
/*	Label = gtk_label_new(msg);
	gtk_label_set_line_wrap(GTK_LABEL(Label), TRUE);
	gtk_box_pack_start(GTK_BOX(VBox), Label, TRUE, TRUE, 0);
*/
	/* ok button */
/*	Alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_widget_set_size_request(Alignment, -1, 50);
	gtk_box_pack_start(GTK_BOX(VBox), Alignment, FALSE, FALSE, 0);

	Button = gtk_button_new_with_label("OK");
	gtk_widget_set_size_request(Button, 70, -1);
	gtk_container_add(GTK_CONTAINER(Alignment), Button);

	g_signal_connect_object(G_OBJECT(Button), "clicked", G_CALLBACK(gtk_widget_destroy), MessageWin, G_CONNECT_SWAPPED);

	gtk_widget_show_all(MessageWin);
*/
}



/* when receive event: redraw an estate */
void on_board_draw(GtkWidget *widget, cairo_t *cr, gpointer d) {
	(void)d;
	gint32 id;
	eng_frame *frame;
	gint32 width, height, stride;
	eng_coord coord;
	cairo_surface_t *surface;
	guint8 *buf;
	gint32 bufferid;

	id = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "estateid"));
 	frame = currentgame->board_frame;
	bufferid = data->estate[id].buffer_board;

	width = data->pngfile_board_width[bufferid];
	height = data->pngfile_board_height[bufferid];
	stride = cairo_format_stride_for_width(CAIRO_FORMAT_ARGB32, width);
	coord.x = data->estate[id].x;
	coord.y = data->estate[id].y;
	coord.width = width;
	coord.height = height;
	coord.stride = stride;

	buf = eng_get_zone(frame, &coord);
	surface = cairo_image_surface_create_for_data((unsigned char*)buf, CAIRO_FORMAT_ARGB32, width, height, stride);
	cairo_set_source_surface(cr, surface, 0, 0);
	cairo_paint(cr);
	cairo_surface_destroy(surface);
	g_free(buf);
}

/* when receive event: redraw player token */
void on_playertoken_draw(GtkWidget *widget, cairo_t *cr, gpointer d) {
	(void)d;
	gint32 id;
	eng_frame *frame;
	gint32 width, height, stride;
	eng_coord coord;
	cairo_surface_t *surface;
	guint8 *buf;

	id = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "playerid"));
	frame = global->player[id].playerlist_token_frame;

	width = data->playerlist_token_width;
	height = data->playerlist_token_height;
	stride = cairo_format_stride_for_width(CAIRO_FORMAT_ARGB32, width);
	coord.x = 0;
	coord.y = 0;
	coord.width = width;
	coord.height = height;
	coord.stride = stride;

	buf = eng_get_zone(frame, &coord);
	surface = cairo_image_surface_create_for_data((unsigned char*)buf, CAIRO_FORMAT_ARGB32, width, height, stride);
	cairo_set_source_surface(cr, surface, 0, 0);
	cairo_paint(cr);
	cairo_surface_destroy(surface);
	g_free(buf);
}

/* when receive event: redraw player cards */
void on_playercards_draw(GtkWidget *widget, cairo_t *cr, gpointer d) {
	(void)d;
	gint32 id;
	eng_frame *frame;
	gint32 width, height, stride;
	eng_coord coord;
	cairo_surface_t *surface;
	guint8 *buf;

	id = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "playerid"));
	frame = global->player[id].playerlist_cards_frame;

	width = data->playerlist_cards_width;
	height = data->playerlist_cards_height;
	stride = cairo_format_stride_for_width(CAIRO_FORMAT_ARGB32, width);
	coord.x = 0;
	coord.y = 0;
	coord.width = width;
	coord.height = height;
	coord.stride = stride;

	buf = eng_get_zone(frame, &coord);
	surface = cairo_image_surface_create_for_data((unsigned char*)buf, CAIRO_FORMAT_ARGB32, width, height, stride);
	cairo_set_source_surface(cr, surface, 0, 0);
	cairo_paint(cr);
	cairo_surface_destroy(surface);
	g_free(buf);
}


/* when receive event: redraw logo */
void on_logo_draw(GtkWidget *widget, cairo_t *cr, gpointer d) {
	(void)d;
	gint32 height, width, stride;
	cairo_surface_t *surface;
	guint8 *buf;
	eng_coord coord;

	width = gtk_widget_get_allocated_width(widget);
	height = gtk_widget_get_allocated_height(widget);
	stride = cairo_format_stride_for_width(CAIRO_FORMAT_ARGB32, width);
	coord.x = 0;
	coord.y = 0;
	coord.width = width;
	coord.height = height;
	coord.stride = stride;

	buf = eng_get_zone(global->logo_frame, &coord);
	surface = cairo_image_surface_create_for_data((unsigned char*)buf, CAIRO_FORMAT_ARGB32, width, height, stride);
	cairo_set_source_surface(cr, surface, 0, 0);
	cairo_paint(cr);
	cairo_surface_destroy(surface);
	g_free(buf);
}


/* update display */
void update_display() {
	guint32 i;
	eng_frame *frame;

	if (global->phase != PHASE_GAMEPLAY) {
		return;
	}

	/* draw the board */
	frame = currentgame->board_frame;
	eng_create_frame(frame);

	for(i = 0 ; i < data->number_estates ; i++)  {
		eng_coord coord;
		gint32 width, height;
		gint32 bufferid;

		if(! currentgame->estate[i].gdkrgb) continue;
		if(! frame) continue;

		bufferid = data->estate[i].buffer_board;

		width = data->pngfile_board_width[bufferid];
		height = data->pngfile_board_height[bufferid];
		coord.x1 = data->estate[i].x;
		coord.y1 = data->estate[i].y;
		coord.x2 = coord.x1 + width -1;
		coord.y2 = coord.y1 + height -1;

		/* force draw event */
		if (eng_zone_is_modified(frame, &coord) ) {
			gtk_widget_queue_draw_area(currentgame->estate[i].gdkrgb, 0, 0, width, height);
		}
	}


	/* draw playerlist */
	for(i = 0 ; i < MAX_PLAYERS ; i++)  {
		eng_frame *frame;
		gint32 width, height;
		eng_coord coord;

		if(! global->player[i].playerid) continue;
		if (global->player[i].spectator) continue;
		if(global->player[i].game != currentgame->gameid)  continue;
		if(! global->player[i].playerlist_cards_gdkrgb) continue;

		/* playerlist cards */
		frame = global->player[i].playerlist_cards_frame;
		eng_create_frame(frame);

		width = data->playerlist_cards_width;
		height = data->playerlist_cards_height;
		coord.x1 = 0;
		coord.y1 = 0;
		coord.x2 = width -1;
		coord.y2 = height -1;

		/* force draw event */
		if ( eng_zone_is_modified(frame, &coord) ) {
			gtk_widget_queue_draw_area(global->player[i].playerlist_cards_gdkrgb, 0, 0, width, height);
		}

		/* playerlist token */
		frame = global->player[i].playerlist_token_frame;
		eng_create_frame(frame);

		width = data->playerlist_token_width;
		height = data->playerlist_token_height;
		coord.x1 = 0;
		coord.y1 = 0;
		coord.x2 = width -1;
		coord.y2 = height -1;

		/* force draw event */
		if ( eng_zone_is_modified(frame, &coord) ) {
			gtk_widget_queue_draw_area(global->player[i].playerlist_token_gdkrgb, 0, 0, width, height);
		}
	}
}
