#include <config.h>

#include "general.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <cups/ppd.h>

#include <gettext.h>
#include <libgtklp.h>

#include "gtklp.h"
#include "gtklp_functions.h"

GtkWidget *generalTab;
GtkWidget *printerFrame;
GtkWidget *printerFrameCombo,*printerFrameInfoText,*printerFrameLocationText;
GtkWidget *printerNumCopiesFrame,*printerNumField;
GtkWidget *printerMediaFrame,*printerMediaSizeCombo,*printerMediaTypeCombo,*printerMediaSourceCombo;
GtkWidget *MediaTypeFrame,*MediaSizeFrame,*MediaSourceFrame;
GtkWidget *printerDuplexFrame;
GSList *DuplexButtons;

void generalTabSetDefaults(void)
{
	unsigned char tmp[MAXNUMCOPYDIGIT+1];
	GList *mediaSize=NULL, *mediaType=NULL, *mediaSource=NULL;
	int i1;
	ppd_option_t *option;
	ppd_choice_t *choice;

	if(DEBUG)
		printf("Get generalTabDefaults\n");

	/* PrinterName */
	gtk_list_select_item(GTK_LIST(GTK_COMBO(printerFrameCombo)->list),PrinterChoice);
	/* PrinterInfo */
	gtk_label_set_text(GTK_LABEL(printerFrameInfoText),PrinterInfos[PrinterChoice]);
	/* PrinterLocation */
	gtk_label_set_text(GTK_LABEL(printerFrameLocationText),PrinterLocations[PrinterChoice]);
	/* Number of Copies */
	snprintf(tmp,(size_t)MAXNUMCOPYDIGIT,"%u",NumberOfCopies);
	gtk_entry_set_text(GTK_ENTRY (printerNumField),tmp);
	/* Media Types */
	if((ppdFindOption(printerPPD,"PageSize") == NULL) & (ppdFindOption(printerPPD,"MediaType") == NULL) & (ppdFindOption(printerPPD,"InputSlot") == NULL))
		gtk_widget_hide(printerMediaFrame);
	else
	{
		gtk_widget_show(printerMediaFrame);

		if((option=ppdFindOption(printerPPD,"PageSize")) != NULL)
		{
				for(i1=option->num_choices, choice=option->choices; i1>0; i1--, choice++)
				{
					mediaSize=g_list_append(mediaSize,choice->text);
					if(choice -> marked)
						MediaSizeSelected=option->num_choices-i1;
				}
			
     	gtk_combo_set_popdown_strings (GTK_COMBO(printerMediaSizeCombo),mediaSize);
			gtk_list_select_item(GTK_LIST(GTK_COMBO(printerMediaSizeCombo)->list),MediaSizeSelected);
			gtk_entry_set_position(GTK_ENTRY(GTK_COMBO(printerMediaSizeCombo)->entry),0);
	    gtk_widget_show(MediaSizeFrame);
		}
		else
		{
			gtk_widget_hide(MediaSizeFrame);
		}
		if((option=ppdFindOption(printerPPD,"MediaType")) != NULL)
		{
			for(i1=option->num_choices, choice=option->choices; i1>0; i1--, choice++)
			{
				mediaType=g_list_append(mediaType,choice->text);
				if(choice -> marked) 
					MediaTypeSelected=option->num_choices-i1;
			}
			gtk_combo_set_popdown_strings (GTK_COMBO(printerMediaTypeCombo),mediaType);
			gtk_list_select_item(GTK_LIST(GTK_COMBO(printerMediaTypeCombo)->list),MediaTypeSelected);
			gtk_entry_set_position(GTK_ENTRY(GTK_COMBO(printerMediaTypeCombo)->entry),0);
			gtk_widget_show(MediaTypeFrame);
		}
		else
		{
			gtk_widget_hide(MediaTypeFrame);
		}
		if((option=ppdFindOption(printerPPD,"InputSlot")) != NULL)
		{
			for(i1=option->num_choices, choice=option->choices; i1>0; i1--, choice++)
			{
				mediaSource=g_list_append(mediaSource,choice->text);
				if(choice -> marked) 
					MediaSourceSelected=option->num_choices-i1;
			}
			gtk_combo_set_popdown_strings (GTK_COMBO(printerMediaSourceCombo),mediaSource);
			gtk_list_select_item(GTK_LIST(GTK_COMBO(printerMediaSourceCombo)->list),MediaSourceSelected);
			gtk_entry_set_position(GTK_ENTRY(GTK_COMBO(printerMediaSourceCombo)->entry),0);
			gtk_widget_show(MediaSourceFrame);
		}
		else
		{
			gtk_widget_hide(MediaSourceFrame);
		}
	}

	/* Duplex */
	if((option=ppdFindOption(printerPPD,"Duplex")) == NULL)
	{
		gtk_widget_hide(printerDuplexFrame);
	}
	else
	{
		choice=ppdFindChoice(option,"None");
		if(choice != NULL)
		{
			if(choice->marked)
			{
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(DuplexButtons,2)),TRUE);
			}
			else 
			{
				choice=ppdFindChoice(option,"DuplexNoTumble");
				if(choice != NULL)
				{
					if(choice->marked)
					{
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(DuplexButtons,1)),TRUE);
					}
					else
					{
						choice=ppdFindChoice(option,"DuplexTumble");
						if(choice != NULL)
						{
							if(choice->marked)
								gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(DuplexButtons,0)),TRUE);
						}
					}
				}
			}
		}
		gtk_widget_show(printerDuplexFrame);
	}
}

void NumOfCopiesChanged(GtkWidget *widget,gpointer data)
{
	unsigned char tmp[MAXNUMCOPYDIGIT+1];
	int i1,flg=0;

	strncpy(tmp,gtk_editable_get_chars(GTK_EDITABLE(printerNumField),0,-1),(size_t)MAXNUMCOPYDIGIT);
	if(DEBUG)
		printf("NumberOfCopiesEntry: %s\n",tmp);

	for(i1=0; i1<strlen(tmp);i1++)
	{
		if(isdigit(tmp[i1]) == 0)
		{
			snprintf(tmp,(size_t)MAXNUMCOPYDIGIT,"%u",NumberOfCopies);
			gtk_entry_set_text(GTK_ENTRY(printerNumField),tmp);
			gtk_editable_set_position(GTK_EDITABLE(printerNumField),-1);
			flg=1;
			break;
		}
	}

	if((flg==0) && tmp[0] != (unsigned char)NULL)
	{
		NumberOfCopies=atoi(tmp);
		if(DEBUG)
			printf("NumberOfCopiesEntry: Value changed: %u\n",NumberOfCopies);
	}

}

void PrinterChanged(GtkWidget *widget,gpointer data)
{
	int i1,strangeerrortrap,ret;
	char tmp[DEF_PRN_LEN+1];

	snprintf(tmp,(size_t)DEF_PRN_LEN,"%s",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(printerFrameCombo)->entry)));

	if(DEBUG)
		printf("Printer changed: %s\n",(char *)tmp);

	conflict_active=0;
	i1=0;
	strangeerrortrap=0;
	do
	{
		if(strcmp(PrinterNames[i1],tmp) == 0)
		{
			lastPrinterChoice=PrinterChoice;
			PrinterChoice=i1;
			strangeerrortrap=1;
		}
		i1++;
	}
	while(PrinterNames[i1][0] != (unsigned char)NULL);

	if(strangeerrortrap == 0)
	{
		if(DEBUG)
			printf("Damned Combo-Box-Error !\n");
		emergency();
		
	}

	hasAskedPWD=0;
	getBannerList(tmp);
	getOptions(tmp,-1);	/* Get PrinterOptions without PPD-Opts to have an password if saved. */
	ret=getPPDOpts(tmp);
	if(ret == -2)		/* Not Authorized */
	{
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(printerFrameCombo)->entry), PrinterNames[lastPrinterChoice]);
	}
	if(ret == 0)  /* OK, printer has ppd */
	{
		getOptions(tmp,0);
		gtk_widget_hide(tabs);
		setDefaults();
		gtk_widget_show(tabs);
	}
	conflict_active=1;
	if(printerPPD != NULL)
		constraints(ppdConflicts(printerPPD));
}

void DuplexChanged(GtkWidget *widget,gpointer data)
{
	if(DEBUG)
		printf("Duplex toggled: %s\n",(char *)data);

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(DuplexButtons,2))))
	{
		if(strcmp((char *)data,"Button1") != 0)
			return;
		if(DEBUG)
			printf("No Duplex\n");
		constraints(ppdMarkOption(printerPPD,"Duplex","None"));
		return;
	}
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(DuplexButtons,1))))
	{
		if(DEBUG)
			printf("Duplex long edge binding\n");
		if(strcmp((char *)data,"Button2") != 0)
			return;	
		constraints(ppdMarkOption(printerPPD,"Duplex","DuplexNoTumble"));
		return;
	}
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(DuplexButtons,0))))
	{
		if(DEBUG)
			printf("Duplex short edge binding\n");
		if(strcmp((char *)data,"Button3") != 0)
			return;
		constraints(ppdMarkOption(printerPPD,"Duplex","DuplexTumble"));
		return;
	}
	else
	{
		if(DEBUG)
			printf("PROG-ERROR: Whats that for an Duplex mode ?\n");
		emergency();
	}
}

void PrinterDuplex(GtkWidget *container)
{
#include "duplex_none.xpm"
#include "duplex_long.xpm"
#include "duplex_short.xpm"
        GtkWidget *mainHBox,*vbox,*hbox;
	GtkWidget *button1,*button2,*button3;
	GtkWidget *lbox1,*lbox2,*lbox3;
	GtkWidget *pmw1,*pmw2,*pmw3;
	GdkPixmap *pm1,*pm2,*pm3;
	GdkBitmap *mask1,*mask2,*mask3;
	GtkStyle  *style;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        printerDuplexFrame=gtk_frame_new(_("Duplex Settings"));
        gtk_box_pack_start(GTK_BOX(mainHBox), printerDuplexFrame, TRUE, TRUE,FRAME_SPACING_V);

        /* Box */
	hbox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
	gtk_container_add(GTK_CONTAINER(printerDuplexFrame), hbox);
	gtk_widget_show(hbox);
        vbox=gtk_vbox_new(FALSE,INFRAME_SPACING_V);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,FALSE,FALSE,INFRAME_SPACING_H);
        gtk_widget_show(vbox);

	/* CheckBoxes */
	lbox1 = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (lbox1), 2);
	style = gtk_widget_get_style(vbox);
	pm1 = gdk_pixmap_create_from_xpm_d (vbox->window, &mask1,
			&style->bg[GTK_STATE_NORMAL],
			duplex_none_xpm);
	pmw1 = gtk_pixmap_new (pm1, mask1);
        button1=gtk_radio_button_new_with_label(DuplexButtons,_("No Duplex"));
	gtk_box_pack_start (GTK_BOX (lbox1),
				pmw1, FALSE, FALSE, 3);
	gtk_box_pack_start (GTK_BOX (lbox1),button1,FALSE,FALSE,3);
	gtk_widget_show(pmw1);
        gtk_box_pack_start (GTK_BOX (vbox), lbox1, FALSE, FALSE,0);
        DuplexButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button1));
	gtk_widget_show(button1);
	gtk_widget_show(lbox1);

	lbox2 = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (lbox2), 2);
	style = gtk_widget_get_style(vbox);
	pm2 = gdk_pixmap_create_from_xpm_d (vbox->window, &mask2,
			&style->bg[GTK_STATE_NORMAL],
			duplex_long_xpm);
	pmw2 = gtk_pixmap_new (pm2, mask2);
        button2=gtk_radio_button_new_with_label(DuplexButtons,_("Long edge binding"));
	gtk_box_pack_start (GTK_BOX (lbox2),
				pmw2, FALSE, FALSE, 3);
	gtk_box_pack_start (GTK_BOX (lbox2),button2,FALSE,FALSE,3);
	gtk_widget_show(pmw2);
        gtk_box_pack_start (GTK_BOX (vbox), lbox2, FALSE, FALSE,0);
        DuplexButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button2));
	gtk_widget_show(button2);
	gtk_widget_show(lbox2);

	lbox3 = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (lbox3), 2);
	style = gtk_widget_get_style(vbox);
	pm3 = gdk_pixmap_create_from_xpm_d (vbox->window, &mask3,
			&style->bg[GTK_STATE_NORMAL],
			duplex_short_xpm);
	pmw3 = gtk_pixmap_new (pm3, mask3);
        button3=gtk_radio_button_new_with_label(DuplexButtons,_("Short edge binding"));
	gtk_box_pack_start (GTK_BOX (lbox3),
				pmw3, FALSE, FALSE, 3);
	gtk_box_pack_start (GTK_BOX (lbox3),button3,FALSE,FALSE,3);
	gtk_widget_show(pmw3);
        gtk_box_pack_start (GTK_BOX (vbox), lbox3, FALSE, FALSE,0);
        DuplexButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button3));
	gtk_widget_show(button3);
	gtk_widget_show(lbox3);

	gtk_signal_connect(GTK_OBJECT(button1),"toggled",GTK_SIGNAL_FUNC(DuplexChanged),"Button1");
	gtk_signal_connect(GTK_OBJECT(button2),"toggled",GTK_SIGNAL_FUNC(DuplexChanged),"Button2");
	gtk_signal_connect(GTK_OBJECT(button3),"toggled",GTK_SIGNAL_FUNC(DuplexChanged),"Button3");

}

void PrinterMedia(GtkWidget *container)
{
        GtkWidget *mainHBox,*vbox;
	GtkWidget *labelSize, *labelType, *labelSource;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        printerMediaFrame=gtk_frame_new(_("Media Selections"));
        gtk_box_pack_start(GTK_BOX(mainHBox), printerMediaFrame, TRUE, TRUE,FRAME_SPACING_V);

        /* Box */
        vbox=gtk_vbox_new(FALSE,INFRAME_SPACING_V);
        gtk_container_add(GTK_CONTAINER(printerMediaFrame), vbox);
        gtk_widget_show(vbox);

	/* MediaSize */
        MediaSizeFrame=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_container_add(GTK_CONTAINER(vbox), MediaSizeFrame);

	labelSize=gtk_label_new(_("Size"));
	gtk_misc_set_alignment(GTK_MISC(labelSize),0,0.5);
	gtk_widget_set_usize(GTK_WIDGET(labelSize),MEDIA_FIELDLENGTH,-1);
	gtk_box_pack_start(GTK_BOX(MediaSizeFrame), labelSize, FALSE, FALSE, INFRAME_SPACING_H);
	gtk_widget_show(labelSize);

        printerMediaSizeCombo=gtk_combo_new();
        gtk_list_set_selection_mode(GTK_LIST(GTK_COMBO(printerMediaSizeCombo)->list),GTK_SELECTION_SINGLE);
        gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(printerMediaSizeCombo)->entry),FALSE);
        gtk_box_pack_start(GTK_BOX(MediaSizeFrame), printerMediaSizeCombo, FALSE, FALSE, INFRAME_SPACING_H);
        gtk_widget_show(printerMediaSizeCombo);

	/* MediaType */
        MediaTypeFrame=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_container_add(GTK_CONTAINER(vbox), MediaTypeFrame);

        labelType=gtk_label_new(_("Type"));
	gtk_misc_set_alignment(GTK_MISC(labelType),0,0.5);
	gtk_widget_set_usize(GTK_WIDGET(labelType),MEDIA_FIELDLENGTH,-1);
        gtk_box_pack_start(GTK_BOX(MediaTypeFrame), labelType, FALSE, FALSE, INFRAME_SPACING_H);
        gtk_widget_show(labelType);

        printerMediaTypeCombo=gtk_combo_new();
        gtk_list_set_selection_mode(GTK_LIST(GTK_COMBO(printerMediaTypeCombo)->list),GTK_SELECTION_SINGLE);
        gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(printerMediaTypeCombo)->entry),FALSE);
        gtk_box_pack_start(GTK_BOX(MediaTypeFrame), printerMediaTypeCombo, FALSE, FALSE, INFRAME_SPACING_H);
        gtk_widget_show(printerMediaTypeCombo);

        /* MediaSource */
        MediaSourceFrame=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_container_add(GTK_CONTAINER(vbox), MediaSourceFrame);

        labelSource=gtk_label_new(_("Source"));
	gtk_misc_set_alignment(GTK_MISC(labelSource),0,0.5);
        gtk_widget_set_usize(GTK_WIDGET(labelSource),MEDIA_FIELDLENGTH,-1);
        gtk_box_pack_start(GTK_BOX(MediaSourceFrame), labelSource, FALSE, FALSE, INFRAME_SPACING_H);
        gtk_widget_show(labelSource);

        printerMediaSourceCombo=gtk_combo_new();
        gtk_list_set_selection_mode(GTK_LIST(GTK_COMBO(printerMediaSourceCombo)->list),GTK_SELECTION_SINGLE);
        gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(printerMediaSourceCombo)->entry),FALSE);
        gtk_box_pack_start(GTK_BOX(MediaSourceFrame), printerMediaSourceCombo, FALSE, FALSE, INFRAME_SPACING_H);
        gtk_widget_show(printerMediaSourceCombo);

	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(printerMediaSizeCombo)->entry),"changed",PPD_DropDown_changed,"PageSize");
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(printerMediaTypeCombo)->entry),"changed",PPD_DropDown_changed,"MediaType");
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(printerMediaSourceCombo)->entry),"changed",PPD_DropDown_changed,"InputSlot");


}


void PrinterNumCopies(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        printerNumCopiesFrame=gtk_frame_new(_("Number of Copies"));
        gtk_box_pack_start(GTK_BOX(mainHBox), printerNumCopiesFrame, TRUE, TRUE,FRAME_SPACING_V);

        /* Box */
        hbox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_container_add(GTK_CONTAINER(printerNumCopiesFrame), hbox);
        gtk_widget_show(hbox);

	/* TextBox */
	printerNumField=gtk_entry_new_with_max_length (MAXNUMCOPYDIGIT);
	gtk_widget_set_usize(printerNumField,NUMCOPIES_FIELD_LENGTH,-1);
	gtk_entry_set_text(GTK_ENTRY (printerNumField),"");
	gtk_box_pack_start(GTK_BOX(hbox), printerNumField, FALSE, FALSE,INFRAME_SPACING_V);
	gtk_widget_show(printerNumField);

        /* Signals */
        gtk_signal_connect(GTK_OBJECT(GTK_ENTRY(printerNumField)),"changed",GTK_SIGNAL_FUNC(NumOfCopiesChanged),NULL);
}


void PrinterFrame(GtkWidget *container)
{
	GtkWidget *mainHBox,*hbox,*vbox;
	GList *printerList=NULL;
	int i1;

	mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
	gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);	
	gtk_widget_show(mainHBox);
	printerFrame=gtk_frame_new(_("Printer"));
	gtk_box_pack_start(GTK_BOX(mainHBox), printerFrame, TRUE, TRUE,FRAME_SPACING_V);

	/* Printer Box */
        hbox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_container_add(GTK_CONTAINER(printerFrame), hbox);
        gtk_widget_show(hbox);

	printerFrameCombo=gtk_combo_new();
	for(i1=0; i1<=PrinterNum; i1++)
	{
		printerList=g_list_append(printerList,PrinterNames[i1]);
	}
	gtk_combo_set_popdown_strings (GTK_COMBO(printerFrameCombo),printerList);
	gtk_combo_set_value_in_list(GTK_COMBO(printerFrameCombo),TRUE,FALSE);
	gtk_list_set_selection_mode(GTK_LIST(GTK_COMBO(printerFrameCombo)->list),GTK_SELECTION_SINGLE);

	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(printerFrameCombo)->entry),FALSE); 
	gtk_box_pack_start(GTK_BOX(hbox), printerFrameCombo, FALSE, FALSE, INFRAME_SPACING_H);
	gtk_widget_show(printerFrameCombo);

	/* InfoBoxen */
	vbox=gtk_vbox_new(FALSE,0);	
	gtk_box_set_spacing(GTK_BOX(vbox),0);
	gtk_box_pack_end(GTK_BOX(hbox), vbox, FALSE, FALSE,INFRAME_SPACING_H);
	gtk_widget_show(vbox);

	/* Information */
	printerFrameInfoText=gtk_label_new("");
	gtk_label_set_line_wrap(GTK_LABEL(printerFrameInfoText),TRUE);
	gtk_label_set_justify(GTK_LABEL(printerFrameInfoText),GTK_JUSTIFY_LEFT);
	gtk_widget_set_usize(printerFrameInfoText,PRINTER_INFO_FIELD_LENGTH,-1);
	gtk_box_pack_start(GTK_BOX(vbox), printerFrameInfoText, FALSE, FALSE,0);
	gtk_widget_show(printerFrameInfoText);	

        /* Location */
        printerFrameLocationText=gtk_label_new("");
	gtk_label_set_line_wrap(GTK_LABEL(printerFrameLocationText),TRUE);
	gtk_label_set_justify(GTK_LABEL(printerFrameLocationText),GTK_JUSTIFY_LEFT);
	gtk_widget_set_usize(printerFrameLocationText,PRINTER_INFO_FIELD_LENGTH,-1);
        gtk_box_pack_start(GTK_BOX(vbox),printerFrameLocationText, FALSE, FALSE,INFRAME_SPACING_H);
        gtk_widget_show(printerFrameLocationText);

	/* Signals */
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(printerFrameCombo)->entry),"changed",GTK_SIGNAL_FUNC(PrinterChanged),NULL);
}

void GeneralTab(void)
{
        generalTab=gtk_vbox_new(FALSE,0);
        gtk_notebook_append_page(GTK_NOTEBOOK(tabs), generalTab, gtk_label_new(_("General")));

	PrinterFrame(generalTab);
	PrinterNumCopies(generalTab);
	PrinterMedia(generalTab);
	PrinterDuplex(generalTab);
}

