#include <config.h>

#include "image.h"

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include <gettext.h>
#include <defaults.h>
#include <libgtklp.h>

#include "gtklp.h"
#include "gtklp_functions.h"

GtkWidget *imageTab;
GtkWidget *imageScalingAllFrame;
GtkObject *imageScaleAllAdj;

GtkWidget *imageHUEFrame, *imageHUEButton;
GtkObject *imageHUEAdj;
GtkWidget *imageSatFrame, *imageSatButton;
GtkObject *imageSatAdj;
GtkWidget *imagePosFrame,*imagePosFrameComboX,*imagePosFrameComboY;
GtkWidget *scaleTypeCombo;
GtkWidget *imageScaleAllScale;

void imageTabSetDefaults(void)
{
	if(DEBUG)
		printf("Get imageTabDefaults\n");
	
	/* Position */
	gtk_list_select_item(GTK_LIST(GTK_COMBO(imagePosFrameComboX)->list),ImagePos[0]);
	gtk_list_select_item(GTK_LIST(GTK_COMBO(imagePosFrameComboY)->list),ImagePos[1]);

	/* Image Scaling */
	gtk_list_select_item(GTK_LIST(GTK_COMBO(scaleTypeCombo)->list),imageScalingType);

	/* HUE */
	gtk_adjustment_set_value(GTK_ADJUSTMENT(imageHUEAdj),hue);
	/* Saturation */
	gtk_adjustment_set_value(GTK_ADJUSTMENT(imageSatAdj),sat);


}

void imageScalingAdjChanged(GtkWidget *widget,gpointer data)
{
  switch(imageScalingType)
  {
    case 0:   /* None */

    break;
    case 1:   /* Sheet */
			imageScalingScalingValue=GTK_ADJUSTMENT(imageScaleAllAdj)->value;	
    break;
    case 2:   /* Image */
			imageScalingNaturalValue=GTK_ADJUSTMENT(imageScaleAllAdj)->value;
    break;
    case 3:   /* PPI */
			imageScalingPPIValue=GTK_ADJUSTMENT(imageScaleAllAdj)->value;
    break;
  }
}

void imageScalingAllChanged(GtkWidget *widget,gpointer data)
{
	int strangeerrortrap;
	char tmp[MAXLINE+1];

	snprintf(tmp,(size_t)MAXLINE,"%s",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(scaleTypeCombo)->entry)));
	if(DEBUG)
		printf("Scaling Combo changed: %s\n",tmp);
    
	strangeerrortrap=1;

	if(strcmp(tmp,_("None")) == 0)
		imageScalingType=0;
	else if(strcmp(tmp,_("Sheet relativ")) == 0)
		imageScalingType=1;
	else if(strcmp(tmp,_("Image relativ")) == 0)
		imageScalingType=2;
	else if(strcmp(tmp,_("PPI")) == 0)
		imageScalingType=3;
	else
	{
		if(DEBUG)
			printf("Damned Combo-Box-Error !\n");
		emergency();
	}
	switch(imageScalingType) 
	{
		case 0:		/* None */
			GTK_ADJUSTMENT(imageScaleAllAdj)->value=0;
			gtk_adjustment_value_changed(GTK_ADJUSTMENT(imageScaleAllAdj));
			gtk_widget_set_sensitive(GTK_WIDGET(imageScaleAllScale),FALSE);
		break;
		case 1:		/* Sheet */
			gtk_widget_set_sensitive(GTK_WIDGET(imageScaleAllScale),TRUE);
			GTK_ADJUSTMENT(imageScaleAllAdj)->lower=1;
			GTK_ADJUSTMENT(imageScaleAllAdj)->upper=800;
			GTK_ADJUSTMENT(imageScaleAllAdj)->step_increment=IMAGE_SCALE_STEP;
			GTK_ADJUSTMENT(imageScaleAllAdj)->page_increment=IMAGE_SCALE_PAGE;
			GTK_ADJUSTMENT(imageScaleAllAdj)->page_size=0;

			GTK_ADJUSTMENT(imageScaleAllAdj)->value=imageScalingScalingValue;
			gtk_adjustment_value_changed(GTK_ADJUSTMENT(imageScaleAllAdj));
		break;
		case 2: 	/* Image */
			gtk_widget_set_sensitive(GTK_WIDGET(imageScaleAllScale),TRUE);
      GTK_ADJUSTMENT(imageScaleAllAdj)->lower=1;
      GTK_ADJUSTMENT(imageScaleAllAdj)->upper=800;
      GTK_ADJUSTMENT(imageScaleAllAdj)->step_increment=IMAGE_SCALE_STEP;
      GTK_ADJUSTMENT(imageScaleAllAdj)->page_increment=IMAGE_SCALE_PAGE;
      GTK_ADJUSTMENT(imageScaleAllAdj)->page_size=0;

      GTK_ADJUSTMENT(imageScaleAllAdj)->value=imageScalingNaturalValue;
      gtk_adjustment_value_changed(GTK_ADJUSTMENT(imageScaleAllAdj));
		break;
		case 3: 	/* PPI */
			gtk_widget_set_sensitive(GTK_WIDGET(imageScaleAllScale),TRUE);
      GTK_ADJUSTMENT(imageScaleAllAdj)->lower=1;
      GTK_ADJUSTMENT(imageScaleAllAdj)->upper=1200;
      GTK_ADJUSTMENT(imageScaleAllAdj)->step_increment=IMAGE_PPI_STEP;
      GTK_ADJUSTMENT(imageScaleAllAdj)->page_increment=IMAGE_PPI_PAGE;
      GTK_ADJUSTMENT(imageScaleAllAdj)->page_size=0;

      GTK_ADJUSTMENT(imageScaleAllAdj)->value=imageScalingPPIValue;
      gtk_adjustment_value_changed(GTK_ADJUSTMENT(imageScaleAllAdj));
		break;
	}
	
}

void ImageScalingAllFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox,*vbox,*hbox1;
				GList *STList=NULL;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        imageScalingAllFrame=gtk_frame_new(_("Scaling"));
        gtk_box_pack_start(GTK_BOX(mainHBox), imageScalingAllFrame, TRUE, TRUE,FRAME_SPACING_V);

        vbox=gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(imageScalingAllFrame), vbox);
        gtk_widget_show(vbox);

        hbox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE,0);
        gtk_widget_show(hbox);

        hbox1=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE,INFRAME_SPACING_V);
        gtk_widget_show(hbox1);

        /* Type-Combo-Box */
        scaleTypeCombo=gtk_combo_new();
        STList=g_list_append(STList,_("None"));
        STList=g_list_append(STList,_("Sheet relativ"));
        STList=g_list_append(STList,_("Image relativ"));
        STList=g_list_append(STList,_("PPI"));

        gtk_combo_set_popdown_strings (GTK_COMBO(scaleTypeCombo),STList);
        gtk_combo_set_value_in_list(GTK_COMBO(scaleTypeCombo),TRUE,FALSE);
        gtk_list_set_selection_mode(GTK_LIST(GTK_COMBO(scaleTypeCombo)->list),GTK_SELECTION_SINGLE);

        gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(scaleTypeCombo)->entry),FALSE);
        gtk_box_pack_start(GTK_BOX(hbox), scaleTypeCombo, FALSE, FALSE, INFRAME_SPACING_V);
        gtk_widget_show(scaleTypeCombo);

				/* Slider */
        imageScaleAllAdj=gtk_adjustment_new(0,1,1,1,1,0);
        imageScaleAllScale=gtk_hscale_new(GTK_ADJUSTMENT(imageScaleAllAdj));
        gtk_scale_set_digits(GTK_SCALE(imageScaleAllScale),IMAGE_SCALE_NATURAL_DIGIT);
        gtk_scale_set_draw_value(GTK_SCALE(imageScaleAllScale),TRUE);
        gtk_scale_set_value_pos(GTK_SCALE(imageScaleAllScale),GTK_POS_TOP);
        gtk_range_set_update_policy(GTK_RANGE(imageScaleAllScale),GTK_UPDATE_DISCONTINUOUS);
        gtk_box_pack_start(GTK_BOX(hbox1), imageScaleAllScale, TRUE, TRUE,INFRAME_SPACING_V);
        gtk_widget_show(imageScaleAllScale);

				gtk_signal_connect(GTK_OBJECT(GTK_COMBO(scaleTypeCombo)->entry),"changed",GTK_SIGNAL_FUNC(imageScalingAllChanged),NULL);
				gtk_signal_connect(GTK_OBJECT(imageScaleAllAdj),"value-changed",GTK_SIGNAL_FUNC(imageScalingAdjChanged),NULL);
}

void ImageHUEFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox1,*hbox2,*vbox,*imageHUEScale,*button1,*button2;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        imageHUEFrame=gtk_frame_new(_("Color HUE rotation"));
        gtk_box_pack_start(GTK_BOX(mainHBox), imageHUEFrame, TRUE, TRUE,FRAME_SPACING_V);

        vbox=gtk_vbox_new(FALSE,INFRAME_SPACING_V);
        gtk_container_add(GTK_CONTAINER(imageHUEFrame), vbox);
        gtk_widget_show(vbox);

        hbox1=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox1);

        imageHUEAdj=gtk_adjustment_new(0,-360,360,HUE_STEP,HUE_PAGE,0);
        imageHUEScale=gtk_hscale_new(GTK_ADJUSTMENT(imageHUEAdj));
        gtk_scale_set_digits(GTK_SCALE(imageHUEScale),HUE_DIGIT);
        gtk_scale_set_draw_value(GTK_SCALE(imageHUEScale),TRUE);
        gtk_scale_set_value_pos(GTK_SCALE(imageHUEScale),GTK_POS_TOP);
        gtk_range_set_update_policy(GTK_RANGE(imageHUEScale),GTK_UPDATE_DISCONTINUOUS);
        gtk_box_pack_start(GTK_BOX(hbox1), imageHUEScale, TRUE, TRUE,INFRAME_SPACING_H);
        gtk_widget_show(imageHUEScale);

        hbox2=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox2);

        button1=gtk_button_new_with_label(_("Default"));
        gtk_box_pack_end(GTK_BOX(hbox2), button1, FALSE, FALSE,BUTTON_SPACING_H);
        gtk_widget_show(button1);

        button2=gtk_button_new_with_label(_("Reset"));
        gtk_box_pack_end(GTK_BOX(hbox2), button2, FALSE, FALSE,0);
        gtk_widget_show(button2);

        gtk_signal_connect(GTK_OBJECT(button1),"pressed",GTK_SIGNAL_FUNC(resetButton),"HUEDefault");
        gtk_signal_connect(GTK_OBJECT(button2),"pressed",GTK_SIGNAL_FUNC(resetButton),"HUE");

}

void ImageSatFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox1,*hbox2,*vbox,*imageSatScale,*button1,*button2;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        imageSatFrame=gtk_frame_new(_("Color saturation"));
        gtk_box_pack_start(GTK_BOX(mainHBox), imageSatFrame, TRUE, TRUE,FRAME_SPACING_V);

        vbox=gtk_vbox_new(FALSE,INFRAME_SPACING_V);
        gtk_container_add(GTK_CONTAINER(imageSatFrame), vbox);
        gtk_widget_show(vbox);

        hbox1=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox1);

        imageSatAdj=gtk_adjustment_new(0,0,200,SAT_STEP,HUE_PAGE,0);
        imageSatScale=gtk_hscale_new(GTK_ADJUSTMENT(imageSatAdj));
        gtk_scale_set_digits(GTK_SCALE(imageSatScale),SAT_DIGIT);
        gtk_scale_set_draw_value(GTK_SCALE(imageSatScale),TRUE);
        gtk_scale_set_value_pos(GTK_SCALE(imageSatScale),GTK_POS_TOP);
        gtk_range_set_update_policy(GTK_RANGE(imageSatScale),GTK_UPDATE_DISCONTINUOUS);
        gtk_box_pack_start(GTK_BOX(hbox1), imageSatScale, TRUE, TRUE,INFRAME_SPACING_H);
        gtk_widget_show(imageSatScale);

        hbox2=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox2);

        button1=gtk_button_new_with_label(_("Default"));
        gtk_box_pack_end(GTK_BOX(hbox2), button1, FALSE, FALSE,BUTTON_SPACING_H);
        gtk_widget_show(button1);

        button2=gtk_button_new_with_label(_("Reset"));
        gtk_box_pack_end(GTK_BOX(hbox2), button2, FALSE, FALSE,0);
        gtk_widget_show(button2);

        gtk_signal_connect(GTK_OBJECT(button1),"pressed",GTK_SIGNAL_FUNC(resetButton),"SatDefault");
        gtk_signal_connect(GTK_OBJECT(button2),"pressed",GTK_SIGNAL_FUNC(resetButton),"Sat");

}
void imagePosChanged(GtkWidget *widget,gpointer data)
{
        int strangeerrortrap,whichone;
        char tmp[MAX_IMAGE_POS_LENGTH+1];

	whichone=atoi((char *)data);

	if(whichone == 0)
	        snprintf(tmp,(size_t)MAX_IMAGE_POS_LENGTH,"%s",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(imagePosFrameComboX)->entry)));
	else
		snprintf(tmp,(size_t)MAX_IMAGE_POS_LENGTH,"%s",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(imagePosFrameComboY)->entry)));

        if(DEBUG)
                printf("Image Postion %i changed: %s\n",whichone, (char *)tmp);


        strangeerrortrap=1;

	if(whichone == 0)
	{
		if(strcmp(tmp,_("Center")) == 0)
			ImagePos[0]=0;
		else if(strcmp(tmp,_("Left")) == 0)
			ImagePos[0]=1;
		else if(strcmp(tmp,_("Right")) == 0)
			ImagePos[0]=2;
		else
			strangeerrortrap=1;
	}
	else
	{
                if(strcmp(tmp,_("Center")) == 0)
                        ImagePos[1]=0;
                else if(strcmp(tmp,_("Top")) == 0)
                        ImagePos[1]=1;
                else if(strcmp(tmp,_("Bottom")) == 0)
                        ImagePos[1]=2;
                else
                        strangeerrortrap=1;
	}

        if(strangeerrortrap == 0)
        {
                if(DEBUG)
                        printf("Damned Combo-Box-Error !\n");
                emergency();

        }
	if(DEBUG)
		printf("imagePos -> %i %i\n",ImagePos[0],ImagePos[1]);
}

void ImagePosFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox;
        GList *XList=NULL,*YList=NULL;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        imagePosFrame=gtk_frame_new(_("Position"));
        gtk_box_pack_start(GTK_BOX(mainHBox), imagePosFrame, TRUE, TRUE,FRAME_SPACING_V);

        /* Box */
        hbox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_container_add(GTK_CONTAINER(imagePosFrame), hbox);
        gtk_widget_show(hbox);

        /* Y */
        imagePosFrameComboY=gtk_combo_new();
        YList=g_list_append(YList,_("Center"));
        YList=g_list_append(YList,_("Top"));
        YList=g_list_append(YList,_("Bottom"));

        gtk_combo_set_popdown_strings (GTK_COMBO(imagePosFrameComboY),YList);
        gtk_combo_set_value_in_list(GTK_COMBO(imagePosFrameComboY),TRUE,FALSE);
        gtk_list_set_selection_mode(GTK_LIST(GTK_COMBO(imagePosFrameComboY)->list),GTK_SELECTION_SINGLE);

        gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(imagePosFrameComboY)->entry),FALSE);
        gtk_box_pack_start(GTK_BOX(hbox), imagePosFrameComboY, FALSE, FALSE, INFRAME_SPACING_H);
        gtk_widget_show(imagePosFrameComboY);

	/* X */
        imagePosFrameComboX=gtk_combo_new();
	XList=g_list_append(XList,_("Center"));
	XList=g_list_append(XList,_("Left"));
	XList=g_list_append(XList,_("Right"));

        gtk_combo_set_popdown_strings (GTK_COMBO(imagePosFrameComboX),XList);
        gtk_combo_set_value_in_list(GTK_COMBO(imagePosFrameComboX),TRUE,FALSE);
        gtk_list_set_selection_mode(GTK_LIST(GTK_COMBO(imagePosFrameComboX)->list),GTK_SELECTION_SINGLE);

        gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(imagePosFrameComboX)->entry),FALSE);
        gtk_box_pack_start(GTK_BOX(hbox), imagePosFrameComboX, FALSE, FALSE, INFRAME_SPACING_H);
        gtk_widget_show(imagePosFrameComboX);

	/* Signals */
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(imagePosFrameComboX)->entry),"changed",GTK_SIGNAL_FUNC(imagePosChanged),"0");
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(imagePosFrameComboY)->entry),"changed",GTK_SIGNAL_FUNC(imagePosChanged),"1");
}



void ImageTab(void)
{
	imageTab=gtk_vbox_new(FALSE,0);
	gtk_notebook_append_page(GTK_NOTEBOOK(tabs), imageTab, gtk_label_new(_("Image")));

	ImagePosFrame(imageTab);
	ImageScalingAllFrame(imageTab);
	ImageHUEFrame(imageTab);
	ImageSatFrame(imageTab);
}
