#include <config.h>

#include "gtklpq.h"

#include <stdio.h>
#include <cups/cups.h>
#include <cups/language.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <dirent.h>
#include <X11/Xlib.h>

#include <gettext.h>
#include <defaults.h>
#include <libgtklp.h>

#include "gtklpq_functions.h"
#include "printer.h"

#include "gtklpq_exit.xpm"
#include "gtklpq_hold.xpm"
#include "gtklpq_move.xpm"
#include "gtklpq_prio.xpm"
#include "gtklpq_release.xpm"
#include "gtklpq_start_printer.xpm"
#include "gtklpq_stop_job.xpm"
#include "gtklpq_stop_jobs.xpm"
#include "gtklpq_stop_printer.xpm"

char PortString[MAX_PORT+11];

int hasAskedPWD;

GtkWidget *tabs,*statbar;
GtkWidget *buttonPrio, *buttonHold,*buttonMove,*buttonCancel,*buttonCancelAll,*holdLabel,*buttonHoldPrinter,*holdPrinterLabel;
GtkWidget *holdimage,*printerimage;
GdkPixmap *gtklpq_hold,*gtklpq_release,*gtklpq_stop_printer,*gtklpq_start_printer;
GdkBitmap *mgtklpq_hold,*mgtklpq_release,*mgtklpq_stop_printer,*mgtklpq_start_printer;
GtkStyle *style;
GtkTooltips *tooltips;

int m_id_upd,c_id_upd,m_id_state,c_id_state;

unsigned char PrinterNames[MAX_PRT][DEF_PRN_LEN+1];
unsigned char PrinterInfos[MAX_PRT][MAXLINE+1];
unsigned char PrinterLocations[MAX_PRT][MAXLINE+1];
int PrinterNum;
int PrinterChoice;
unsigned char PrinterBannerStart[MAX_PRT][MAXLINE+1];
unsigned char PrinterBannerEnd[MAX_PRT][MAXLINE+1];

unsigned int selectedJob;

int lastPrinterChoice;


http_t *cupsHttp;
cups_lang_t *cupsLanguage;

int main(int argc,char *argv[])
{
	GtkWidget *mainVBox;
	GtkWidget *buttonBox,*buttonAbbruch;
	GdkPixmap *gtklpq_exit,*gtklpq_move,*gtklpq_prio, *gtklpq_stop_job, *gtklpq_stop_jobs;
	GdkBitmap *mgtklpq_exit,*mgtklpq_move,*mgtklpq_prio, *mgtklpq_stop_job, *mgtklpq_stop_jobs;
	GtkWidget *image;

	int i1;
	unsigned char Path[MAXPATH+1];
	char *z1;

	int queryIntervall=0;
	int xpos,ypos;

	char tmpenv[MAX_SERVER_NAME+13];

	hasAskedPWD=0;

	selectedJob=0;

	xpos=-1;
	ypos=-1;

	setlocale (LC_ALL, "");
        bindtextdomain (PACKAGE, LOCALEDIR);
        textdomain(PACKAGE);

	nox=noX();

	/*--- Get Programm Options ---*/
	DEF_PRN[0]=(unsigned char)NULL;
	ServerName[0]=(char)NULL;
	UserName[0]=(char)NULL;
	Path[0]=(unsigned char)NULL;
	passWord[0]=(char)NULL;
	i1=getopt(argc,argv,GTKLPQ_ProgOpts);
	while(i1 != -1)
	{
		switch(i1)
		{
			case '?':
				printf("%s\n",_("Usage: gtklpq [-P|-d Printer] [-S server] [-p port] [-D] [-V] [-U user] [-t timeout] [-g geometry]"));
				return(0);
			break;
			case 'p':
				if(strlen(optarg) > MAX_PORT)
				{
					if(DEBUG)
						printf("Port too long !\n");
					g_error(_("Invalid Portnumber !"));
					exit(-1);
					//emergency();
				}
				else
				{
					if(DEBUG)
						printf("Using port: %s\n",optarg);
					snprintf(PortString,(size_t)MAX_PORT+10,"IPP_PORT=%s",optarg);
					putenv(PortString);
				}
			break;	
			case 'P':
			case 'd':
				if(strlen(optarg) < DEF_PRN_LEN)
				{
					strncpy(DEF_PRN,optarg,(size_t)DEF_PRN_LEN);
				}
				else
				{
					if(DEBUG)
						printf("PROG-ERROR: Printername too long !\n ");
					g_error(_("Invalid Printername !"));
					exit(-1);
					//emergency();
				}
			break;
			case 't':
				queryIntervall=atoi(optarg);
				if(queryIntervall < 0)
					queryIntervall=0;
				if(DEBUG)
					printf("Timeout: %i\n",queryIntervall);
			break;
			case 'S':
				if(strlen(optarg) < MAX_SERVER_NAME)
				{
					strncpy(ServerName,optarg,(size_t)MAX_SERVER_NAME);
				}
				else
				{
					if(DEBUG)
						printf("PROG-ERROR: Servername too long !\n ");
					g_error(_("Invalid Servername !"));
					exit(-1);
					//emergency();
				}
			break;
      case 'U':
				if(strlen(optarg) < MAX_USERNAME)
			  {
			    strncpy(UserName,optarg,(size_t)MAX_USERNAME);
			  }
			  else
			  {
				  if(DEBUG)
				    printf("PROG-ERROR: Username too long !\n ");
					g_error(_("Invalid Username !"));
					exit(-1);
			    //emergency();
			  }
			break;
			case 'D':
				DEBUG=1;
				printf("DEBUG-MODE on !\n");
			break;
			case 'V':
				printf("\n%s %s ",PROGNAME,_("version"));
				printf("%s\n",VERSION);
				printf("%s\n\n",MY_HOME);
				return(0);
			break;
			case 'g':
				if(strchr(optarg,'x') != NULL)
				{
					z1=strchr(optarg,'x');
					*z1=(char)NULL;
					z1++;
					xpos=atoi(optarg);
					ypos=atoi(z1);
				}
			break;
			default:
				if(DEBUG)
					printf("PROG-ERROR: Unknown, but allowed switch: %c\n",i1);
				emergency();
			break;
		}
		i1=getopt(argc,argv,GTKLPQ_ProgOpts);
	}

	if(DEBUG)
	{
		if (optind < argc)
           	{
             		printf ("non-option ARGV-elements: ");
             		while (optind < argc)
             			printf ("%s ", argv[optind++]);
             		printf ("\n");
           	}
	}

	/* Try to get connected to Server */
	if(ServerName[0]==(char)NULL)
	{
		if(DEBUG)
			printf("No Servername given, searching...\n");
		z1=(char *)cupsServer();
		if(z1 == (char *)NULL)
		{
			if(DEBUG)
				printf("PROG-ERROR: No Cups-Server found !\n");
			g_error(_("No Cups-Server found !"));
			exit(-1);
			//emergency();
		}
		strncpy(ServerName,z1,(size_t)MAX_SERVER_NAME);
	}
	if(DEBUG)
		printf("ServerName: %s\nTry to connect...\n",ServerName);
	cupsHttp=httpConnect(ServerName, ippPort());
	if(cupsHttp==NULL)
	{
		if(DEBUG)
			printf("PROG-ERROR: Cannot connect to Server %s!\n",ServerName);
		g_error(_("Unable to connect to Server %s !"),ServerName);
		exit(-1);
		//emergency();
	}
	else
	{
		if(DEBUG)
			printf("connected\n");
		snprintf(tmpenv,(size_t)MAX_SERVER_NAME+12,"CUPS_SERVER=%s",ServerName);
		putenv(tmpenv);
		cupsSetServer((const char *)ServerName);
	}
	cupsLanguage=cupsLangDefault();

	/* Setting Username */
	cupsSetUser((const char *)UserName);	
	if(DEBUG)
		printf("Username is set to: %s\n",cupsUser());

	/*--- GUI creation ---*/
	if(nox == 0) {
		gtk_init(&argc, &argv);

		/* HauptFenster */
		mainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(mainWindow),_("GtkLPQ"));
		gtk_widget_set_usize(mainWindow,GTKLPQ_MAINSIZEH,GTKLPQ_MAINSIZEV);
		if((xpos < 0) || (ypos < 0))
			gtk_window_set_position(GTK_WINDOW(mainWindow),GTK_WIN_POS_CENTER);
		else
			gtk_widget_set_uposition(mainWindow,(gint)xpos,(gint)ypos);

		gtk_signal_connect (GTK_OBJECT (mainWindow), "delete_event",GTK_SIGNAL_FUNC (gtklpq_end), NULL);
		gtk_signal_connect (GTK_OBJECT (mainWindow), "destroy",GTK_SIGNAL_FUNC (gtklpq_end), NULL);
		gtk_container_set_border_width (GTK_CONTAINER (mainWindow), 10);
		gtk_widget_show(mainWindow);
	}

 /* Printer */
        if(DEBUG)
                printf("Default-Printer(1): %s\n",DEF_PRN);

  getPrinters(0);

  if(DEBUG)
    printf("Default-Printer(2): %s\n",DEF_PRN);

  if(DEF_PRN[0] == (unsigned char)NULL)
  {
    if(DEBUG)
      printf("PROG-ERROR: No Printer found to use for default !\n");
		g_error(_("No Printer found to use as default !"));
		exit(-1);
    //emergency();
  }

	if(nox == 0) {
		/* Vertikaler Container im HauptFenster */
		mainVBox=gtk_vbox_new(FALSE,BUTTON_SPACING_H);
		gtk_container_add(GTK_CONTAINER(mainWindow), mainVBox);
		gtk_widget_show(mainVBox);

		PrinterFrame(mainVBox,0);
		printerSetDefaults(0);
		gtk_widget_show(printerFrame[0]);

		printQueueInit(mainVBox);
		gtk_widget_show(queueFrame);

		statbar=gtk_statusbar_new();
		gtk_box_pack_end(GTK_BOX(mainVBox),statbar,FALSE,FALSE,0);
		c_id_upd=gtk_statusbar_get_context_id((GtkStatusbar *)statbar,"Update Queue");
		c_id_state=gtk_statusbar_get_context_id((GtkStatusbar *)statbar,"Printer State");
		gtk_widget_show(statbar);

		buttonBox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_end(GTK_BOX(mainVBox), buttonBox, FALSE, FALSE, 0);
		gtk_widget_show(buttonBox);

		tooltips=gtk_tooltips_new();
		gtk_tooltips_set_delay(tooltips,TOOLTIP_DELAY);
		gtk_tooltips_enable(tooltips);

		style = gtk_widget_get_style(mainVBox);
		gtklpq_exit = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_exit, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_exit);
		gtklpq_hold = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_hold, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_hold);
		gtklpq_move = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_move, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_move);
		gtklpq_prio = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_prio, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_prio);
		gtklpq_release = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_release, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_release);
		gtklpq_start_printer = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_start_printer, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_start_printer);
		gtklpq_stop_job = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_stop_job, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_stop_job);
		gtklpq_stop_jobs = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_stop_jobs, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_stop_jobs);
		gtklpq_stop_printer = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mgtklpq_stop_printer, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_gtklpq_stop_printer);

		image=gtk_pixmap_new(gtklpq_stop_job,mgtklpq_stop_job);
		gtk_widget_show(image);
		buttonCancel = gtk_button_new();
		gtk_signal_connect (GTK_OBJECT (buttonCancel), "clicked",GTK_SIGNAL_FUNC (queueFunc),"CANCEL");
		gtk_container_add(GTK_CONTAINER(buttonCancel),image);
		gtk_box_pack_start(GTK_BOX(buttonBox), buttonCancel, FALSE, FALSE, BUTTON_SPACING_V);
		gtk_widget_show (buttonCancel);

		gtk_tooltips_set_tip(tooltips, buttonCancel, _("Cancel Job"), _("Cancel Job")); 

		image=gtk_pixmap_new(gtklpq_stop_jobs,mgtklpq_stop_jobs);
		gtk_widget_show(image);
		buttonCancelAll = gtk_button_new();
		gtk_signal_connect (GTK_OBJECT (buttonCancelAll), "clicked",GTK_SIGNAL_FUNC (queueFunc), "CANCELALL");
		gtk_container_add(GTK_CONTAINER(buttonCancelAll),image);
		gtk_box_pack_start(GTK_BOX(buttonBox), buttonCancelAll, FALSE, FALSE, BUTTON_SPACING_V);
		gtk_widget_show (buttonCancelAll);

		gtk_tooltips_set_tip(tooltips, buttonCancelAll, _("Cancel All"), _("Cancel All"));

		holdimage=gtk_pixmap_new(gtklpq_hold,mgtklpq_hold);
		gtk_widget_show(holdimage);
		buttonHold = gtk_button_new();
		gtk_signal_connect (GTK_OBJECT (buttonHold), "clicked",GTK_SIGNAL_FUNC (queueFunc),"HOLD");
		gtk_container_add(GTK_CONTAINER(buttonHold),holdimage);
		gtk_box_pack_start(GTK_BOX(buttonBox), buttonHold, FALSE, FALSE, BUTTON_SPACING_V);
		gtk_widget_show (buttonHold);

		gtk_tooltips_set_tip(tooltips, buttonHold, _("Hold Job"), _("Hold Job"));

		image=gtk_pixmap_new(gtklpq_move,mgtklpq_move);
		gtk_widget_show(image);
		buttonMove = gtk_button_new();
		gtk_signal_connect (GTK_OBJECT (buttonMove), "clicked",GTK_SIGNAL_FUNC (queueFunc),"MOVE");
		gtk_container_add(GTK_CONTAINER(buttonMove),image);
		gtk_box_pack_start(GTK_BOX(buttonBox), buttonMove, FALSE, FALSE, BUTTON_SPACING_V);
		gtk_widget_show (buttonMove);

		gtk_tooltips_set_tip(tooltips, buttonMove, _("Move Job"), _("Move Job"));

		printerimage=gtk_pixmap_new(gtklpq_stop_printer,mgtklpq_stop_printer);
		gtk_widget_show(printerimage);
	  buttonHoldPrinter = gtk_button_new();
		gtk_signal_connect (GTK_OBJECT (buttonHoldPrinter), "clicked",GTK_SIGNAL_FUNC (queueFunc),"HOLDPRINTER");
		gtk_container_add(GTK_CONTAINER(buttonHoldPrinter),printerimage);
	  gtk_box_pack_start(GTK_BOX(buttonBox), buttonHoldPrinter, FALSE, FALSE, BUTTON_SPACING_V);
  	gtk_widget_show (buttonHoldPrinter);

		gtk_tooltips_set_tip(tooltips, buttonHoldPrinter, _("Stop Printer"), _("Stop Printer"));

		image=gtk_pixmap_new(gtklpq_prio,mgtklpq_prio);
		gtk_widget_show(image);
		buttonPrio = gtk_button_new();
	  gtk_signal_connect (GTK_OBJECT (buttonPrio), "clicked",GTK_SIGNAL_FUNC (queueFunc),"PRIORITY");
		gtk_container_add(GTK_CONTAINER(buttonPrio),image);
  	gtk_box_pack_start(GTK_BOX(buttonBox), buttonPrio, FALSE, FALSE, BUTTON_SPACING_V);
	  gtk_widget_show (buttonPrio);

		gtk_tooltips_set_tip(tooltips, buttonPrio, _("Priority"), _("Priority"));

  	gtk_widget_set_sensitive((GtkWidget *)buttonHold,FALSE);
		gtk_widget_set_sensitive((GtkWidget *)buttonMove,FALSE);
		gtk_widget_set_sensitive((GtkWidget *)buttonCancel,FALSE);
		gtk_widget_set_sensitive((GtkWidget *)buttonCancelAll,FALSE);
		gtk_widget_set_sensitive((GtkWidget *)buttonHoldPrinter,TRUE);
		gtk_widget_set_sensitive((GtkWidget *)buttonPrio,TRUE);
			
	
		image=gtk_pixmap_new(gtklpq_exit,mgtklpq_exit);
		gtk_widget_show(image);
		buttonAbbruch = gtk_button_new();
    gtk_signal_connect (GTK_OBJECT (buttonAbbruch), "clicked",GTK_SIGNAL_FUNC (gtklpq_end), NULL);
		gtk_container_add(GTK_CONTAINER(buttonAbbruch),image);
    gtk_box_pack_end(GTK_BOX(buttonBox), buttonAbbruch, FALSE, FALSE, BUTTON_SPACING_V);
    gtk_widget_show (buttonAbbruch);

		gtk_tooltips_set_tip(tooltips, buttonAbbruch, _("Cancel"), _("Cancel"));

		cupsSetPasswordCB(getPass);
	}
	printQueueUpdate(NULL,NULL);
	if(nox == 0) {
		if(queryIntervall == 0)
			queryIntervall=QUERY_INTERVALL;
		gtk_timeout_add(queryIntervall*1000, (GtkFunction)printQueueUpdate,NULL );
		gtk_main ();
	}
  return(0);
}
